<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/Kiosk.js"/>
                </ui:head>    
                <ui:body focus="f1:p1:ps:pss:p1:i1"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="kiosk"/>
                        <ui:alert binding ="#{kioskHandler.statusMessage.alert}"/>
                        <ui:contentPageTitle id="p1" 
                            title="#{msg.kiosk_edit_pageTitle}"
                            helpText="#{msg.kiosk_edit_pageHelpText}">
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup> 
                                    <ui:button id="ok"
                                               text="#{msg.ok_button}"
                                               primary="true"
                                               action="#{kioskHandler.modify}"
                                               toolTip="#{msg.kiosk_edit_props_ok_tooltip}"
                                               alt="#{msg.ok_button_alt}"/>
                                    <ui:button id="cancel" 
                                               text="#{msg.cancel_button}"
                                               action="kiosk"
                                               immediate="true"
                                               toolTip="#{msg.kiosk_edit_cancel_tooltip}"
                                               alt="#{msg.cancel_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            <ui:propertySheet id="ps">
                                <ui:propertySheetSection id="pss">
                                    <ui:property id="p1" label="#{msg.kiosk_sessionLabel}" labelAlign="right">
                                        <ui:dropDown id="i1" items="#{kioskHandler.sessionOptions}" 
                                            selected="#{kioskHandler.session}"
                                            onChange="javascript: setTimeout('toggleOkButton();', 0);"
                                            submitForm="true"
                                            toolTip="#{msg.kiosk_sessionOptions_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p2" label="#{msg.kiosk_timeoutLabel}" labelAlign="right">
                                        <ui:textField id="i2" text="#{kioskHandler.kiosk.timeout}"
                                            onKeyUp="javascript: setTimeout('toggleOkButton();', 0);"
                                            onChange="javascript: setTimeout('toggleOkButton();', 0);"
                                            toolTip="#{msg.kiosk_timeout_tooltip}"/>
                                        <ui:staticText id="i2u" text="&#160;&#160;#{msg.kiosk_secondsUnit}" style="color:#999; font-size:11px;"/>
                                        <ui:markup tag="br" singleton="true"/>
                                        <ui:staticText text="#{msg.kiosk_default}" escape="true" rendered="#{kioskHandler.kiosk.descriptor.recommendations.timeoutSet}"/>
                                        <ui:hyperlink text="#{kioskHandler.kiosk.descriptor.recommendations.timeout}"
                                            onClick="document.getElementById('f1:p1:ps:pss:p2:i2').value='#{kioskHandler.kiosk.descriptor.recommendations.timeout}'; toggleOkButton(); return false;"
                                            toolTip="#{msg.kiosk_recommended_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p3" label="#{msg.kiosk_maxCPULabel}" labelAlign="right">
                                        <ui:textField id="i3" text="#{kioskHandler.kiosk.maxCPU}"
                                            onKeyUp="javascript: setTimeout('toggleOkButton();', 0);"
                                            onChange="javascript: setTimeout('toggleOkButton();', 0);"
                                            toolTip="#{msg.kiosk_maxCPU_tooltip}"/>
                                        <ui:staticText id="i3u" text="&#160;&#160;#{msg.kiosk_secondsUnit}" style="color:#999; font-size:11px;"/>
                                        <ui:markup tag="br" singleton="true"/>
                                        <ui:staticText text="#{msg.kiosk_default}" escape="true" rendered="#{kioskHandler.kiosk.descriptor.recommendations.maxCPUSet}"/>
                                        <ui:hyperlink text="#{kioskHandler.kiosk.descriptor.recommendations.maxCPU}"
                                            onClick="document.getElementById('f1:p1:ps:pss:p3:i3').value='#{kioskHandler.kiosk.descriptor.recommendations.maxCPU}'; toggleOkButton(); return false;"
                                            toolTip="#{msg.kiosk_recommended_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p4" label="#{msg.kiosk_maxVMLabel}" labelAlign="right">
                                        <ui:textField id="i4" text="#{kioskHandler.kiosk.maxVM}"
                                            onKeyUp="javascript: setTimeout('toggleOkButton();', 0);"
                                            onChange="javascript: setTimeout('toggleOkButton();', 0);"
                                            toolTip="#{msg.kiosk_maxVM_tooltip}"/>
                                        <ui:staticText id="i4u" text="&#160;&#160;#{msg.kiosk_kbUnit}" style="color:#999; font-size:11px;"/>
                                        <ui:markup tag="br" singleton="true"/>
                                        <ui:staticText text="#{msg.kiosk_default}" escape="true" rendered="#{kioskHandler.kiosk.descriptor.recommendations.maxVMSet}"/>
                                        <ui:hyperlink text="#{kioskHandler.kiosk.descriptor.recommendations.maxVM}"
                                            onClick="document.getElementById('f1:p1:ps:pss:p4:i4').value='#{kioskHandler.kiosk.descriptor.recommendations.maxVM}'; toggleOkButton(); return false;"
                                            toolTip="#{msg.kiosk_recommended_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p5" label="#{msg.kiosk_maxFilesLabel}" labelAlign="right">
                                        <ui:textField id="i5" text="#{kioskHandler.kiosk.maxFiles}"
                                            onKeyUp="javascript: setTimeout('toggleOkButton();', 0);"
                                            onChange="javascript: setTimeout('toggleOkButton();', 0);"                                            
                                            toolTip="#{msg.kiosk_maxFiles_tooltip}"/>
                                        <ui:markup tag="br" singleton="true"/>
                                        <ui:staticText text="#{msg.kiosk_default}" escape="true" rendered="#{kioskHandler.kiosk.descriptor.recommendations.maxFilesSet}"/>
                                        <ui:hyperlink text="#{kioskHandler.kiosk.descriptor.recommendations.maxFiles}"
                                            onClick="document.getElementById('f1:p1:ps:pss:p5:i5').value='#{kioskHandler.kiosk.descriptor.recommendations.maxFiles}'; toggleOkButton(); return false;"
                                            toolTip="#{msg.kiosk_recommended_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p6" label="#{msg.kiosk_maxFileSizeLabel}" labelAlign="right">
                                        <ui:textField id="i6" text="#{kioskHandler.kiosk.maxFileSize}"
                                            onKeyUp="javascript: setTimeout('toggleOkButton();', 0);"
                                            onChange="javascript: setTimeout('toggleOkButton();', 0);"
                                            toolTip="#{msg.kiosk_maxFileSize_tooltip}"/>
                                        <ui:staticText id="i6u" text="&#160;&#160;#{msg.kiosk_blocksUnit}" style="color:#999; font-size:11px;"/>
                                        <ui:markup tag="br" singleton="true"/>
                                        <ui:staticText text="#{msg.kiosk_default}" escape="true" rendered="#{kioskHandler.kiosk.descriptor.recommendations.maxFileSizeSet}"/>
                                        <ui:hyperlink text="#{kioskHandler.kiosk.descriptor.recommendations.maxFileSize}"
                                            onClick="document.getElementById('f1:p1:ps:pss:p6:i6').value='#{kioskHandler.kiosk.descriptor.recommendations.maxFileSize}'; toggleOkButton(); return false;"
                                            toolTip="#{msg.kiosk_recommended_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p7" label="#{msg.kiosk_localeLabel}" labelAlign="right">
                                        <ui:textField id="i7" text="#{kioskHandler.kiosk.locale}"
                                            onKeyUp="javascript: setTimeout('toggleOkButton();', 0);"
                                            onChange="javascript: setTimeout('toggleOkButton();', 0);"
                                            toolTip="#{msg.kiosk_locale_tooltip}"/>
                                        <ui:markup tag="br" singleton="true"/>
                                        <ui:staticText text="#{msg.kiosk_default}" escape="true" rendered="#{kioskHandler.kiosk.descriptor.recommendations.localeSet}"/>
                                        <ui:hyperlink text="#{kioskHandler.kiosk.descriptor.recommendations.locale}"
                                            onClick="document.getElementById('f1:p1:ps:pss:p7:i7').value='#{kioskHandler.kiosk.descriptor.recommendations.locale}'; toggleOkButton(); return false;"
                                            toolTip="#{msg.kiosk_recommended_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p8" label="#{msg.kiosk_argsLabel}" labelAlign="right">
                                        <ui:textField id="i8" text="#{kioskHandler.kiosk.args}" columns="64"
                                            onKeyUp="javascript: setTimeout('toggleOkButton();', 0);"
                                            onChange="javascript: setTimeout('toggleOkButton();', 0);"
                                            toolTip="#{msg.kiosk_args2_tooltip}"/>
                                        <ui:markup tag="br" singleton="true"/>
                                        <ui:staticText text="#{msg.kiosk_default}" escape="true" rendered="#{kioskHandler.kiosk.descriptor.recommendations.argsSet}"/>
                                        <ui:hyperlink text="#{kioskHandler.kiosk.descriptor.recommendations.args}"
                                            onClick="document.getElementById('f1:p1:ps:pss:p8:i8').value='#{kioskHandler.kiosk.descriptor.recommendations.args}'; toggleOkButton(); return false;"
                                            toolTip="#{msg.kiosk_recommended_tooltip}"/>
                                    </ui:property>
                                </ui:propertySheetSection>
                            </ui:propertySheet>
                            <ui:hiddenField id="hiddenKioskValues" value="#{kioskHandler.hiddenKiosk}"/>
                        </ui:contentPageTitle>
                        <ui:script>
                            <f:verbatim>
                                toggleOkButton();
                            </f:verbatim>
                        </ui:script>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 

