<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                </ui:head>    
                <ui:body focus="f1:p2:_id18:edit"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="dtus"/>
                        <ui:alert binding ="#{dtu.statusMessage.alert}"/>

                        <ui:breadcrumbs>
                            <ui:hyperlink text="#{msg.dtu_breadcrump_dtus_links}"
                                          action="viewDesktopUnits"
                                          immediate="true"
                                          toolTip="#{msg.dtu_breadcrump_dtus_tooltip}"/>
                            <ui:hyperlink text="#{dtu.id}"
                                          toolTip="#{msg.dtu_id_link_tooltip}"/>
                        </ui:breadcrumbs>
                        <ui:contentPageTitle id="p2" 
                                             title="#{dtu.id} - #{msg.dtu_pageTitle}"
                                             helpText="#{msg.dtu_pageHelpText}">
                            <f:facet name="pageButtonsTop">
                                <ui:panelGroup> 
                                    <ui:button id="edit"
                                               text="#{msg.edit_button}"
                                               primary="true"
                                               action="editDesktopUnitDetails"
                                               immediate="true"
                                               toolTip="#{msg.dtu_edit_button_tooltip}"
                                               alt="#{msg.edit_button_alt}"/>
                                    <ui:button id="back"
                                               text="#{msg.dtu_back_button}"
                                               action="viewDesktopUnits"
                                               immediate="true"
                                               toolTip="#{msg.dtu_back_button_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup> 
                                    <ui:button id="edit"
                                               text="#{msg.edit_button}"
                                               primary="true"
                                               action="editDesktopUnitDetails"
                                               immediate="true"
                                               toolTip="#{msg.dtu_edit_button_tooltip}"
                                               alt="#{msg.edit_button_alt}"/>
                                    <ui:button id="back"
                                               text="#{msg.dtu_back_button}"
                                               action="viewDesktopUnits"
                                               immediate="true"
                                               toolTip="#{msg.dtu_back_button_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                    <f:verbatim><br/><br/></f:verbatim>
                                </ui:panelGroup> 
                            </f:facet> 
                            <ui:propertySheet id="a1" jumpLinks="false">
                                <ui:propertySheetSection id="s1"
                                                         label="#{msg.dtu_general_section}"
                                                         rendered="#{dtu.registered}">
                                    <ui:property id="p1"
                                                 label="#{msg.dtu_location}"
                                                 labelAlign="right">
                                        <ui:staticText id="s1" text="#{dtu.location}"/>
                                    </ui:property>
                                    <ui:property id="p2"
                                                 label="#{msg.dtu_description}"
                                                 labelAlign="right">
                                        <ui:staticText id="s2" text="#{dtu.description}"/>
                                    </ui:property>
                                    <ui:property id="p3"
                                                 label="#{msg.dtu_model}"
                                                 labelAlign="right">
                                        <ui:staticText id="s3" text="#{dtu.model}"/>
                                    </ui:property>    
                                    <ui:property id="p4"
                                                 label="#{msg.dtu_firmware}"
                                                 labelAlign="right">
                                        <ui:staticText id="s4" text="#{dtu.firmware}"/>
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>
                                </ui:propertySheetSection>
                                <ui:propertySheetSection id="s2"
                                                         label="#{msg.dtu_reader_section}" 
                                                         rendered="#{dtu.tokenReader and dtu.connected}">
                                    <ui:property id="p1" label="#{msg.dtu_tokenID}">
                                        <ui:staticText id="s1" text="#{dtu.readerToken}"/>
                                        <ui:staticText text="&#160;" escape="false"/>
                                        <ui:staticText text="&#160;" escape="false"/>
                                        <ui:button id="b1"
                                                   text="#{msg.dtu_token_read_button}"
                                                   mini="true"
                                                   action="#{dtu.readTokenFromReader}"
                                                   toolTip="#{msg.dtu_token_read_button_tooltip}"
                                                   alt="#{msg.dtu_token_read_button_alt}"/>
                                        <ui:helpInline type="field" 
                                                       text="#{msg.dtu_reader_helpText}"/>
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>                                
                                </ui:propertySheetSection>
                                <ui:propertySheetSection id="s3"
                                                         label="#{msg.dtu_status_section}">
                                    <ui:property id="p1"
                                                 label="#{msg.dtu_current_token}"
                                                 labelAlign="right">
                                        <ui:staticText id="s3" text="#{dtu.token}"/>
                                        <ui:staticText text="&#160;&#160;" escape="false"/>
                                        <ui:hyperlink id="l1" 
                                                      toolTip="#{msg.dtu_view_token_link_toolTip}"
                                                      action="#{dtu.viewTokenDetails}"
                                                      immediate="true"
                                                      rendered="#{dtu.connected}"> 
                                            <ui:image icon="HREF_LINK"/>
                                            <ui:staticText text="&#160;" escape="false"/> 
                                            <ui:staticText text="#{msg.dtu_view_token_link}"/>
                                        </ui:hyperlink>
                                    </ui:property>
                                    <ui:property id="p2"
                                                 label="#{msg.dtu_unix_user}"
                                                 labelAlign="right">
                                        <ui:staticText id="s2"
                                                       text="#{dtu.user}"
                                                       rendered="#{dtu.userLoggedIn}"/>
                                       <ui:staticText text="#{msg.dtu_no_user}"
                                                      rendered="#{!dtu.userLoggedIn}"/>
                                        <ui:staticText text="&#160;" escape="false"/>
                                        <ui:staticText id="s3" text="#{dtu.userComment}"/>
                                        <ui:staticText text="&#160;" escape="false"/>
                                        <ui:button id="b1"
                                                   text="#{dtu.terminateLabel}" 
                                                   mini="true"
                                                   toolTip="#{dtu.terminateTooltip}"
                                                   onClick="#{dtu.terminateOnClick}"
                                                   action="#{dtu.terminate}"
                                                   rendered="#{dtu.connected}"/> 
                                    </ui:property>
                                    <ui:property id="p3"
                                                 label="#{msg.dtu_server}"
                                                 labelAlign="right"
                                                 rendered="#{dtu.connected}">
                                        <ui:staticText id="s3" text="#{dtu.server}"/>
                                        <ui:staticText text="&#160;&#160;" escape="false"/>
                                        <ui:hyperlink id="l1" 
                                                      toolTip="#{msg.dtu_view_server_link_toolTip}"
                                                      action="#{dtu.viewServerDetails}"
                                                      immediate="true"> 
                                            <ui:image icon="HREF_LINK"/>
                                            <ui:staticText text="&#160;" escape="false"/> 
                                            <ui:staticText text="#{msg.dtu_view_server_link}"/>
                                        </ui:hyperlink>
                                    </ui:property>
                                    <ui:property id="p4"
                                                 label="#{msg.dtu_status}"
                                                 labelAlign="right">
                                        <ui:staticText id="s4"
                                                       text="#{msg.dtu_connected}"
                                                       rendered="#{dtu.connected}"/>
                                        <ui:staticText id="s5"
                                                       text="#{msg.dtu_disconnected}"
                                                       rendered="#{!dtu.connected}"/>
                                    </ui:property>
                                    <ui:property id="p5"
                                                 label="#{msg.dtu_last_update}"
                                                 labelAlign="right">
                                        <ui:staticText id="s5" text="#{dtu.lastStatusUpdate}"/>
                                    </ui:property>

                                    <ui:property id="p6"
                                                 label="#{msg.dtu_first_connection}"
                                                 labelAlign="right">
                                        <ui:staticText id="s6" text="#{dtu.firstConnection}"/>
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>
                                </ui:propertySheetSection>
                                <ui:propertySheetSection id="s5"
                                                         label="#{msg.dtu_title_multihead}" 
                                                         rendered="#{dtu.multiheadGroupMember}">
                                    <ui:property id="p3"
                                                 label="#{msg.dtu_multihead_group_name}"
                                                 labelAlign="right">
                                        <ui:staticText id="s3"
                                                       text="#{dtu.multiheadGroupName}"/>
                                    </ui:property>
                                    <ui:property id="p4"
                                                 label="#{msg.dtu_multihead_group_geometry}"
                                                 labelAlign="right">
                                        <ui:staticText id="s3"
                                                       text="#{dtu.multiheadGroupGeometry}"
                                                       escape="false"/>
                                    </ui:property>
                                    <ui:property id="p5"
                                                 label="#{msg.dtu_multihead_group_members}"
                                                 labelAlign="right">
                                        <ui:staticText id="s3"
                                                       text="#{dtu.multiheadGroupMembers}"
                                                       escape="false"/>
                                    </ui:property>
                                </ui:propertySheetSection>
                                <ui:propertySheetSection id="s4"
                                                         label="#{msg.dtu_advanced_section}">
                                    <ui:property id="p1"
                                                 label="#{msg.dtu_token_reader}"
                                                 labelAlign="right">
                                        <ui:staticText id="s1"
                                                       text="#{msg.dtu_token_reader_use}"
                                                       rendered="#{dtu.configuredTokenReader}"/>
                                        <ui:staticText id="s2"
                                                       text="#{msg.dtu_no_token_reader}"
                                                       rendered="#{!dtu.configuredTokenReader}"/>
                                        <ui:panelGroup rendered="#{(dtu.configuredTokenReader != dtu.tokenReader)}">               
                                            <f:verbatim><br/></f:verbatim>
                                            <ui:image icon="DOT" width="1" height="15"/>
                                            <ui:image icon="ALERT_WARNING_SMALL"
                                                          alt="#{msg.alert_cold_restart_setting}" 
                                                          toolTip="#{msg.alert_cold_restart_setting}"/>
                                            <ui:staticText id="s0"
                                                           styleClass="HlpFldTxt"
                                                           text="#{msg.alert_cold_restart_setting}"/>
                                            <ui:staticText text="&#160;&#160;" escape="false"/>
                                        </ui:panelGroup>                   
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>
                                </ui:propertySheetSection>
                            </ui:propertySheet>    
                        </ui:contentPageTitle>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 

