/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.web.ui.component.Table;
import com.sun.web.ui.component.TableColumn;
import com.sun.web.ui.component.TableRowGroup;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class TableRenderer
extends Renderer {
    private static final String JAVASCRIPT_OBJECT_CLASS = "Table";
    private static final String[] stringAttributes = new String[]{"align", "bgColor", "dir", "frame", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseMove", "onMouseOut", "onMouseOver", "onMouseUp", "rules", "summary"};

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeBegin", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeBegin", "Component not rendered, nothing to display");
            return;
        }
        Table table = (Table)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagStart(context, table, writer);
        this.renderTitle(context, table, writer);
        this.renderActionsTop(context, table, writer);
        this.renderEmbeddedPanels(context, table, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        Table table = (Table)component;
        ResponseWriter writer = context.getResponseWriter();
        Iterator kids = table.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)((Object)kids.next());
            RenderingUtilities.renderComponent((UIComponent)group, context);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeEnd", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeEnd", "Component not rendered, nothing to display");
            return;
        }
        Table table = (Table)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderActionsBottom(context, table, writer);
        this.renderTableFooter(context, table, writer);
        this.renderEnclosingTagEnd(writer);
        this.renderJavascript(context, table, writer);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderActionsBottom(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderActionsBottom", "Cannot render actions bar, Table is null");
            return;
        }
        UIComponent actions = component.getTableActionsBottom();
        if (actions == null || !actions.isRendered()) {
            this.log("renderActionsBottom", "Actions bar not rendered, nothing to display");
            return;
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_tableActionsBottomBar"), null);
        RenderingUtilities.renderComponent(actions, context);
        writer.endElement("tr");
    }

    protected void renderActionsTop(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderActionsTop", "Cannot render actions bar, Table is null");
            return;
        }
        UIComponent actions = component.getTableActionsTop();
        if (actions == null || !actions.isRendered()) {
            this.log("renderActionsTop", "Actions bar not rendered, nothing to display");
            return;
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_tableActionsTopBar"), null);
        RenderingUtilities.renderComponent(actions, context);
        writer.endElement("tr");
    }

    protected void renderEmbeddedPanels(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEmbeddedPanels", "Cannot render embedded panels, Table is null");
            return;
        }
        UIComponent panels = component.getEmbeddedPanels();
        if (panels == null || !panels.isRendered()) {
            this.log("renderEmbeddedPanels", "Embedded panels not rendered, nothing to display");
            return;
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_embeddedPanelsBar"), null);
        RenderingUtilities.renderComponent(panels, context);
        writer.endElement("tr");
    }

    protected void renderTableFooter(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderTableFooter", "Cannot render table foter, Table is null");
            return;
        }
        UIComponent footer = component.getTableFooter();
        if (footer == null || !footer.isRendered()) {
            this.log("renderTableFooter", "Table footer not rendered, nothing to display");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_tableFooterBar"), null);
        RenderingUtilities.renderComponent(footer, context);
        writer.endElement("tr");
    }

    protected void renderTitle(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderTitle", "Cannot render title, Table is null");
            return;
        }
        UIComponent facet = component.getFacet("title");
        if (facet != null) {
            this.renderTitleStart(context, component, writer);
            RenderingUtilities.renderComponent(facet, context);
            this.renderTitleEnd(context, writer);
            return;
        }
        if (component.getTitle() == null) {
            this.log("renderTitle", "Title is null, nothing to display");
            return;
        }
        Theme theme = this.getTheme();
        String filter = component.getFilterText() != null ? theme.getMessage("table.title.filterApplied", new String[]{component.getFilterText()}) : "";
        TableRowGroup group = component.getTableRowGroupChild();
        boolean paginated = group != null ? group.isPaginated() : false;
        int totalRows = component.getRowCount();
        boolean emptyTable = totalRows == 0;
        boolean singlePage = totalRows < component.getRows();
        String title = component.getTitle();
        if (component.isAugmentTitle()) {
            if (!emptyTable && !singlePage && paginated) {
                int maxRows = component.getRows();
                int maxFirst = component.getFirst();
                String first = Integer.toString(maxFirst + 1);
                String last = Integer.toString(Math.min(maxFirst + maxRows, totalRows));
                title = component.getItemsText() != null ? theme.getMessage("table.title.paginatedItems", new String[]{component.getTitle(), first, last, Integer.toString(totalRows), component.getItemsText(), filter}) : theme.getMessage("table.title.paginated", new String[]{component.getTitle(), first, last, Integer.toString(totalRows), filter});
            } else {
                title = component.getItemsText() != null ? theme.getMessage("table.title.scrollItems", new String[]{component.getTitle(), Integer.toString(totalRows), component.getItemsText(), filter}) : theme.getMessage("table.title.scroll", new String[]{component.getTitle(), Integer.toString(totalRows), filter});
            }
        } else {
            this.log("renderTitle", "Title not augmented, itemsText & filterText not displayed");
        }
        this.renderTitleStart(context, component, writer);
        if (component.isHiddenSelectedRows()) {
            writer.startElement("span", (UIComponent)component);
            writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_TITLE_TEXT_SPAN"), null);
            writer.writeText((Object)title, null);
            writer.endElement("span");
            writer.startElement("span", (UIComponent)component);
            writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_TITLE_MESSAGE_SPAN"), null);
            writer.writeText((Object)theme.getMessage("table.hiddenSelections", new String[]{Integer.toString(component.getHiddenSelectedRowsCount())}), null);
            writer.endElement("span");
        } else {
            writer.writeText((Object)title, null);
        }
        this.renderTitleEnd(context, writer);
    }

    private void renderTitleStart(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.startElement("caption", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_titleBar"), null);
        writer.writeAttribute("class", (Object)this.getTheme().getStyleClass("TABLE_TITLE_TEXT"), null);
        if (component.getExtraTitleHtml() != null) {
            RenderingUtilities.renderExtraHtmlAttributes(writer, component.getExtraTitleHtml());
        }
    }

    private void renderTitleEnd(FacesContext context, ResponseWriter writer) throws IOException {
        writer.endElement("caption");
    }

    protected void renderEnclosingTagStart(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEnclosingTagStart", "Cannot render enclosing tag, Table is null");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        if (component.getStyle() != null) {
            writer.writeAttribute("style", (Object)component.getStyle(), null);
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)component, null);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        if (component.getWidth() != null) {
            String width = component.getWidth();
            if (width.indexOf("%") == -1) {
                width = width + "px";
            }
            writer.writeAttribute("style", (Object)("width:" + width), null);
        } else {
            writer.writeAttribute("style", (Object)"width:100%", null);
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("table", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_table"), null);
        String styleClass = theme.getStyleClass("TABLE");
        if (component.isLite()) {
            styleClass = styleClass + " " + theme.getStyleClass("TABLE_LITE");
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("width", (Object)"100%", null);
        if (component.getBorder() > -1) {
            writer.writeAttribute("border", (Object)Integer.toString(component.getBorder()), null);
        } else {
            writer.writeAttribute("border", (Object)"0", null);
        }
        if (component.getCellPadding() != null) {
            writer.writeAttribute("cellpadding", (Object)component.getCellPadding(), null);
        } else {
            writer.writeAttribute("cellpadding", (Object)"0", null);
        }
        if (component.getCellSpacing() != null) {
            writer.writeAttribute("cellspacing", (Object)component.getCellSpacing(), null);
        } else {
            writer.writeAttribute("cellspacing", (Object)"0", null);
        }
        if (component.getToolTip() != null) {
            writer.writeAttribute("title", (Object)component.getToolTip(), "toolTip");
        }
        RenderingUtilities.writeStringAttributes((UIComponent)component, writer, stringAttributes);
    }

    protected void renderEnclosingTagEnd(ResponseWriter writer) throws IOException {
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    private String getId(UIComponent component, String id) {
        String clientId = component.getClientId(FacesContext.getCurrentInstance());
        return clientId + ':' + id;
    }

    private String getSelectId(FacesContext context, TableColumn component) {
        TableRowGroup group;
        String selectId = null;
        if (component == null) {
            this.log("getSelectId", "Cannot obtain select Id, TableColumn is null");
            return selectId;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            TableColumn col;
            while (kids.hasNext() && (!(col = (TableColumn)((Object)kids.next())).isRendered() || (selectId = this.getSelectId(context, col)) == null)) {
            }
        } else if (component.getSelectId() != null && (group = component.getTableRowGroupAncestor()) != null) {
            String colId = component.getClientId(context);
            String groupId = group.getClientId(context) + ':';
            try {
                selectId = colId.substring(groupId.length(), colId.length()) + ':' + component.getSelectId();
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        return selectId;
    }

    private String getSelectSortMenuOptionValue(Table component) {
        TableRowGroup group = component.getTableRowGroupChild();
        if (group != null) {
            Iterator kids = group.getTableColumnChildren();
            while (kids.hasNext()) {
                String value;
                TableColumn col = (TableColumn)((Object)kids.next());
                if (!col.isRendered() || col.getSelectId() == null || (value = this.getSelectSortMenuOptionValue(col)) == null) continue;
                return value;
            }
        } else {
            this.log("getSelectSortMenuOptionValue", "Cannot obtain select sort menu option value, TableRowGroup is null");
        }
        return null;
    }

    private String getSelectSortMenuOptionValue(TableColumn component) {
        SortCriteria criteria;
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                String value;
                TableColumn col = (TableColumn)((Object)kids.next());
                if (!col.isRendered() || col.getSelectId() == null || (value = this.getSelectSortMenuOptionValue(col)) == null) continue;
                return value;
            }
        }
        return (criteria = component.getSortCriteria()) != null ? criteria.getCriteriaKey() : null;
    }

    private String getSortToolTipJavascript(Table component, boolean descending) {
        String tooltip = descending ? "table.sort.augment.undeterminedDescending" : "table.sort.augment.undeterminedAscending";
        StringBuffer buff = new StringBuffer(1024);
        buff.append("new Array('").append(this.getTheme().getMessage(tooltip)).append("'");
        TableRowGroup group = component.getTableRowGroupChild();
        if (group != null) {
            Iterator kids = group.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                if (!col.isRendered()) continue;
                buff.append(",'").append(col.getSortToolTipAugment(descending)).append("'");
            }
        } else {
            this.log("getSortToolTipJavascript", "Cannot obtain Javascript array of sort tool tips, TableRowGroup is null");
        }
        buff.append(")");
        return buff.toString();
    }

    private String getTableColumnFooterStyleClass(TableColumn component, int level) {
        String styleClass = null;
        styleClass = component.isSpacerColumn() ? "TABLE_COL_FOOTER_SPACER" : (level == 1 ? "TABLE_COL_FOOTER_SORT" : "TABLE_COL_FOOTER");
        return this.getTheme().getStyleClass(styleClass);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private void log(String method, String message) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }

    private void renderJavascript(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderJavascript", "Cannot render Javascript, Table is null");
            return;
        }
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderJsInclude(context, (UIComponent)component, this.getTheme(), writer, "table");
        this.renderAssignFunctions(context, component, writer);
        this.renderAssignPanelProperties(context, component, writer);
        this.renderAssignFilterProperties(context, component, writer);
        this.renderAssignSortPanelProperties(context, component, writer);
        this.renderAssignGroupProperties(context, component, writer);
        this.renderAssignGroupPanelProperties(context, component, writer);
    }

    private void renderAssignFunctions(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderAssignFunctions", "Cannot render assignFunctions Javascript function, Table is null");
            return;
        }
        StringBuffer buff = new StringBuffer(1024);
        buff.append("sjwuic_table_assignFunctions('").append(component.getClientId(context)).append("')");
        writer.writeText((Object)"\n", null);
        writer.startElement("script", (UIComponent)component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)buff.toString(), null);
        writer.endElement("script");
    }

    private void renderAssignPanelProperties(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderAssignPanelProperties", "Cannot render assignProperties Javascript function, Table is null");
            return;
        }
        UIComponent panels = component.getFacet("_embeddedPanels");
        if (panels == null) {
            this.log("renderAssignPanelProperties", "Cannot render assignProperties Javascript function, embedded panels facet is null");
            return;
        }
        Theme theme = this.getTheme();
        String prefix = panels.getClientId(context) + ':';
        StringBuffer buff = new StringBuffer(1024);
        buff.append("sjwuic_table_assignPanelProperties('").append(component.getClientId(context)).append("'");
        buff.append(",new Array('").append(prefix + "_sortPanel").append("','").append(prefix + "_preferencesPanel").append("','").append(prefix + "_filterPanel").append("')");
        UIComponent actions = component.getFacet("_tableActionsTop");
        if (actions == null) {
            this.log("renderAssignPanelProperties", "Cannot render assignProperties Javascript function, actions top facet is null");
            return;
        }
        buff.append(",new Array('").append(component.getSortPanelFocusId() != null ? component.getSortPanelFocusId() : prefix + "_primarySortColumnMenu").append("',").append(component.getPreferencesPanelFocusId() != null ? "'" + component.getPreferencesPanelFocusId() + "'" : "null").append(",").append(component.getFilterPanelFocusId() != null ? "'" + component.getFilterPanelFocusId() + "'" : "null").append(")");
        prefix = actions.getClientId(context) + ':';
        buff.append(",new Array('").append(prefix + "_sortPanelToggleButton").append("','").append(prefix + "_preferencesPanelToggleButton").append("','").append(component.getFilterId() != null ? component.getFilterId() : "").append("')");
        buff.append(",new Array('").append(theme.getIcon("TABLE_SORT_PANEL_FLIP").getUrl()).append("','").append(theme.getIcon("TABLE_PREFERENCES_PANEL_FLIP").getUrl()).append("', null)");
        buff.append(",new Array('").append(theme.getIcon("TABLE_SORT_PANEL").getUrl()).append("','").append(theme.getIcon("TABLE_PREFERENCES_PANEL").getUrl()).append("', null))");
        writer.writeText((Object)"\n", null);
        writer.startElement("script", (UIComponent)component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)buff.toString(), null);
        writer.endElement("script");
    }

    private void renderAssignFilterProperties(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderAssignFilterProperties", "Cannot render assignFilterProperties Javascript function, Table is null");
            return;
        }
        Theme theme = this.getTheme();
        StringBuffer buff = new StringBuffer(1024);
        buff.append("sjwuic_table_assignFilterProperties('").append(component.getClientId(context)).append("'");
        buff.append(",'").append(theme.getStyleClass("MENU_JUMP")).append("','").append(theme.getStyleClass("TABLE_CUSTOM_FILTER_MENU")).append("'");
        buff.append(",'").append("_customFilter").append("','").append("_customFilterApplied").append("')");
        writer.writeText((Object)"\n", null);
        writer.startElement("script", (UIComponent)component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)buff.toString(), null);
        writer.endElement("script");
    }

    private void renderAssignGroupProperties(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        TableRowGroup group;
        if (component == null) {
            this.log("renderAssignGroupProperties", "Cannot render assignGroupProperties Javascript function, Table is null");
            return;
        }
        Theme theme = this.getTheme();
        StringBuffer buff = new StringBuffer(1024);
        buff.append("sjwuic_table_assignGroupProperties('").append(component.getClientId(context)).append("'");
        buff.append(",'").append(theme.getStyleClass("TABLE_SELECT_ROW")).append("'");
        buff.append(",new Array(");
        Iterator kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableColumn col;
            group = (TableRowGroup)((Object)kids.next());
            String selectId = null;
            Iterator grandkids = group.getTableColumnChildren();
            while (grandkids.hasNext() && (!(col = (TableColumn)((Object)grandkids.next())).isRendered() || (selectId = this.getSelectId(context, col)) == null)) {
            }
            buff.append("'").append(selectId != null ? selectId : "").append("'");
            if (!kids.hasNext()) continue;
            buff.append(",");
        }
        buff.append(")");
        buff.append(",new Array(");
        kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            group = (TableRowGroup)((Object)kids.next());
            buff.append("'").append(group.getClientId(context)).append("'");
            if (!kids.hasNext()) continue;
            buff.append(",");
        }
        buff.append(")");
        buff.append(",new Array(");
        kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            group = (TableRowGroup)((Object)kids.next());
            RowKey[] rowKeys = group.getRenderedRowKeys();
            if (rowKeys != null) {
                buff.append("new Array(");
                for (int i = 0; i < rowKeys.length; ++i) {
                    buff.append(i > 0 ? ",'" : "'").append(rowKeys[i].getRowId()).append("'");
                }
                buff.append(")");
            } else {
                buff.append("null");
            }
            if (!kids.hasNext()) continue;
            buff.append(",");
        }
        buff.append(")");
        buff.append(",new Array(");
        kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            group = (TableRowGroup)((Object)kids.next());
            if (component.isHiddenSelectedRows()) {
                buff.append("'").append(Integer.toString(group.getHiddenSelectedRowsCount())).append("'");
            } else {
                buff.append("'0'");
            }
            if (!kids.hasNext()) continue;
            buff.append(",");
        }
        buff.append(")");
        buff.append(",'").append(theme.getMessage("table.confirm.hiddenSelections")).append("','").append(theme.getMessage("table.confirm.totalSelections")).append("','").append(theme.getMessage("table.confirm.deleteSelections")).append("')");
        writer.writeText((Object)"\n", null);
        writer.startElement("script", (UIComponent)component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)buff.toString(), null);
        writer.endElement("script");
    }

    private void renderAssignGroupPanelProperties(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderAssignGroupPanelProperties", "Cannot render assignGroupPanelProperties Javascript function, Table is null");
            return;
        }
        Theme theme = this.getTheme();
        StringBuffer buff = new StringBuffer(1024);
        buff.append("sjwuic_table_assignGroupPanelProperties('").append(component.getClientId(context)).append("'");
        buff.append(",'").append("_columnFooterBar").append("','").append("_columnHeaderBar").append("','").append("_tableColumnFooterBar").append("','").append("_groupFooterBar").append("'");
        String prefix = "_groupHeader:";
        buff.append(",'").append(prefix + "_groupPanelToggleButton").append("','").append(theme.getMessage("table.group.collapse")).append("','").append(theme.getMessage("table.group.expand")).append("','").append(theme.getIcon("TABLE_GROUP_PANEL_FLIP").getUrl()).append("','").append(theme.getIcon("TABLE_GROUP_PANEL").getUrl()).append("'");
        buff.append(",'").append(prefix + "_warningIcon").append("','").append(this.getTheme().getIcon("DOT").getUrl()).append("','").append(this.getTheme().getIcon("ALERT_WARNING_SMALL").getUrl()).append("',").append("null").append(",'").append(theme.getMessage("table.group.warning")).append("'");
        buff.append(",'").append(prefix + "_collapsedHiddenField").append("'");
        buff.append(",'").append(prefix + "_selectMultipleToggleButton").append("','").append(theme.getMessage("table.group.selectMultiple")).append("','").append(theme.getMessage("table.group.deselectMultiple")).append("')");
        writer.writeText((Object)"\n", null);
        writer.startElement("script", (UIComponent)component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)buff.toString(), null);
        writer.endElement("script");
    }

    private void renderAssignSortPanelProperties(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderAssignSortPanelProperties", "Cannot render assignSortPanelProperties Javascript function, Table is null");
            return;
        }
        UIComponent panels = component.getFacet("_embeddedPanels");
        if (panels == null) {
            this.log("renderAssignSortPanelProperties", "Cannot render assignSortPanelProperties Javascript function, Embedded panels facet is null");
            return;
        }
        Theme theme = this.getTheme();
        String prefix = panels.getClientId(context) + ':';
        StringBuffer buff = new StringBuffer(1024);
        buff.append("sjwuic_table_assignSortPanelProperties('").append(component.getClientId(context)).append("'");
        buff.append(",new Array('").append(prefix + "_primarySortColumnMenu").append("','").append(prefix + "_secondarySortColumnMenu").append("','").append(prefix + "_tertiarySortColumnMenu").append("')");
        buff.append(",new Array('").append(prefix + "_primarySortOrderMenu").append("','").append(prefix + "_secondarySortOrderMenu").append("','").append(prefix + "_tertiarySortOrderMenu").append("')");
        buff.append(",new Array('").append(theme.getMessage("table.panel.primarySortOrder")).append("','").append(theme.getMessage("table.panel.secondarySortOrder")).append("','").append(theme.getMessage("table.panel.tertiarySortOrder")).append("')");
        buff.append(",").append(this.getSortToolTipJavascript(component, false));
        buff.append(",").append(this.getSortToolTipJavascript(component, true));
        buff.append(",'").append(theme.getMessage("table.panel.duplicateSelectionError")).append("','").append(theme.getMessage("table.panel.missingSelectionError")).append("'");
        String value = this.getSelectSortMenuOptionValue(component);
        TableRowGroup group = component.getTableRowGroupChild();
        buff.append(",'").append(value != null ? value : "null").append("',").append(component.isHiddenSelectedRows()).append(",").append(group != null ? Boolean.toString(group.isPaginated()) : "false").append(")");
        writer.writeText((Object)"\n", null);
        writer.startElement("script", (UIComponent)component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)buff.toString(), null);
        writer.endElement("script");
    }
}

