/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.advanced;

import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.I18N;
import com.sun.ut.service.Policy;
import com.sun.ut.service.ServiceException;
import com.sun.web.ui.model.Option;
import java.util.ArrayList;
import java.util.List;

public class PolicyHandler
extends BaseHandler {
    private static final int ACCESS_NONE = 0;
    private static final int ACCESS_ALL_USERS = 1;
    private static final int ACCESS_REGISTERED_USERS = 2;
    private static final int NUMBER_ACCESS_OPTIONS = 3;
    private boolean kioskConfigured = false;
    private int smartCardAccess = 0;
    private boolean smartCardKiosk = false;
    private int nonSmartCardAccess = 0;
    private boolean nonSmartCardKiosk = false;
    private boolean nscmSupported = false;
    private boolean nscmEnabled = false;
    private boolean nscmExitAllowed = false;
    private boolean smartCardSelfRegistration = false;
    private boolean nonSmartCardSelfRegistration = false;
    private boolean cardUnixAuthentication = false;
    private boolean nonCardUnixAuthentication = false;
    private boolean multiheadEnabled = false;
    private boolean directSessionAccessEnabled = false;
    private ArrayList accessOptions;
    private Policy policy;

    public PolicyHandler() {
        try {
            String selfRegistrationAccess;
            String unregisteredAccess;
            String registeredAccess;
            this.kioskConfigured = this.getProvider().isKioskConfigured();
            this.nscmSupported = this.getProvider().isNscmSupported();
            this.policy = this.getProvider().getPolicy();
            this.nonCardUnixAuthentication = this.cardUnixAuthentication = this.policy.isUnixAuthenticationRequired();
            this.nscmEnabled = this.policy.isNscmEnabled();
            this.nscmExitAllowed = this.policy.isNscmExitAllowed();
            this.multiheadEnabled = this.policy.isMultiheadEnabled();
            this.directSessionAccessEnabled = this.policy.isDirectSessionAccessEnabled();
            String kioskMode = this.policy.getKioskMode();
            if (kioskMode != null) {
                if (kioskMode.equals("both")) {
                    this.smartCardKiosk = true;
                    this.nonSmartCardKiosk = true;
                } else if (kioskMode.equals("card")) {
                    this.smartCardKiosk = true;
                } else if (kioskMode.equals("pseudo")) {
                    this.nonSmartCardKiosk = true;
                }
            }
            if ((registeredAccess = this.policy.getRegisteredTokensAccess()) != null) {
                if (registeredAccess.equals("both")) {
                    this.smartCardAccess = 2;
                    this.nonSmartCardAccess = 2;
                } else if (registeredAccess.equals("card")) {
                    this.smartCardAccess = 2;
                } else if (registeredAccess.equals("pseudo")) {
                    this.nonSmartCardAccess = 2;
                }
            }
            if ((unregisteredAccess = this.policy.getUnregisteredTokensAccess()) != null) {
                if (unregisteredAccess.equals("both")) {
                    this.smartCardAccess = 1;
                    this.nonSmartCardAccess = 1;
                } else if (unregisteredAccess.equals("card")) {
                    this.smartCardAccess = 1;
                } else if (unregisteredAccess.equals("pseudo")) {
                    this.nonSmartCardAccess = 1;
                }
            }
            if ((selfRegistrationAccess = this.policy.getSelfRegisteredTokensAccess()) != null) {
                if (selfRegistrationAccess.equals("both")) {
                    this.smartCardSelfRegistration = true;
                    this.nonSmartCardSelfRegistration = true;
                } else if (selfRegistrationAccess.equals("card")) {
                    this.smartCardSelfRegistration = true;
                } else if (selfRegistrationAccess.equals("pseudo")) {
                    this.nonSmartCardSelfRegistration = true;
                }
            }
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("policy_alert_get", se);
        }
    }

    public String modify() {
        try {
            if (this.smartCardKiosk && this.nonSmartCardKiosk) {
                this.policy.setKioskMode("both");
            } else if (this.smartCardKiosk) {
                this.policy.setKioskMode("card");
            } else if (this.nonSmartCardKiosk) {
                this.policy.setKioskMode("pseudo");
            } else {
                this.policy.setKioskMode(null);
            }
            if (this.smartCardSelfRegistration && this.nonSmartCardSelfRegistration) {
                this.policy.setSelfRegisteredTokensAccess("both");
                this.policy.setUnixAuthentication(this.nonCardUnixAuthentication);
            } else if (this.smartCardSelfRegistration) {
                this.policy.setSelfRegisteredTokensAccess("card");
                this.policy.setUnixAuthentication(this.cardUnixAuthentication);
            } else if (this.nonSmartCardSelfRegistration) {
                this.policy.setSelfRegisteredTokensAccess("pseudo");
                this.policy.setUnixAuthentication(this.nonCardUnixAuthentication);
            } else {
                this.policy.setSelfRegisteredTokensAccess(null);
                this.policy.setUnixAuthentication(true);
            }
            if (this.smartCardAccess == 2 && this.nonSmartCardAccess == 2) {
                this.policy.setRegisteredTokensAccess("both");
            } else if (this.smartCardAccess == 2) {
                this.policy.setRegisteredTokensAccess("card");
            } else if (this.nonSmartCardAccess == 2) {
                this.policy.setRegisteredTokensAccess("pseudo");
            } else {
                this.policy.setRegisteredTokensAccess(null);
            }
            if (this.smartCardAccess == 1 && this.nonSmartCardAccess == 1) {
                this.policy.setUnregisteredTokensAccess("both");
            } else if (this.smartCardAccess == 1) {
                this.policy.setUnregisteredTokensAccess("card");
            } else if (this.nonSmartCardAccess == 1) {
                this.policy.setUnregisteredTokensAccess("pseudo");
            } else {
                this.policy.setUnregisteredTokensAccess(null);
            }
            this.policy.setDirectSessionAccess(this.directSessionAccessEnabled);
            this.policy.setMultihead(this.multiheadEnabled);
            this.policy.setNscm(this.nscmEnabled);
            if (this.nscmEnabled) {
                this.policy.setNscmExit(this.nscmExitAllowed);
            } else {
                this.policy.setNscmExit(true);
            }
            Object[] args = new String[]{this.policy.getContent()};
            this.getProvider().modifyPolicy(this.policy);
            this.getNotification().setRestartRequired(true);
            this.getStatusMessage().restartRequired();
            this.getAuditService().publishEvent("Admin", "policy_changed", args, 0);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("policy_alert_modify", se);
        }
        return "success";
    }

    public List getAccessOptions() {
        if (this.accessOptions == null) {
            Option none = new Option((Object)new Integer(0), I18N.getResource("policy_access_none"));
            none.setTooltip(I18N.getResource("policy_access_tooltip_none"));
            Option all = new Option((Object)new Integer(1), I18N.getResource("policy_access_all_users"));
            all.setTooltip(I18N.getResource("policy_access_tooltip_all"));
            Option registered = new Option((Object)new Integer(2), I18N.getResource("policy_access_registered_users"));
            registered.setTooltip(I18N.getResource("policy_access_tooltip_registered"));
            this.accessOptions = new ArrayList(3);
            this.accessOptions.add(none);
            this.accessOptions.add(all);
            this.accessOptions.add(registered);
        }
        return this.accessOptions;
    }

    public boolean isKioskConfigured() {
        return this.kioskConfigured;
    }

    public boolean isNscmSupported() {
        return this.nscmSupported;
    }

    public int getSmartCardAccess() {
        return this.smartCardAccess;
    }

    public void setSmartCardAccess(int value) {
        this.smartCardAccess = value;
    }

    public boolean isSmartCardKiosk() {
        return this.smartCardKiosk;
    }

    public void setSmartCardKiosk(boolean enabled) {
        this.smartCardKiosk = enabled;
    }

    public int getNonSmartCardAccess() {
        return this.nonSmartCardAccess;
    }

    public void setNonSmartCardAccess(int value) {
        this.nonSmartCardAccess = value;
    }

    public boolean isNonSmartCardKiosk() {
        return this.nonSmartCardKiosk;
    }

    public void setNonSmartCardKiosk(boolean enabled) {
        this.nonSmartCardKiosk = enabled;
    }

    public boolean isNscmEnabled() {
        return this.nscmEnabled;
    }

    public void setNscmEnabled(boolean enabled) {
        this.nscmEnabled = enabled;
    }

    public boolean isNscmExitAllowed() {
        return this.nscmExitAllowed;
    }

    public void setNscmExitAllowed(boolean enabled) {
        this.nscmExitAllowed = enabled;
    }

    public boolean isSmartCardSelfRegistration() {
        return this.smartCardSelfRegistration;
    }

    public void setSmartCardSelfRegistration(boolean enabled) {
        this.smartCardSelfRegistration = enabled;
    }

    public boolean isNonSmartCardSelfRegistration() {
        return this.nonSmartCardSelfRegistration;
    }

    public void setNonSmartCardSelfRegistration(boolean enabled) {
        this.nonSmartCardSelfRegistration = enabled;
    }

    public boolean isCardUnixAuthentication() {
        return this.cardUnixAuthentication;
    }

    public void setCardUnixAuthentication(boolean enabled) {
        this.cardUnixAuthentication = enabled;
    }

    public boolean isNonCardUnixAuthentication() {
        return this.nonCardUnixAuthentication;
    }

    public void setNonCardUnixAuthentication(boolean enabled) {
        this.nonCardUnixAuthentication = enabled;
    }

    public boolean isMultiheadEnabled() {
        return this.multiheadEnabled;
    }

    public void setMultiheadEnabled(boolean enabled) {
        this.multiheadEnabled = enabled;
    }

    public boolean isDirectSessionAccessEnabled() {
        return this.directSessionAccessEnabled;
    }

    public void setDirectSessionAccessEnabled(boolean enabled) {
        this.directSessionAccessEnabled = enabled;
    }
}

