/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.logs;

import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.Context;
import com.sun.ut.service.LogFile;
import com.sun.web.ui.model.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class LogFilesHandler
extends BaseHandler {
    public static final String LOGDIR_PATH = "/var/opt/SUNWut/log/";
    public static final String SELECTED_LOG_FILE = "selectedLogFileName";

    public Option[] getMessageOptions() {
        return this.getOptions("messages");
    }

    public Option[] getAuthOptions() {
        return this.getOptions("auth_log");
    }

    public Option[] getAdminOptions() {
        return this.getOptions("admin_log");
    }

    public Option[] getMountOptions() {
        return this.getOptions("utmountd.log");
    }

    public Option[] getStorageOptions() {
        return this.getOptions("utstoraged.log");
    }

    public LogFile getSelectedLogFile() {
        return new LogFile(new File(LOGDIR_PATH + this.getSelectedLogFileName()));
    }

    public void setSelectedLogFileName(String name) {
        Context.setSessionAttribute(SELECTED_LOG_FILE, name);
        if (name.startsWith("messages")) {
            Context.setSessionAttribute("messagesLogFileName", name);
        }
        if (name.startsWith("auth_log")) {
            Context.setSessionAttribute("auth_logLogFileName", name);
        }
        if (name.startsWith("admin_log")) {
            Context.setSessionAttribute("admin_logLogFileName", name);
        }
        if (name.startsWith("utmountd.log")) {
            Context.setSessionAttribute("utmountd.logLogFileName", name);
        }
        if (name.startsWith("utstoraged.log")) {
            Context.setSessionAttribute("utstoraged.logLogFileName", name);
        }
    }

    public String getSelectedLogFileName() {
        String name = (String)Context.getSessionAttribute(SELECTED_LOG_FILE);
        return name;
    }

    private Option[] getOptions(String basename) {
        ArrayList<LogFile> logFiles = new ArrayList<LogFile>();
        File dir = new File(LOGDIR_PATH);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String filename = file.getName();
            if (!file.isFile() || !filename.startsWith(basename)) continue;
            logFiles.add(new LogFile(file));
        }
        Collections.sort(logFiles);
        String storedName = (String)Context.getSessionAttribute(basename + "LogFileName");
        String newName = null;
        Option[] options = new Option[logFiles.size()];
        for (int i = 0; i < logFiles.size(); ++i) {
            LogFile logFile = (LogFile)logFiles.get(i);
            options[i] = new Option((Object)logFile.getName(), logFile.getName() + "&#160;" + logFile.getDate());
            String name = logFile.getName();
            if (i == 0) {
                newName = name;
                continue;
            }
            if (storedName == null || !storedName.equals(name)) continue;
            newName = name;
        }
        this.setSelectedLogFileName(newName);
        return options;
    }
}

