/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.authentication;

import com.sun.ut.service.authentication.AuthenticationMessage;
import com.sun.ut.service.authentication.LoginModule;
import com.sun.ut.service.authentication.PamMessage;
import junit.framework.TestCase;

public class LoginTest
extends TestCase {
    public static final String[] SUCCESS_INPUTS = new String[]{"admin", "admin"};
    public static final String[] FAILURE_INPUTS = new String[]{"wrong username", "wrong password"};
    private LoginModule loginModule;

    protected final void setUp() throws Exception {
        this.loginModule = new LoginModule();
        this.loginModule.init();
        AuthenticationMessage authMsg = this.loginModule.login(null);
        LoginTest.assertTrue((String)"Could not retrieve initial login challenge!", (boolean)authMsg.isData());
        PamMessage pam = new PamMessage(authMsg.getData());
        this.displayPamMessage(pam);
        this.loginModule.abort();
        System.out.println("Login module is ready\n");
    }

    protected final void tearDown() {
        this.loginModule = null;
    }

    public void testSuccessfulLogin() throws Exception {
        PamMessage pam = this.performLogin(SUCCESS_INPUTS);
        LoginTest.assertTrue((String)"Login did not succeed!", (boolean)pam.isSuccess());
        System.out.println("Successfully logged in as " + pam.getMessage() + "\n");
    }

    public void testFailedLogin() throws Exception {
        PamMessage pam = this.performLogin(FAILURE_INPUTS);
        LoginTest.assertFalse((String)"Login succeeded with wrong user name and password!", (boolean)pam.isSuccess());
    }

    private PamMessage performLogin(String[] inputs) throws Exception {
        int i = 0;
        this.loginModule.init();
        AuthenticationMessage authMsg = this.loginModule.login(null);
        LoginTest.assertTrue((String)"Could not retrieve initial login challenge!", (boolean)authMsg.isData());
        PamMessage pam = new PamMessage(authMsg.getData());
        this.displayPamMessage(pam);
        while (!authMsg.isDisconnect()) {
            LoginTest.assertTrue((String)"Error got more challenges than expected", (i < inputs.length ? 1 : 0) != 0);
            System.out.println(inputs[i]);
            authMsg = this.loginModule.login(inputs[i]);
            LoginTest.assertNotNull((String)"Could not retrieve next challenge!", (Object)authMsg.getData());
            pam = new PamMessage(authMsg.getData());
            this.displayPamMessage(pam);
            ++i;
        }
        this.loginModule.commit();
        return pam;
    }

    private void displayPamMessage(PamMessage pam) {
        System.out.println(pam.getType() + ", " + pam.getMessage());
    }
}

