/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.command;

import com.sun.ut.service.command.StreamListener;
import java.io.IOException;
import java.io.InputStream;

public class Task
extends Thread {
    public static final int ERROR_CODE = -1;
    public static final int SUCCESS_CODE = 0;
    private String[] args;
    private Process process;
    private String errorMsg = "";
    private String outputMsg = "";
    private int exitCode = -1;

    public Task() {
    }

    public Task(String[] args) {
        this.args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.process = Runtime.getRuntime().exec(this.getElements());
            InputStream[] streams = new InputStream[]{this.process.getInputStream(), this.process.getErrorStream()};
            StreamListener listener = new StreamListener(streams);
            listener.start();
            this.process.waitFor();
            this.exitCode = this.process.exitValue();
            listener.join();
            this.errorMsg = listener.getOutput(1);
            this.outputMsg = listener.getOutput(0);
            this.process.getOutputStream().close();
            this.process.getInputStream().close();
            this.process.getErrorStream().close();
        }
        catch (IOException e) {
            this.errorMsg = e.getMessage();
        }
        catch (InterruptedException e) {
            this.errorMsg = e.getMessage();
        }
        finally {
            this.process = null;
        }
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getOutputMsg() {
        return this.outputMsg;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setElements(String[] elements) {
        this.args = elements;
    }

    public String[] getElements() {
        return this.args;
    }

    public String getSyntax() {
        StringBuffer buffer = new StringBuffer();
        String[] cmd = this.getElements();
        for (int i = 0; i < cmd.length; ++i) {
            buffer.append(cmd[i]);
            buffer.append(" ");
        }
        return buffer.toString();
    }
}

