/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.jni;

import com.sun.ut.service.Kiosk;
import com.sun.ut.service.KioskApplication;
import com.sun.ut.service.KioskDescriptor;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.KioskStatus;
import com.sun.ut.service.command.UtKiosk;
import com.sun.ut.service.jni.Datastore;
import com.sun.ut.service.jni.DatastoreFactory;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;

public class KioskTest
extends TestCase {
    private Datastore ds;
    private String backupKiosk;
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int FIVE = 5;
    private static final int SIX = 6;
    private static final String[] TEST_DESCRIPTOR = new String[]{"gnome", "Gnome", "/path/to/icon", "application"};
    private static final String[] TEST_KIOSK = new String[]{"15000", "1000", "2000", "3000", "4000", "en", "-args"};
    private static final String[] TEST_RECOMMENDATIONS = new String[]{"500", "1000", "1500", "2000", "2500", "en-US", "-a -b"};
    private static final String[] TEST_APPLICATION = new String[]{"/path/to/app", "exec", "critical", "-args"};
    private static final KioskApplication KIOSK_APPLICATION = new KioskApplication(TEST_APPLICATION[0], TEST_APPLICATION[1], TEST_APPLICATION[1], TEST_APPLICATION[3]);
    private static final KioskApplication[] KIOSK_APPS = new KioskApplication[]{KIOSK_APPLICATION};
    private static final Kiosk RECOMMENDATIONS = new Kiosk(null, TEST_RECOMMENDATIONS[0], TEST_RECOMMENDATIONS[1], TEST_RECOMMENDATIONS[2], TEST_RECOMMENDATIONS[3], TEST_RECOMMENDATIONS[4], TEST_RECOMMENDATIONS[5], TEST_RECOMMENDATIONS[6], new ArrayList<KioskApplication>(Arrays.asList(KIOSK_APPS)));
    private static final KioskDescriptor DESCRIPTOR = new KioskDescriptor(TEST_DESCRIPTOR[0], TEST_DESCRIPTOR[1], true, TEST_DESCRIPTOR[2], TEST_DESCRIPTOR[3], RECOMMENDATIONS);
    private static final Kiosk KIOSK = new Kiosk(DESCRIPTOR, TEST_KIOSK[0], TEST_KIOSK[1], TEST_KIOSK[2], TEST_KIOSK[3], TEST_KIOSK[4], TEST_KIOSK[5], TEST_KIOSK[6], new ArrayList<KioskApplication>(Arrays.asList(KIOSK_APPS)));

    protected final void setUp() throws ServiceException {
        KioskStatus status = new KioskStatus();
        if (status.isKioskConfigured()) {
            this.ds = DatastoreFactory.getDatastore();
            try {
                this.backupKiosk = this.ds.getKiosk();
                System.out.println("Backup Kiosk: " + this.backupKiosk);
                UtKiosk cmd = new UtKiosk();
                cmd.deleteKiosk();
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
    }

    protected final void tearDown() throws ServiceException {
        KioskStatus status = new KioskStatus();
        if (status.isKioskConfigured()) {
            try {
                this.ds.getKiosk();
                UtKiosk cmd = new UtKiosk();
                cmd.deleteKiosk();
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            if (this.backupKiosk != null) {
                System.out.println("Restoring Kiosk: " + this.backupKiosk);
                this.ds.saveKiosk(this.backupKiosk);
            }
            this.ds = null;
        }
    }

    public void testKioskSaveContent() throws ServiceException {
        KioskStatus status = new KioskStatus();
        if (status.isKioskConfigured()) {
            System.out.println("JNI Kiosk Method Tests");
            System.out.println("Saving new Kiosk: " + KIOSK.getContents());
            this.ds.saveKiosk(KIOSK.getContents());
            System.out.println("Retrieving saved Kiosk");
            String kioskContents = null;
            try {
                kioskContents = this.ds.getKiosk();
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            KioskTest.assertNotNull((Object)kioskContents);
            KioskTest.assertTrue((boolean)KIOSK.getContents().equals(kioskContents));
        } else {
            System.out.println("Kiosk Mode is not configured. Unable to complete JNI Kiosk tests!");
        }
    }
}

