/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.UploadBase;
import com.sun.web.ui.model.UploadedFile;
import com.sun.web.ui.util.ComponentUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.fileupload.FileItem;

public class Upload
extends UploadBase
implements Serializable {
    public static final String INPUT_ID = "_com.sun.web.ui.upload";
    public static final String INPUT_PARAM_ID = "_com.sun.web.ui.uploadParam";
    public static final String SCRIPT_ID = "_script";
    public static final String SCRIPT_FACET = "script";
    public static final String TEXT_ID = "_text";
    public static final String LENGTH_EXCEEDED = "length_exceeded";
    public static final String UPLOAD_ERROR_KEY = "upload_error_key";
    public static final String FILE_SIZE_KEY = "file_size_key";
    private static final boolean DEBUG = false;

    protected void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    public Object getConvertedValue(FacesContext context, Object value) {
        String name;
        UploadedFileImpl uf = new UploadedFileImpl();
        uf.setAttribute(value);
        if (this.isRequired() && uf.getSize() == 0L && ((name = uf.getOriginalName()) == null || name.trim().length() == 0)) {
            this.setValue("");
            return "";
        }
        return uf;
    }

    public String getValueAsString(FacesContext context) {
        return null;
    }

    public String getReadOnlyValueString(FacesContext context) {
        String valueString = null;
        Object value = this.getValue();
        if (value != null & value instanceof UploadedFile) {
            try {
                valueString = ((UploadedFile)value).getOriginalName();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (valueString == null) {
            valueString = ThemeUtilities.getTheme(context).getMessage("FileUpload.noFile");
        }
        return valueString;
    }

    public String getType() {
        return "file";
    }

    public Object getText() {
        return null;
    }

    public void setText(Object text) {
    }

    public int getColumns() {
        int columns = super.getColumns();
        if (columns < 1) {
            columns = 40;
            super.setColumns(40);
        }
        return columns;
    }

    public String getPrimaryElementID(FacesContext context) {
        String clntId = this.getClientId(context);
        UIComponent facet = this.getFacet("label");
        if (facet != null) {
            return clntId.concat(INPUT_ID);
        }
        facet = ComponentUtilities.getPrivateFacet((UIComponent)this, "label", false);
        if (facet == null) {
            return this.getClientId(context);
        }
        return this.getClientId(context).concat(INPUT_ID);
    }

    class UploadedFileImpl
    implements UploadedFile {
        transient Object attribute = null;

        UploadedFileImpl() {
        }

        void setAttribute(Object attribute) {
            this.attribute = attribute;
        }

        private FileItem getFileItemObject() {
            FacesContext context = FacesContext.getCurrentInstance();
            Object fileItemObject = context.getExternalContext().getRequestMap().get(this.attribute);
            if (!(fileItemObject instanceof FileItem)) {
                String message = "Did you install the upload filter?";
                throw new FacesException(message);
            }
            return (FileItem)fileItemObject;
        }

        public void write(File file) throws Exception {
            this.getFileItemObject().write(file);
        }

        public long getSize() {
            return this.getFileItemObject().getSize();
        }

        public String getOriginalName() {
            return this.getFileItemObject().getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.getFileItemObject().getInputStream();
        }

        public String getContentType() {
            return this.getFileItemObject().getContentType();
        }

        public byte[] getBytes() {
            return this.getFileItemObject().get();
        }

        public String getAsString() {
            return this.getFileItemObject().getString();
        }

        public void dispose() {
            this.getFileItemObject().delete();
        }
    }
}

