/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import com.sun.ut.service.ServiceException;

public abstract class ReplicationListener {
    private static final int MAX_WAIT_LOOPS = 8;
    private static final int INITIAL_WAIT_TIME = 100;
    private Object data;

    public ReplicationListener() {
        this.data = null;
    }

    public ReplicationListener(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public abstract boolean isReplicated() throws ServiceException;

    public void waitForReplication() throws ServiceException {
        boolean replicated = false;
        int waitTime = 100;
        for (int i = 0; i < 8; ++i) {
            try {
                Thread.currentThread();
                Thread.sleep(waitTime);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            if (this.isReplicated()) {
                replicated = true;
                break;
            }
            waitTime += waitTime;
        }
        if (!replicated) {
            throw new ServiceException("error_replication", -1);
        }
    }
}

