/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.jni;

import com.sun.ut.service.jni.BusyFlag;
import com.sun.ut.service.jni.Datastore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class SynchronizedDatastore
implements InvocationHandler {
    private Datastore ds;
    private BusyFlag lock;

    public static Datastore newInstance(Datastore ds) {
        return (Datastore)Proxy.newProxyInstance(ds.getClass().getClassLoader(), ds.getClass().getInterfaces(), (InvocationHandler)new SynchronizedDatastore(ds));
    }

    private SynchronizedDatastore(Datastore ds) {
        this.ds = ds;
        this.lock = new BusyFlag();
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result;
        try {
            this.lock.getBusyFlag();
            result = m.invoke((Object)this.ds, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            this.lock.freeBusyFlag();
        }
        return result;
    }
}

