/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.admin.Admin;
import auth.admin.UTDtuGroup;
import auth.admin.UTPolicyAttributes;
import auth.protocol.RegisterKeys;
import auth.sdk.AccessControl;
import auth.sdk.AuthenticationClient;
import auth.sdk.JobQueue;
import auth.sdk.JobQueueEntry;
import auth.sdk.Log;
import auth.sdk.LogicalToken;
import auth.sdk.RawToken;
import auth.sdk.TaskListener;
import auth.sdk.Utils;
import auth.utauthd.Configuration;
import auth.utauthd.Controller;
import auth.utauthd.Crypto;
import auth.utauthd.Mutex;
import auth.utauthd.Session;
import auth.utauthd.SessionId;
import auth.utauthd.SessionManager;
import auth.utauthd.Terminal;
import auth.utauthd.utauthd;
import com.sun.ut.utils.SimpleProcess;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class AuthRecord
implements AccessControl,
TaskListener {
    private static final int TERMINAL_DOES_NOT_EXIST = 0;
    private static final int TERMINAL_EXISTS = 1;
    private boolean terminated = false;
    private boolean destroyed = false;
    private String terminalId = null;
    private String name;
    private String udpPort = null;
    private String dmxid = null;
    private Terminal terminal;
    private AuthenticationClient client;
    private Session session;
    private String ipAddress = null;
    private Crypto crypto;
    private final String sessionRefused = "sessionrefused";
    private boolean clientCreated = false;
    private boolean reapable = false;
    private boolean connected = false;
    private boolean tokenIn = false;
    private int expecting = 0;
    private long createTime = 0L;
    private long connectTime = 0L;
    private String firmware = null;
    private String lastExist = null;
    private Hashtable taggedControllers = new Hashtable();
    private Hashtable annotations = new Hashtable();
    private Mutex mutex = null;
    private AuthRecord primary = null;
    private UTDtuGroup groupInfo = null;
    private AuthRecord[] secondaries = null;
    private boolean isPrimary = false;
    private String groupTerminalId = null;
    private int currentMod = 0;
    private static JobQueue jobQueue = null;
    private static Method m_connRsp = null;
    private static boolean jobQGroup = false;
    private static Hashtable bySocket = new Hashtable(16);
    private static Hashtable byTerminalId = new Hashtable(16);
    private static Hashtable bySid = new Hashtable(16);
    private static String uniquePrefix = null;
    private static long uniqueNumber = 0L;
    private static Properties nameMappings = null;
    private static File nameFile = null;
    private static Properties sessionTypes = null;
    private static Vector tickets = null;
    private String callbackCookie = null;
    public String insertToken = null;
    public String tokenName = null;
    static /* synthetic */ Class class$auth$utauthd$AuthRecord;

    public int getCurrentMod() {
        return this.currentMod;
    }

    public void setTokenState(boolean bl) {
        this.tokenIn = bl;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public String getTerminalId() {
        return this.terminalId;
    }

    public static void initTickets(int n) {
        tickets = new Vector(n);
        for (int i = 0; i < n; ++i) {
            tickets.addElement(new Object());
        }
    }

    private static void startJobQGroup() {
        if (jobQGroup) {
            return;
        }
        Log.debug((String)"Initializing JobQGroup");
        jobQueue = new JobQueue("JobQGroup");
        try {
            m_connRsp = (class$auth$utauthd$AuthRecord == null ? (class$auth$utauthd$AuthRecord = AuthRecord.class$("auth.utauthd.AuthRecord")) : class$auth$utauthd$AuthRecord).getMethod("primaryConnect", class$auth$utauthd$AuthRecord == null ? (class$auth$utauthd$AuthRecord = AuthRecord.class$("auth.utauthd.AuthRecord")) : class$auth$utauthd$AuthRecord);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.configError((String)("Cannot get AuthRecord.primaryConnect method" + noSuchMethodException));
            System.exit(1);
        }
        jobQGroup = true;
        Log.debug((String)"JobQGroup Initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskEvent(Object object) {
        JobQueueEntry jobQueueEntry = (JobQueueEntry)object;
        Log.debug((String)"AuthRecord.taskEvent:: locking terminal");
        AuthRecord authRecord = (AuthRecord)jobQueueEntry.param;
        Terminal terminal = authRecord.getTerminal();
        if (terminal == null) {
            Log.unexpectedError((String)"AuthRecord.taskEvent: Terminal is null. returning.");
            return;
        }
        terminal.lock();
        JobQueueEntry jobQueueEntry2 = jobQueueEntry;
        synchronized (jobQueueEntry2) {
            try {
                jobQueueEntry.result = jobQueueEntry.method.invoke(jobQueueEntry.param, jobQueueEntry.args);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.unexpectedError((String)("AuthRecord:taskEvent " + jobQueueEntry.method + " " + jobQueueEntry.args + " " + illegalAccessException));
                System.exit(1);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println(invocationTargetException.getTargetException());
                Log.unexpectedError((String)("AuthRecord:taskEvent: " + jobQueueEntry.method + " " + jobQueueEntry.args + " " + invocationTargetException.getTargetException()));
                System.exit(1);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Log.unexpectedError((String)("AuthRecord:taskEvent: " + jobQueueEntry.method + " " + jobQueueEntry.args + " " + noClassDefFoundError));
                System.exit(1);
            }
            catch (Exception exception) {
                jobQueueEntry.exception = exception;
                if (!jobQueueEntry.sync) {
                    Log.unexpectedError((String)("AuthRecord:taskEvent: " + exception));
                }
            }
            finally {
                Log.debug((String)"AuthRecord.taskEvent:: releasing terminal");
                terminal.unlock();
            }
            jobQueueEntry.done = true;
        }
    }

    private AuthRecord() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthRecord(Terminal terminal, String string, String string2, String string3, String string4, Mutex mutex, Crypto crypto) throws Exception {
        boolean bl = false;
        AuthRecord authRecord = null;
        String string5 = "";
        while (!bl) {
            Object object;
            if (authRecord != null) {
                block18: {
                    Log.debug((String)"AuthRecord:: oldar is not null.. destroying old terminal");
                    object = authRecord.terminal;
                    if (object != null) {
                        ((Terminal)object).lock();
                        try {
                            if (authRecord.terminal == null) {
                                Log.debug((String)"AuthRecord:: oldar.terminal is null");
                                string5 = "";
                                authRecord = null;
                                continue;
                            }
                            if (object != authRecord.terminal) {
                                bl = false;
                                continue;
                            }
                            ((Terminal)object).disable();
                            authRecord.disconnect("reauthenticating" + string5, false);
                            authRecord.destroy();
                            ((Terminal)object).close();
                            break block18;
                        }
                        finally {
                            ((Terminal)object).unlock();
                            continue;
                        }
                    }
                    Log.unexpectedError((String)"AuthRecord:: oldar terminal exists..");
                }
                string5 = "";
                authRecord = null;
                object = null;
            }
            object = terminal.getAuthIPAandPortString();
            AuthRecord authRecord2 = this;
            synchronized (authRecord2) {
                Hashtable hashtable = byTerminalId;
                synchronized (hashtable) {
                    authRecord = AuthRecord.getBySocket((String)object);
                    if (authRecord != null) {
                        bl = false;
                        string5 = "DuplicateIPA";
                        continue;
                    }
                    authRecord = AuthRecord.getByTerminalId(string);
                    if (authRecord != null) {
                        bl = false;
                        string5 = "DuplicateTID";
                        continue;
                    }
                    this.createTime = System.currentTimeMillis();
                    this.terminalId = string;
                    this.firmware = string2;
                    this.terminal = terminal;
                    this.crypto = crypto;
                    this.client = null;
                    this.name = AuthRecord.uniqueTransientName();
                    this.mutex = mutex;
                    this.ipAddress = string4;
                    bySocket.put(object, this);
                    byTerminalId.put(string, this);
                    bl = true;
                }
            }
        }
        this.lastExist = this.adminEvent("exist=true,session=false", this.lastExist, this.firmware);
    }

    private String adminEvent(String string, String string2, String string3) {
        String string4;
        String string5;
        Admin admin = Admin.getAdmin();
        if (admin == null) {
            return string2;
        }
        String string6 = null;
        int n = string.indexOf("exist=");
        if (n >= 0) {
            string5 = "exist=true";
            string4 = "exist=false";
            if (string.regionMatches(n, string5, 0, string5.length())) {
                string6 = "true";
            } else if (string.regionMatches(n, string4, 0, string4.length())) {
                string6 = "false";
            } else {
                Log.unexpectedError((String)("adminEvent strange event=" + string + " lastExist=" + string2 + " exists=" + string6 + " ei=" + n + " etrue<" + string5 + ">" + string5.length()));
                string6 = "unknown";
            }
        }
        if (Configuration.reportAllDesktopEvents || string2 == null || string6 == null || !string6.equals(string2)) {
            string5 = this.terminal.getModel();
            string4 = this.terminal.getSerialNumber();
            admin.desktopEvent(string5, string4, string4, string, string3, System.currentTimeMillis());
        }
        return string6;
    }

    public void finalize() throws Throwable {
        long l = System.currentTimeMillis();
        super.finalize();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        try {
            if (this.destroyed) {
                bufferedWriter.write("defunct");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("terminalId=" + this.terminalId);
            bufferedWriter.newLine();
            bufferedWriter.write("tokenName=" + this.tokenName);
            bufferedWriter.newLine();
            if (this.taggedControllers == null) {
                bufferedWriter.write("No tagged controllers");
            } else {
                Enumeration enumeration = this.taggedControllers.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    bufferedWriter.write("Controller : " + string);
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            return "AuthRecord--cannot-toString!";
        }
        return stringWriter.toString().replace('\n', '/');
    }

    private boolean setSecondary(String string, AuthRecord authRecord) {
        int n = -1;
        if (this.groupInfo == null) {
            return false;
        }
        String[] stringArray = this.groupInfo.getDtuCIDs();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return false;
        }
        this.secondaries[n] = authRecord;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addSecondary(String string, String string2) throws Exception {
        UTDtuGroup[] uTDtuGroupArray;
        Log.debug((String)("AuthRecord::addSecondary: Primaryid = " + string + ", Secondary Id = " + string2));
        AuthRecord authRecord = AuthRecord.getByTerminalId(string);
        if (authRecord == null) {
            return false;
        }
        Admin admin = Admin.getAdmin();
        if (admin != null && (uTDtuGroupArray = admin.getDtuGrpByDtuCID(string, "MULTIHEAD")) != null) {
            this.groupInfo = uTDtuGroupArray[0];
        }
        uTDtuGroupArray = authRecord.getTerminal();
        boolean bl = false;
        if (uTDtuGroupArray == null) {
            throw new Exception("Primary disconnected before Secondary could connect..disconnecting secondary now !");
        }
        uTDtuGroupArray.lock();
        try {
            if (authRecord.isTerminated()) {
                throw new Exception("Primary destroyed before Secondary could get lock");
            }
            bl = authRecord.setSecondary(string2, this);
        }
        finally {
            uTDtuGroupArray.unlock();
        }
        if (bl) {
            this.primary = authRecord;
            this.groupTerminalId = string;
            this.tokenName = authRecord.tokenName;
        }
        return bl;
    }

    public synchronized String getPrimaryId() {
        Admin admin = Admin.getAdmin();
        if (admin != null) {
            return admin.getDtuGrpPrimByDtuCID(this.terminalId, "MULTIHEAD");
        }
        return null;
    }

    public static int numberOfConnections() {
        return byTerminalId.size();
    }

    private boolean putStatus(Writer writer, Terminal terminal) throws IOException {
        if (this.destroyed) {
            return false;
        }
        writer.write("begin" + Configuration.lineSeparator);
        writer.write("terminalId=" + terminal.getModel() + "." + terminal.getSerialNumber() + Configuration.lineSeparator);
        writer.write("terminalCID=" + this.terminalId + Configuration.lineSeparator);
        writer.write("terminalModel=" + terminal.getModel() + Configuration.lineSeparator);
        if (this.firmware != null) {
            writer.write("firmware=");
            int n = this.firmware.indexOf(",Boot:");
            if (n == -1) {
                writer.write(this.firmware);
                writer.write(Configuration.lineSeparator);
                writer.write("boot=unknown");
            } else {
                writer.write(this.firmware.substring(0, n));
                writer.write(Configuration.lineSeparator);
                writer.write("boot=" + this.firmware.substring(n + 6));
            }
            writer.write(Configuration.lineSeparator);
        }
        writer.write("connected=" + this.connected + Configuration.lineSeparator);
        writer.write("createTime=" + this.createTime + Configuration.lineSeparator);
        writer.write("connectTime=" + this.connectTime + Configuration.lineSeparator);
        writer.write("terminalIPA=" + terminal.getIPAddressString() + Configuration.lineSeparator);
        writer.write("realIP=" + terminal.getRealIPString() + Configuration.lineSeparator);
        if (!Configuration.termAddrIsSecret) {
            writer.write("udpPort=" + this.udpPort + Configuration.lineSeparator);
        }
        writer.write("terminalPort=" + terminal.renderPort() + Configuration.lineSeparator);
        if (this.client != null) {
            writer.write("LocalName=" + this.client.getLocalName() + Configuration.lineSeparator);
            writer.write("GlobalName=" + this.client.getGlobalName() + Configuration.lineSeparator);
            writer.write("ModuleName=" + this.client.getModuleName() + Configuration.lineSeparator);
            writer.write("SessionManagerId=" + this.client.getSessionManagerId() + Configuration.lineSeparator);
            if (this.crypto.getSessionType() == this.crypto.NO_SESSION) {
                writer.write("ServiceInitCommand=" + this.getServiceStartCommand("sessionrefused"));
            } else {
                writer.write("ServiceInitCommand=" + this.client.getServiceInitCommand());
            }
            writer.write(Configuration.lineSeparator);
        }
        writer.write("tokenName=" + this.tokenName + Configuration.lineSeparator);
        writer.write("clientCreated=" + this.clientCreated + Configuration.lineSeparator);
        writer.write("lifetime=" + (System.currentTimeMillis() - this.createTime) + Configuration.lineSeparator);
        Enumeration enumeration = this.annotations.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.annotations.get(string);
            if (!string.startsWith("x_")) continue;
            writer.write("annotation." + string + "=" + string2 + Configuration.lineSeparator);
        }
        if (this.destroyed) {
            writer.write("destroyed=" + this.destroyed + Configuration.lineSeparator);
        }
        writer.write(terminal.getTerminalStats() + Configuration.lineSeparator);
        if (this.groupTerminalId != null) {
            writer.write("MultiheadGroupName=" + this.groupInfo.getDtuGroupID() + Configuration.lineSeparator);
            writer.write("MultiheadTerminalIndex=" + this.groupInfo.getTerminalIndex(this.terminalId) + Configuration.lineSeparator);
            writer.write("MultiheadData=" + this.groupInfo.getPrivateData() + Configuration.lineSeparator);
            writer.write("MultiheadPrimary=" + this.isPrimary + Configuration.lineSeparator);
        }
        if (this.crypto != null) {
            writer.write(this.crypto.getSessionInfo() + Configuration.lineSeparator);
        }
        writer.write("firstServer=" + terminal.getFirstString() + Configuration.lineSeparator);
        writer.write("end" + Configuration.lineSeparator);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void statusImpl(Writer writer, AuthRecord authRecord) throws IOException {
        if (authRecord == null) {
            return;
        }
        Terminal terminal = authRecord.getTerminal();
        if (terminal != null) {
            terminal.lock();
            try {
                authRecord.putStatus(writer, terminal);
            }
            finally {
                terminal.unlock();
            }
        }
    }

    public static void status(Writer writer, String string) throws IOException {
        block10: {
            Hashtable hashtable = (Hashtable)byTerminalId.clone();
            if (string == null) {
                try {
                    Enumeration enumeration = hashtable.elements();
                    while (enumeration.hasMoreElements()) {
                        AuthRecord.statusImpl(writer, (AuthRecord)enumeration.nextElement());
                    }
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)("AuthRecord:status " + exception));
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                try {
                    if (string2.equalsIgnoreCase("terminalCID")) {
                        AuthRecord.statusImpl(writer, (AuthRecord)hashtable.get(string3));
                        break block10;
                    }
                    if (string2.equalsIgnoreCase("tokenName")) {
                        Enumeration enumeration = hashtable.elements();
                        while (enumeration.hasMoreElements()) {
                            AuthRecord authRecord = (AuthRecord)enumeration.nextElement();
                            if (!authRecord.tokenName.equals(string3)) continue;
                            AuthRecord.statusImpl(writer, authRecord);
                            if (authRecord.isPrimary || authRecord.primary != null) continue;
                            break block10;
                        }
                        break block10;
                    }
                    return;
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)("AuthRecord:status " + exception + " key " + string2 + " value " + string3));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncTerminalGroups(Hashtable hashtable, Hashtable hashtable2) throws IOException {
        Hashtable hashtable3 = (Hashtable)byTerminalId.clone();
        Enumeration enumeration = hashtable3.elements();
        while (enumeration.hasMoreElements()) {
            AuthRecord authRecord = (AuthRecord)enumeration.nextElement();
            Terminal terminal = authRecord.getTerminal();
            if (terminal == null) continue;
            terminal.lock();
            try {
                authRecord.doSync(hashtable, hashtable2);
            }
            finally {
                terminal.unlock();
            }
        }
    }

    private void doSync(Hashtable hashtable, Hashtable hashtable2) {
        UTDtuGroup uTDtuGroup;
        String string = (String)hashtable.get(this.terminalId);
        if (this.groupTerminalId == null) {
            if (string != null) {
                Log.debug((String)("Resetting new terminal added to a group : " + string));
                this.disconnect("syncing terminal groups", true);
            }
            return;
        }
        if (this.terminalId.equals(this.groupTerminalId) && ((uTDtuGroup = (UTDtuGroup)hashtable2.get(this.terminalId)) == null && this.groupInfo != null || uTDtuGroup != null && this.groupInfo == null || !uTDtuGroup.toString().equals(this.groupInfo.toString()))) {
            Log.debug((String)("Resetting old primary : " + this.terminalId));
            this.disconnect("syncing terminal groups", true);
            return;
        }
    }

    public static AuthRecord getBySocket(String string) {
        if (string == null) {
            return null;
        }
        return (AuthRecord)bySocket.get(string);
    }

    public static AuthRecord getByTerminalId(String string) {
        if (string == null) {
            return null;
        }
        return (AuthRecord)byTerminalId.get(string);
    }

    public static int gotTerminal(String string) {
        if (AuthRecord.getByTerminalId(string) == null) {
            return 0;
        }
        return 1;
    }

    public static AuthRecord getBySid(SessionId sessionId) {
        if (sessionId == null) {
            return null;
        }
        return (AuthRecord)bySid.get(sessionId.toString());
    }

    public void setClient(AuthenticationClient authenticationClient) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"setClient:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return;
        }
        this.client = authenticationClient;
    }

    public String mapModuleToGlobalName(String string) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"mapModuleToGlobalName::Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return null;
        }
        return AuthRecord.mapModuleToGlobalNameImpl(string);
    }

    private static String mapModuleToGlobalNameImpl(String string) {
        String string2;
        String string3 = AuthRecord.rawTokenEquiv(string);
        Admin admin = Admin.getAdmin();
        if (admin != null && (string2 = admin.rawTokenIDtoLogicalTokenID(string3)) != null) {
            string3 = string2;
        }
        return string3;
    }

    private static String rawTokenEquiv(String string) {
        if (Configuration.namesFileName == null) {
            return string;
        }
        if ((nameMappings = AuthRecord.refreshProperties(Configuration.namesFileName, nameMappings)) == null) {
            return string;
        }
        String string2 = (String)nameMappings.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public boolean connReq(Hashtable hashtable) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"connReq:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return false;
        }
        if (hashtable.get("currentMod") != null) {
            this.currentMod = (Integer)hashtable.get("currentMod");
        }
        return this.client.connReq(hashtable);
    }

    public boolean message(String string, Hashtable hashtable) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"message:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return false;
        }
        Log.debug((String)("AuthRecord.message(): command = " + string));
        Log.debug((String)("AuthRecord.message(): param = " + hashtable));
        return this.client.message(string, hashtable);
    }

    public void cleanUpOnRedirect() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"cleanUpOnRedirect::Assertion failed");
            System.exit(1);
        }
        String string = this.terminal.getAuthIPAandPortString();
        byTerminalId.remove(this.terminalId);
        bySocket.remove(string);
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public String getName() {
        Terminal terminal = null;
        if (!this.destroyed) {
            terminal = this.terminal;
        }
        if (terminal != null) {
            return terminal.getAuthIPAandPortString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createClient() {
        Object object;
        Object object2;
        String string;
        String string2 = this.terminal.getTokenSet();
        String string3 = null;
        AuthRecord authRecord = null;
        Terminal terminal = null;
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"createClient:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return false;
        }
        if (this.clientCreated) {
            return true;
        }
        if (utauthd.attachInProgress) {
            Log.debug((String)"AuthRecord:: attach in progress..");
            return false;
        }
        try {
            string = Configuration.forceSessionLocation ? Configuration.sessionHost + ":" + Configuration.sessionPort : this.client.getSessionManagerId();
            if (this.crypto.getSessionType() == this.crypto.NO_SESSION) {
                string3 = this.getServiceStartCommand("sessionrefused");
                this.tokenName = "sessionrefused." + this.tokenName;
            } else {
                string3 = this.client.getServiceInitCommand();
            }
            if (string3 == null) {
                Log.notice((String)("createClient: Null command for client: " + this.client));
            }
            this.session = new Session(this.tokenName, string);
            if (this.session.getSid() == null) {
                this.session = null;
                return false;
            }
            Log.debug((String)("createClient: bySid: sid = " + this.session.sessionId.toString()));
            Log.debug((String)("createClient: insertToken = " + this.insertToken));
            Log.debug((String)("createClient: tokenName = " + this.tokenName));
            Log.debug((String)("createClient: tokenSet = " + string2));
            authRecord = (AuthRecord)bySid.get(this.session.sessionId.toString());
            if (authRecord != null) {
                Log.debug((String)("createClient: bySid.get :: " + authRecord + ", sid = " + this.session.sessionId.toString()));
                terminal = authRecord.getTerminal();
            }
            object2 = null;
            object = null;
            if (authRecord != null && ((object2 = this.terminal.getStoredParam("stealProtected")) == null || (object = this.terminal.getStoredParam("auth")) != null && ((String)object).equals("true"))) {
                Log.debug((String)("createClient: Pre-existing or legacy session connect by token: " + this.tokenName + " (" + this.insertToken + "), on terminal: " + this.terminalId + " stealProtected: " + (String)object2 + " auth: " + (String)object));
                if (terminal == null) return false;
                terminal.lock();
                try {
                    authRecord.disconnect("old session");
                }
                finally {
                    terminal.unlock();
                }
                Log.notice((String)("createClient: Pre-existing session disconnected by token: " + this.tokenName + " (" + this.insertToken + "), on terminal: " + this.terminalId + " from terminal: " + terminal.getNamespace() + "." + terminal.getSerialNumber()));
            } else {
                if (terminal != null) {
                    Log.notice((String)("createClient: Attempted session steal for token: " + this.tokenName + " (" + this.insertToken + "), on terminal: " + this.terminalId + " from terminal: " + terminal.getNamespace() + "." + terminal.getSerialNumber()));
                    this.session = null;
                    return false;
                }
                Log.debug((String)("createClient: New connection/session for token: " + this.tokenName + " (" + this.insertToken + "), on terminal: " + this.terminalId));
            }
            bySid.put(this.session.sessionId.toString(), this);
        }
        catch (NullPointerException nullPointerException) {
            Log.unexpectedError((String)("createClient: " + nullPointerException));
            object2 = new ByteArrayOutputStream();
            object = new PrintWriter((OutputStream)object2);
            nullPointerException.printStackTrace((PrintWriter)object);
            ((PrintWriter)object).flush();
            Log.unexpectedError((String)((ByteArrayOutputStream)object2).toString());
            System.exit(1);
        }
        if (this.session == null) {
            return false;
        }
        string = null;
        object2 = tickets;
        synchronized (object2) {
            while (string == null) {
                try {
                    string = tickets.elementAt(0);
                    if (string == null) continue;
                    tickets.removeElementAt(0);
                }
                catch (NoSuchElementException noSuchElementException) {
                    try {
                        tickets.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    try {
                        tickets.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        try {
            String string4;
            String string5;
            String string6;
            object2 = this.getName();
            Log.debug((String)((String)object2 + " createClient running: <" + string3 + ">"));
            object = new SimpleProcess().exec(string3);
            PrintWriter printWriter = new PrintWriter(object.getOutputStream());
            int n = 1;
            String string7 = "CORONA_SESSION=" + this.session.getSid();
            Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
            printWriter.println(string7);
            string7 = "TOKEN_IDENTITY=" + this.tokenName;
            Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
            printWriter.println(string7);
            string7 = "INSERT_TOKEN=" + this.insertToken;
            Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
            printWriter.println(string7);
            string7 = "TERMINAL_ID=" + this.terminalId;
            Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
            printWriter.println(string7);
            string7 = "MODEL_ID=" + this.terminal.getModel();
            Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
            printWriter.println(string7);
            string7 = "TOKEN_SET=" + string2;
            Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
            printWriter.println(string7);
            String string8 = this.terminal.getStoredParam("stealProtected");
            if (string8 == null || string8.equals("false")) {
                string7 = "ALTUID=legacy";
                Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
                printWriter.println(string7);
            } else {
                string6 = this.terminal.getStoredParam("altuid");
                if (string6 != null) {
                    string7 = "ALTUID=" + string6;
                    Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
                    printWriter.println(string7);
                }
            }
            string6 = this.terminal.getStoredParam("auth");
            if (string6 != null) {
                string7 = "AUTH=" + string6;
                Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
                printWriter.println(string7);
            }
            if ((string5 = this.terminal.getResolution()) != null) {
                string7 = "CURRENT_RESOLUTION=" + string5;
                Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
                printWriter.println(string7);
            }
            if ((string4 = this.terminal.getDdcInfo()) != null) {
                string7 = "DDC_INFO=" + string4;
                Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
                printWriter.println(string7);
            }
            if (this.groupInfo != null) {
                string7 = "GROUP_PRIVATE_DATA=" + this.groupInfo.getPrivateData();
                Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
                printWriter.println(string7);
            }
            this.callbackCookie = Utils.makeCookie();
            string7 = "CALLBACK_COOKIE=" + this.callbackCookie;
            Log.debug((String)((String)object2 + " createClient param" + n++ + ": <" + string7 + ">"));
            printWriter.println(string7);
            printWriter.println();
            printWriter.close();
            int n2 = object.waitFor();
            Log.debug((String)((String)object2 + " createClient: exitValue=" + n2));
            if (n2 != 0) {
                Log.unexpectedError((String)("SESSION_ERROR " + this.tokenName + " exitCode=" + n2));
                Vector vector = tickets;
                synchronized (vector) {
                    tickets.addElement(string);
                    tickets.notifyAll();
                    return false;
                }
            }
            Log.notice((String)("SESSION_OK " + this.tokenName));
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("SESSION_ERROR " + this.tokenName + " " + exception + " <" + string3 + ">" + " Client = " + this.client));
            object = tickets;
            synchronized (object) {
                tickets.addElement(string);
                tickets.notifyAll();
                return false;
            }
        }
        this.clientCreated = true;
        object2 = tickets;
        synchronized (object2) {
            tickets.addElement(string);
            tickets.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean redirect(Hashtable hashtable, boolean bl) {
        String string;
        String string2 = null;
        Log.debug((String)"AuthRecord::Doing Redirect");
        if (this.destroyed) {
            return false;
        }
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = this.terminal.getStoredParams();
        hashtable2.put("authipa", hashtable.get("authipa"));
        hashtable2.put("authport", hashtable.get("authport"));
        if (hashtable.get("authtoken") != null) {
            hashtable2.put("authtoken", hashtable.get("authtoken"));
        }
        if (hashtable.get("forceInsert") != null) {
            hashtable2.put("forceInsert", hashtable.get("forceInsert"));
        }
        if (bl) {
            Log.notice((String)("AuthRecord:redirect:: Redirecting terminal " + this.terminalId + " to a trusted host " + hashtable.get("authipa")));
            if (this.tokenName != null) {
                hashtable2.put("authtoken", this.tokenName);
                hashtable2.put("realType", this.tokenName.substring(0, this.tokenName.indexOf(".")));
                hashtable2.put("realId", this.tokenName.substring(this.tokenName.indexOf(".") + 1, this.tokenName.length()));
            }
            string2 = RegisterKeys.tokenSetKey + "=" + this.getTokenSet();
            hashtable2.put("roamInitiated", "false");
        } else {
            Log.notice((String)("AuthRecord:redirect:: Redirecting terminal " + this.terminalId + " to a non-trusted host " + hashtable.get("authipa")));
            hashtable2.put("roamInitiated", "true");
        }
        String string3 = (String)hashtable.get(RegisterKeys.usernameKey);
        if (string3 != null) {
            string2 = string2 + " " + RegisterKeys.usernameKey + "=" + string3;
        } else if (hashtable3 != null && (string3 = (String)hashtable3.get("username")) != null && !string3.equals("")) {
            string2 = string2 + " " + RegisterKeys.usernameKey + "=" + string3;
        }
        if (hashtable3 != null && (string = (String)hashtable3.get("quicklogin")) != null && !string.equals("")) {
            string2 = string2 + " " + RegisterKeys.quickloginKey + "=" + string;
        }
        if (hashtable.get(RegisterKeys.subCauseKey) != null) {
            string2 = string2 + " " + RegisterKeys.subCauseKey + "=" + hashtable.get(RegisterKeys.subCauseKey);
        }
        if ((string = (String)hashtable.get(RegisterKeys.doAmghKey)) != null) {
            string2 = string2 + " " + RegisterKeys.doAmghKey + "=" + string;
        } else {
            String string4 = (String)hashtable3.get(RegisterKeys.doAmghKey);
            if (hashtable3 != null && string4 != null) {
                string2 = string2 + " " + RegisterKeys.doAmghKey + "=" + string4;
            }
        }
        if (string2 != null) {
            hashtable2.put("redirectProps", string2);
        }
        Log.notice((String)("Redirecting with params: " + hashtable2));
        if (!this.send("redirectInf", hashtable2)) {
            return false;
        }
        if (this.isPrimary && bl) {
            block4: for (int i = 0; i < this.secondaries.length; ++i) {
                AuthRecord authRecord = this.secondaries[i];
                Terminal terminal = null;
                if (authRecord == null || authRecord == this) continue;
                while ((terminal = authRecord.getTerminal()) != null) {
                    terminal.lock();
                    try {
                        if (terminal != authRecord.getTerminal()) continue;
                        authRecord.redirect(hashtable, bl);
                        continue block4;
                    }
                    finally {
                        terminal.unlock();
                    }
                }
                Log.notice((String)"redirect: terminal object is null.");
                return false;
            }
        }
        if (this.terminal.isActionPending()) {
            this.terminal.setActionPending(false);
            this.terminal.enable();
        }
        return true;
    }

    public boolean send(String string, Hashtable hashtable) {
        if (this.destroyed) {
            return false;
        }
        return this.terminal.write(string, hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(Hashtable hashtable) {
        String string = (String)hashtable.get("cid");
        String string2 = (String)hashtable.get("head");
        if (this.destroyed) {
            return false;
        }
        if (string == null && string2 == null || !this.isPrimary) {
            Log.debug((String)("AuthRecord::load " + hashtable));
            this.send("controlInf", hashtable);
            return false;
        }
        int n = string2 != null ? Integer.decode(string2) : -1;
        if (string == null) {
            string = "";
        }
        Log.debug((String)("AuthRecord::load secondary " + string + " or " + string2));
        for (int i = 0; i < this.secondaries.length; ++i) {
            AuthRecord authRecord = this.secondaries[i];
            Terminal terminal = null;
            if (authRecord == null || authRecord.terminalId == null) continue;
            Log.debug((String)("secAR.cid " + authRecord.terminalId));
            if (n != i && !string.equals("all") && !authRecord.terminalId.equals(string)) continue;
            terminal = authRecord.getTerminal();
            Log.debug((String)("secAR.cid found " + authRecord.terminalId));
            if (terminal == null) continue;
            terminal.lock();
            try {
                if (terminal == authRecord.getTerminal()) {
                    authRecord.send("controlInf", hashtable);
                    Log.debug((String)("AuthRecord::load " + hashtable));
                }
                if (string.equals("all")) continue;
                break;
            }
            finally {
                terminal.unlock();
            }
        }
        return false;
    }

    public boolean connect(String string) {
        return this.connect(string, this.terminal.renderIpa(), this.udpPort);
    }

    public boolean connect(String string, InetAddress inetAddress, String string2) {
        Admin admin;
        String string3 = null;
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"connect:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return false;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(6);
        String string4 = "";
        if (this.tokenName == null) {
            this.tokenName = this.client.getGlobalName();
        }
        hashtable.put("module", this.client.getModuleName());
        if (this.connected) {
            Log.unexpectedError((String)("AuthRecord.connect: " + this.tokenName + " already connected"));
        }
        this.connected = false;
        if (this.tokenName != null) {
            hashtable.put("token", this.tokenName);
            if (!this.setupCrypto(this.tokenName)) {
                return false;
            }
        }
        if (this.tokenIn) {
            ++this.expecting;
        }
        hashtable.put("access", "allowed");
        string3 = this.crypto.getMyDHMsg();
        if (string3 != null) {
            hashtable.put("serverDH", string3);
        }
        if ((string3 = this.crypto.getServerRandom()) != null) {
            hashtable.put("serverRand", string3);
        }
        if ((string3 = this.crypto.getSignature()) != null) {
            hashtable.put("signature", string3);
        }
        if ((string3 = this.crypto.getEncUpType()) != null) {
            hashtable.put("encUpType", string3);
        }
        if ((string3 = this.crypto.getEncDownType()) != null) {
            hashtable.put("encDownType", string3);
        }
        if ((string3 = this.terminal.getUseReal()) != null) {
            hashtable.put("useReal", string3);
        }
        if ((admin = Admin.getAdmin()) != null) {
            String string5;
            admin.getPolicyAttributes();
            if (UTPolicyAttributes.isMultiheadEnabled() && (string5 = admin.getDtuGrpPrimByDtuCID(this.terminalId, "MULTIHEAD")) != null && string5.equals(this.terminalId)) {
                AuthRecord.startJobQGroup();
                this.primary = this;
                this.isPrimary = true;
                this.groupTerminalId = this.terminalId;
                UTDtuGroup[] uTDtuGroupArray = admin.getDtuGrpByDtuCID(string5, "MULTIHEAD");
                if (uTDtuGroupArray != null) {
                    this.groupInfo = uTDtuGroupArray[0];
                    this.secondaries = new AuthRecord[this.groupInfo.getNDtus()];
                    Log.debug((String)("AuthRecord:: Num of Secondaries = " + this.secondaries.length));
                    String[] stringArray = this.groupInfo.getDtuCIDs();
                    if (this.terminalId.equals(stringArray[this.groupInfo.getPrimaryIdx()])) {
                        this.secondaries[this.groupInfo.getPrimaryIdx()] = this;
                    }
                }
            }
        }
        if (this.send("connInf", hashtable)) {
            this.lastExist = this.adminEvent("exist=true,session=true", this.lastExist, this.firmware);
            if (string == null) {
                Log.notice((String)("CONNECT " + this.terminalId + ", " + this.tokenName));
            } else {
                Log.notice((String)("CONNECT " + this.terminalId + ", " + this.tokenName + ", " + string));
            }
            return true;
        }
        if (this.tokenIn) {
            --this.expecting;
        }
        this.connected = false;
        if (this.session != null) {
            this.session.disconnect(this.terminalId, inetAddress.getHostAddress());
        }
        Log.unexpectedError((String)(this.getName() + " cannot send connInf, " + "disconnecting session"));
        string4 = "cannot send connInf";
        Log.unexpectedError((String)(this.tokenName + " connect failed: " + string4));
        return false;
    }

    public void disconnect(String string) {
        this.disconnect(string, false, false);
    }

    public void disconnect(String string, boolean bl) {
        this.disconnect(string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(String string, boolean bl, boolean bl2) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"disconnect:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return;
        }
        if (this.isPrimary) {
            block6: for (int i = 0; i < this.secondaries.length; ++i) {
                AuthRecord authRecord = this.secondaries[i];
                Terminal terminal = null;
                if (authRecord == null || authRecord == this) continue;
                while ((terminal = authRecord.getTerminal()) != null) {
                    terminal.lock();
                    try {
                        if (terminal != authRecord.getTerminal()) continue;
                        authRecord.disconnect(string, bl, this.session != null);
                        continue block6;
                    }
                    finally {
                        terminal.unlock();
                    }
                }
            }
        }
        if (string != null) {
            Log.notice((String)("DISCONNECT " + this.terminalId + ", " + this.tokenName + " " + string));
        } else {
            Log.notice((String)("DISCONNECT " + this.terminalId + ", " + this.tokenName));
        }
        if (this.session != null || bl2) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.client != null) {
                hashtable.put("module", this.client.getModuleName());
            } else {
                Log.unexpectedError((String)"AuthRecord.disconnect: Null Client");
            }
            hashtable.put("access", "denied");
            this.send("discInf", hashtable);
            this.connected = false;
            this.udpPort = null;
            if (this.session != null) {
                this.session.disconnect(this.terminalId, this.ipAddress);
            } else {
                try {
                    jobQueue.submit((TaskListener)new AuthRecord(), (Object)this.primary, m_connRsp, new Object[]{this}, false);
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)("AuthRecord:: disconnect : " + exception));
                }
            }
        }
        if (!string.equals("destroy")) {
            this.destroy();
        }
    }

    public void terminate(int n, boolean bl) {
        Log.debug((String)("terminate: " + this.tokenName + " join=" + n));
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"terminate:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return;
        }
        if (!this.isIdle() && SessionManager.readActiveSessionId(this.tokenName) != null) {
            Log.debug((String)("terminate: session still configured: " + this.tokenName));
            return;
        }
        if (this.terminal.isActionPending()) {
            this.terminal.enable();
        }
        this.disconnect("session terminated", true);
        this.terminated = true;
    }

    private boolean isIdle() {
        String string = (String)this.getAnnotation("x_idle");
        return string != null && string.equals("true");
    }

    public boolean isTerminated() {
        return this.destroyed || this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object;
        Object object2;
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"destroy:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return;
        }
        if (this.isPrimary) {
            block4: for (int i = 0; i < this.secondaries.length; ++i) {
                object2 = this.secondaries[i];
                object = null;
                if (object2 == null || object2 == this) continue;
                while ((object = ((AuthRecord)object2).getTerminal()) != null) {
                    ((Terminal)object).lock();
                    try {
                        if (object != ((AuthRecord)object2).getTerminal()) continue;
                        ((AuthRecord)object2).destroy();
                        continue block4;
                    }
                    finally {
                        ((Terminal)object).unlock();
                    }
                }
            }
        }
        if (this.connected) {
            this.disconnect("destroy", false, !this.isPrimary);
        } else if (this.session != null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.client != null) {
                hashtable.put("module", this.client.getModuleName());
            } else {
                Log.unexpectedError((String)"AuthRecord.destroy: Null Client");
            }
            hashtable.put("access", "denied");
            this.send("discInf", hashtable);
        }
        this.destroyed = true;
        Log.notice((String)("DESTROY " + this.tokenName + " lifetime=" + (System.currentTimeMillis() - this.createTime)));
        this.lastExist = this.adminEvent("exist=false,session=false", this.lastExist, this.firmware);
        Enumeration enumeration = this.taggedControllers.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            Log.debug((String)("AuthRecord:: destorying controller: " + (String)object2));
            object = (Controller)this.taggedControllers.get(object2);
            if (object == null) continue;
            object.destroy();
        }
        if (this.terminal.getAuthIPAandPortString() != null) {
            bySocket.remove(this.terminal.getAuthIPAandPortString());
        }
        if (this.terminalId != null) {
            byTerminalId.remove(this.terminalId);
        }
        if (this.session != null) {
            bySid.remove(this.session.sessionId.toString());
        }
        if (this.tokenName != null && ((String)((Object)(enumeration = this.tokenName.substring(0, this.tokenName.indexOf("."))))).equals("escape") | ((String)((Object)enumeration)).equals("auth")) {
            AuthRecord.dpyTokReplace(this.tokenName);
        }
        this.terminalId = null;
        this.name = null;
        this.tokenName = null;
        this.udpPort = null;
        if (!this.terminal.isActionPending()) {
            this.terminal = null;
        }
        this.firmware = null;
        this.taggedControllers = null;
        this.client = null;
        this.session = null;
        this.clientCreated = false;
        this.lastExist = null;
        if (this.annotations != null) {
            enumeration = this.annotations.keys();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                this.annotations.remove(object2);
            }
            this.annotations = null;
        }
        Log.debug((String)"AuthRecord.destroy completed");
    }

    private static void dpyTokReplace(String string) {
        String string2 = new String("/var/opt/SUNWut/ctokens/" + string);
        String string3 = null;
        String string4 = null;
        File file = new File(string2);
        if (!file.exists()) {
            Log.debug((String)("AuthRecord::dpyTokReplace:ctoken file" + string2 + " doesnot exist"));
            return;
        }
        try {
            String string5;
            Object object;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            StringTokenizer stringTokenizer = null;
            String string6 = null;
            StringBuffer stringBuffer = new StringBuffer("");
            while ((string6 = bufferedReader.readLine()) != null) {
                stringTokenizer = new StringTokenizer(string6, "=");
                object = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
                if (((String)object).equals("TOKEN")) {
                    string3 = string5;
                    stringBuffer.append(string6 + "\n");
                    continue;
                }
                if (((String)object).equals("DISPLAY")) {
                    string4 = string5;
                    stringBuffer.append(string6 + "\n");
                    continue;
                }
                if (((String)object).equals("INSERT_TOKEN")) {
                    stringBuffer.append("INSERT_TOKEN=" + string3 + "\n");
                    continue;
                }
                if (((String)object).equals("TOKEN_SET")) {
                    stringBuffer.append("TOKEN_SET=" + string3 + "\n");
                    continue;
                }
                stringBuffer.append(string6 + "\n");
            }
            bufferedReader.close();
            object = new PrintWriter(new FileOutputStream(file));
            ((PrintWriter)object).print(stringBuffer);
            ((PrintWriter)object).close();
            string5 = new String("/tmp/SUNWut/session_proc/" + string4);
            File file2 = new File(string5);
            if (!file2.exists()) {
                Log.unexpectedError((String)("Error: AuthRecord::dpyTokReplace:sessionProc file" + string5 + " doesnot exist"));
                return;
            }
            if (!file2.setLastModified(System.currentTimeMillis())) {
                Log.unexpectedError((String)("Error: AuthRecord::dpyTokReplace:touch failed for sessionProc file " + string5));
            }
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("AuthRecord::dpyTokReplace: " + exception));
        }
    }

    public String getDefaultSessionHost() {
        return Configuration.sessionHost;
    }

    public int getDefaultSessionPort() {
        return Configuration.sessionPort;
    }

    private static Properties refreshProperties(String string, Properties properties) {
        boolean bl = false;
        if (string == null) {
            Log.configError((String)"refreshProperties: no filename");
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            Log.configError((String)("refreshProperties: file non-existent: " + string));
            return null;
        }
        long l = file.lastModified();
        if (properties != null) {
            long l2 = (Long)properties.get("=lastReadTime");
            if (l2 != l) {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            Log.debug((String)("refreshProperties: rereading " + string));
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                properties = new Properties();
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
            catch (Exception exception) {
                Log.configError((String)("cannot read properties file:" + string));
                return null;
            }
            properties.put("=lastReadTime", new Long(l));
        }
        return properties;
    }

    public String getServiceStartCommand(String string) {
        if ((sessionTypes = AuthRecord.refreshProperties(Configuration.sessionTypesFileName, sessionTypes)) == null) {
            Log.configError((String)"Cannot read session types");
            System.exit(1);
        }
        String string2 = (String)sessionTypes.get(string + ".start");
        return string2;
    }

    public String getServiceStopCommand(String string) {
        if ((sessionTypes = AuthRecord.refreshProperties(Configuration.sessionTypesFileName, sessionTypes)) == null) {
            Log.configError((String)"Cannot read session types");
            System.exit(1);
        }
        String string2 = (String)sessionTypes.get(string + ".stop");
        return string2;
    }

    private static synchronized String uniqueTransientName() {
        if (uniquePrefix == null) {
            String string = (String)System.getProperties().get("prefix");
            string = string != null ? string + "." : "";
            uniquePrefix = string + System.currentTimeMillis() + ".";
        }
        return uniquePrefix + ++uniqueNumber;
    }

    public void setController(String string, Controller controller) throws Exception {
        if (this.destroyed) {
            return;
        }
        if (string == null) {
            Exception exception = new Exception("Controller is not tagged.");
            exception.fillInStackTrace();
            throw new Exception("Controller is not tagged.");
        }
        if (controller != null) {
            this.taggedControllers.put(string, controller);
            Log.debug((String)("AR: controller added: tag = " + string + " control = " + controller));
        } else {
            this.taggedControllers.remove(string);
        }
    }

    public void controlRsp(Hashtable hashtable) {
        Object object;
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"controlRsp:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return;
        }
        String string = (String)hashtable.get("tag");
        if (string == null) {
            object = this.taggedControllers.keys();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
            }
            Log.debug((String)"Get the last tag from hash. Old firmare");
        }
        if (string != null) {
            object = (Controller)this.taggedControllers.get(string);
            if (object != null) {
                object.response(hashtable);
            } else {
                Log.notice((String)("No tagged controller  available to handle message: " + hashtable));
            }
        } else {
            Log.notice((String)("No controller available to handle message: " + hashtable));
        }
    }

    public RawToken getRawToken(String string) {
        if (this.destroyed) {
            return null;
        }
        RawToken rawToken = null;
        Admin admin = Admin.getAdmin();
        if (admin != null) {
            rawToken = admin.getRawToken(string);
        }
        return rawToken;
    }

    public LogicalToken getLogicalToken(String string) {
        if (this.destroyed) {
            return null;
        }
        LogicalToken logicalToken = null;
        Admin admin = Admin.getAdmin();
        if (admin != null) {
            logicalToken = admin.getLogicalToken(string);
        }
        return logicalToken;
    }

    public boolean primaryConnect(AuthRecord authRecord) {
        boolean bl = true;
        Log.debug((String)("AuthRecord::Primary connected:: " + this.connected));
        bl = this.connRsp(true);
        if (!bl) {
            return bl;
        }
        if (this.destroyed && authRecord != null && authRecord.terminal != null) {
            Log.debug((String)"AuthRecord::primary destroyed. Recycle DTU ");
            authRecord.terminal.close();
            return true;
        }
        return bl;
    }

    public boolean connRsp(String string, String string2) {
        this.udpPort = string;
        this.dmxid = string2;
        return this.connRsp(false);
    }

    public boolean connRsp(boolean bl) {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        Hashtable<String, String> hashtable = new Hashtable<String, String>(6);
        String string2 = "";
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"AuthRecord::connRsp:: Assertion failed.");
            System.exit(1);
        }
        if (bl && !this.connected || this.destroyed) {
            Log.debug((String)"AuthRecord:: connRsp returning as primary not connected");
            return true;
        }
        if (this.isPrimary) {
            for (int i = 0; i < this.secondaries.length; ++i) {
                AuthRecord authRecord = this.secondaries[i];
                if (authRecord != null && authRecord.udpPort != null) {
                    int n;
                    Crypto crypto = authRecord.getCrypto();
                    Terminal terminal = authRecord.getTerminal();
                    stringBuffer.append(" ip" + i + "=" + authRecord.ipAddress + " port" + i + "=" + authRecord.udpPort);
                    String string3 = null;
                    if (crypto != null && (string3 = crypto.getMasterKey()) != null) {
                        stringBuffer.append(" key" + i + "=" + string3);
                    }
                    if (terminal == null || (n = terminal.getMTU()) == 0 || n == 1500) continue;
                    stringBuffer.append(" mtu" + i + "=" + n);
                    continue;
                }
                stringBuffer.append(" ip" + i + "=" + " port" + i + "= ");
            }
            string = null;
            if (this.crypto != null && (string = this.crypto.getMasterKey()) != null) {
                stringBuffer.append(" encUp=" + this.crypto.getEncUpType());
                stringBuffer.append(" encDown=" + this.crypto.getEncDownType());
            }
            stringBuffer.append(" " + this.groupInfo.getPrivateData());
        } else if (this.primary == null) {
            string = null;
            if (this.crypto != null && (string = this.crypto.getMasterKey()) != null) {
                stringBuffer.append(" key=" + string);
                stringBuffer.append(" encUp=" + this.crypto.getEncUpType());
                stringBuffer.append(" encDown=" + this.crypto.getEncDownType());
            }
            if (this.terminal != null) {
                int n = this.terminal.getMTU();
                Log.notice((String)("MTU = " + n));
                if (n != 0 && n != 1500) {
                    stringBuffer.append(" mtu=" + n);
                }
            }
        }
        if (this.isPrimary || this.primary == null) {
            hashtable.put("module", this.client.getModuleName());
            if (!this.createClient()) {
                if (this.tokenName != null) {
                    hashtable.put("token", this.tokenName);
                }
                string2 = "cannot init session";
                hashtable.put("cause", string2);
                hashtable.put("access", "denied");
                if (this.session != null) {
                    this.disconnect(string2);
                } else {
                    this.send("discInf", hashtable);
                }
                return false;
            }
            boolean bl2 = false;
            if (bl) {
                if (this.tokenIn && this.connected) {
                    bl2 = true;
                }
            } else if (this.expecting <= 0) {
                Log.debug((String)"AuthRecord::Protocol error:unexpected connRsp");
                this.expecting = 0;
            } else if (--this.expecting == 0 && this.tokenIn && !this.connected) {
                bl2 = true;
            }
            if (bl2) {
                Log.debug((String)("Invoking session.connect with : " + stringBuffer));
                if (!this.session.connect(this.terminalId, this.ipAddress, this.udpPort, this.dmxid, stringBuffer.toString())) {
                    Log.unexpectedError((String)"Cannot connect on port change");
                    this.destroy();
                } else if (!this.connected) {
                    this.connectTime = System.currentTimeMillis();
                    this.connected = true;
                }
            }
            return true;
        }
        Log.debug((String)("AuthRecord::connRsp of secondary,  calling primary: " + this.primary));
        if (this.expecting <= 0) {
            Log.debug((String)"AuthRecord::Protocol error:unexpected connRsp");
            this.expecting = 0;
        } else if (--this.expecting == 0) {
            this.connected = true;
            if (this.primary.isTerminated()) {
                Log.debug((String)"AuthRecord::Primary has been terminated.. do not queue secondary");
                return false;
            }
            try {
                jobQueue.submit((TaskListener)new AuthRecord(), (Object)this.primary, m_connRsp, new Object[]{this}, false);
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("AuthRecord:: connRsp : " + exception));
            }
        }
        return true;
    }

    public void annotate(String string, Object object) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"annotate:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return;
        }
        if (object == null) {
            this.annotations.remove(string);
        } else {
            this.annotations.put(string, object);
        }
    }

    public Object getAnnotation(String string) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"getAnnotation:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return null;
        }
        return this.annotations.get(string);
    }

    public Enumeration getAnnotationKeys() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"getAnnotationKeys:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return null;
        }
        return this.annotations.keys();
    }

    public boolean isGroupManagerEnabled() {
        return Configuration.enableGroupManager;
    }

    public Integer getAuthPort() {
        return new Integer(Configuration.port);
    }

    public boolean compareCookie(String string) {
        boolean bl = Utils.cookieMatch((String)string, (String)this.callbackCookie);
        Log.debug((String)("compareCookie: match = " + bl));
        return bl;
    }

    public String getTokenSet() {
        return this.terminal.getTokenSet();
    }

    public boolean setupCrypto(String string) {
        String string2 = this.terminal.getClientRandom();
        this.crypto.resetCrypto();
        if (!this.crypto.readConfig(string)) {
            return false;
        }
        this.crypto.setSessionType(string2);
        if (string2 != null) {
            this.crypto.processChallenge(string2);
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

