/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.utauthd.SmartCardWordException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SmartCardConfigTokenizer {
    private Hashtable cmd_list;
    private char CMD_prefixchar = (char)255;
    private static final String StartWords = "--StartWords--";
    private static final String EndWords = "--EndWords--";
    private String labelSuffix = "::";
    private int labelsIndex = 0;
    private int firstTokenIndex = 1;

    public SmartCardConfigTokenizer(Hashtable hashtable) {
        this.cmd_list = hashtable;
    }

    public void setCMDprefix(char c) {
        this.CMD_prefixchar = c;
    }

    public void setLabelsIndex(int n) {
        this.labelsIndex = n;
    }

    public void setFirstTokenIndex(int n) {
        this.firstTokenIndex = n;
    }

    public void setLabelSuffix(String string) {
        this.labelSuffix = string;
    }

    public boolean tokenize(byte[] byArray, Vector vector) throws SmartCardWordException {
        return this.tokenize(new ByteArrayInputStream(byArray), vector);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tokenize(InputStream inputStream, Vector vector) throws SmartCardWordException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.commentChar(35);
        streamTokenizer.quoteChar(34);
        streamTokenizer.ordinaryChars(33, 33);
        streamTokenizer.wordChars(33, 33);
        streamTokenizer.ordinaryChars(36, 47);
        streamTokenizer.wordChars(36, 47);
        streamTokenizer.ordinaryChars(48, 64);
        streamTokenizer.wordChars(48, 64);
        streamTokenizer.ordinaryChars(91, 91);
        streamTokenizer.wordChars(91, 91);
        streamTokenizer.ordinaryChars(93, 96);
        streamTokenizer.wordChars(93, 96);
        streamTokenizer.ordinaryChars(123, 126);
        streamTokenizer.wordChars(123, 126);
        boolean bl = false;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        vector.add(hashtable);
        try {
            int n;
            int n2;
            block8: while (true) {
                n2 = streamTokenizer.nextToken();
                if (n2 == -1) return true;
                n = vector.size() - this.firstTokenIndex;
                switch (n2) {
                    case -3: {
                        String string = streamTokenizer.sval;
                        if (bl) {
                            if (string.equals(StartWords)) {
                                throw new SmartCardWordException(streamTokenizer.lineno(), n, "StartWords seen while tokenizing enabled");
                            }
                            if (string.equals(EndWords)) {
                                bl = false;
                                continue block8;
                            }
                            int n3 = string.lastIndexOf(this.labelSuffix);
                            if (n3 > 0) {
                                String string2 = string.substring(0, n3);
                                if (hashtable.containsKey(string2)) {
                                    throw new SmartCardWordException(streamTokenizer.lineno(), n, "duplicate label: " + string2);
                                }
                                if (this.cmd_list.get(string2) != null) {
                                    throw new SmartCardWordException(streamTokenizer.lineno(), n, "reserved word used as label: " + string2);
                                }
                                hashtable.put(string2, new Integer(vector.size()).toString());
                                continue block8;
                            }
                            String string3 = (String)this.cmd_list.get(string);
                            if (string3 != null) {
                                string = string3;
                            }
                            vector.add(string);
                            continue block8;
                        }
                        if (string.equals(EndWords)) {
                            throw new SmartCardWordException(streamTokenizer.lineno(), n, "EndWords seen while tokenizing disabled");
                        }
                        if (!string.equals(StartWords)) continue block8;
                        bl = true;
                        continue block8;
                    }
                    case 34: {
                        if (!bl) continue block8;
                        vector.add(streamTokenizer.sval);
                        continue block8;
                    }
                    case 10: {
                        continue block8;
                    }
                    case -2: {
                        continue block8;
                    }
                }
                break;
            }
            throw new SmartCardWordException(streamTokenizer.lineno(), n, "StreamTokenizer returned unexpected token type: " + n2);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean unTokenize(Vector vector, OutputStream outputStream) {
        Enumeration enumeration = vector.elements();
        if (!enumeration.hasMoreElements()) {
            return false;
        }
        Hashtable hashtable = (Hashtable)enumeration.nextElement();
        if (hashtable == null) {
            return false;
        }
        try {
            outputStream.write(("[" + hashtable.toString() + "] ").getBytes());
        }
        catch (IOException iOException) {
            return false;
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.cmd_list.containsValue(string)) {
                Enumeration enumeration2 = this.cmd_list.keys();
                while (enumeration2.hasMoreElements()) {
                    String string2 = (String)enumeration2.nextElement();
                    String string3 = (String)this.cmd_list.get(string2);
                    if (!string3.equals(string)) continue;
                    string = string2 + "(" + string.substring(1) + ")";
                    break;
                }
            }
            try {
                outputStream.write(("[" + string + "] ").getBytes());
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }
}

