/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.admin.Admin;
import auth.sdk.Log;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Crypto {
    public final int SECURE_SESSION = 0;
    public final int INSECURE_SESSION = 1;
    public final int NO_SESSION = 2;
    private final int LOW = 0;
    private final int HIGH = 1;
    private String authDownType;
    private String encUpType;
    private String encDownType;
    private String securityMode;
    private Hashtable param = new Hashtable();
    private int sessionType = 1;
    private String clientRandom = null;
    private String serverRandom = "";
    private String myDHMsg = "";
    private String masterKey = null;
    private String signature = null;

    public Crypto() {
        this.setSecurity(0);
    }

    public boolean readConfig(String string) {
        StringTokenizer stringTokenizer = null;
        Admin admin = Admin.getAdmin();
        if (admin != null) {
            String[] stringArray = admin.getCryptoEntByTokenID(string);
            Log.debug((String)("CryptoConfigData:: tokenId=" + string));
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringTokenizer = new StringTokenizer(stringArray[i], "=");
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    this.param.put(string2, string3);
                    Log.debug((String)("CryptoConfigData::" + string2 + " = " + string3));
                }
                this.securityMode = (String)this.param.get("mode");
                this.authDownType = (String)this.param.get("auth_down_type");
                this.encUpType = (String)this.param.get("enc_up_type");
                this.encDownType = (String)this.param.get("enc_down_type");
            } else {
                Log.notice((String)"Crypto.readConfig: config values are not found in the admin database, defaulting to high security options.");
                this.setSecurity(1);
            }
        } else {
            Log.debug((String)"Crypto.readConfig: admin database not found");
        }
        return true;
    }

    public static void init() {
        Crypto.loadPrivateKey();
    }

    public void resetCrypto() {
        this.sessionType = 1;
        this.clientRandom = null;
        this.serverRandom = "";
        this.myDHMsg = "";
        this.masterKey = null;
        this.signature = null;
    }

    public void setSessionType(Object object) {
        this.sessionType = this.authDownType != null && !this.authDownType.equalsIgnoreCase("none") || this.encUpType != null && !this.encUpType.equalsIgnoreCase("none") || this.encDownType != null && !this.encDownType.equalsIgnoreCase("none") ? (this.securityMode.equalsIgnoreCase("hard") ? (object == null ? 2 : 0) : (object == null ? 1 : 0)) : 1;
        if (this.sessionType != 0) {
            this.authDownType = "none";
            this.encUpType = "none";
            this.encDownType = "none";
        }
    }

    public void processChallenge(String string) {
        if (this.sessionType == 2 || this.sessionType == 1) {
            return;
        }
        if (this.encUpType != null && !this.encUpType.equalsIgnoreCase("none") || this.encDownType != null && !this.encDownType.equalsIgnoreCase("none")) {
            this.doEncryptionInit(string);
        }
        if (this.authDownType != null && !this.authDownType.equalsIgnoreCase("none")) {
            this.doAuthentication(string);
        }
    }

    public void processConnRsp(Hashtable hashtable) {
        if (this.sessionType == 1) {
            return;
        }
        if (this.encUpType != null && !this.encUpType.equalsIgnoreCase("none") || this.encDownType != null && !this.encDownType.equalsIgnoreCase("none")) {
            this.genDHKey(hashtable);
        }
    }

    public String getSessionInfo() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("encryptUpType=" + this.encUpType + "\n");
        stringBuffer.append("encryptDownType=" + this.encDownType + "\n");
        stringBuffer.append("authenticateUpType=none\n");
        stringBuffer.append("authenticateDownType=" + this.authDownType + "\n");
        stringBuffer.append("securityMode=" + this.securityMode);
        return stringBuffer.toString();
    }

    public String getSecurityMode() {
        return this.securityMode;
    }

    public String getMyDHMsg() {
        if (this.myDHMsg.length() != 0) {
            return this.myDHMsg;
        }
        return null;
    }

    public String getServerRandom() {
        if (this.serverRandom.length() != 0) {
            return this.serverRandom;
        }
        return null;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getMasterKey() {
        return this.masterKey;
    }

    public int getSessionType() {
        return this.sessionType;
    }

    public String getEncUpType() {
        return this.encUpType;
    }

    public String getEncDownType() {
        return this.encDownType;
    }

    private void doAuthentication(String string) {
        this.signature = this.sign(string + ":" + this.serverRandom + ":" + this.myDHMsg + ":" + this.encUpType + ":" + this.encDownType);
        Log.debug((String)"Authentication done");
    }

    private void doEncryptionInit(String string) {
        this.clientRandom = string;
        this.serverRandom = this.genServerRand();
        this.myDHMsg = this.genDHMsg();
    }

    private void genDHKey(Hashtable hashtable) {
        String string = null;
        string = (String)hashtable.get("clientDH");
        if (string != null) {
            this.masterKey = this.genMasterKey(string, this.clientRandom, this.serverRandom);
        }
    }

    private void setSecurity(int n) {
        switch (n) {
            case 0: {
                this.authDownType = "none";
                this.encUpType = "none";
                this.encDownType = "none";
                this.securityMode = "soft";
                break;
            }
            case 1: {
                this.authDownType = "simple";
                this.encUpType = "ARCFOUR";
                this.encDownType = "ARCFOUR";
                this.securityMode = "hard";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown security level:" + n));
            }
        }
    }

    public native String genServerRand();

    public native String genDHMsg();

    public native String genMasterKey(String var1, String var2, String var3);

    public native String sign(String var1);

    public static native void loadPrivateKey();

    static {
        System.loadLibrary("utcrypto");
    }
}

