/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.utauthd.AuthRecord;
import auth.utauthd.Configuration;
import auth.utauthd.SessionId;
import auth.utauthd.Terminal;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.NoSuchElementException;

public class GroupManager
extends Thread {
    private static final String SCCS_ID = "@(#)GroupManager.java\t1.25 04/01/29 SMI";
    private String status;

    public static void init() {
        GroupManager groupManager = new GroupManager();
        new Thread((Runnable)groupManager, "GroupManager").start();
    }

    public static native String whichServer(String var0, String var1, String var2, String var3);

    public static native String findPrimary(String var0, String var1);

    public static void status(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.configError((String)("during status: " + unsupportedEncodingException));
            return;
        }
        if (Configuration.enableGroupManager) {
            int n = GroupManager.groupNumHosts();
            outputStreamWriter.write("numhosts " + n + "\n");
            for (int i = 0; i < n; ++i) {
                outputStreamWriter.write(GroupManager.groupHostLine(i));
                int n2 = GroupManager.groupNumIfs(i);
                for (int j = 0; j < n2; ++j) {
                    outputStreamWriter.write(GroupManager.groupIntfLine(i, j));
                }
                outputStreamWriter.write(GroupManager.groupLoadLine(i));
            }
            outputStreamWriter.write("endhosts\n");
        } else {
            outputStreamWriter.write("disabled\n");
        }
        outputStreamWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tokenStatus(OutputStream outputStream, String string, String string2) throws IOException {
        Terminal terminal;
        OutputStreamWriter outputStreamWriter;
        Object object;
        SessionId sessionId;
        String string3 = "";
        try {
            sessionId = new SessionId(string2);
        }
        catch (Exception exception) {
            object = exception instanceof NoSuchElementException ? "Callback: malformed command" : "Callback: malformed session id";
            Log.unexpectedError((String)object);
            sessionId = null;
        }
        Log.notice((String)("tokenStatus " + string));
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.configError((String)("during status: " + unsupportedEncodingException));
            return;
        }
        String string4 = string;
        if (sessionId != null && (object = AuthRecord.getBySid(sessionId)) != null && (terminal = ((AuthRecord)object).getTerminal()) != null) {
            terminal.lock();
            try {
                string3 = ((AuthRecord)object).getIPAddress();
                if (string == null) {
                    string = ((AuthRecord)object).tokenName;
                }
                string4 = ((AuthRecord)object).insertToken;
            }
            finally {
                terminal.unlock();
            }
        }
        if (string == null) {
            outputStreamWriter.write("no token for sid\n");
            outputStreamWriter.flush();
            return;
        }
        if (Configuration.enableGroupManager) {
            object = GroupManager.sessionList(string, string4, string3);
            outputStreamWriter.write((String)object);
        } else {
            outputStreamWriter.write("disabled\n");
        }
        outputStreamWriter.flush();
    }

    public static String listSessionsByToken(String string) {
        return GroupManager.sessionList(string, string, "");
    }

    public static native boolean claimToken(String var0);

    public static native boolean disclaimToken(String var0);

    public static native boolean isNetworkAllowed(long var0);

    public void run() {
        this.status = GroupManager.groupManager();
        System.out.println(this.status);
    }

    private static native String sessionList(String var0, String var1, String var2);

    private static native String groupManager();

    private static native int groupNumHosts();

    private static native String groupHostLine(int var0);

    private static native int groupNumIfs(int var0);

    private static native String groupIntfLine(int var0, int var1);

    private static native String groupLoadLine(int var0);

    static {
        System.loadLibrary("utgrpmgr");
    }
}

