/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.admin.Admin;
import auth.protocol.AuthWriter;
import auth.protocol.Protocol;
import auth.sdk.AuthenticationClient;
import auth.sdk.Log;
import auth.sdk.Task;
import auth.sdk.TaskListener;
import auth.utauthd.Alarm;
import auth.utauthd.AuthModule;
import auth.utauthd.AuthRecord;
import auth.utauthd.Configuration;
import auth.utauthd.Crypto;
import auth.utauthd.DeadlockException;
import auth.utauthd.GroupManager;
import auth.utauthd.Mutex;
import auth.utauthd.SmartCardID;
import auth.utauthd.SmartCardIDException;
import auth.utauthd.WatchIO;
import auth.utauthd.WatchIOListener;
import auth.utauthd.WatchIORequest;
import auth.utauthd.Worker;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Terminal
implements WatchIOListener,
TaskListener {
    private boolean valid = false;
    private int tagCtr = 0;
    private String msgTag;
    private boolean protocolErrorPending = false;
    private AuthRecord ar = null;
    private SmartCardID scId = null;
    private boolean scDone = false;
    private AuthWriter out = null;
    private BufferedInputStream in;
    private InputStreamReader reader;
    private Socket s;
    private String address;
    private String dmxid;
    private InetAddress localAddr;
    private InetAddress ipAddress;
    private InetAddress realIP;
    private int ipPort;
    private String lastInsertToken = null;
    private String buffer = null;
    private String useReal;
    private WatchIORequest wior = null;
    private int tokenSeq = 0;
    private int savedTokenSeq = 0;
    private int mtu = 0;
    private static final String NAMESPACE = "IEEE802";
    private String model = null;
    private String sn = null;
    private String namespace = null;
    private long pktCount = 0L;
    private long lossCount = 0L;
    private float connTime = 0.0f;
    private float idleTime = 0.0f;
    private long byteCount = 0L;
    private long latency = 0L;
    private String startRes = null;
    private String ddcInfo = null;
    private String initState = null;
    private String barrierLevel = null;
    private Hashtable storedParams = new Hashtable();
    private boolean actionPending = false;
    private static Object connectionCounterLock = new Object();
    private static int connectionCounter = 0;
    private String debugName = null;
    private int keepAliveState = 0;
    private static final int KEEPALIVE_OK = 0;
    private static final int KEEPALIVE_PENDING = 1;
    private static final int KEEPALIVE_ERROR = 2;
    int errorCount = 0;
    static final int MAXERRORS = 1000;
    private Mutex mutex = new Mutex();
    private Crypto crypto = new Crypto();
    private String clientRand = null;
    private StringBuffer tokenSet = null;
    private final String CORONA_NAME = "corona";
    private final String SUNRAY_NAME = "SunRay";
    private String firstServer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal(Socket socket, String string) throws Exception {
        if (socket == null) {
            throw new Exception("Terminal instantiated with null");
        }
        this.msgTag = string;
        this.s = socket;
        this.ipAddress = socket.getInetAddress();
        this.localAddr = socket.getLocalAddress();
        this.ipPort = socket.getPort();
        this.address = this.ipAddress.getHostAddress();
        this.in = new BufferedInputStream(this.s.getInputStream());
        this.reader = new InputStreamReader((InputStream)this.in, "8859_1");
        this.out = new AuthWriter(this.s.getOutputStream());
        Log.debug((String)"Terminal:: creating terminal object .. getting lock");
        this.lock();
        try {
            socket.setTcpNoDelay(true);
            this.s.setSoTimeout(Configuration.timeout);
            if (!Terminal.isNetworkAllowed(this.ipAddress)) {
                Log.unexpectedError((String)("Connection from " + this.address + " is not allowed"));
                this.protocolError("networkNotAllowed");
            } else {
                this.valid = true;
                this.debugName = "Terminal" + ++connectionCounter;
                this.wior = new WatchIORequest(this.s, 1, this, true, this.debugName);
                this.wior.setTimeout(Configuration.timeout);
                WatchIO.add(this.wior);
            }
        }
        catch (SocketException socketException) {
            Log.unexpectedError((String)(this.s + " Cannot set socket timeout: " + socketException));
            this.close();
            return;
        }
        finally {
            Log.debug((String)"Terminal:: releasing lock after create terminal");
            this.unlock();
        }
    }

    public String toString() {
        String string;
        if (this.ar != null) {
            string = this.ar.toString();
            if (string.length() > 40) {
                string = string.substring(0, 40) + "...";
            }
        } else {
            string = "null";
        }
        return this.debugName + "(valid:" + this.valid + ", s:" + this.address + ", ar:" + string + ")";
    }

    public void lock() {
        try {
            this.mutex.lock();
        }
        catch (DeadlockException deadlockException) {
            Log.unexpectedError((String)deadlockException.getMessage());
            deadlockException.printStackTrace();
            Log.notice((String)"System error !!! Server exiting.");
            System.exit(1);
        }
    }

    public void unlock() {
        this.mutex.unlock();
    }

    private void queueProtocolError(long l, String string) {
        long l2 = System.currentTimeMillis() + l;
        if (!this.protocolErrorPending) {
            this.protocolErrorPending = true;
            Vector<String> vector = new Vector<String>(2);
            vector.addElement("protocolError");
            vector.addElement(string);
            Alarm.queue(this, l2, vector, (byte)0);
        }
    }

    public boolean watchIOEvent(short s, Object object) {
        Worker.begin(new Task((TaskListener)this, (Object)new Short(s), true));
        return false;
    }

    public boolean write(String string, Hashtable hashtable) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"write:: Does not have required locks!");
            System.exit(1);
        }
        if (this.valid) {
            if (string.equals("connInf") || string.equals("redirectInf")) {
                hashtable.put("tokenSeq", String.valueOf(this.tokenSeq));
                if (string.equals("connInf")) {
                    this.savedTokenSeq = this.tokenSeq;
                }
            }
            return this.out.write(string, hashtable);
        }
        return false;
    }

    public void setStoredParams(Hashtable hashtable) {
        this.storedParams = hashtable;
    }

    public Hashtable getStoredParams() {
        return this.storedParams;
    }

    public String getStoredParam(String string) {
        return (String)this.storedParams.get(string);
    }

    public String getResolution() {
        return this.startRes;
    }

    public String getDdcInfo() {
        return this.ddcInfo;
    }

    public String getInitialState() {
        return this.initState;
    }

    public String getTerminalStats() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"getTerminalStats:: Does not have required locks!");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("terminalPackets=" + this.pktCount);
        stringBuffer.append("\nterminalLostPackets=" + this.lossCount);
        stringBuffer.append("\nterminalConnectTime=" + this.connTime);
        stringBuffer.append("\nterminalIdleTime=" + this.idleTime);
        stringBuffer.append("\nterminalBytes=" + this.byteCount);
        stringBuffer.append("\nterminalLatency=" + this.latency);
        stringBuffer.append("\nterminalBarrierLevel=" + this.barrierLevel);
        return stringBuffer.toString();
    }

    public String getIPAddressString() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"getIPAddressString:: Does not have required locks!");
            return null;
        }
        if (this.valid) {
            return this.address;
        }
        return null;
    }

    public String getRealIPString() {
        return this.realIP.getHostAddress();
    }

    public String getUseReal() {
        return this.useReal;
    }

    public String getAuthPortString() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"getAuthPortString:: Does not have required locks!");
            return null;
        }
        if (this.valid) {
            return Integer.toString(this.ipPort);
        }
        return null;
    }

    public String getAuthIPAandPortString() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"getAuthIPAandPortString:: Does not have required locks!");
            return null;
        }
        if (this.valid) {
            return this.address + "/" + this.ipPort;
        }
        return null;
    }

    public InetAddress renderIpa() {
        return this.ipAddress;
    }

    public int renderPort() {
        return this.ipPort;
    }

    public InetAddress authIpa() {
        return this.ipAddress;
    }

    public int authPort() {
        return this.ipPort;
    }

    public void disable() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"disable:: Does not have required locks!");
            System.exit(1);
        }
        WatchIO.remove(this.wior);
    }

    public void enable() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"enable:: Does not have required locks!");
            System.exit(1);
        }
        WatchIO.add(this.wior);
    }

    public String getModel() {
        return this.model;
    }

    public String getSerialNumber() {
        return this.sn;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getFirstString() {
        if (this.firstServer != null) {
            return Terminal.longToInet(Long.parseLong(this.firstServer, 16)).getHostAddress();
        }
        return null;
    }

    public boolean isActionPending() {
        return this.actionPending;
    }

    public void setActionPending(boolean bl) {
        this.actionPending = bl;
    }

    public void close() {
        Log.debug((String)"Terminal.close: BEGIN");
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"close:: Does not have required locks!");
            System.exit(1);
        }
        if (this.ar != null) {
            this.ar.destroy();
            this.ar = null;
        }
        this.valid = false;
        if (this.s != null) {
            this.disable();
            try {
                this.s.close();
            }
            catch (IOException iOException) {
                Log.unexpectedError((String)("Terminal.close: " + iOException));
                System.exit(1);
            }
            this.s = null;
        }
        this.in = null;
        this.out = null;
        this.address = null;
        this.wior = null;
    }

    private static boolean isNetworkAllowed(InetAddress inetAddress) {
        boolean bl = false;
        if (Configuration.allowLANConnections) {
            return true;
        }
        Long l = Terminal.addrToLong(inetAddress.getHostAddress());
        return GroupManager.isNetworkAllowed(l);
    }

    private static Long addrToLong(String string) {
        long l = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreElements()) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            l = l << 8 | (long)n;
        }
        return new Long(l & 0xFFFFFFFFFFFFFFFFL);
    }

    private static InetAddress longToInet(long l) {
        String string = (l >> 24 & 0xFFL) + "." + (l >> 16 & 0xFFL) + "." + (l >> 8 & 0xFFL) + "." + (l & 0xFFL);
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLocalAddr() {
        return this.localAddr.getHostAddress();
    }

    public void protocolError(String string) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"protocolError:: Does not have required locks!");
            return;
        }
        Log.unexpectedError((String)(this.address + " protocolError: " + string));
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
            hashtable.put("state", "disconnected");
            hashtable.put("error", string);
            this.write("protocolErrorInf", hashtable);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)(this.address + " Error while processing protocolError: " + exception));
            Thread.currentThread();
            Thread.dumpStack();
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskEvent(Object object) {
        block36: {
            this.lock();
            try {
                boolean bl = true;
                Task task = (Task)object;
                short s = (Short)task.param;
                if ((s & 1) != 0) {
                    s = (short)(s & 0xFFFFFFFE);
                    if (!this.readMessages()) {
                        this.close();
                    } else {
                        this.keepAliveState = 0;
                    }
                }
                if ((s & 8) != 0) {
                    s = (short)(s & 0xFFFFFFF7);
                    Log.unexpectedError((String)"Terminal.taskEvent: POLLERR");
                    return;
                }
                if ((s & 0x10) != 0) {
                    s = (short)(s & 0xFFFFFFEF);
                    Log.unexpectedError((String)"Terminal.taskEvent: POLLHUP");
                    return;
                }
                if ((s & 4) != 0) {
                    s = (short)(s & 0xFFFFFFFB);
                    Log.unexpectedError((String)"Terminal.taskEvent: POLLPRI");
                    return;
                }
                if ((s & 0x20) != 0) {
                    s = (short)(s & 0xFFFFFFDF);
                    Log.unexpectedError((String)"Terminal.taskEvent: POLLNVAL");
                    this.close();
                    return;
                }
                if ((s & 0x1000) != 0) {
                    s = (short)(s & 0xFFFFEFFF);
                    switch (this.keepAliveState) {
                        case 0: {
                            try {
                                if (this.write("keepAliveInf", null)) {
                                    this.keepAliveState = 1;
                                    break;
                                }
                                this.keepAliveState = 2;
                            }
                            catch (Exception exception) {
                                Log.unexpectedError((String)"cannot send keepAliveInf");
                                this.keepAliveState = 2;
                            }
                            break;
                        }
                        case 1: {
                            this.keepAliveState = 2;
                            break;
                        }
                        case 2: {
                            this.keepAliveState = 2;
                        }
                    }
                    if (this.keepAliveState == 2) {
                        this.close();
                    }
                }
                if (s != 0) {
                    Log.unexpectedError((String)("Terminal.taskEvent: ignored events: " + s));
                    s = 0;
                    return;
                }
                if (!this.actionPending) break block36;
                String string = (String)this.storedParams.get("savedType");
                String string2 = (String)this.storedParams.get("savedId");
                if (string != null) {
                    String string3 = (String)this.storedParams.get("username");
                    if (!string.equals("auth") || string3 != null && !string3.equals("")) {
                        this.storedParams.put("type", string);
                        if (string2 != null) {
                            this.storedParams.put("id", string2);
                        }
                    }
                }
                try {
                    bl = this.continueProcess("infoReq", this.storedParams);
                    this.actionPending = false;
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)("Failed in process: " + exception));
                    exception.printStackTrace();
                    bl = false;
                }
                if (!bl) {
                    this.close();
                    if (this.ar != null) {
                        this.ar.destroy();
                        this.ar = null;
                    }
                }
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("Terminal.taskEvent: failed with exception " + exception));
                exception.printStackTrace();
                System.out.println("Worker thread recovered from error. Continuing..");
                Log.notice((String)"Worker thread recovered from error. Continuing..");
            }
            finally {
                this.unlock();
            }
        }
        if (this.valid) {
            WatchIO.add(this.wior);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskEvent(Object[] objectArray) {
        String string = (String)objectArray[0];
        this.lock();
        try {
            if (string.equals("protocolError")) {
                if (!this.protocolErrorPending) {
                    return;
                }
                String string2 = null;
                if (objectArray.length > 1) {
                    string2 = (String)objectArray[1];
                }
            } else {
                Log.unexpectedError((String)("Terminal.alarmEvent: " + string));
            }
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("Terminal.taskEvent: failed with exception " + exception));
            exception.printStackTrace();
            System.out.println("Worker thread recovered from error. Continuing..");
            Log.notice((String)"Worker thread recovered from error. Continuing..");
        }
        finally {
            this.unlock();
        }
    }

    private boolean readMessages() {
        boolean bl = true;
        block12: while (this.valid) {
            int n;
            int n2;
            try {
                n2 = this.in.available();
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("Terminal.readMesages: " + exception));
                return false;
            }
            if (bl && n2 < 1) {
                ++this.errorCount;
                if (this.errorCount > 1000) {
                    Log.notice((String)"readMessage::socket looping limit exceeded.Close it.");
                    return false;
                }
            } else {
                this.errorCount = 0;
            }
            if (n2 <= 0) {
                if (!Configuration.nonBlockRead || !bl) break;
                try {
                    int n3 = this.s.getSoTimeout();
                    this.s.setSoTimeout(1);
                    int n4 = this.in.read();
                    if (n4 == -1) {
                        Log.debug((String)"end of file. Close socket.");
                        return false;
                    }
                    Log.notice((String)("Read a byte after av was <=0 : " + (char)n4));
                    this.buffer = this.buffer + (char)n4;
                    this.s.setSoTimeout(n3);
                    break;
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)("Terminal.readMessages: " + exception));
                    return false;
                }
            }
            byte[] byArray = new byte[n2];
            int n5 = 0;
            try {
                n5 = this.in.read(byArray, 0, n2);
                bl = false;
            }
            catch (IOException iOException) {
                Log.unexpectedError((String)("Terminal.readMessages: in.read: " + iOException));
                return false;
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("Terminal.readMessages: catchall-2" + exception));
                return false;
            }
            if (n5 != n2) {
                Log.unexpectedError((String)("Terminal.readMessages: expected " + n2 + " bytes, got " + n5));
            }
            if (n5 > 0) {
                String string = "";
                try {
                    string = new String(byArray, "8859_1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.configError((String)"Terminal.readMessages: impossible");
                    System.exit(1);
                }
                this.buffer = this.buffer != null ? this.buffer + string : string;
            } else if (n5 <= 0) {
                Log.unexpectedError((String)"Terminal.readMessages: end of stream; socket closed.");
                return false;
            }
            while ((n = this.buffer.indexOf(10)) != -1) {
                int n6;
                String string = this.buffer.substring(0, n);
                Log.debug((String)("Terminal.processCompleteCommands: msg=\"" + string + "\""));
                this.buffer = this.buffer.substring(n + 1);
                Hashtable hashtable = Protocol.parse((String)string);
                if (hashtable == null) {
                    this.protocolError("does_not_parse");
                    if (this.buffer != null && this.buffer.length() > 0) {
                        Log.debug((String)("Terminal.readMessages: discard_a " + this.buffer.length() + "<" + this.buffer + ">"));
                    }
                    this.buffer = null;
                    continue block12;
                }
                String string2 = (String)hashtable.get("_command");
                if (string2 == null) {
                    this.protocolError("missing command");
                    Log.debug((String)("Terminal.readMessages: discard_b " + this.buffer.length() + "<" + this.buffer + ">"));
                    this.buffer = null;
                    continue block12;
                }
                hashtable.remove("_command");
                String string3 = (String)hashtable.get("hw");
                if (string3 != null) {
                    n6 = string3.toLowerCase().indexOf("corona");
                    if (n6 != -1) {
                        StringBuffer stringBuffer = new StringBuffer("");
                        stringBuffer.append(string3.substring(0, n6));
                        stringBuffer.append("SunRay");
                        stringBuffer.append(string3.substring(n6 + "corona".length(), string3.length()));
                        hashtable.put("hw", stringBuffer.toString());
                    }
                } else {
                    this.protocolError("Missing hw string from : " + hashtable.get("sn") + ". Check hardware");
                    this.buffer = null;
                    continue block12;
                }
                n6 = 0;
                try {
                    n6 = this.process(string2, hashtable) ? 1 : 0;
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)("Terminal.readMessages: process() failed with exception " + exception));
                    exception.printStackTrace();
                    System.out.println("Worker thread recovered from error. Continuing..");
                    Log.notice((String)"Worker thread recovered from error. Continuing..");
                    n6 = 0;
                }
                if (n6 == 0) {
                    Log.debug((String)("Terminal.readMessages: discard_c " + this.buffer.length() + "<" + this.buffer + ">"));
                    this.buffer = null;
                    this.close();
                    if (this.ar == null) continue block12;
                    this.ar.destroy();
                    this.ar = null;
                    continue block12;
                }
                if (this.buffer.length() <= 0) continue;
                Log.debug((String)("Terminal.readMessages: iOfNL=" + this.buffer.indexOf(10) + ", remainder=\"" + this.buffer + "\""));
            }
        }
        return true;
    }

    private boolean process(String string, Hashtable hashtable) {
        String string2;
        Log.debug((String)("PROCESS: " + string + hashtable));
        if (string.equals("keepAliveReq")) {
            this.startSmartCardIDTimer();
            if (!this.write("keepAliveCnf", null)) {
                Log.unexpectedError((String)"cannot send keepAliveCnf");
                return false;
            }
            if (hashtable.get("pktCount") != null) {
                this.pktCount = Long.parseLong((String)hashtable.get("pktCount"));
            }
            if (hashtable.get("lossCount") != null) {
                this.lossCount = Long.parseLong((String)hashtable.get("lossCount"));
            }
            if (hashtable.get("byteCount") != null) {
                this.byteCount = Long.parseLong((String)hashtable.get("byteCount"));
            }
            if (hashtable.get("idleTime") != null) {
                this.idleTime = Float.parseFloat((String)hashtable.get("idleTime"));
            }
            if (hashtable.get("connTime") != null) {
                this.connTime = Float.parseFloat((String)hashtable.get("connTime"));
            }
            if (hashtable.get("latency") != null) {
                this.latency = Long.parseLong((String)hashtable.get("latency"));
            }
            return true;
        }
        if (string.equals("keepAliveRsp")) {
            return true;
        }
        String string3 = (String)hashtable.get("terminalIPA");
        if (string3 == null) {
            hashtable.put("terminalIPA", this.address);
        }
        String string4 = (String)hashtable.get("event");
        String string5 = (String)hashtable.get("cause");
        if (string.equals("infoReq") && string4.equals("insert")) {
            string2 = (String)hashtable.get("tokenSeq");
            if (string2 != null) {
                this.tokenSeq = Integer.parseInt((String)hashtable.get("tokenSeq"));
            }
            this.startRes = (String)hashtable.get("startRes");
            this.ddcInfo = (String)hashtable.get("ddcconfig");
            this.initState = (String)hashtable.get("initState");
            this.barrierLevel = (String)hashtable.get("barrierLevel");
            if (this.barrierLevel == null) {
                this.barrierLevel = "0";
            }
            this.mtu = (string2 = (String)hashtable.get("MTU")) != null ? Integer.parseInt(string2) : 1500;
            string2 = (String)hashtable.get("realIP");
            this.realIP = null;
            if (string2 != null) {
                this.realIP = Terminal.longToInet(Long.parseLong(string2, 16));
            }
            if (this.realIP == null) {
                this.realIP = this.ipAddress;
            }
            this.useReal = this.realIP.equals(this.ipAddress) ? "true" : "false";
            hashtable.put("useReal", this.useReal);
            hashtable.put("rawType", hashtable.get("type"));
            hashtable.put("rawId", hashtable.get("id"));
            this.clientRand = (String)hashtable.get("clientRand");
        }
        if (!this.checkSmartCardMsg(string, hashtable)) {
            return false;
        }
        if ((string.equals("infoReq") || string.equals("infoSmartCard")) && this.scId != null) {
            if (this.scDone) {
                string = this.moreSmartCardProcessing(string, hashtable);
                hashtable.put("rawType", hashtable.get("type"));
                hashtable.put("rawId", hashtable.get("id"));
                Log.debug((String)"Terminal.process: Done processing smartcard");
            } else {
                Log.debug((String)"Terminal.process: Still processing smartcard");
                return true;
            }
        }
        string4 = (String)hashtable.get("event");
        string5 = (String)hashtable.get("cause");
        string2 = (String)hashtable.get("forceInsert");
        if (string.equals("infoReq")) {
            this.insertRemove(hashtable);
            if (hashtable.get("doamgh") == null) {
                if (string5 != null && string5.equals("insert")) {
                    if (string2 != null && string2.equals("true")) {
                        hashtable.put("doamgh", "false");
                        if (hashtable.get("subcause") == null) {
                            hashtable.put("subcause", "utswitch");
                        }
                    } else {
                        hashtable.put("doamgh", "true");
                    }
                } else {
                    hashtable.put("doamgh", "false");
                    if (hashtable.get("subcause") == null) {
                        hashtable.put("subcause", "utswitch");
                    }
                }
            }
            this.setStoredParams(hashtable);
            this.clearTokenSet();
        }
        return this.continueProcess(string, hashtable);
    }

    private boolean continueProcess(String string, Hashtable hashtable) {
        boolean bl = true;
        if (this.ar != null && this.ar.isTerminated()) {
            this.ar = null;
        }
        if (this.ar == null) {
            bl = this.requireNewAR(string, hashtable);
            return bl;
        }
        bl = this.alreadyHasAR(string, hashtable);
        return bl;
    }

    private void insertRemove(Hashtable hashtable) {
        String string;
        String string2;
        String string3;
        String string4 = (String)hashtable.get("event");
        if (string4 == null) {
            return;
        }
        String string5 = (String)hashtable.get("rawType");
        if (string5 == null) {
            string5 = "unknown";
        }
        if ((string3 = (String)hashtable.get("rawId")) == null) {
            string3 = "unknown";
        }
        this.lastInsertToken = string2 = string5 + "." + string3;
        Admin admin = Admin.getAdmin();
        if (admin == null) {
            return;
        }
        String string6 = (String)hashtable.get("hw");
        if (string6 == null) {
            string6 = "unknown";
        }
        if ((string = (String)hashtable.get("sn")) == null) {
            string = "unknown";
        }
        String string7 = string6 + "." + string;
        if (string4.equals("insert")) {
            admin.userEvent(string2, string7, "n/a", -1, "insert", System.currentTimeMillis());
        } else if (string4.equals("remove")) {
            if (string2.equals("card.0") && this.lastInsertToken != null) {
                string2 = this.lastInsertToken;
            }
            this.lastInsertToken = null;
            admin.userEvent(string2, string7, "n/a", -1, "remove", System.currentTimeMillis());
        } else {
            admin.userEvent(string2, string7, "n/a", -1, "unknown", System.currentTimeMillis());
        }
    }

    private boolean requireNewAR(String string, Hashtable hashtable) {
        Log.debug((String)("In require newAR, this: " + this + " actionPending: " + this.actionPending));
        if (string.equals("discRsp")) {
            if (this.actionPending) {
                return true;
            }
            return !this.scDone;
        }
        if (string.equals("discReq")) {
            return false;
        }
        if (string.equals("controlRsp") || string.equals("protocolErrorReq")) {
            return true;
        }
        if (string.equals("connRsp")) {
            return false;
        }
        if (!string.equals("infoReq")) {
            this.protocolError("incorrect state");
            return false;
        }
        if (!this.setupAR(hashtable)) {
            return false;
        }
        this.addToTokenSet(hashtable.get("type") + "." + hashtable.get("id"));
        if (this.actionPending) {
            this.actionPending = false;
        }
        AuthenticationClient authenticationClient = AuthModule.select(hashtable, this.ar);
        if (hashtable.get("stealProtected") != null) {
            this.storedParams.put("stealProtected", hashtable.get("stealProtected"));
        }
        Log.debug((String)("Client = " + authenticationClient));
        if (authenticationClient == null) {
            return this.cleanup(string, hashtable);
        }
        this.ar.setClient(authenticationClient);
        if (authenticationClient.getModuleName().startsWith("TerminalId")) {
            this.ar.insertToken = authenticationClient.getLocalName();
            this.clearTokenSet();
            this.addToTokenSet(this.ar.insertToken);
            this.addToTokenSet(authenticationClient.getGlobalName());
        } else {
            this.ar.insertToken = this.lastInsertToken;
            this.addToTokenSet(hashtable.get("type") + "." + hashtable.get("id"));
        }
        this.recordTokenState(string, hashtable);
        Log.debug((String)"Terminal.requireNewAR(): calling ar.connReq");
        if (hashtable.get("savedType") != null) {
            this.storedParams.put("savedType", hashtable.get("savedType"));
            this.storedParams.put("savedId", hashtable.get("savedId"));
        }
        if (hashtable.get("altuid") != null) {
            this.storedParams.put("altuid", hashtable.get("altuid"));
        }
        if (hashtable.get("altlocale") != null) {
            this.storedParams.put("altlocale", hashtable.get("altlocale"));
        }
        if (!this.ar.connReq(hashtable)) {
            this.protocolError("connReq failed: " + this.address);
            return false;
        }
        return true;
    }

    private boolean alreadyHasAR(String string, Hashtable hashtable) {
        Log.debug((String)"In already hasAR");
        if (this.ar.isTerminated()) {
            if (this.ar != null) {
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                hashtable2.put("cause", "terminated");
                if (!this.ar.message("discReq", hashtable)) {
                    this.ar = null;
                }
            }
            return false;
        }
        if (string.equals("controlRsp")) {
            this.ar.controlRsp(hashtable);
        } else {
            if (string.equals("connRsp")) {
                int n;
                String string2 = (String)hashtable.get("tokenSeq");
                if (string2 != null && (n = Integer.parseInt(string2)) != this.savedTokenSeq) {
                    return true;
                }
                String string3 = (String)hashtable.get("pn");
                this.dmxid = (String)hashtable.get("dmXid");
                if (this.dmxid == null) {
                    this.dmxid = string3;
                }
                this.crypto.processConnRsp(hashtable);
                return this.ar.connRsp(string3, this.dmxid);
            }
            if (!string.equals("discRsp")) {
                if (string.equals("infoReq") || string.equals("infoRsp")) {
                    if (!this.ar.message(string, hashtable)) {
                        this.ar = null;
                    }
                } else {
                    if (string.equals("discReq")) {
                        String string4;
                        if (!this.ar.message(string, hashtable)) {
                            this.ar = null;
                        }
                        return (string4 = (String)hashtable.get("cause")) == null || !string4.equals("redirect");
                    }
                    this.protocolError("invalid message: " + string);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean setupAR(Hashtable hashtable) {
        Log.debug((String)"In setupAR");
        this.model = (String)hashtable.get("hw");
        this.sn = (String)hashtable.get("sn");
        this.namespace = (String)hashtable.get("namespace");
        this.firstServer = (String)hashtable.get("firstServer");
        String string = (String)hashtable.get("fw");
        String string2 = (String)hashtable.get("pn");
        if (this.sn != null) {
            if (this.namespace == null) {
                this.namespace = NAMESPACE;
            }
        } else {
            this.protocolError("terminal must supply unique hw.sn params");
            return false;
        }
        String string3 = this.namespace + "." + this.sn;
        hashtable.put("terminalCID", string3);
        try {
            this.ar = new AuthRecord(this, string3, string, string2, this.address, this.mutex, this.crypto);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)(this.address + "Handleclient, AuthRecord: " + exception));
            exception.printStackTrace();
            this.close();
            return false;
        }
        return true;
    }

    private boolean cleanup(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get("event");
        if (!string.equals("infoReq") || string2 == null || !string2.equals("insert")) {
            this.ar.destroy();
            this.ar = null;
            return true;
        }
        String string3 = "unclaimed token from: " + this.address + " sent: " + hashtable;
        this.protocolError(string3);
        return false;
    }

    private void recordTokenState(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get("event");
        if (string.equals("infoReq")) {
            if (string2.equals("insert")) {
                this.ar.setTokenState(true);
            } else {
                this.ar.setTokenState(false);
            }
        }
    }

    private boolean checkSmartCardMsg(String string, Hashtable hashtable) {
        try {
            if (string.equals("infoReq")) {
                String string2 = (String)hashtable.get("event");
                if (string2.equals("insert")) {
                    if (this.scId == null) {
                        try {
                            this.createSmartCardID(this, Configuration.scConfigData, Configuration.terminalTokens);
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }
                    this.scDone = this.processSmartCardMessage(string, hashtable);
                }
                if (string2.equals("remove")) {
                    boolean bl = true;
                    if (this.scId != null) {
                        bl = this.processSmartCardMessage(string, hashtable);
                    }
                    this.scDone = bl;
                }
            }
            if (string.equals("infoSmartCard")) {
                if (this.scId == null) {
                    Log.unexpectedError((String)"Terminal.checkSmartCardMsg:(1): SmartCardID is null");
                    this.scDone = false;
                    return false;
                }
                this.scDone = this.processSmartCardMessage(string, hashtable);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String moreSmartCardProcessing(String string, Hashtable hashtable) {
        String string2;
        if (string.equals("infoSmartCard")) {
            Log.debug((String)("Terminal.moreSmartCardProcessing: change to infoReq from " + string));
            string = "infoReq";
        }
        if (string.equals("infoReq") && (string2 = (String)hashtable.get("event")).equals("remove")) {
            this.scId = null;
        }
        return string;
    }

    private void createSmartCardID(Terminal terminal, Vector vector, Vector vector2) throws Exception {
        try {
            this.scId = new SmartCardID(terminal, vector, vector2, this.getUniqueTag());
            Log.debug((String)("Terminal.createSmartCardID(): SmartCard object created: " + this.scId));
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("Terminal.createSmartCardID(): new SmartCardId() failed " + exception));
            throw exception;
        }
    }

    private void startSmartCardIDTimer() {
        if (this.scId != null) {
            this.scId.tick();
        }
    }

    private boolean processSmartCardMessage(String string, Hashtable hashtable) throws SmartCardIDException {
        Log.debug((String)"Terminal.processSmartCardMessage(): process smartcard");
        try {
            this.scDone = this.scId.process(string, hashtable);
            Log.debug((String)("Terminal.processSmartCardMessage: SmartCard.process() returns : " + this.scDone));
        }
        catch (SmartCardIDException smartCardIDException) {
            Log.unexpectedError((String)("Cannot obtain SmartCard ID: " + smartCardIDException.getMessage()));
            this.scId = null;
            this.scDone = false;
            throw smartCardIDException;
        }
        return this.scDone;
    }

    public synchronized String getUniqueTag() {
        return this.msgTag + ":" + Integer.toHexString(this.tagCtr++);
    }

    public void addToTokenSet(String string) {
        if (this.tokenSet == null || this.tokenSet.length() == 0) {
            this.tokenSet = new StringBuffer(string);
        } else if (this.tokenSet.toString().indexOf(string) == -1) {
            this.tokenSet.append("," + string);
        }
    }

    public void setRedirectedTokenSet(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get("rawType");
        String string3 = (String)hashtable.get("rawId");
        this.tokenSet = new StringBuffer(string2 + "." + string3);
        int n = string.indexOf(44);
        if (n != -1) {
            this.tokenSet.append(string.substring(n));
        }
    }

    public String getTokenSet() {
        return this.tokenSet.toString();
    }

    public void clearTokenSet() {
        this.tokenSet = new StringBuffer("");
    }

    public String getClientRandom() {
        return this.clientRand;
    }

    public int getMTU() {
        return this.mtu;
    }
}

