/*
 * Decompiled with CFR 0.152.
 */
package auth.utguiauth;

public abstract class AbstractPamAuthCallback {
    private static final String SCCS_ID = "@(#)AbstractPamAuthCallback.java\t1.1\t07/02/14 SMI";
    private static boolean beginAbort = false;
    private static int PAM_SUCCESS = 0;
    private String response = null;
    private boolean aborted = false;
    private boolean interrupted = false;
    private boolean done = false;
    private boolean restart = false;

    protected abstract void pamMsgCallbackNotify(String var1, int var2);

    protected abstract void completedCallbackNotify(int var1);

    public final synchronized void putPamResponse(String response) {
        this.response = response;
        this.notify();
    }

    public final synchronized void restart() {
        this.restart = true;
        this.notify();
    }

    public final synchronized void shutdown() {
        beginAbort = true;
        this.notify();
        while (!this.aborted) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    final void pamMsgCallback(String msg, int msgStyle) {
        this.pamMsgCallbackNotify(msg, msgStyle);
    }

    final void completedCallback(int pamStatus) {
        if (pamStatus == 7) {
            pamStatus = 9;
        }
        this.completedCallbackNotify(pamStatus);
        this.done = pamStatus == PAM_SUCCESS;
    }

    final synchronized String getPamResponse() throws InterruptedException {
        while (this.response == null && !beginAbort && !this.restart) {
            this.wait();
            if (this.response != null) {
                String resp = this.response;
                this.response = null;
                return resp;
            }
            if (!beginAbort && !this.restart) continue;
            throw new InterruptedException("PAM" + (beginAbort ? " abort" : (this.restart ? " restart" : " <error: unknown interrupt>")) + " by client");
        }
        return null;
    }

    final void started() {
        this.restart = false;
        this.interrupted = false;
    }

    final synchronized void shutdownComplete() {
        this.aborted = true;
        this.notify();
    }

    final synchronized void serverInterrupted() {
        this.interrupted = true;
    }

    final boolean wasInterrupted() {
        return this.interrupted;
    }

    final boolean isDone() {
        return beginAbort || this.interrupted || this.done;
    }
}

