//<!--
//
// ident "$Id$ SMI"
//
// Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
// Use is subject to license terms.
//

var applicationsTableId = "f1:_id15:p1:ps:pss:p9:t1";
var predefinedId = "f1:t1:a1:s1:p1:i1_editable";
var dropdownId = "f1:t1:a1:s1:p1:i2_editable";
var customId = "f1:t1:a1:s1:p1:i3_editable";
var textfieldId = "f1:t1:a1:s1:p1:i4_editable";
var browseBtnId = "f1:t1:a1:s1:p1:i5";
var descriptorId = "f1:t1:a1:s1:p2:i1_editable:i1_editable_0";
var executableId = "f1:t1:a1:s1:p2:i1_editable:i1_editable_1";

function initAllRows() {
    var table = document.getElementById(applicationsTableId);
    table.initAllRows();
}

function disableActions() {
    var table = document.getElementById(applicationsTableId);
    var selections = table.getAllSelectedRowsCount();
    var selected = (selections > 0) ? true : false;
    document.getElementById(applicationsTableId + ":actionsTop:new").setDisabled(selected);
    document.getElementById(applicationsTableId + ":actionsTop:delete").setDisabled(!selected);
}

function disableElements() {
    var predefined = document.getElementById(predefinedId);
    var dropdown = document.getElementById(dropdownId);
    var custom = document.getElementById(customId);
    var textfield = document.getElementById(textfieldId);
    var browseBtn = document.getElementById(browseBtnId);
    var descriptor = document.getElementById(descriptorId);
    var executable = document.getElementById(executableId);
    // Note: Use setDisabled function for some components, but set disabled field directly for others...
    if (predefined.checked == true) {
        descriptor.checked = true;
        executable.checked = false;
        dropdown.disabled = false;
        textfield.disabled = true;
        browseBtn.setDisabled(true);
        descriptor.disabled = true;
        executable.disabled = true;
    } else {
        dropdown.disabled = true;
        textfield.disabled = false;
        browseBtn.setDisabled(false);
        descriptor.disabled = false;
        executable.disabled = false;
    }
    // Special case if no predefined descs available
    if (dropdown.options.length == 0) {
        dropDown_setDisabled(dropdownId, true);
        custom.checked = true;
        predefined.checked = false;
        predefined.disabled = true;
        textfield.disabled = false;
        browseBtn.setDisabled(false);
        descriptor.disabled = false;
        executable.disabled = false;
    }
}

function disableBrowseOk() {
    var okBtn = document.getElementById("f1:p1:pg1:ok");
    var file = document.getElementById("f1:p1:f1:f1_selectedField").value;
    if (file != null && file.length > 0) {
        okBtn.disabled = false;
    } else {
        okBtn.disabled = true;
    }
}

function setCustomPath(separator) {
    if (top.window.opener != null) {
        var dir = FileChooser_f1_p1_f1.getCurrentDirectory();
        var file = document.getElementById("f1:p1:f1:f1_selectedField").value;
        if (file != null && file.length > 0) {
            // if dir is the root then no need to add the file separator
            if (dir == "/") {
                top.window.opener.document.getElementById(textfieldId).value = dir + file;
            } else {
                top.window.opener.document.getElementById(textfieldId).value = dir + separator + file;
            }
        }
    }
}

function toggleOkButton() {
    var original = document.getElementById("f1:p1:hiddenKioskValues").value;
    var sessionIndex = document.getElementById("f1:p1:ps:pss:p1:i1").selectedIndex
    var session = document.getElementById("f1:p1:ps:pss:p1:i1").options[sessionIndex].value;
    var timeout = document.getElementById("f1:p1:ps:pss:p2:i2").value;
    var cpu = document.getElementById("f1:p1:ps:pss:p3:i3").value;
    var vm = document.getElementById("f1:p1:ps:pss:p4:i4").value;
    var files = document.getElementById("f1:p1:ps:pss:p5:i5").value;
    var size = document.getElementById("f1:p1:ps:pss:p6:i6").value;
    var locale = document.getElementById("f1:p1:ps:pss:p7:i7").value;
    var args = document.getElementById("f1:p1:ps:pss:p8:i8").value;
    var current = session + " " + timeout + " " + cpu + " " + vm + " " + files + " " + size + " " + locale + " " + args;
    if (current == original) {
        document.getElementById("f1:p1:_id16:ok").setDisabled(true);
    } else {
        document.getElementById("f1:p1:_id16:ok").setDisabled(false);
    }
}

//-->
