//<!--
//
// ident "$Id$ SMI"
//
// Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
// Use is subject to license terms.
//

var SUBMIT_FLAG = "_submit";
var CLEAR_FLAG = "_clear";
var EDITABLE_FLAG = "_editable";
var REQUIRED_FLAG = "_editable_required";
var CLEAR_BTNS = new Array(0);
var SUBMIT_BTNS = new Array(0);
var EDIT_FIELDS = new Array(0);
var ORIG_VALUES = new Array(0);
var REQUIRED_FIELDS = new Array(0);

function initValues() {
    SUBMIT_BTNS.length = 0;
    CLEAR_BTNS.length = 0;
    EDIT_FIELDS.length = 0;
    ORIG_VALUES.length = 0;
    REQUIRED_FIELDS.length = 0;
    var f = document.forms[0];
    var elems = f.elements;
    for (i = 0;i < elems.length; i++) {
        if (elems[i].id.indexOf(SUBMIT_FLAG) != -1 && elems[i].id.indexOf(SUBMIT_FLAG) == elems[i].id.length - SUBMIT_FLAG.length) {
            SUBMIT_BTNS.length += 1
            SUBMIT_BTNS[SUBMIT_BTNS.length-1] = document.getElementById(elems[i].id);
        } else if (elems[i].id.indexOf(CLEAR_FLAG) != -1) {
            CLEAR_BTNS.length += 1
            CLEAR_BTNS[CLEAR_BTNS.length-1] = document.getElementById(elems[i].id);
        } else if (elems[i].id.indexOf(EDITABLE_FLAG) != -1) {
            EDIT_FIELDS.length += 1
            EDIT_FIELDS[EDIT_FIELDS.length-1] = document.getElementById(elems[i].id);
            ORIG_VALUES.length += 1
            if (elems[i].id.indexOf(REQUIRED_FLAG) != -1) {
                REQUIRED_FIELDS.length += 1
                REQUIRED_FIELDS[REQUIRED_FIELDS.length-1] = document.getElementById(elems[i].id);
            }
            if (elems[i].type == "checkbox") {
                ORIG_VALUES[ORIG_VALUES.length-1] = document.getElementById(elems[i].id).checked;
            } else if (elems[i].type == "text") {
                ORIG_VALUES[ORIG_VALUES.length-1] = document.getElementById(elems[i].id).value;
            } else if (elems[i].type == "select-one") {
                ORIG_VALUES[ORIG_VALUES.length-1] = document.getElementById(elems[i].id).selectedIndex;
            } else if (elems[i].type == "radio") {
                ORIG_VALUES[ORIG_VALUES.length-1] = document.getElementById(elems[i].id).checked;
            }
        }
    }
}

function toggleEditButtons() {
    // Edit pages have original values and new values - need 
    // to check that a change has been made before enabling buttons
    var disableSubmits = false;
    // first check that all required fields have values
    for (i = 0; i < REQUIRED_FIELDS.length; i++) {
        if (REQUIRED_FIELDS[i].value == null || REQUIRED_FIELDS[i].value.length == 0) {
            disableSubmits = true;
            break;
        }
    }
    // then check that at least one value is different from the original value
    if (!disableSubmits) {
        for (i = 0; i < EDIT_FIELDS.length; i++) {
            var field = EDIT_FIELDS[i];
            var original = ORIG_VALUES[i];
            if (field.type == "checkbox") {
                if (field.checked && !original) {
                    break;
                } else if (!field.checked && original) {
                    break;
                }
            } else if (field.type == "text") {
                if (field.value != original) {
                    break;
                }
            } else if (field.type == "select-one") {
                if (field.selectedIndex != original) {
                    break;
                }
            } else if (field.type == "radio") {
                if (field.checked != original) {
                    break;
                }
            } 
            if (i == EDIT_FIELDS.length - 1) {
                disableSubmits = true;
            }
        }
    }
    for (i = 0; i < SUBMIT_BTNS.length; i++) {
        SUBMIT_BTNS[i].setDisabled(disableSubmits);
    }
}

function disableEditButtons() {
    for (i = 0; i < SUBMIT_BTNS.length; i++) {
        SUBMIT_BTNS[i].setDisabled(true);
    }    
}

function disableClearButtons() {
    for (i = 0; i < CLEAR_BTNS.length; i++) {
        CLEAR_BTNS[i].setDisabled(true);
    }   
}

function toggleNewButtons() {
    // New item pages create a new item so by definition have 
    // no original values. Just enable the submit if the 
    // required values are there
    var disableSubmits = false;
    for (i = 0; i < REQUIRED_FIELDS.length; i++) {
        if (REQUIRED_FIELDS[i].value == null || REQUIRED_FIELDS[i].value.length == 0) {
            disableSubmits = true;
            break;
        }
    }    
    for (i = 0; i < SUBMIT_BTNS.length; i++) {
        SUBMIT_BTNS[i].setDisabled(disableSubmits);
    }
}

function toggleClearButtons() {
    // Clear buttons clear all editable textfields and password
    // fields on a page
    var disableClears = false;
    for (i = 0; i < EDIT_FIELDS.length; i++) {
        var field = EDIT_FIELDS[i];
        if (field.type == "text") {
            if (field.value != null && field.value.length != 0) {
                break;
            }
        } else if (field.type == "password") {
            if (field.value != null && field.value.length != 0) {
                break;
            }
        }
        if (i == EDIT_FIELDS.length - 1) {
            disableClears = true;
        }
    }    
    for (i = 0; i < CLEAR_BTNS.length; i++) {
        CLEAR_BTNS[i].setDisabled(disableClears);
    }
}

//-->
