<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
 
   
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                </ui:head>    
                <ui:body focus="f1:p1:_id19:back"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="servers"/>
                        <ui:alert binding ="#{dtuSearchHandler.statusMessage.alert}"/>
    
                        <ui:breadcrumbs>
                            <ui:hyperlink text="#{msg.breadcrump_link_all_servers}"
                                          action="viewServers"
                                          immediate="true"
                                          toolTip="#{msg.dtu_breadcrump_all_servers_tooltip}"/>
                            <ui:hyperlink text="#{dtuSearchHandler.serverName}"
                                          action="viewServerDetails"
                                          immediate="true"
                                          toolTip="#{msg.dtu_breadcrump_server_name_tooltip}"/>
                            <ui:hyperlink text="#{msg.dtu_breadcrump_dtus_links}"
                                          toolTip="#{msg.dtu_breadcrump_dtus_tooltip}"/>
                        </ui:breadcrumbs>

                        <ui:contentPageTitle id="p1" 
                                             title="#{dtuSearchHandler.serverName} #{msg.server_dtus_pageTitle}"
                                             helpText="#{msg.server_dtus_pageHelpText}">
                            
                            <f:facet name="pageButtonsTop">
                                <ui:panelGroup> 
                                    <ui:button id="back"
                                               text="#{dtuSearchHandler.backToLabel}"
                                               action="viewServerDetails"
                                               immediate="true"
                                               toolTip="#{msg.dtu_back_to_server_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup>
                                    <ui:button id="back"
                                               text="#{dtuSearchHandler.backToLabel}" 
                                               action="viewServerDetails"
                                               immediate="true"
                                               toolTip="#{msg.dtu_back_to_server_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet>

                            <f:verbatim><br/></f:verbatim>
                            <ui:markup tag="div" styleClass="ConMgn">

                                <ui:table id="t1"
                                          title="#{dtuSearchHandler.title}" 
                                          paginateButton="true"
                                          paginationControls="true"
                                          selectMultipleButton="#{dtuSearchHandler.selectable}"
                                          selectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          deselectMultipleButton="#{dtuSearchHandler.selectable}"
                                          deselectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          clearSortButton="true"
                                          summary="#{msg.dtu_table_servers_summary}"
                                          toolTip="#{msg.dtu_table_servers_summary}">

                                    <ui:tableRowGroup sourceData="#{dtuSearchHandler.dtus}" 
                                                      rows="20"
                                                      sourceVar="dtuRowGroup"
                                                      binding="#{dtuSearchHandler.tableRowGroup}"
                                                      selected="#{dtuSearchHandler.selectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select"
                                                        visible="#{dtuSearchHandler.selectable}">
                                            <ui:checkbox id="select" 
                                                         onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                         selected="#{dtuSearchHandler.selectHelper.selected}"
                                                         selectedValue="#{dtuSearchHandler.selectHelper.selectedValue}"
                                                         toolTip="#{msg.dtu_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>

                                        <!-- Identifier column -->
                                        <ui:tableColumn headerText="#{msg.dtus_table_identifier_header}"
                                                        rowHeader="true"
                                                        sort="id"
                                                        style="width: 12%;">
                                            <ui:hyperlink text="#{dtuRowGroup.value.id}" 
                                                          action="#{dtuSearchHandler.viewProperties}"
                                                          immediate="true"
                                                          toolTip="#{msg.dtu_table_value_tooltip}">
                                                <f:param name="id" 
                                                         value="#{dtuRowGroup.value.id}"/>
                                            </ui:hyperlink>
                                        </ui:tableColumn>

                                        <!-- Location column -->
                                        <ui:tableColumn headerText="#{msg.dtus_table_location_header}" 
                                                        rowHeader="true" 
                                                        sort="location"
                                                        style="width: 25%;">
                                            <ui:staticText text="#{dtuRowGroup.value.location}"/>
                                        </ui:tableColumn>

                                        <!-- Description column -->
                                        <ui:tableColumn headerText="#{msg.dtus_table_description_header}" 
                                                        sort="description"
                                                        rowHeader="true">
                                            <ui:staticText text="#{dtuRowGroup.value.description}"/>
                                        </ui:tableColumn>
                                         
                                    </ui:tableRowGroup>
                                </ui:table>

                            </ui:markup>
                        </ui:contentPageTitle> 
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 
