<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:meta httpEquiv="REFRESH" content="4" rendered="#{serverList.restartInProgress}"/>
                    <ui:script url="../../js/Servers.js"/>
                </ui:head>    
                <ui:body> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="servers"/>
                        <ui:alert id="restartAlert"
                                  type="warning"
                                  summary="#{notification.summary}"
                                  detail="#{notification.alertDetails}"
                                  rendered="#{notification.visible}"/>
                        <ui:alert binding ="#{serverList.statusMessage.alert}"/>
        
                        <ui:contentPageTitle id="p1" 
                                             title="#{msg.servers_pageTitle}">

                            <ui:markup tag="div" styleClass="TtlHlpDiv">
                                <ui:helpInline id="h1" type="page"
                                               text="#{msg.servers_signature_pageHelpText}">
                                    <ui:helpWindow windowTitle="#{msg.helpWindow_title}" 
                                                   pageTitle="#{msg.helpWindow_pageTitle}"
                                                   mastheadImageUrl="/images/productName.png"
                                                   mastheadImageHeight="40"
                                                   mastheadImageWidth="204"   
                                                   helpFile="servers.html"
                                                   toolTip="#{msg.helpWindow_link_tooltip}"
                                                   linkIcon="true" linkText="#{msg.servers_help_link}" />
                                </ui:helpInline>
                            </ui:markup>   
                            
                            <f:verbatim><br/></f:verbatim>
                            <ui:markup tag="div" styleClass="ConMgn">

                                <ui:table id="t1" 
                                          title="#{msg.servers_table_title}" 
                                          paginateButton="false"
                                          paginationControls="false"
                                          selectMultipleButton="true"
                                          deselectMultipleButton="true"
                                          selectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          deselectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          clearSortButton="true"
                                          summary="#{msg.servers_table_summary}"
                                          toolTip="#{msg.servers_table_summary}">

                                    <ui:tableRowGroup sourceData="#{serverList.serverList}" 
                                                      sourceVar="server"
                                                      binding="#{serverList.tableRowGroup}"
                                                      selected="#{serverList.selectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select">
                                            <ui:checkbox id="select"
                                                         selected="#{serverList.selectHelper.selected}"
                                                         selectedValue="#{serverList.selectHelper.selectedValue}"
                                                         visible="#{server.value.restartStatus == null}"
                                                         onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                         toolTip="#{msg.server_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>

                                        <!-- Server name column -->
                                        <ui:tableColumn headerText="#{msg.servers_table_name_header}" 
                                                        rowHeader="true"
                                                        sort="name">
                                            <ui:hyperlink text="#{server.value.name}" 
                                                          action="#{serverList.viewProperties}"
                                                          immediate="true"
                                                          toolTip="#{msg.server_table_value_tooltip}">
                                                <f:param name="id" 
                                                         value="#{server.value.name}"/>
                                            </ui:hyperlink>
                                        </ui:tableColumn>

                                        <!-- IP address column -->
                                        <ui:tableColumn headerText="#{msg.servers_table_IP_header}" 
                                                        rowHeader="true"
                                                        sort="primaryAddress">
                                            <ui:staticText text="#{server.value.primaryAddress}"/>
                                        </ui:tableColumn>

                                        <!-- Mode column -->
                                        <ui:tableColumn headerText="#{msg.servers_table_mode_header}" 
                                                        rowHeader="true"
                                                        sort="offline">
                                            <ui:image icon="ALERT_OK_SMALL"
                                                      rendered="#{!server.value.offline}"
                                                      alt="#{msg.server_ok_image_alt}" 
                                                      toolTip="#{msg.server_ok_image_alt}" />
                                            <ui:image icon="ALARM_DOWN_MEDIUM"
                                                      rendered="#{server.value.offline}"
                                                      alt="#{msg.server_down_image_alt}" 
                                                      toolTip="#{msg.server_down_image_alt}" />
                                            <ui:staticText text="&#160;" escape="false"/>
                                            <ui:staticText text="#{msg.server_online_mode}"
                                                           rendered="#{!server.value.offline}"/>
                                            <ui:staticText text="#{msg.server_offline_mode}"
                                                           rendered="#{server.value.offline}"/>               
                                        </ui:tableColumn>

                                        <!-- LAN connection column -->
                                        <ui:tableColumn headerText="#{msg.servers_table_LAN_header}" 
                                                        rowHeader="true"
                                                        sort="enabledLAN">
                                            <ui:staticText text="#{msg.server_LAN_enabled}" 
                                                           rendered="#{server.value.enabledLAN}"/>
                                            <ui:staticText text="#{msg.server_LAN_disabled}" 
                                                           rendered="#{!server.value.enabledLAN}"/>               
                                        </ui:tableColumn>

                                        <!-- Start time column -->
                                        <ui:tableColumn headerText="#{msg.servers_table_start_header}" 
                                                        rowHeader="true"
                                                        sort="startTime">
                                            <ui:staticText text="#{server.value.startTime}"
                                                           rendered="#{(server.value.restartStatus != 'restarting') and (server.value.restartStatus != 'restart_done')}"/>
                                            <ui:panelGroup rendered="#{(server.value.restartStatus == 'restarting') or (server.value.restartStatus == 'restart_done')}">               
                                                <ui:image id="progressBar" 
                                                          url="/images/barberpole.gif" 
                                                          alt="#{msg.server_restart_in_progress_image}" 
                                                          width="192"
                                                          height="16"
                                                          toolTip="#{msg.server_restart_in_progress_image}" />
                                            </ui:panelGroup>
                                        </ui:tableColumn>

                                    </ui:tableRowGroup>

                                    <!-- Action buttons -->
                                    <f:facet name="actionsTop">
                                        <f:subview id="actionsTop">
                                            <ui:button id="warmRestart"
                                                       action="#{serverList.warmRestart}"
                                                       text="#{msg.servers_table_warm_restart_button}"
                                                       onClick="#{serverList.warmRestartOnClick}"
                                                       disabled="true"
                                                       toolTip="#{msg.server_warm_restart_tooltip}"
                                                       alt="#{msg.server_warm_restart_alt}"/>
                                            <ui:button id="coldRestart"
                                                       action="#{serverList.coldRestart}"
                                                       text="#{msg.servers_table_cold_restart_button}"                                       
                                                       onClick="#{serverList.coldRestartOnClick}"
                                                       disabled="true"
                                                       toolTip="#{msg.server_cold_restart_tooltip}"
                                                       alt="#{msg.server_cold_restart_alt}"/>
                                        </f:subview>
                                    </f:facet>

                                </ui:table>

                            </ui:markup>
                        </ui:contentPageTitle>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 
