<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}" />
                    <ui:script url="../../js/Util.js"/>
                    <ui:script url="../../js/Token.js"/>
                </ui:head>    
                <ui:body focus="f1:t1:a1:s1:p2:i2_editable_required"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="tokens"/>
                        <ui:alert binding ="#{newTokenHandler.statusMessage.alert}"/>
        
                        <ui:contentPageTitle id="t1" title="#{msg.tokens_new_title} #{tokenHandler.selectedToken.id}"
                                             helpText="#{msg.tokens_new_title_help}">

                            <ui:propertySheet id="a1" jumpLinks="false">
                                <ui:propertySheetSection id="s1">
                                    <ui:property id="p2"
                                                 labelAlign="right">
                                        <f:facet name="label">
                                            <ui:label id="l1" 
                                                  requiredIndicator="true"  
                                                  text="#{msg.tokens_identifier_label}"
                                                  for="p2"/>
                                         </f:facet>
                                         <ui:markup tag="table">
                                             <ui:markup tag="tr">
                                                 <ui:markup tag="td">
                                                     <ui:radioButton id="rb0" 
                                                            disabled="false"
                                                            name="idFromGrp" 
                                                            selected="#{newTokenHandler.isReadFromReader}" 
                                                            label="#{msg.tokens_from_reader}" 
                                                            onClick="toggleAddTokenButtons(); toggleReaderItems();" />
                                                 </ui:markup>
                                                 <ui:markup tag="td">
                                                     <ui:dropDown id="i1"
                                                                  selected="#{newTokenHandler.tokenReader}" 
                                                                  items="#{newTokenHandler.availableTokenReaders}"
                                                                  styleClass="HlpFldTxt"
                                                                  toolTip="#{msg.tokens_available_readers_tooltip}"/>
                                                     <ui:button id="b1"
                                                                text="#{msg.tokens_read_button}" 
                                                                action="#{newTokenHandler.getToken}"
                                                                mini="true"
                                                                immediate="true"
                                                                disabled="#{!newTokenHandler.tokenReaders}"
                                                                toolTip="#{msg.tokens_read_button_tooltip}"
                                                                alt="#{msg.tokens_read_button_alt}"/>
                                                 </ui:markup>
                                             </ui:markup>
                                             <ui:markup tag="tr">
                                                 <ui:markup tag="td">
                                                     <ui:radioButton id="rb1" 
                                                            name="idFromGrp" 
                                                            label="#{msg.tokens_from_manual}" 
                                                            onClick="toggleAddTokenButtons(); toggleReaderItems();" /> 
                                                 </ui:markup>
                                                 <ui:markup tag="td">
                                                     <ui:textField id="i2_editable_required"
                                                                   text="#{newTokenHandler.tokenId}"
                                                                   columns="50"
                                                                   onKeyUp="javascript: setTimeout('toggleAddTokenButtons()', 0);"
                                                                   onChange="javascript: setTimeout('toggleAddTokenButtons()', 0);"
                                                                   toolTip="#{msg.tokens_identifier_tooltip}"/>
                                                 </ui:markup>
                                             </ui:markup>
                                         </ui:markup>
                                    </ui:property>
                                </ui:propertySheetSection>
                            </ui:propertySheet>
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup id="pg1"> 
                                    <ui:button id="ok_submit"
                                               text="#{msg.ok_button}"
                                               primary="true"
                                               disabled="true"
                                               action="#{newTokenHandler.addToken}"
                                               toolTip="#{msg.tokens_new_ok_tooltip}"
                                               alt="#{msg.ok_button_alt}"/>
                                    <ui:button id="cancel"
                                               text="#{msg.cancel_button}"
                                               action="viewTokenDetails"
                                               immediate="true"
                                               toolTip="#{msg.tokens_new_cancel_tooltip}"
                                               alt="#{msg.cancel_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                        </ui:contentPageTitle>
                        <ui:script>
                            <f:verbatim>
                                toggleAddTokenButtons();
                                toggleReaderItems();
                            </f:verbatim>
                        </ui:script>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 

