/*
 * Decompiled with CFR 0.152.
 */
package auth.protocol;

import auth.protocol.RegisterKeys;
import auth.sdk.Log;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ClientCommand {
    public static final int TOKEN_EVENT = 0;
    public static final int INFO_SMARTCARD = 1;
    public static final int KEY_RESPONSE = 2;
    public static final int CONNECT_RESPONSE = 3;
    public static final int DISCONNECT_REQUEST = 4;
    public static final int DISCONNECT_RESPONSE = 5;
    public static final int KEEPALIVE_REQUEST = 6;
    public static final int KEEPALIVE_RESPONSE = 7;
    public static final int CONTROL_RESPONSE = 8;
    public static final int PROTOCOL_ERROR = 9;
    public static final int INVALID = -1;
    public static final String IEEE802_NAMESPACE = "IEEE802";
    public static final int IEEE802_ID_LENGTH = 12;
    public static final String KEYED_NAMESPACE = "MD5";
    public static final int KEYED_ID_LENGTH = 32;
    public static final String PSEUDO_TOKEN = "pseudo";
    public static final String BOOTVER_PREFIX = ",Boot:";
    private static final String[] INSERT_CAUSE_VALUES = new String[]{"insert", "redirect"};
    private static final String[] DISC_CAUSE_VALUES = new String[]{"redirect", "keepAliveExpiry", "bye", "disc", "mtu", "authFailed"};
    private static final String[] EVENT_VALUES = new String[]{"insert", "remove"};
    private static final String[] STATE_VALUES = new String[]{"connected", "disconnected"};
    private static final String[] ACCESS_VALUES = new String[]{"allowed", "denied"};
    private static final String[] BOOL_VALUES = new String[]{"true", "false"};
    private static final String[] NUM_1_VALUES = new String[]{"1"};
    private static final String[] NUM_01_VALUES = new String[]{"0", "1"};
    private static final String[] NAMESPACE_VALUES = new String[]{"IEEE802", "MD5"};
    private static final String[] OLD_NAMESPACE_VALUES = new String[]{"IEEE802"};
    private static final String FWVER_PATTERN = "[a-zA-Z0-9][-_.,+:a-zA-Z0-9=]{0,63}";
    private static final String BOOTVER_PATTERN = "(?:,Boot:[a-zA-Z0-9][-_.+:a-zA-Z0-9 ;()]{0,63})?";
    private static final Pattern MODEL_MATCH = Pattern.compile("[a-zA-Z][-,_a-zA-Z0-9]*");
    private static final Pattern TYPE_MATCH = Pattern.compile("[a-zA-Z][-_a-zA-Z0-9]*");
    private static final Pattern ID_MATCH = Pattern.compile("[a-zA-Z0-9][-_a-zA-Z0-9]*");
    private static final Pattern FW_MATCH = Pattern.compile("[a-zA-Z0-9][-_.,+:a-zA-Z0-9=]{0,63}(?:,Boot:[a-zA-Z0-9][-_.+:a-zA-Z0-9 ;()]{0,63})?");
    private static final Pattern SW_MATCH = Pattern.compile("[a-zA-Z0-9][-_.,+:/a-zA-Z0-9]*");
    private static final String HEXSTR_PATTERN = "(?:\\p{XDigit}\\p{XDigit})*";
    private static final Pattern HEX_IP_MATCH = Pattern.compile("(?:\\p{XDigit}\\p{XDigit})*(?:-(?:\\p{XDigit}\\p{XDigit})*)?");
    private static final int MAX_TYPE_LEN = 32;
    private static final int MAX_MODEL_LEN = 32;
    private static final int MAX_TOKEN_LEN = 64;
    private static final int MAX_VERSION_LEN = 64;
    private static final int MAX_BOOTVER_LEN = 64 + ",Boot:".length();
    private static final int MAX_HEX_IP_LEN = 32;
    private static final String CORONA_NAME = "corona";
    private static final String SUNRAY_NAME = "SunRay";
    private String command;
    private int type;
    private Hashtable params;
    private String fullMessage;
    private static final Pattern LOWERCASE_HEX_STRING = Pattern.compile("[0-9a-z]*");
    private static final String UPPERCASE_HEX_STRING = "[0-9A-Z]*";

    public static int classifyCommand(String name) {
        if (name.equals("keepAliveReq")) {
            return 6;
        }
        if (name.equals("keepAliveRsp")) {
            return 7;
        }
        if (name.equals("infoReq") || name.equals("sessionReq")) {
            return 0;
        }
        if (name.equals("infoSmartCard")) {
            return 1;
        }
        if (name.equals("keyRsp")) {
            return 2;
        }
        if (name.equals("connRsp")) {
            return 3;
        }
        if (name.equals("discRsp")) {
            return 5;
        }
        if (name.equals("discReq")) {
            return 4;
        }
        if (name.equals("controlRsp")) {
            return 8;
        }
        if (name.equals("protocolErrorReq")) {
            return 9;
        }
        return -1;
    }

    public ClientCommand(String name, Hashtable rawParam) {
        this(name, rawParam, true);
    }

    public ClientCommand(String name, Hashtable rawParam, boolean validate) {
        this.command = name;
        this.type = ClientCommand.classifyCommand(name);
        if (validate) {
            this.validateParams(rawParam);
        } else {
            this.params = rawParam;
            if (this.params == null) {
                this.type = -1;
            }
        }
    }

    public void setFullMessage(String message) {
        this.fullMessage = message;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean is(int type) {
        return this.type == type;
    }

    public int getCommandType() {
        return this.type;
    }

    public Hashtable getParams() {
        return this.params;
    }

    public Hashtable mergeParams(Hashtable rawParams) {
        if (rawParams != null) {
            Hashtable result = (Hashtable)rawParams.clone();
            result.putAll(this.params);
            return result;
        }
        return (Hashtable)this.params.clone();
    }

    public void setParam(String key, String value) {
        this.params.put(key, value);
    }

    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    public String getParam(String key) {
        return (String)this.params.get(key);
    }

    public boolean isValid() {
        return this.type != -1;
    }

    public boolean isLegacyClient() {
        return IEEE802_NAMESPACE.equals(this.getParam("namespace"));
    }

    public void setRawTokenFromToken() {
        this.setParam("rawType", this.getParam("type"));
        this.setParam("rawId", this.getParam("id"));
    }

    public String getRawTokenId() {
        String type = this.getParam("rawType");
        if (type == null) {
            type = "unknown";
        } else if (!TYPE_MATCH.matcher(type).matches()) {
            type = "invalid";
        }
        String id = this.getParam("rawId");
        if (id == null) {
            id = "unknown";
        } else if (!ID_MATCH.matcher(id).matches()) {
            id = "invalid";
        }
        String token = type + "." + id;
        if (token.length() > 64) {
            token = "invalid.length";
        }
        return token;
    }

    public boolean isConsistentWith(ClientCommand older) {
        if (!this.isValid()) {
            return false;
        }
        if (older == null) {
            switch (this.type) {
                case 0: 
                case 4: 
                case 6: 
                case 9: {
                    return true;
                }
                case 5: 
                case 7: {
                    return true;
                }
                case 1: 
                case 2: 
                case 3: 
                case 8: {
                    return false;
                }
            }
            return false;
        }
        return this.isConsistent("namespace", this.params, older.params) && this.isConsistent("sn", this.params, older.params) && this.isConsistent("hw", this.params, older.params) && this.isConsistent("sw", this.params, older.params) && this.isConsistent("fw", this.params, older.params) && this.isValueConsistent("pn", this.params, older.params) && this.isValueConsistent("clientDH", this.params, older.params);
    }

    public String toString() {
        return this.command + " " + this.params;
    }

    private boolean validateParams(Hashtable rawParam) {
        if (rawParam == null) {
            this.type = -1;
            this.params = null;
            return false;
        }
        boolean shouldLogIgnored = true;
        try {
            switch (this.type) {
                case 0: {
                    this.params = this.validateTokenEventParams(rawParam, this.command.equals("infoReq"));
                    break;
                }
                case 1: {
                    this.params = this.validateInfoSmartCardParams(rawParam);
                    shouldLogIgnored = false;
                    break;
                }
                case 2: {
                    this.params = this.validateKeyRspParams(rawParam);
                    break;
                }
                case 3: {
                    this.params = this.validateConnRspParams(rawParam);
                    break;
                }
                case 4: {
                    this.params = this.validateDiscReqParams(rawParam);
                    break;
                }
                case 5: {
                    this.params = this.validateDiscRspParams(rawParam);
                    break;
                }
                case 6: {
                    this.params = this.validateKeepAliveReqParams(rawParam);
                    break;
                }
                case 7: {
                    this.params = this.validateKeepAliveRspParams(rawParam);
                    break;
                }
                case 8: {
                    this.params = this.validateControlRspParams(rawParam);
                    shouldLogIgnored = false;
                    break;
                }
                case 9: {
                    this.params = this.validateProtocolErrorParams(rawParam);
                    break;
                }
                default: {
                    this.params = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.unexpectedError((String)("Invalid params for '" + this.command + "': " + e));
            this.params = null;
        }
        if (this.params == null) {
            this.type = -1;
            return false;
        }
        if (shouldLogIgnored) {
            this.logIgnored(this.params, rawParam);
        }
        return true;
    }

    private boolean isConsistent(String key, Hashtable newer, Hashtable older) {
        if (!newer.containsKey(key)) {
            return true;
        }
        if (older.containsKey(key) && newer.get(key).equals(older.get(key))) {
            return true;
        }
        Log.notice((String)("Inconsistent value for " + key + " in " + this.command + ": Found=" + newer.get(key) + ", Expected=" + older.get(key)));
        return false;
    }

    private boolean isValueConsistent(String key, Hashtable newer, Hashtable older) {
        if (!newer.containsKey(key)) {
            return true;
        }
        if (!older.containsKey(key) || newer.get(key).equals(older.get(key))) {
            return true;
        }
        Log.notice((String)("Inconsistent value for " + key + " in " + this.command + ": Found=" + newer.get(key) + ", Expected=" + older.get(key)));
        return false;
    }

    private void logIgnored(Hashtable param, Hashtable rawParam) {
        Enumeration e = rawParam.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (param.containsKey(key) || key.equals("pn")) continue;
            Log.debug((String)("Ignoring unknown/unnecessary parameter '" + key + "' for " + this.command));
        }
    }

    private Hashtable validateTokenEventParams(Hashtable rawParam, boolean isOldReq) throws Exception {
        Hashtable param = this.validateBasicParams(rawParam, isOldReq);
        ClientCommand.checkRequiredValue(param, rawParam, "event", EVENT_VALUES);
        ClientCommand.checkRequiredValue(param, rawParam, "type", TYPE_MATCH, 32);
        ClientCommand.checkExpectedValue(param, rawParam, "id", ID_MATCH, 64);
        ClientCommand.getExpectedValue(param, rawParam, "state", STATE_VALUES);
        ClientCommand.checkTokenMatch(param, "type", "id");
        boolean isInserting = ((String)param.get("event")).equals("insert");
        if (isInserting) {
            ClientCommand.getExpectedValue(param, rawParam, "tokenSeq");
            ClientCommand.getExpectedValue(param, rawParam, "startRes");
            ClientCommand.getValue(param, rawParam, "initState", NUM_01_VALUES);
            ClientCommand.getValue(param, rawParam, "firstServer", HEX_IP_MATCH, 32);
            ClientCommand.getValue(param, rawParam, "ddcconfig");
            ClientCommand.getValue(param, rawParam, "barrierLevel");
            ClientCommand.getValue(param, rawParam, "MTU");
            ClientCommand.getValue(param, rawParam, "realIP");
            ClientCommand.getValue(param, rawParam, "clientRand");
            ClientCommand.getValue(param, rawParam, "keyTypes");
            ClientCommand.getValue(param, rawParam, "atr");
            ClientCommand.getValue(param, rawParam, "atr.hs");
            ClientCommand.getValue(param, rawParam, "atr.hist_len");
            boolean isRedirect = false;
            ClientCommand.checkRequiredValue(param, rawParam, "cause", INSERT_CAUSE_VALUES);
            isRedirect = ((String)param.get("cause")).equals("redirect");
            if (ClientCommand.getValue(param, rawParam, "forceInsert", BOOL_VALUES) && ((String)param.get("forceInsert")).equals("true")) {
                isRedirect = true;
            }
            if (isRedirect) {
                ClientCommand.getExpectedValue(param, rawParam, "realType", TYPE_MATCH, 32);
                ClientCommand.getExpectedValue(param, rawParam, "realId", ID_MATCH, 64);
                ClientCommand.addRedirectProps(param, rawParam, "redirectProps");
                ClientCommand.getValue(param, rawParam, "roamInitiated", BOOL_VALUES);
                ClientCommand.checkTokenMatch(param, "realType", "realId");
            }
            if (!param.containsKey("hw")) {
                throw new Exception("Connecting client does not specify Model ('hw')");
            }
            if (!param.containsKey("fw") && !param.containsKey("sw")) {
                throw new Exception("Connecting client does not specify firmware or software version ('hw')");
            }
        }
        return param;
    }

    private Hashtable validateInfoSmartCardParams(Hashtable rawParam) throws Exception {
        Hashtable param = this.validateBasicParams(rawParam);
        ClientCommand.getValue(param, rawParam, "tag");
        return param;
    }

    private Hashtable validateKeyRspParams(Hashtable rawParam) throws Exception {
        Hashtable param = this.validateBasicParams(rawParam);
        ClientCommand.getRequiredValue(param, rawParam, "clientKey");
        ClientCommand.getRequiredValue(param, rawParam, "keyType");
        ClientCommand.getRequiredValue(param, rawParam, "clientSignature");
        ClientCommand.getExpectedValue(param, rawParam, "tokenSeq");
        ClientCommand.getValue(param, rawParam, "clientDH");
        ClientCommand.getValue(param, rawParam, "pn");
        return param;
    }

    private Hashtable validateConnRspParams(Hashtable rawParam) throws Exception {
        Hashtable param = this.validateBasicParams(rawParam);
        ClientCommand.checkRequiredValue(param, rawParam, "access", ACCESS_VALUES);
        ClientCommand.checkRequiredValue(param, rawParam, "state", STATE_VALUES);
        ClientCommand.getExpectedValue(param, rawParam, "pn");
        ClientCommand.getExpectedValue(param, rawParam, "dmXid");
        if (!param.containsKey("pn")) {
            Log.clientError((String)"Rendering port number 'pn' missing in connRsp message");
        }
        ClientCommand.getValue(param, rawParam, "tokenSeq");
        ClientCommand.getValue(param, rawParam, "clientDH");
        ClientCommand.getValue(param, rawParam, "keyType");
        ClientCommand.getValue(param, rawParam, "clientSignature");
        return param;
    }

    private Hashtable validateDiscReqParams(Hashtable rawParam) throws Exception {
        Hashtable param = this.validateBasicParams(rawParam);
        ClientCommand.getExpectedValue(param, rawParam, "cause", DISC_CAUSE_VALUES);
        ClientCommand.getExpectedValue(param, rawParam, "state", STATE_VALUES);
        ClientCommand.getExpectedValue(param, rawParam, "type");
        return param;
    }

    private Hashtable validateDiscRspParams(Hashtable rawParam) throws Exception {
        Hashtable param = this.validateBasicParams(rawParam);
        ClientCommand.getExpectedValue(param, rawParam, "state", STATE_VALUES);
        return param;
    }

    private Hashtable validateKeepAliveReqParams(Hashtable rawParam) throws Exception {
        Hashtable param = this.validateBasicParams(rawParam);
        ClientCommand.getExpectedValue(param, rawParam, "state", STATE_VALUES);
        ClientCommand.getValue(param, rawParam, "byteCount");
        ClientCommand.getValue(param, rawParam, "connTime");
        ClientCommand.getValue(param, rawParam, "idleTime");
        ClientCommand.getValue(param, rawParam, "lossCount");
        ClientCommand.getValue(param, rawParam, "pktCount");
        ClientCommand.getValue(param, rawParam, "latency");
        return param;
    }

    private Hashtable validateKeepAliveRspParams(Hashtable rawParam) throws Exception {
        Hashtable param = this.validateBasicParams(rawParam);
        return param;
    }

    private Hashtable validateControlRspParams(Hashtable rawParam) throws Exception {
        Hashtable param = this.validateBasicParams(rawParam);
        ClientCommand.getValue(param, rawParam, "tag");
        ClientCommand.getValue(param, rawParam, "error");
        return param;
    }

    private Hashtable validateProtocolErrorParams(Hashtable rawParam) throws Exception {
        Hashtable param = this.validateBasicParams(rawParam);
        ClientCommand.getExpectedValue(param, rawParam, "cause");
        return param;
    }

    private Hashtable validateBasicParams(Hashtable rawParam) throws Exception {
        return this.validateBasicParams(rawParam, false);
    }

    private Hashtable validateBasicParams(Hashtable rawParam, boolean isOldReq) throws Exception {
        String keyValue;
        int indx;
        Hashtable<String, String> param = new Hashtable<String, String>();
        ClientCommand.checkValue(param, rawParam, "_", NUM_1_VALUES);
        String[] knownNamespaces = isOldReq ? OLD_NAMESPACE_VALUES : NAMESPACE_VALUES;
        ClientCommand.checkValueWithDefault(param, rawParam, "namespace", knownNamespaces, IEEE802_NAMESPACE);
        ClientCommand.getRequiredValue(param, rawParam, "sn");
        ClientCommand.checkClientId(param, "namespace", "sn");
        if (ClientCommand.getExpectedValue(param, rawParam, "hw", MODEL_MATCH, 32) && (indx = (keyValue = (String)param.get("hw")).toLowerCase().indexOf(CORONA_NAME)) != -1) {
            String newValue = keyValue.substring(0, indx) + SUNRAY_NAME + keyValue.substring(indx + CORONA_NAME.length(), keyValue.length());
            Log.debug((String)"Sanitizing hw parameter: Corona->SunRay");
            param.put("hw", newValue);
        }
        ClientCommand.getValue(param, rawParam, "fw", FW_MATCH, 64 + MAX_BOOTVER_LEN);
        if (!isOldReq) {
            ClientCommand.getValue(param, rawParam, "sw", SW_MATCH, 64);
        }
        return param;
    }

    public static void checkClientId(Hashtable param, String nsKey, String snKey) throws Exception {
        String namespace = (String)param.get(nsKey);
        String sn = (String)param.get(snKey);
        boolean length_ok = false;
        switch (sn.length()) {
            case 12: {
                length_ok = namespace.equals(IEEE802_NAMESPACE);
                break;
            }
            case 32: {
                length_ok = namespace.equals(KEYED_NAMESPACE);
                break;
            }
        }
        if (!length_ok) {
            throw new Exception("Unexpected length of " + namespace + " client id: '" + sn + "' ");
        }
        if (!LOWERCASE_HEX_STRING.matcher(sn).matches()) {
            if (namespace.equals(IEEE802_NAMESPACE) && sn.matches(UPPERCASE_HEX_STRING)) {
                Log.clientError((String)"MAC address ('sn') submitted in upper case.Trying autoconverted value.");
                param.put(snKey, sn.toLowerCase(Locale.US));
                param.put("raw_sn", sn);
            } else {
                throw new Exception("Illegal characters in " + namespace + " client id: '" + sn + "' ");
            }
        }
    }

    private static void checkTokenMatch(Hashtable param, String typeName, String idName) throws Exception {
        Object sn;
        if (!param.containsKey(typeName)) {
            if (param.containsKey(idName)) {
                throw new Exception("Message contains " + idName + ", but no " + typeName);
            }
            return;
        }
        String type = (String)param.get(typeName);
        String id = (String)param.get(idName);
        int tokenlen = type.length() + 1 + (id != null ? id.length() : 0);
        if (tokenlen > 64) {
            throw new Exception("Total token <type>.<id> too long.");
        }
        if (PSEUDO_TOKEN.equals(type) && !(sn = param.get("sn")).equals(id)) {
            if (id.equals(param.get("raw_sn"))) {
                Log.debug((String)("Fixing up " + idName + " value to match sn. " + "[" + id + "] -> [" + sn + "]"));
                param.put(idName, sn);
            } else {
                throw new Exception("Parameter " + idName + " [" + id + "]" + " for " + typeName + "=" + PSEUDO_TOKEN + " does not match terminal ID" + " [" + sn + "]");
            }
        }
    }

    private static void checkRequiredValue(Hashtable outParam, Hashtable inParam, String key, String[] allowedValues) throws Exception {
        if (!ClientCommand.checkValue(outParam, inParam, key, allowedValues)) {
            throw new Exception("Missing required parameter '" + key + "'");
        }
    }

    private static void checkRequiredValue(Hashtable outParam, Hashtable inParam, String key, Pattern allowedFormat, int allowedLength) throws Exception {
        if (!ClientCommand.checkValue(outParam, inParam, key, allowedFormat, allowedLength)) {
            throw new Exception("Missing required parameter '" + key + "'");
        }
    }

    private static boolean checkValueWithDefault(Hashtable outParam, Hashtable inParam, String key, String[] allowedValues, String defaultValue) throws Exception {
        if (!ClientCommand.checkValue(outParam, inParam, key, allowedValues)) {
            Log.debug((String)("ClientCommand: Missing value for " + key + " -> substituting default: " + defaultValue));
            outParam.put(key, defaultValue);
            return false;
        }
        return true;
    }

    private static boolean checkExpectedValue(Hashtable outParam, Hashtable inParam, String key, String[] allowedValues) throws Exception {
        if (!ClientCommand.checkValue(outParam, inParam, key, allowedValues)) {
            Log.debug((String)("Expected parameter '" + key + "' is missing"));
            return false;
        }
        return true;
    }

    private static boolean checkExpectedValue(Hashtable outParam, Hashtable inParam, String key, Pattern allowedFormat, int allowedLength) throws Exception {
        if (!ClientCommand.checkValue(outParam, inParam, key, allowedFormat, allowedLength)) {
            Log.debug((String)("Expected parameter '" + key + "' is missing"));
            return false;
        }
        return true;
    }

    private static boolean checkValue(Hashtable outParam, Hashtable inParam, String key, String[] allowedValues) throws Exception {
        String value = (String)inParam.get(key);
        if (value == null) {
            return false;
        }
        if (!ClientCommand.isValidValue(value, allowedValues)) {
            throw new Exception("Unexpected value '" + value + "' for '" + key + "'");
        }
        outParam.put(key, value);
        return true;
    }

    private static boolean checkValue(Hashtable outParam, Hashtable inParam, String key, Pattern allowedFormat, int allowedLength) throws Exception {
        String value = (String)inParam.get(key);
        if (value == null) {
            return false;
        }
        if (!ClientCommand.isValidValue(value, allowedFormat, allowedLength)) {
            throw new Exception("Illegal value '" + value + "' for '" + key + "'");
        }
        outParam.put(key, value);
        return true;
    }

    private static void getRequiredValue(Hashtable outParam, Hashtable inParam, String key) throws Exception {
        if (!ClientCommand.getValue(outParam, inParam, key)) {
            throw new Exception("Missing required parameter '" + key + "'");
        }
    }

    private static boolean getExpectedValue(Hashtable outParam, Hashtable inParam, String key, String[] allowedValues) {
        if (!ClientCommand.getValue(outParam, inParam, key, allowedValues)) {
            Log.debug((String)("Expected parameter '" + key + "' is missing"));
            return false;
        }
        return true;
    }

    private static boolean getExpectedValue(Hashtable outParam, Hashtable inParam, String key, Pattern allowedFormat, int allowedLength) {
        if (!ClientCommand.getValue(outParam, inParam, key, allowedFormat, allowedLength)) {
            Log.debug((String)("Expected parameter '" + key + "' is missing"));
            return false;
        }
        return true;
    }

    private static boolean getExpectedValue(Hashtable outParam, Hashtable inParam, String key) {
        if (!ClientCommand.getValue(outParam, inParam, key)) {
            Log.debug((String)("Expected parameter '" + key + "' is missing"));
            return false;
        }
        return true;
    }

    private static boolean getValue(Hashtable outParam, Hashtable inParam, String key, String[] allowedValues) {
        String value = (String)inParam.get(key);
        if (value == null) {
            return false;
        }
        if (!ClientCommand.isValidValue(value, allowedValues)) {
            Log.clientError((String)("Unexpected value '" + value + "' for '" + key + "'" + " - ignored."));
            return false;
        }
        outParam.put(key, value);
        return true;
    }

    private static boolean getValue(Hashtable outParam, Hashtable inParam, String key, Pattern allowedFormat, int allowedLength) {
        String value = (String)inParam.get(key);
        if (value == null) {
            return false;
        }
        if (!ClientCommand.isValidValue(value, allowedFormat, allowedLength)) {
            Log.clientError((String)("Unexpected value '" + value + "' for '" + key + "'" + " - ignored."));
            return false;
        }
        outParam.put(key, value);
        return true;
    }

    private static boolean getValue(Hashtable outParam, Hashtable inParam, String key) {
        Object value = inParam.get(key);
        if (value == null) {
            return false;
        }
        outParam.put(key, value);
        return true;
    }

    private static boolean isValidValue(String value, String[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (!allowedValues[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidValue(String value, Pattern allowedFormat, int allowedLength) {
        if (value.length() > allowedLength) {
            return false;
        }
        return allowedFormat.matcher(value).matches();
    }

    private static void addSafeRedirectPropValue(Hashtable param, String key, String value) {
        if (key.equals(RegisterKeys.usernameKey) || key.equals(RegisterKeys.subCauseKey) || key.equals(RegisterKeys.doAmghKey) || key.equals(RegisterKeys.quickloginKey) || key.equals(RegisterKeys.tokenSetKey)) {
            if (param.containsKey(key)) {
                Log.clientError((String)("Duplicate redirect key " + key + " - ignoring."));
                return;
            }
            param.put(key, value);
        } else if (key.equals(RegisterKeys.authKey)) {
            Log.debug((String)("Ignoring obsolete redirect key '" + key + "=" + value + "'."));
        } else {
            Log.debug((String)("Ignoring unknown redirect key '" + key + "=" + value + "'."));
        }
    }

    private static void addRedirectProps(Hashtable param, Hashtable rawParam, String redirKey) {
        String set = (String)rawParam.get(redirKey);
        if (set == null) {
            Log.debug((String)("ClientCommand: No indirect properties (" + redirKey + ") specified for redirect."));
            return;
        }
        StringTokenizer st = new StringTokenizer(set, " ");
        while (st.hasMoreTokens()) {
            String value;
            String key;
            String keyValue = st.nextToken();
            int index = keyValue.indexOf("=");
            if (index < 0) {
                key = keyValue;
                value = "true";
            } else {
                if (index == 0) {
                    Log.clientError((String)("ClientCommand: invalid parameter '" + keyValue + "' in " + redirKey));
                    return;
                }
                key = keyValue.substring(0, index);
                value = keyValue.substring(index + 1);
            }
            ClientCommand.addSafeRedirectPropValue(param, key, value);
        }
        param.put(redirKey, "*");
    }
}

