/*
 * Decompiled with CFR 0.152.
 */
package auth.module.ServerSelect;

import auth.sdk.AccessControl;
import auth.sdk.Authentication;
import auth.sdk.AuthenticationClient;
import auth.sdk.Log;
import java.util.Hashtable;

public final class ServerSelectClient
implements AuthenticationClient {
    private AccessControl access;
    private String myTokenType = null;
    private String myTokenId = null;
    private String localName;
    private String globalName;
    private Authentication module;

    ServerSelectClient(AccessControl access, Authentication module, String name) {
        this.access = access;
        this.module = module;
        this.localName = name;
        this.globalName = access.mapModuleToGlobalName(this.localName);
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String name) {
        this.localName = name;
        this.globalName = this.access.mapModuleToGlobalName(this.localName);
    }

    public String getGlobalName() {
        return this.globalName;
    }

    public String getModuleName() {
        return this.module.getName();
    }

    public String getSessionManagerId() {
        return this.access.getDefaultSessionHost() + ":" + this.access.getDefaultSessionPort();
    }

    public String getServiceInitCommand() {
        return null;
    }

    public boolean connReq(Hashtable param) {
        return true;
    }

    public boolean message(String command, Hashtable param) {
        return false;
    }

    public void close() {
        Log.notice((String)"ServerSelectClient.close");
    }
}

