/*
 * Decompiled with CFR 0.152.
 */
package auth.module.StartSession;

import auth.module.StartSession.StartSessionClient;
import auth.sdk.AccessControl;
import auth.sdk.Authentication;
import auth.sdk.AuthenticationClient;
import auth.sdk.Log;
import auth.sdk.ParseOptions;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class StartSession
implements Authentication {
    protected String instanceName;
    protected Hashtable policy = new Hashtable();
    protected String sessionType = null;
    protected String sessionOptions = null;
    protected static String version = "@(#) StartSession.java 1.16@(#)";
    protected static final String RAW_TOKEN = "raw";
    protected static final String CURRENT_TOKEN = "current";
    protected static final String PROPERTY_DEFAULT = StartSession.propertyTag("default");
    protected static final String PROPERTY_NULL = StartSession.propertyTag("");
    protected String whichInsertToken = "current";
    protected String whichRedirectToken = "current";
    protected String tokenType = null;
    protected String property = null;
    protected String hotdeskHandlingOpt = null;
    protected boolean disconnectOnLock = false;

    public static Authentication getAuthenticationObject(String instanceName, String opt) {
        StartSession za = new StartSession(instanceName, opt);
        return za;
    }

    public StartSession() {
        this.instanceName = "--BOGUS--";
        Log.unexpectedError((String)"AuthmoduleOK BOGUS constructor called");
    }

    protected static void usage(String message) {
        Log.configError((String)message);
        Log.configError((String)"usage: [-a acceptTokenType[,type,...]] [-r rejectTokenType[,type,...]] [-s sessionType] [-A onlyPropval[,propval]] [-R rejectPropval[,propval]] [-N] [-p] [-{t|T} whichtoken] [-o tokenType] [-c property] [-h {accept|reject}] [-d]");
        System.exit(1);
    }

    private static String propertyTag(String propval) {
        return "PROP@" + propval;
    }

    public StartSession(String instanceName, String arg) {
        this.instanceName = instanceName;
        boolean specifiedAccept = false;
        boolean specifiedPropertyAccept = false;
        boolean specifiedPropertyReject = false;
        boolean rejectNullProperty = false;
        ParseOptions options = new ParseOptions(arg, "a:r:s:A:R:Npt:T:o:c:h:d");
        Enumeration e = options.keys();
        block15: while (e.hasMoreElements()) {
            Character flag = (Character)e.nextElement();
            Object value = options.getValue(flag);
            switch (flag.charValue()) {
                case 'a': {
                    String type;
                    specifiedAccept = true;
                    StringTokenizer st = new StringTokenizer((String)value, ",");
                    while (st.hasMoreTokens()) {
                        type = st.nextToken();
                        this.policy.put(type, "accept");
                        Log.debug((String)(instanceName + " policy " + type + "=accept"));
                    }
                    continue block15;
                }
                case 'r': {
                    String type;
                    StringTokenizer st = new StringTokenizer((String)value, ",");
                    while (st.hasMoreTokens()) {
                        type = st.nextToken();
                        this.policy.put(type, "reject");
                    }
                    continue block15;
                }
                case 'A': {
                    String tag;
                    specifiedPropertyAccept = true;
                    StringTokenizer st = new StringTokenizer((String)value, ",");
                    while (st.hasMoreTokens()) {
                        tag = StartSession.propertyTag(st.nextToken());
                        this.policy.put(tag, "accept");
                        Log.debug((String)(instanceName + " policy " + tag + "=accept"));
                    }
                    continue block15;
                }
                case 'R': {
                    String tag;
                    specifiedPropertyReject = true;
                    StringTokenizer st = new StringTokenizer((String)value, ",");
                    while (st.hasMoreTokens()) {
                        tag = StartSession.propertyTag(st.nextToken());
                        this.policy.put(tag, "reject");
                        Log.debug((String)(instanceName + " policy " + tag + "=reject"));
                    }
                    continue block15;
                }
                case 'N': {
                    rejectNullProperty = true;
                    continue block15;
                }
                case 's': {
                    this.sessionType = (String)value;
                    continue block15;
                }
                case 'p': {
                    this.sessionOptions = "-p";
                    continue block15;
                }
                case 't': {
                    this.whichInsertToken = (String)value;
                    continue block15;
                }
                case 'T': {
                    this.whichRedirectToken = (String)value;
                    continue block15;
                }
                case 'o': {
                    this.tokenType = (String)value;
                    continue block15;
                }
                case 'c': {
                    this.property = (String)value;
                    continue block15;
                }
                case 'h': {
                    this.hotdeskHandlingOpt = (String)value;
                    continue block15;
                }
                case 'd': {
                    this.disconnectOnLock = true;
                    continue block15;
                }
            }
            StartSession.usage(instanceName + ": invalid option: '" + flag.charValue() + "'");
        }
        if (!this.policy.containsKey("default")) {
            Log.debug((String)(instanceName + " !policy.containsKey(\"default\") is true"));
            if (specifiedAccept) {
                this.policy.put("default", "reject");
            } else {
                this.policy.put("default", "accept");
            }
        }
        if (this.property != null) {
            if (!this.policy.containsKey(PROPERTY_DEFAULT)) {
                Log.debug((String)(instanceName + " !policy.containsKey(\"" + PROPERTY_DEFAULT + "\") is true"));
                if (specifiedPropertyAccept) {
                    this.policy.put(PROPERTY_DEFAULT, "reject");
                } else {
                    this.policy.put(PROPERTY_DEFAULT, "accept");
                }
            }
            if (!this.policy.containsKey(PROPERTY_NULL)) {
                if (rejectNullProperty) {
                    this.policy.put(PROPERTY_NULL, "reject");
                } else {
                    this.policy.put(PROPERTY_NULL, "accept");
                }
            } else {
                Log.debug((String)(instanceName + " policy.containsKey(\"" + PROPERTY_NULL + "\") is true"));
            }
        } else if (specifiedPropertyAccept || specifiedPropertyReject || rejectNullProperty) {
            StartSession.usage("The -A, -R and -N options must be used with '-c <property>'");
        }
        Log.debug((String)(instanceName + " policy=" + this.policy));
    }

    public String getName() {
        return new String(this.instanceName);
    }

    public String getVersion() {
        if (version.equals("%A%")) {
            version = "Development";
        }
        return version;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ActionToken isMyTokenTypeByToken(Hashtable attrib) {
        String id;
        String event = (String)attrib.get("event");
        if (event == null || !event.equals("insert")) {
            return new ActionToken("reject");
        }
        String type = (String)attrib.get("type");
        if (type == null) {
            type = "noType";
        }
        if ((id = (String)attrib.get("id")) == null) {
            id = "noId";
        }
        String rawType = (String)attrib.get("rawType");
        String rawId = (String)attrib.get("rawId");
        String cause = (String)attrib.get("cause");
        if (cause == null) {
            cause = "nocause";
        }
        Log.debug((String)("isMyTokenTypeByToken: type=" + type + ", id=" + id));
        if (this.property != null) {
            String propval = (String)attrib.get(this.property);
            Log.debug((String)("isMyTokenTypeByToken: Property " + this.property + "=" + (propval != null ? propval : "(null)")));
            String propertyPolicy = null;
            if (propval != null) {
                propertyPolicy = (String)this.policy.get(StartSession.propertyTag(propval));
                if (propertyPolicy == null) {
                    propertyPolicy = (String)this.policy.get(PROPERTY_DEFAULT);
                }
            } else {
                propertyPolicy = (String)this.policy.get(PROPERTY_NULL);
            }
            if (propertyPolicy != null && !propertyPolicy.equals("accept")) {
                Log.debug((String)("isMyTokenTypeByToken: rejecting for property value " + this.property + "=" + (propval != null ? propval : "(null)")));
                return new ActionToken("reject");
            }
        }
        String action = null;
        if (cause.equals("redirect")) {
            if (this.whichRedirectToken.equals(RAW_TOKEN)) {
                action = (String)this.policy.get(rawType);
            } else {
                if (!this.whichRedirectToken.equals(CURRENT_TOKEN)) {
                    Log.notice((String)("isMyTokenTypeByToken: Invalid token type specified: " + this.whichRedirectToken));
                    return new ActionToken("reject");
                }
                action = (String)this.policy.get(type);
            }
        } else if (this.whichInsertToken.equals(RAW_TOKEN)) {
            action = (String)this.policy.get(rawType);
        } else {
            if (!this.whichInsertToken.equals(CURRENT_TOKEN)) {
                Log.notice((String)("isMyTokenTypeByToken: Invalid token type specified: " + this.whichInsertToken));
                return new ActionToken("reject");
            }
            action = (String)this.policy.get(type);
        }
        if (action == null) {
            action = (String)this.policy.get("default");
        }
        if (action == null || !action.equals("accept")) {
            action = "reject";
        }
        Log.debug((String)("isMyTokenTypeByToken: action after normalization: " + (action == null ? "<NULL>" : action)));
        return new ActionToken(action, type, id, rawType, rawId);
    }

    protected String fixupMondexId(String type, String id) {
        if (type.equals("mondex") && id.startsWith("0x")) {
            Long mid = new Long(Long.parseLong(id.substring(2), 16));
            id = mid.toString();
        }
        return id;
    }

    public AuthenticationClient isMyTokenType(Hashtable attrib, AccessControl access) {
        StartSessionClient client;
        Log.debug((String)"StartSession:In isMyTokenType");
        ActionToken aid = this.isMyTokenTypeByToken(attrib);
        if (aid.action.equals("reject")) {
            return null;
        }
        String id = this.fixupMondexId(aid.type, aid.id);
        if (this.disconnectOnLock) {
            attrib.put("lockaction", "disconnect");
        }
        if ((client = new StartSessionClient(access, this, aid.rawType + "." + aid.rawId, aid.type + "." + id, this.sessionType, this.sessionOptions)) == null) {
            return null;
        }
        return client;
    }

    protected class ActionToken {
        public String action = null;
        public String type = null;
        public String id = null;
        public String rawType = null;
        public String rawId = null;

        ActionToken(String action) {
            this.action = action;
        }

        ActionToken(String action, String type, String id, String rawType, String rawId) {
            this.action = action;
            this.type = type;
            this.id = id;
            this.rawType = rawType;
            this.rawId = rawId;
        }
    }
}

