/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.utauthd.GroupManager;
import auth.utauthd.SmartCardID;
import auth.utauthd.SmartCardWordException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;

public class SmartCardWordsImpl {
    private static final String SCCS_ID = "@(#)SmartCardWordsImpl.java\t1.27 09/08/04 SMI";
    private SmartCardID scid;
    private Stack configStack;
    private String bTRUE = "true";
    private String bFALSE = "false";
    private Properties configProps;
    private Hashtable clist = null;
    private int tagLength;
    private boolean useTagLength;
    private String bigLengthFlag;
    private int bigLengthSize;
    private boolean bigLengthEndian;
    private String tBuffer = null;
    private int tBufferPos;
    private boolean tBufferValid = false;
    private int vBufferOffset;
    private String useTagLengthFlag = "useTag";
    private String useBigEndianFlag = "bigEndian";
    private String useLittleEndianFlag = "littleEndian";
    private boolean debugMessage = false;
    private Stack executeControl;
    static final char CMD_prefixchar = '\u00ff';
    private static final int IDX_nocode = 0;
    private static final String CMD_setprop = "setprop";
    private static final int IDX_setprop = 10;
    private static final String CMD_getprop = "getprop";
    private static final int IDX_getprop = 11;
    private static final String CMD_add = "+";
    private static final int IDX_add = 22;
    private static final String CMD_subtract = "-";
    private static final int IDX_subtract = 23;
    private static final String CMD_equals = "=";
    private static final int IDX_equals = 30;
    private static final String CMD_hexequals = "hexequals";
    private static final int IDX_hexequals = 130;
    private static final String CMD_lessThan = "<";
    private static final int IDX_lessThan = 31;
    private static final String CMD_lessThanOrEqual = "<=";
    private static final int IDX_lessThanOrEqual = 32;
    private static final String CMD_greaterThan = ">";
    private static final int IDX_greaterThan = 33;
    private static final String CMD_greaterThanOrEqual = ">=";
    private static final int IDX_greaterThanOrEqual = 34;
    private static final String CMD_multiply = "*";
    private static final int IDX_multiply = 35;
    private static final String CMD_divide = "/";
    private static final int IDX_divide = 36;
    private static final String CMD_length = "length";
    private static final int IDX_length = 40;
    private static final String CMD_hexlength = "hexlength";
    private static final int IDX_hexlength = 140;
    private static final String CMD_chop = "chop";
    private static final int IDX_chop = 41;
    private static final String CMD_hexchop = "hexchop";
    private static final int IDX_hexchop = 141;
    private static final String CMD_toUpper = "toUpper";
    private static final int IDX_toUpper = 42;
    private static final String CMD_toLower = "toLower";
    private static final int IDX_toLower = 142;
    private static final String CMD_toASCII = "toASCII";
    private static final int IDX_toASCII = 242;
    private static final String CMD_toHEX = "toHEX";
    private static final int IDX_toHEX = 342;
    private static final String CMD_findString = "findString";
    private static final int IDX_findString = 442;
    private static final String CMD_padLeft = "padLeft";
    private static final int IDX_padLeft = 542;
    private static final String CMD_hexpadLeft = "hexpadLeft";
    private static final int IDX_hexpadLeft = 642;
    private static final String CMD_padRight = "padRight";
    private static final int IDX_padRight = 742;
    private static final String CMD_hexpadRight = "hexpadRight";
    private static final int IDX_hexpadRight = 842;
    private static final String CMD_dup = "dup";
    private static final int IDX_dup = 43;
    private static final String CMD_drop = "drop";
    private static final int IDX_drop = 44;
    private static final String CMD_not = "!";
    private static final int IDX_not = 45;
    private static final String CMD_concat = "concat";
    private static final int IDX_concat = 46;
    private static final String CMD_swap = "swap";
    private static final int IDX_swap = 47;
    private static final String CMD_clearstack = "clearstack";
    private static final int IDX_clearstack = 48;
    private static final String CMD_sendAPDU = "sendAPDU";
    private static final int IDX_sendAPDU = 50;
    private static final String CMD_exchangeAPDU = "exchangeAPDU";
    private static final int IDX_exchangeAPDU = 51;
    private static final String CMD_exchangeAPDUwHash = "exchangeAPDUwithHash";
    private static final int IDX_exchangeAPDUwHash = 52;
    private static final String CMD_cardProto = "cardProto";
    private static final int IDX_cardProto = 53;
    private static final String CMD_sendPTS = "sendPTS";
    private static final int IDX_sendPTS = 54;
    private static final String CMD_cardBaud = "cardBaud";
    private static final int IDX_cardBaud = 58;
    private static final String CMD_shiftBytesRIGHT = "shiftBytesRIGHT";
    private static final int IDX_shiftBytesRIGHT = 60;
    private static final String CMD_shiftBytesLEFT = "shiftBytesLEFT";
    private static final int IDX_shiftBytesLEFT = 61;
    private static final String CMD_shiftBitsRIGHT = "shiftBitsRIGHT";
    private static final int IDX_shiftBitsRIGHT = 62;
    private static final String CMD_shiftBitsLEFT = "shiftBitsLEFT";
    private static final int IDX_shiftBitsLEFT = 63;
    private static final String CMD_maskAND = "&";
    private static final int IDX_maskAND = 64;
    private static final String CMD_maskOR = "|";
    private static final int IDX_maskOR = 65;
    private static final String CMD_complement = "~";
    private static final int IDX_complement = 66;
    private static final String CMD_andNot = "&~";
    private static final int IDX_andNot = 67;
    private static final String CMD_xor = "^";
    private static final int IDX_xor = 68;
    private static final String CMD_setBit = "setBit";
    private static final int IDX_setBit = 69;
    private static final String CMD_clearBit = "clearBit";
    private static final int IDX_clearBit = 70;
    private static final String CMD_flipBit = "flipBit";
    private static final int IDX_flipBit = 71;
    private static final String CMD_testBit = "testBit";
    private static final int IDX_testBit = 72;
    private static final String CMD_msg = "msg";
    private static final int IDX_msg = 80;
    private static final String CMD_msgDebug = "msgDebug";
    private static final int IDX_msgDebug = 81;
    private static final String CMD_msgLog = "msgLog";
    private static final int IDX_msgLog = 82;
    private static final String CMD_showstack = "showstack";
    private static final int IDX_showstack = 83;
    private static final String CMD_jmp = "jmp";
    private static final int IDX_jmp = 90;
    private static final String CMD_jmpIfTrue = "jmpIfTrue";
    private static final int IDX_jmpIfTrue = 91;
    private static final String CMD_jmpIfFalse = "jmpIfFalse";
    private static final int IDX_jmpIfFalse = 92;
    private static final String CMD_returnID = "returnID";
    private static final int IDX_returnID = 93;
    private static final String CMD_return = "return";
    private static final int IDX_return = 94;
    private static final String CMD_onException = "onException";
    private static final int IDX_onException = 95;
    private static final String CMD_cardReset = "cardReset";
    private static final int IDX_cardReset = 100;
    private static final String CMD_hasSession = "hasSession";
    private static final int IDX_hasSession = 101;
    private static final String CMD_isWord = "isWord";
    private static final int IDX_isWord = 102;
    private static final String CMD_needWords = "needWords";
    private static final int IDX_needWords = 103;
    private static final String CMD_setupTbufferParser = "setupTbufferParser";
    private static final int IDX_setupTbufferParser = 104;
    private static final String CMD_parseTbuffer = "parseTbuffer";
    private static final int IDX_parseTbuffer = 204;
    static final int Next_Word = 0;
    static final int Send_APDU = 10;
    static final int Xchange_APDU = 11;
    static final int Card_Proto = 12;
    static final int Send_PTS = 13;
    static final int Card_Baud = 17;
    static final int ID_Available = 20;
    static final int No_ID = 21;
    static final int Display_Message = 30;
    static final int Log_Message = 31;
    static final int Debug_Set = 32;
    static final int Jump = 40;
    static final int Set_Exception_Handler = 50;
    static final int Card_Reset = 100;

    public SmartCardWordsImpl(SmartCardID smartCardID) {
        this.scid = smartCardID;
        this.executeControl = new Stack();
        this.configStack = new Stack();
        this.configProps = new Properties();
    }

    public SmartCardWordsImpl(Hashtable hashtable) {
        SmartCardWordsImpl.populateCmdList(hashtable);
    }

    private static void populateCmdList(Hashtable hashtable) {
        hashtable.put(CMD_setprop, '\u00ff' + Integer.toString(10));
        hashtable.put(CMD_getprop, '\u00ff' + Integer.toString(11));
        hashtable.put(CMD_add, '\u00ff' + Integer.toString(22));
        hashtable.put(CMD_subtract, '\u00ff' + Integer.toString(23));
        hashtable.put(CMD_equals, '\u00ff' + Integer.toString(30));
        hashtable.put(CMD_hexequals, '\u00ff' + Integer.toString(130));
        hashtable.put(CMD_lessThan, '\u00ff' + Integer.toString(31));
        hashtable.put(CMD_lessThanOrEqual, '\u00ff' + Integer.toString(32));
        hashtable.put(CMD_greaterThan, '\u00ff' + Integer.toString(33));
        hashtable.put(CMD_greaterThanOrEqual, '\u00ff' + Integer.toString(34));
        hashtable.put(CMD_multiply, '\u00ff' + Integer.toString(35));
        hashtable.put(CMD_divide, '\u00ff' + Integer.toString(36));
        hashtable.put(CMD_length, '\u00ff' + Integer.toString(40));
        hashtable.put(CMD_hexlength, '\u00ff' + Integer.toString(140));
        hashtable.put(CMD_chop, '\u00ff' + Integer.toString(41));
        hashtable.put(CMD_hexchop, '\u00ff' + Integer.toString(141));
        hashtable.put(CMD_toUpper, '\u00ff' + Integer.toString(42));
        hashtable.put(CMD_toLower, '\u00ff' + Integer.toString(142));
        hashtable.put(CMD_toASCII, '\u00ff' + Integer.toString(242));
        hashtable.put(CMD_toHEX, '\u00ff' + Integer.toString(342));
        hashtable.put(CMD_findString, '\u00ff' + Integer.toString(442));
        hashtable.put(CMD_padLeft, '\u00ff' + Integer.toString(542));
        hashtable.put(CMD_hexpadLeft, '\u00ff' + Integer.toString(642));
        hashtable.put(CMD_padRight, '\u00ff' + Integer.toString(742));
        hashtable.put(CMD_hexpadRight, '\u00ff' + Integer.toString(842));
        hashtable.put(CMD_dup, '\u00ff' + Integer.toString(43));
        hashtable.put(CMD_drop, '\u00ff' + Integer.toString(44));
        hashtable.put(CMD_not, '\u00ff' + Integer.toString(45));
        hashtable.put(CMD_concat, '\u00ff' + Integer.toString(46));
        hashtable.put(CMD_swap, '\u00ff' + Integer.toString(47));
        hashtable.put(CMD_clearstack, '\u00ff' + Integer.toString(48));
        hashtable.put(CMD_sendAPDU, '\u00ff' + Integer.toString(50));
        hashtable.put(CMD_exchangeAPDU, '\u00ff' + Integer.toString(51));
        hashtable.put(CMD_exchangeAPDUwHash, '\u00ff' + Integer.toString(52));
        hashtable.put(CMD_cardProto, '\u00ff' + Integer.toString(53));
        hashtable.put(CMD_sendPTS, '\u00ff' + Integer.toString(54));
        hashtable.put(CMD_cardBaud, '\u00ff' + Integer.toString(58));
        hashtable.put(CMD_shiftBytesRIGHT, '\u00ff' + Integer.toString(60));
        hashtable.put(CMD_shiftBytesLEFT, '\u00ff' + Integer.toString(61));
        hashtable.put(CMD_shiftBitsRIGHT, '\u00ff' + Integer.toString(62));
        hashtable.put(CMD_shiftBitsLEFT, '\u00ff' + Integer.toString(63));
        hashtable.put(CMD_maskAND, '\u00ff' + Integer.toString(64));
        hashtable.put(CMD_maskOR, '\u00ff' + Integer.toString(65));
        hashtable.put(CMD_complement, '\u00ff' + Integer.toString(66));
        hashtable.put(CMD_andNot, '\u00ff' + Integer.toString(67));
        hashtable.put(CMD_xor, '\u00ff' + Integer.toString(68));
        hashtable.put(CMD_setBit, '\u00ff' + Integer.toString(69));
        hashtable.put(CMD_clearBit, '\u00ff' + Integer.toString(70));
        hashtable.put(CMD_flipBit, '\u00ff' + Integer.toString(71));
        hashtable.put(CMD_testBit, '\u00ff' + Integer.toString(72));
        hashtable.put(CMD_msg, '\u00ff' + Integer.toString(80));
        hashtable.put(CMD_msgDebug, '\u00ff' + Integer.toString(81));
        hashtable.put(CMD_msgLog, '\u00ff' + Integer.toString(82));
        hashtable.put(CMD_showstack, '\u00ff' + Integer.toString(83));
        hashtable.put(CMD_jmp, '\u00ff' + Integer.toString(90));
        hashtable.put(CMD_jmpIfTrue, '\u00ff' + Integer.toString(91));
        hashtable.put(CMD_jmpIfFalse, '\u00ff' + Integer.toString(92));
        hashtable.put(CMD_returnID, '\u00ff' + Integer.toString(93));
        hashtable.put(CMD_return, '\u00ff' + Integer.toString(94));
        hashtable.put(CMD_onException, '\u00ff' + Integer.toString(95));
        hashtable.put(CMD_cardReset, '\u00ff' + Integer.toString(100));
        hashtable.put(CMD_hasSession, '\u00ff' + Integer.toString(101));
        hashtable.put(CMD_isWord, '\u00ff' + Integer.toString(102));
        hashtable.put(CMD_needWords, '\u00ff' + Integer.toString(103));
        hashtable.put(CMD_setupTbufferParser, '\u00ff' + Integer.toString(104));
        hashtable.put(CMD_parseTbuffer, '\u00ff' + Integer.toString(204));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int wordImpl(String var1_1, Hashtable var2_2) throws EmptyStackException, NumberFormatException, SmartCardWordException {
        block143: {
            var3_3 = 0;
            if (var1_1.length() > 0 && var1_1.charAt(0) == '\u00ff') {
                var3_3 = Integer.parseInt(var1_1.substring(1));
            }
            var4_4 = 0;
            block4 : switch (var3_3) {
                case 0: {
                    this.configStack.push(var1_1);
                    return var4_4;
                }
                case 10: {
                    var5_5 = (String)this.configStack.pop();
                    var6_28 = (String)this.configStack.pop();
                    if (var5_5.startsWith("atr.")) {
                        throw new SmartCardWordException("ATR property [" + var5_5 + "] is READ ONLY");
                    }
                }
                if (var5_5.startsWith("dtu.")) {
                    var7_49 = var5_5.substring(var5_5.indexOf("dtu.") + "dtu.".length());
                    if (var7_49.length() < 1) {
                        throw new SmartCardWordException("Missing DTU property name");
                    }
                    var2_2.put(var7_49, var6_28);
                    return var4_4;
                }
                this.configProps.setProperty(var5_5, var6_28);
                if (var5_5.equals("debug.msg") == false) return var4_4;
                if (this.checkBoolean(var6_28)) {
                    this.debugMessage = true;
                    return var4_4;
                }
                this.debugMessage = false;
                return var4_4;
                case 11: {
                    var5_6 = (String)this.configStack.pop();
                    if (!var5_6.startsWith("atr.")) ** GOTO lbl42
                    var6_29 = this.scid.ATRprops.getProperty(var5_6);
                    if (var6_29 == null) {
                        throw new SmartCardWordException("ATR property [" + var5_6 + "] not found");
                    }
                    ** GOTO lbl55
                }
lbl42:
                // 1 sources

                if (var5_6.startsWith("dtu.")) {
                    var7_50 = var5_6.substring(var5_6.indexOf("dtu.") + "dtu.".length());
                    if (var7_50.length() < 1) {
                        throw new SmartCardWordException("Missing DTU property name");
                    }
                    var6_29 = (String)var2_2.get(var7_50);
                    if (var6_29 == null) {
                        throw new SmartCardWordException("Property [" + var5_6 + "] not found");
                    }
                } else {
                    var6_29 = this.configProps.getProperty(var5_6);
                    if (var6_29 == null) {
                        throw new SmartCardWordException("Property [" + var5_6 + "] not found");
                    }
                }
lbl55:
                // 4 sources

                this.configStack.push(var6_29);
                return var4_4;
                case 64: {
                    var5_7 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_30 = new BigInteger((String)this.configStack.pop(), 16);
                    var7_51 = var6_30.and(var5_7);
                    this.pushHex(var7_51.toString(16));
                    return var4_4;
                }
                case 65: {
                    var5_8 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_31 = new BigInteger((String)this.configStack.pop(), 16);
                    var7_52 = var6_31.or(var5_8);
                    this.pushHex(var7_52.toString(16));
                    return var4_4;
                }
                case 66: {
                    var5_9 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_32 = var5_9.not();
                    this.pushHex(var6_32.toString(16));
                    return var4_4;
                }
                case 67: {
                    var5_10 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_33 = new BigInteger((String)this.configStack.pop(), 16);
                    var7_53 = var6_33.andNot(var5_10);
                    this.pushHex(var7_53.toString(16));
                    return var4_4;
                }
                case 68: {
                    var5_11 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_34 = new BigInteger((String)this.configStack.pop(), 16);
                    var7_54 = var6_34.xor(var5_11);
                    this.pushHex(var7_54.toString(16));
                    return var4_4;
                }
                case 69: {
                    var5_12 = Integer.parseInt((String)this.configStack.pop(), 16);
                    if (var5_12 < 0) {
                        throw new SmartCardWordException("negative bit number");
                    }
                    var6_35 = new BigInteger((String)this.configStack.pop(), 16);
                    var7_55 = var6_35.setBit(var5_12);
                    this.pushHex(var7_55.toString(16));
                    return var4_4;
                }
                case 70: {
                    var5_13 = Integer.parseInt((String)this.configStack.pop(), 16);
                    if (var5_13 < 0) {
                        throw new SmartCardWordException("negative bit number");
                    }
                    var6_36 = new BigInteger((String)this.configStack.pop(), 16);
                    var7_56 = var6_36.clearBit(var5_13);
                    this.pushHex(var7_56.toString(16));
                    return var4_4;
                }
                case 71: {
                    var5_14 = Integer.parseInt((String)this.configStack.pop(), 16);
                    if (var5_14 < 0) {
                        throw new SmartCardWordException("negative bit number");
                    }
                    var6_37 = new BigInteger((String)this.configStack.pop(), 16);
                    var7_57 = var6_37.flipBit(var5_14);
                    this.pushHex(var7_57.toString(16));
                    return var4_4;
                }
                case 72: {
                    var5_15 = Integer.parseInt((String)this.configStack.pop(), 16);
                    if (var5_15 < 0) {
                        throw new SmartCardWordException("negative bit number");
                    }
                    var6_38 = new BigInteger((String)this.configStack.pop(), 16);
                    if (var6_38.testBit(var5_15)) {
                        this.configStack.push(this.bTRUE);
                        return var4_4;
                    }
                    this.configStack.push(this.bFALSE);
                    return var4_4;
                }
                case 22: {
                    var5_16 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_39 = new BigInteger((String)this.configStack.pop(), 16);
                    var7_58 = var6_39.add(var5_16);
                    this.pushHex(var7_58.toString(16));
                    return var4_4;
                }
                case 23: {
                    var5_17 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_40 = new BigInteger((String)this.configStack.pop(), 16);
                    var7_59 = var6_40.subtract(var5_17);
                    this.pushHex(var7_59.toString(16));
                    return var4_4;
                }
                case 30: {
                    if (((String)this.configStack.pop()).equalsIgnoreCase((String)this.configStack.pop())) {
                        this.configStack.push(this.bTRUE);
                        return var4_4;
                    }
                    this.configStack.push(this.bFALSE);
                    return var4_4;
                }
                case 130: {
                    var5_18 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_41 = new BigInteger((String)this.configStack.pop(), 16);
                    if (var6_41.equals(var5_18)) {
                        this.configStack.push(this.bTRUE);
                        return var4_4;
                    }
                    this.configStack.push(this.bFALSE);
                    return var4_4;
                }
                case 31: {
                    var5_19 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_42 = new BigInteger((String)this.configStack.pop(), 16);
                    if (var6_42.compareTo(var5_19) < 0) {
                        this.configStack.push(this.bTRUE);
                        return var4_4;
                    }
                    this.configStack.push(this.bFALSE);
                    return var4_4;
                }
                case 32: {
                    var5_20 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_43 = new BigInteger((String)this.configStack.pop(), 16);
                    if (var6_43.compareTo(var5_20) <= 0) {
                        this.configStack.push(this.bTRUE);
                        return var4_4;
                    }
                    this.configStack.push(this.bFALSE);
                    return var4_4;
                }
                case 33: {
                    var5_21 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_44 = new BigInteger((String)this.configStack.pop(), 16);
                    if (var6_44.compareTo(var5_21) > 0) {
                        this.configStack.push(this.bTRUE);
                        return var4_4;
                    }
                    this.configStack.push(this.bFALSE);
                    return var4_4;
                }
                case 34: {
                    var5_22 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_45 = new BigInteger((String)this.configStack.pop(), 16);
                    if (var6_45.compareTo(var5_22) >= 0) {
                        this.configStack.push(this.bTRUE);
                        return var4_4;
                    }
                    this.configStack.push(this.bFALSE);
                    return var4_4;
                }
                case 35: {
                    var5_23 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_46 = new BigInteger((String)this.configStack.pop(), 16);
                    var7_60 = var6_46.multiply(var5_23);
                    this.pushHex(var7_60.toString(16));
                    return var4_4;
                }
                case 36: {
                    var5_24 = new BigInteger((String)this.configStack.pop(), 16);
                    var6_47 = new BigInteger((String)this.configStack.pop(), 16);
                    try {
                        var7_61 = var6_47.divideAndRemainder(var5_24);
                        this.pushHex(var7_61[1].toString(16));
                        this.pushHex(var7_61[0].toString(16));
                        return var4_4;
                    }
                    catch (ArithmeticException var7_62) {
                        throw new NumberFormatException("divide by zero");
                    }
                }
                case 40: {
                    this.pushHex(Integer.toString(((String)this.configStack.pop()).length(), 16));
                    return var4_4;
                }
                case 140: {
                    var5_25 = ((String)this.configStack.pop()).length();
                    if ((var5_25 & 1) == 1) {
                        ++var5_25;
                    }
                    this.pushHex(Integer.toString(var5_25 /= 2, 16));
                    return var4_4;
                }
                case 50: {
                    var2_2.remove("_WI_Xchange_APDU.rlen");
                    var2_2.put("_WI_Xchange_APDU.APDU", (String)this.configStack.pop());
                    return 10;
                }
                case 51: {
                    var5_26 = Integer.parseInt((String)this.configStack.pop(), 16);
                    if (var5_26 > 255) {
                        throw new SmartCardWordException("length out of range: " + var5_26);
                    }
                }
                var2_2.put("_WI_Xchange_APDU.rlen", Integer.toString(var5_26, 16));
                var2_2.put("_WI_Xchange_APDU.APDU", (String)this.configStack.pop());
                var2_2.remove("_WI_Xchange_APDU.bitmask");
                return 11;
                case 52: {
                    var2_2.put("_WI_Xchange_APDU.bitmask", (String)this.configStack.pop());
                    var5_27 = Integer.parseInt((String)this.configStack.pop(), 16);
                    if (var5_27 > 255) {
                        throw new SmartCardWordException("length out of range: " + var5_27);
                    }
                }
                var2_2.put("_WI_Xchange_APDU.rlen", Integer.toString(var5_27, 16));
                var2_2.put("_WI_Xchange_APDU.APDU", (String)this.configStack.pop());
                return 11;
                case 53: {
                    var2_2.remove("_WI_cardProtocol");
                    var2_2.put("_WI_cardProtocol", (String)this.configStack.pop());
                    return 12;
                }
                case 54: {
                    var2_2.remove("_WI_cardPTS");
                    var2_2.put("_WI_cardPTS", (String)this.configStack.pop());
                    return 13;
                }
                case 58: {
                    var2_2.remove("_WI_cardBaud.ctl");
                    var2_2.remove("_WI_cardBaud.baud");
                    var6_48 = ((String)this.configStack.pop()).toLowerCase();
                    if (var6_48.equals("set")) {
                        var7_63 = Integer.parseInt((String)this.configStack.pop(), 10);
                        var6_48 = "on";
                        var2_2.put("_WI_cardBaud.ctl", var6_48);
                        var2_2.put("_WI_cardBaud.baud", Integer.toString(var7_63, 10));
                        return 17;
                    } else if (var6_48.equals("default")) {
                        var6_48 = "off";
                        var2_2.put("_WI_cardBaud.ctl", var6_48);
                        return 17;
                    } else if (var6_48.equals("auto")) {
                        var6_48 = "auto";
                        var2_2.put("_WI_cardBaud.ctl", var6_48);
                        return 17;
                    } else {
                        if (var6_48.equals("get") == false) throw new SmartCardWordException("Invalid control word for cardBaud: " + var6_48);
                        var6_48 = "get";
                        var2_2.put("_WI_cardBaud.ctl", var6_48);
                    }
                    return 17;
                }
                case 60: {
                    var7_64 = Integer.parseInt((String)this.configStack.pop(), 16);
                    var8_81 = new BigInteger((String)this.configStack.pop(), 16);
                    this.pushHex(var8_81.shiftRight(var7_64 * 8).toString(16));
                    return var4_4;
                }
                case 61: {
                    var7_65 = Integer.parseInt((String)this.configStack.pop(), 16);
                    var8_82 = new BigInteger((String)this.configStack.pop(), 16);
                    this.pushHex(var8_82.shiftLeft(var7_65 * 8).toString(16));
                    return var4_4;
                }
                case 62: {
                    var7_66 = Integer.parseInt((String)this.configStack.pop(), 16);
                    var8_83 = new BigInteger((String)this.configStack.pop(), 16);
                    this.pushHex(var8_83.shiftRight(var7_66).toString(16));
                    return var4_4;
                }
                case 63: {
                    var7_67 = Integer.parseInt((String)this.configStack.pop(), 16);
                    var8_84 = new BigInteger((String)this.configStack.pop(), 16);
                    this.pushHex(var8_84.shiftLeft(var7_67).toString(16));
                    return var4_4;
                }
                case 41: 
                case 141: {
                    var7_68 = Integer.parseInt((String)this.configStack.pop(), 16);
                    var8_85 = Integer.parseInt((String)this.configStack.pop(), 16);
                    var9_95 = (String)this.configStack.pop();
                    if (var3_3 == 141) {
                        var7_68 *= 2;
                        var8_85 *= 2;
                    }
                    if (var8_85 >= var9_95.length()) throw new SmartCardWordException("length or offset out of range");
                    if (var8_85 + var7_68 > var9_95.length()) {
                        throw new SmartCardWordException("length or offset out of range");
                    }
                    var10_102 = var9_95.substring(var8_85, var8_85 + var7_68);
                    if (var3_3 == 141) {
                        this.pushHex(var10_102);
                        return var4_4;
                    }
                    this.configStack.push(var10_102);
                    return var4_4;
                }
                case 42: {
                    this.configStack.push(((String)this.configStack.pop()).toUpperCase());
                    return var4_4;
                }
                case 142: {
                    this.configStack.push(((String)this.configStack.pop()).toLowerCase());
                    return var4_4;
                }
                case 242: {
                    var7_69 = (String)this.configStack.pop();
                    var8_86 = var7_69.length();
                    if ((var8_86 & 1) == 1) {
                        throw new SmartCardWordException("hex string has odd number of characters: " + var8_86);
                    }
                    var9_96 = var7_69.toCharArray();
                    var10_103 = new char[var8_86 / 2];
                    var12_113 = 0;
                    var11_120 = 0;
                    while (true) {
                        if (var11_120 >= var8_86 / 2) {
                            this.configStack.push(String.valueOf(var10_103));
                            return var4_4;
                        }
                        var10_103[var11_120] = (char)(Character.digit(var9_96[var12_113++], 16) << 4 | Character.digit(var9_96[var12_113++], 16));
                        ++var11_120;
                    }
                }
                case 342: {
                    var7_70 = (String)this.configStack.pop();
                    var8_87 = var7_70.toCharArray();
                    var9_97 = var7_70.length();
                    var10_104 = new char[var9_97 * 2];
                    var12_114 = 0;
                    var11_121 = 0;
                    while (true) {
                        if (var11_121 >= var9_97) {
                            this.pushHex(String.valueOf(var10_104));
                            return var4_4;
                        }
                        var10_104[var12_114++] = Character.forDigit(var8_87[var11_121] >> 4, 16);
                        var10_104[var12_114++] = Character.forDigit(var8_87[var11_121] & 15, 16);
                        ++var11_121;
                    }
                }
                case 442: {
                    var7_71 = (String)this.configStack.pop();
                    var8_88 = ((String)this.configStack.pop()).indexOf(var7_71);
                    if (var8_88 < 0) {
                        this.configStack.push(this.bFALSE);
                        return var4_4;
                    }
                    this.pushHex(Integer.toString(var8_88, 16));
                    this.configStack.push(this.bTRUE);
                    return var4_4;
                }
                case 542: 
                case 742: {
                    var7_72 = Integer.parseInt((String)this.configStack.pop(), 16);
                    var8_89 = (String)this.configStack.pop();
                    var9_98 = (String)this.configStack.pop();
                    if (var9_98.length() >= var7_72) {
                        var10_105 = var9_98;
                    } else {
                        if (var8_89.length() == 0) {
                            throw new SmartCardWordException("pad value is empty");
                        }
                        var11_122 = var7_72 - var9_98.length();
                        var12_115 = new char[var11_122];
                        for (var13_128 = 0; var13_128 < var11_122; ++var13_128) {
                            var12_115[var13_128] = var8_89.charAt(var13_128 % var8_89.length());
                        }
                        var10_105 = var3_3 == 542 ? new String(var12_115) + var9_98 : var9_98 + new String(var12_115);
                    }
                    this.configStack.push(var10_105);
                    return var4_4;
                }
                case 642: 
                case 842: {
                    var7_73 = Integer.parseInt((String)this.configStack.pop(), 16);
                    var8_90 = Integer.parseInt((String)this.configStack.pop(), 16);
                    var9_99 = (String)this.configStack.pop();
                    var10_106 = Integer.parseInt(var9_99, 16);
                    if (var8_90 > 255) {
                        throw new SmartCardWordException("pad value too large: " + Integer.toString(var8_90, 16));
                    }
                    if (var9_99.length() >= (var7_73 *= 2)) {
                        var11_123 = var9_99;
                    } else {
                        var12_116 = var7_73 - var9_99.length();
                        var13_129 = new char[var12_116];
                        var14_130 = Integer.toString(var8_90 >> 4, 16).charAt(0);
                        var15_131 = Integer.toString(var8_90 & 15).charAt(0);
                        if (var3_3 == 642) {
                            if ((var9_99.length() & 1) == 1) {
                                var13_129[--var12_116] = var14_130;
                            }
                            while (var12_116 > 0) {
                                var13_129[--var12_116] = var15_131;
                                var13_129[--var12_116] = var14_130;
                            }
                            var11_123 = new String(var13_129) + var9_99;
                        } else {
                            var16_132 = 0;
                            if ((var9_99.length() & 1) == 1) {
                                var13_129[var16_132++] = var15_131;
                            }
                            while (var16_132 < var12_116) {
                                var13_129[var16_132++] = var14_130;
                                var13_129[var16_132++] = var15_131;
                            }
                            var11_123 = var9_99 + new String(var13_129);
                        }
                    }
                    this.pushHex(var11_123);
                    return var4_4;
                }
                case 43: {
                    this.configStack.push(this.configStack.peek());
                    return var4_4;
                }
                case 44: {
                    this.configStack.pop();
                    return var4_4;
                }
                case 45: {
                    if (this.checkBoolean((String)this.configStack.pop())) {
                        this.configStack.push(this.bFALSE);
                        return var4_4;
                    }
                    this.configStack.push(this.bTRUE);
                    return var4_4;
                }
                case 46: {
                    var7_74 = (String)this.configStack.pop();
                    var8_91 = (String)this.configStack.pop();
                    this.configStack.push(var8_91 + var7_74);
                    return var4_4;
                }
                case 47: {
                    var7_75 = (String)this.configStack.pop();
                    var8_92 = (String)this.configStack.pop();
                    this.configStack.push(var7_75);
                    this.configStack.push(var8_92);
                    return var4_4;
                }
                case 93: {
                    var2_2.put("_WI_TokenID.name", (String)this.configStack.pop());
                    var2_2.put("_WI_TokenID.ID", (String)this.configStack.pop());
                    return 20;
                }
                case 94: {
                    return 21;
                }
                case 95: {
                    var2_2.put("_WI_Jump_Label", (String)this.configStack.pop());
                    return 50;
                }
                case 80: {
                    var2_2.put("_WI_Display_Message", (String)this.configStack.pop() + "\n");
                    return 30;
                }
                case 81: {
                    var7_76 = (String)this.configStack.pop();
                    if (this.debugMessage == false) return var4_4;
                    var2_2.put("_WI_Display_Message", var7_76 + "\n");
                    return 30;
                }
                case 82: {
                    var2_2.put("_WI_Display_Message", (String)this.configStack.pop());
                    return 31;
                }
                case 83: {
                    var7_77 = "";
                    var8_93 = this.configStack.size();
                    var9_100 = 0;
                    if (var8_93 > 0) {
                        while (var8_93-- > 0) {
                            var7_77 = var7_77 + "[(" + var9_100++ + "):" + this.configStack.get(var8_93) + "]\n";
                        }
                    } else {
                        var7_77 = "(empty)";
                    }
                    var7_77 = var7_77 + "\n";
                    var2_2.put("_WI_Display_Message", var7_77);
                    return 30;
                }
                case 48: {
                    this.configStack.clear();
                    return var4_4;
                }
                case 90: {
                    var2_2.put("_WI_Jump_Label", (String)this.configStack.pop());
                    return 40;
                }
                case 91: {
                    var7_78 = (String)this.configStack.pop();
                    if (this.checkBoolean((String)this.configStack.pop()) == false) return var4_4;
                    var2_2.put("_WI_Jump_Label", var7_78);
                    return 40;
                }
                case 92: {
                    var7_79 = (String)this.configStack.pop();
                    if (this.checkBoolean((String)this.configStack.pop()) != false) return var4_4;
                    var2_2.put("_WI_Jump_Label", var7_79);
                    return 40;
                }
                case 100: {
                    return 100;
                }
                case 101: {
                    var8_94 = false;
                    var7_80 = (String)this.configStack.pop();
                    var9_101 = new BufferedReader(new StringReader(GroupManager.listSessionsByToken(var7_80)));
                    while (true) {
                        ** try [egrp 1[TRYBLOCK] [2, 3 : 5092->5221)] { 
lbl550:
                        // 1 sources

                        break block4;
lbl551:
                        // 1 sources

                        catch (NoSuchElementException var10_108) {
                            throw new SmartCardWordException("Error getting session info for token: [" + var7_80 + "] : [" + var10_108.getMessage() + "]");
                        }
                        break;
                    }
                }
                case 102: 
                case 103: {
                    if (this.clist == null) {
                        this.clist = new Hashtable<K, V>();
                        SmartCardWordsImpl.populateCmdList(this.clist);
                    }
                    var10_110 = new StringTokenizer((String)this.configStack.pop());
                    var11_125 = false;
                    while (!var11_125 && var10_110.hasMoreTokens()) {
                        var12_118 = var10_110.nextToken();
                        if (this.clist.containsKey(var12_118)) continue;
                        if (var3_3 == 103) {
                            throw new SmartCardWordException("required word not a SwapDrop word: " + var12_118);
                        }
                        this.configStack.push(var12_118);
                        this.configStack.push(this.bFALSE);
                        var11_125 = true;
                    }
                    if (var11_125 != false) return var4_4;
                    this.configStack.push(this.bTRUE);
                    return var4_4;
                }
                case 104: {
                    this.tBufferValid = false;
                    this.useTagLength = false;
                    this.tBufferPos = 0;
                    this.vBufferOffset = 0;
                    this.tagLength = 0;
                    var10_111 = ((String)this.configStack.pop()).toLowerCase();
                    this.bigLengthSize = Integer.parseInt((String)this.configStack.pop(), 16);
                    this.bigLengthFlag = ((String)this.configStack.pop()).toLowerCase();
                    var11_126 = ((String)this.configStack.pop()).toLowerCase();
                    this.tBuffer = ((String)this.configStack.pop()).toLowerCase();
                    try {
                        if (var10_111.equals(this.useTagLengthFlag.toLowerCase())) {
                            this.useTagLength = true;
                        } else {
                            this.tagLength = Integer.parseInt(var10_111, 16) * 2;
                        }
                    }
                    catch (NumberFormatException var12_119) {
                        throw new SmartCardWordException("invalid tag length specification");
                    }
                    if (var11_126.equals(this.useBigEndianFlag.toLowerCase())) {
                        this.bigLengthEndian = true;
                    } else {
                        if (var11_126.equals(this.useLittleEndianFlag.toLowerCase()) == false) throw new SmartCardWordException("invalid endian specification");
                        this.bigLengthEndian = false;
                    }
                    if ((this.tBuffer.length() & 1) == 1) {
                        throw new SmartCardWordException("tBuffer length is odd");
                    }
                    this.tBufferValid = true;
                    return var4_4;
                }
                case 204: {
                    var10_112 = false;
                    var11_127 = this.parseTbuffer(((String)this.configStack.pop()).toLowerCase());
                    if (var11_127 >= 0) {
                        this.configStack.push(Integer.toString(this.vBufferOffset, 16));
                        this.configStack.push(Integer.toString(var11_127, 16));
                        this.vBufferOffset += var11_127;
                        var10_112 = true;
                    } else {
                        this.tBufferPos = 0;
                        this.vBufferOffset = 0;
                    }
                    this.configStack.push(var10_112 != false ? this.bTRUE : this.bFALSE);
                    return var4_4;
                }
                default: {
                    throw new SmartCardWordException("Invalid word encountered: [" + var1_1 + "]");
                }
            }
            while ((var10_107 = var9_101.readLine()) != null) {
                Log.notice((String)("hasSession: token=[" + var7_80 + "] " + "sessioninfo=[" + var10_107 + "]"));
                var11_124 = new StringTokenizer(var10_107);
                var11_124.nextToken();
                try {
                    if (Integer.parseInt(var11_124.nextToken()) < 0) ** continue;
                    var8_94 = true;
                }
                catch (NumberFormatException var12_117) {
                    throw new NoSuchElementException("Bad display data from group manager: [" + var12_117.getMessage() + "]");
                }
            }
            break block143;
lbl632:
            // 1 sources

            catch (IOException var10_109) {
                throw new SmartCardWordException("Bad token data from group manager for token: [" + var7_80 + "]");
            }
        }
        this.configStack.push(var8_94 != false ? this.bTRUE : this.bFALSE);
        return var4_4;
    }

    private boolean checkBoolean(String string) throws NumberFormatException {
        if (string.equals(this.bTRUE)) {
            return true;
        }
        if (string.equals(this.bFALSE)) {
            return false;
        }
        throw new NumberFormatException("Invalid boolean word: [" + string + "]");
    }

    public void push(String string) {
        this.configStack.push(string);
    }

    public void push(boolean bl) {
        if (bl) {
            this.configStack.push(this.bTRUE);
        } else {
            this.configStack.push(this.bFALSE);
        }
    }

    public void pushHex(String string) {
        this.configStack.push(string.toLowerCase());
    }

    public String getHexFromString(String string) {
        return string.toLowerCase();
    }

    public void clearStack() {
        this.configStack.clear();
        this.executeControl.clear();
    }

    public void clearProperties() {
        this.configProps.clear();
        this.debugMessage = false;
    }

    public void clear() {
        this.clearStack();
        this.clearProperties();
    }

    private int parseTbuffer(String string) throws SmartCardWordException {
        if (!this.tBufferValid) {
            throw new SmartCardWordException("T-buffer parser not properly initialized");
        }
        if (this.useTagLength) {
            this.tagLength = string.length();
        } else {
            if (string.length() < this.tagLength) {
                throw new SmartCardWordException("tag smaller than required tag length");
            }
            if (string.length() > this.tagLength) {
                throw new SmartCardWordException("tag larger than required tag length");
            }
        }
        if (((this.tagLength | string.length()) & 1) == 1) {
            throw new SmartCardWordException("tag length is odd");
        }
        if (this.tBuffer.length() < this.tagLength) {
            throw new SmartCardWordException("tBuffer smaller than tag");
        }
        try {
            while (this.tBufferPos < this.tBuffer.length() - this.tagLength) {
                int n;
                int n2 = n = this.tBufferPos + this.tagLength;
                int n3 = n + 2;
                int n4 = this.tBufferPos;
                this.tBufferPos += 2;
                if (this.tBuffer.startsWith(this.bigLengthFlag, n)) {
                    n2 = n + 2;
                    n3 = n + 2 + this.bigLengthSize * 2;
                    this.tBufferPos += this.bigLengthSize * 2;
                }
                this.tBufferPos += this.tagLength;
                String string2 = this.tBuffer.substring(n2, n3);
                if (!this.bigLengthEndian) {
                    string2 = this.flipEndian(string2);
                }
                int n5 = Integer.parseInt(string2, 16);
                if (this.tBuffer.regionMatches(true, n4, string, 0, this.tagLength)) {
                    return n5;
                }
                this.vBufferOffset += n5;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
        return -1;
    }

    public String flipEndian(String string) throws SmartCardWordException {
        int n = string.length();
        char[] cArray = new char[n];
        char[] cArray2 = string.toCharArray();
        if ((n & 1) == 1) {
            throw new SmartCardWordException("not enough bytes in buffer to flipEndian");
        }
        int n2 = 0;
        int n3 = n - 1;
        for (int i = 0; i < n / 2; ++i) {
            cArray[n2++] = cArray2[n3 - 1];
            cArray[n2++] = cArray2[n3];
            n3 -= 2;
        }
        return new String(cArray);
    }

    public String getCmdWordCode(String string) throws SmartCardWordException {
        String string2;
        if (this.clist == null) {
            this.clist = new Hashtable();
            SmartCardWordsImpl.populateCmdList(this.clist);
        }
        if ((string2 = (String)this.clist.get(string)) == null) {
            throw new SmartCardWordException("no command found for: [" + string + "]");
        }
        return string2;
    }
}

