/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.utauthd.SmartCardIDException;
import auth.utauthd.SmartCardWordException;
import auth.utauthd.SmartCardWordsImpl;
import auth.utauthd.Terminal;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SmartCardID {
    private static final String SCCS_ID = "@(#)SmartCardID.java\t1.30 09/08/04 SMI";
    private Terminal term;
    private int tagCtr = 0;
    private String msgTag;
    private String expectedMsgTag = null;
    private boolean needMsgTags = false;
    private Hashtable tokenInfo;
    private Vector terminalTokens;
    private int state;
    private static final int STATE_DEBUG = 0;
    private static final int STATE_INIT = 1;
    private static final int STATE_ERROR = 2;
    private static final int STATE_TIMEOUT = 3;
    private static final int STATE_SEND_APDU = 10;
    private static final int STATE_XCHANGE_APDU = 11;
    private static final int STATE_SETPROTO = 12;
    private static final int STATE_SEND_PTS = 13;
    private static final int STATE_CARD_BAUD = 14;
    private static final int STATE_RECEIVE_APDU = 20;
    private static final int STATE_RECEIVE_APDU_NO_DATA = 21;
    private static final int STATE_SETPROTO_DONE = 30;
    private static final int STATE_PTS_DONE = 31;
    private static final int STATE_CARD_BAUD_DONE = 32;
    private static final int STATE_PROCESS = 40;
    private static final int STATE_FINISHED = 41;
    private static final int STATE_TOKEN_REMOVED = 42;
    private static final int STATE_WAITFOR_TOKEN = 43;
    private static final int STATE_CARD_RESET = 100;
    private static final int STATE_CARD_RESET_DONE = 101;
    private int mStime = 0;
    private int mSticks = 0;
    private static final String ti_INFO_REQ = "infoReq";
    private static final String ti_SESSION_REQ = "sessionReq";
    private static final String ir_EVENT_MSG = "event";
    private static final String ir_INSERT_EVENT = "insert";
    private static final String ir_REMOVE_EVENT = "remove";
    private static final String ir_TOKEN_TYPE = "type";
    private static final String ir_TOKEN_ID = "id";
    private static final String ir_TOKEN_ATR = "atr";
    private static final String ir_TOKEN_ATR_HIST_START = "atr.hs";
    private static final String ir_TOKEN_ATR_HIST_LEN = "atr.hist_len";
    private static final String ir_UNKNOWN_TOKEN = "unknown";
    private static final String ir_UNKNOWN_ID = "unknown";
    public static final String ir_PSEUDO_TOKEN = "pseudo";
    private static final String tc_CONTROL = "command";
    static final String tc_SMARTCARD = "controlSmartCard";
    private static final String ai_APDU_INF = "apduInf";
    private static final String ai_HEAD = "head";
    private static final String ai_RLEN = "rlen";
    private static final String ai_TDATA = "tdata";
    private static final String ai_HASH_BITMASK = "hash_bitmask";
    private static final String ai_SYNC = "sync";
    private static final String ai_NORETRY = "noretry";
    private static final String ai_LED = "led";
    private static final String ai_CARD_RESET_INF = "cardReset";
    private static final String ai_SETPROTO = "cardProto";
    private static final String ai_SETPROTO_CMD = "protocol";
    private static final String ai_SEND_PTS = "cardPTS";
    private static final String ai_SEND_PTS_CMD = "pts";
    private static final String ai_SEND_CARD_BAUD = "cardBaud";
    private static final String ai_SEND_CARD_BAUD_CTL = "switch";
    private static final String ai_SEND_CARD_BAUD_RATE = "val";
    private static final String ti_INFO_SMARTCARD = "infoSmartCard";
    private static final String isc_APDU_RESULT = "apdu_result";
    private static final String isc_APDU_RESULT_ERROR = "0";
    private static final String isc_APDU_RESULT_OK = "1";
    private static final String isc_REC_LEN = "rec_len";
    private static final String isc_REC_DATA = "rec_data";
    private static final String isc_HASH_RESULT = "hash_result";
    private static final String isc_PROC_BYTE = "proc_byte";
    private static final String isc_STATUS = "status";
    private static final String isc_RESET_RESULT = "reset_result";
    private static final String isc_RESET_RESULT_ERROR = "0";
    private static final String isc_RESET_RESULT_OK = "1";
    private static final String isc_RESET_ATR = "atr";
    private static final String isc_RESET_ATR_HIST_START = "atr.hs";
    private static final String isc_RESET_ATR_HIST_LEN = "atr.hist_len";
    private static final String isc_SETPROTO_RESULT = "cardProto_result";
    private static final String isc_SETPROTO_ERROR = "0";
    private static final String isc_SETPROTO_OK = "1";
    private static final String isc_SEND_PTS_RESULT = "cardPTS_result";
    private static final String isc_SEND_PTS_RESULT_ERROR = "0";
    private static final String isc_SEND_PTS_RESULT_OK = "1";
    private static final String isc_SEND_CARD_BAUD_RESULT = "cardBaud_result";
    private static final String isc_SEND_CARD_BAUD_RESULT_OK = "0";
    private static final String isc_SEND_CARD_BAUD_RESULT_PPS_FAILURE = "1";
    private static final String isc_SEND_CARD_BAUD_RESULT_PROTO_ERROR = "2";
    private static final String isc_SEND_CARD_BAUD_RESULT_NO_CARD = "3";
    private static final String isc_SEND_CARD_BAUD_RESULT_NO_READER = "4";
    private static final String isc_SEND_CARD_BAUD_RESULT_UNKNOWN_ERR = "9";
    private static final String isc_SEND_CARD_BAUD_RATE = "cardBaud_current";
    private static final String isc_SEND_CARD_BAUD_CARDBAUD_HIGH = "cardBaud_high";
    private static final String isc_SEND_CARD_BAUD_CARDBAUD_LOW = "cardBaud_low";
    private static final String isc_SEND_CARD_BAUD_READERBAUD_HIGH = "rdrBaud_high";
    private static final String isc_SEND_CARD_BAUD_READERBAUD_LOW = "rdrBaud_low";
    private Vector configFiles;
    private int configFileIndex;
    private int configFileTokenIndex;
    private int labelsIndex = 0;
    private int firstConfigFileTokenIndex = 1;
    private static final int noExceptionHandlerIndex = -1;
    private int exceptionHandlerIndex = -1;
    private static final int noLabelIndex = -1;
    private Hashtable labels;
    private String configTokensSource = null;
    private SmartCardWordsImpl scwi;
    static final String WIpropPrefix = "_WI_";
    static final String TokenID = "_WI_TokenID.ID";
    static final String TokenType = "_WI_TokenID.name";
    static final String Xchange_APDU = "_WI_Xchange_APDU.APDU";
    static final String Xchange_APDU_rlen = "_WI_Xchange_APDU.rlen";
    static final String Xchange_APDU_bitmask = "_WI_Xchange_APDU.bitmask";
    static final String Display_Message = "_WI_Display_Message";
    static final String Debug_Set = "_WI_Debug_Set";
    static final String Jump_Label = "_WI_Jump_Label";
    static final String CardProtocol = "_WI_cardProtocol";
    static final String CardPTS = "_WI_cardPTS";
    static final String CardBaud_ctl = "_WI_cardBaud.ctl";
    static final String CardBaud_baud = "_WI_cardBaud.baud";
    Properties ATRprops;
    static final String ATR_prop_prefix = "atr.";
    static final String ATR_data_prop = "atr.atr";
    static final String ATR_history_prop = "atr.history";
    static final String DEBUG_prop_prefix = "debug.";
    static final String DEBUG_words = "debug.words";
    static final String DEBUG_msg = "debug.msg";
    static final String DTU_prop_prefix = "dtu.";

    public SmartCardID(Terminal terminal, Vector vector, Vector vector2, String string) {
        this.term = terminal;
        this.state = 43;
        this.ATRprops = new Properties();
        this.labels = new Hashtable();
        this.tokenInfo = new Hashtable();
        this.configFiles = vector;
        this.configFileIndex = 0;
        this.configFileTokenIndex = this.firstConfigFileTokenIndex;
        this.terminalTokens = vector2;
        this.msgTag = string;
        this.scwi = new SmartCardWordsImpl(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(String string, Hashtable hashtable) throws SmartCardIDException {
        boolean bl;
        String string2;
        String string3;
        if (string.equals(ti_INFO_REQ) || string.equals(ti_SESSION_REQ)) {
            string3 = (String)hashtable.get(ir_EVENT_MSG);
            if (string3.equals(ir_INSERT_EVENT)) {
                string2 = (String)hashtable.get(ir_TOKEN_TYPE);
                if (string2 == null) {
                    throw new SmartCardIDException("No token type received for message: [" + string + "] " + "event: [" + string3 + "]");
                }
                if (this.terminalTokens.contains(string2.toLowerCase())) {
                    this.state = 1;
                    return true;
                }
                this.tokenInfo.clear();
                this.tokenInfo.putAll(hashtable);
                this.setupATRprops(string, string3, hashtable);
                this.state = 1;
            } else {
                if (!string3.equals(ir_REMOVE_EVENT)) {
                    this.state = 43;
                    throw new SmartCardIDException("Unknown event: [" + string3 + "] " + "for message: [" + string + "] " + "from terminal");
                }
                this.state = 42;
            }
        } else {
            if (!string.equals(ti_INFO_SMARTCARD)) {
                throw new SmartCardIDException("Unknown message: [" + string + "] " + "from terminal");
            }
            string2 = this.expectedMsgTag;
            this.expectedMsgTag = null;
            string3 = (String)hashtable.get("tag");
            if (string2 == null) {
                if (string3 != null) throw new SmartCardIDException("Message: [infoSmartCard] message tag: [" + string3 + "] " + "not expected");
                string3 = "(no message tag received)";
                throw new SmartCardIDException("Message: [infoSmartCard] message tag: [" + string3 + "] " + "not expected");
            }
            if (string3 != null) {
                if (!string3.equals(string2)) {
                    throw new SmartCardIDException("Message: [infoSmartCard] has wrong message tag. Expected: [" + string2 + "] " + "Received: [" + string3 + "] ");
                }
            } else if (this.needMsgTags) {
                throw new SmartCardIDException("Message: [infoSmartCard] does not have a message tag");
            }
        }
        boolean bl2 = false;
        block24: do {
            bl = false;
            switch (this.state) {
                case 1: {
                    this.configFileIndex = 0;
                    this.configFileTokenIndex = this.firstConfigFileTokenIndex;
                    this.scwi.clear();
                    this.exceptionHandlerIndex = -1;
                    this.loadLabels(this.configFileIndex);
                    this.state = 40;
                    break;
                }
                case 40: {
                    bl2 = this.processMsg(hashtable);
                    if (!bl2) continue block24;
                    this.state = 41;
                    break;
                }
                case 20: 
                case 21: {
                    Object object = (String)hashtable.get(isc_APDU_RESULT);
                    if (object == null) {
                        throw new SmartCardIDException("Missing APDU operation result");
                    }
                    String string4 = (String)hashtable.get(isc_PROC_BYTE);
                    if (string4 == null) {
                        throw new SmartCardIDException("Missing APDU Procedure Byte");
                    }
                    String string5 = (String)hashtable.get(isc_STATUS);
                    if (string5 == null) {
                        throw new SmartCardIDException("Missing APDU Status");
                    }
                    String string6 = (String)hashtable.get(isc_REC_LEN);
                    if (string6 == null) {
                        throw new SmartCardIDException("Missing APDU Receive Length");
                    }
                    boolean bl3 = false;
                    try {
                        if (Integer.parseInt(string6, 16) > 0) {
                            bl3 = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SmartCardIDException("APDU Receive Length format error: [" + string6 + "]");
                    }
                    boolean bl4 = false;
                    if (((String)object).equals("1")) {
                        boolean bl5 = false;
                        bl4 = true;
                        if (bl3) {
                            String string7 = (String)hashtable.get(isc_REC_DATA);
                            String string8 = (String)hashtable.get(isc_HASH_RESULT);
                            if (string7 == null) {
                                throw new SmartCardIDException("Missing APDU data");
                            }
                            bl5 = true;
                            this.scwi.pushHex(string7);
                            if (string8 != null) {
                                this.scwi.pushHex(string8);
                                hashtable.remove(string8);
                            }
                        }
                        if (this.state != 21) {
                            this.scwi.push(bl5);
                        }
                    }
                    this.scwi.pushHex(string4);
                    this.scwi.pushHex(string5);
                    this.scwi.push(bl4);
                    this.state = 40;
                    break;
                }
                case 11: {
                    Object object = new Hashtable();
                    this.stuffAPDU((Hashtable)object, hashtable);
                    String string9 = (String)hashtable.get(Xchange_APDU_bitmask);
                    if (string9 != null) {
                        ((Hashtable)object).put(ai_HASH_BITMASK, string9);
                        hashtable.remove(Xchange_APDU_bitmask);
                    }
                    ((Hashtable)object).put(tc_CONTROL, ai_APDU_INF);
                    if (!this.write(tc_SMARTCARD, (Hashtable)object, this.getUniqueTag())) {
                        this.state = 2;
                        throw new SmartCardIDException("Error sending message to terminal");
                    }
                    this.state = 20;
                    bl = true;
                    break;
                }
                case 10: {
                    Object object = new Hashtable();
                    this.stuffAPDU((Hashtable)object, hashtable);
                    ((Hashtable)object).put(tc_CONTROL, ai_APDU_INF);
                    if (!this.write(tc_SMARTCARD, (Hashtable)object, this.getUniqueTag())) {
                        throw new SmartCardIDException("Error sending message to terminal");
                    }
                    this.state = 21;
                    bl = true;
                    break;
                }
                case 12: {
                    Object object = (String)hashtable.get(CardProtocol);
                    Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                    hashtable2.put(ai_SETPROTO_CMD, object);
                    hashtable2.put(tc_CONTROL, ai_SETPROTO);
                    if (!this.write(tc_SMARTCARD, hashtable2, this.getUniqueTag())) {
                        throw new SmartCardIDException("Error sending card_proto message to terminal");
                    }
                    this.state = 30;
                    bl = true;
                    break;
                }
                case 30: {
                    Object object = (String)hashtable.get(isc_SETPROTO_RESULT);
                    if (object == null) {
                        throw new SmartCardIDException("Missing cardProto operation result");
                    }
                    if (((String)object).equals("1")) {
                        this.scwi.push(true);
                    } else {
                        this.scwi.push(false);
                    }
                    this.state = 40;
                    break;
                }
                case 13: {
                    Object object = (String)hashtable.get(CardPTS);
                    Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
                    hashtable3.put(ai_SEND_PTS_CMD, object);
                    hashtable3.put(tc_CONTROL, ai_SEND_PTS);
                    if (!this.write(tc_SMARTCARD, hashtable3, this.getUniqueTag())) {
                        throw new SmartCardIDException("Error sending pts message to terminal");
                    }
                    this.state = 31;
                    bl = true;
                    break;
                }
                case 31: {
                    Object object = (String)hashtable.get(isc_SEND_PTS_RESULT);
                    if (object == null) {
                        throw new SmartCardIDException("Missing cardPTS operation result");
                    }
                    if (((String)object).equals("1")) {
                        this.scwi.push(true);
                    } else {
                        this.scwi.push(false);
                    }
                    this.state = 40;
                    break;
                }
                case 14: {
                    Object object = new Hashtable();
                    ((Hashtable)object).put(ai_SEND_CARD_BAUD_CTL, (String)hashtable.get(CardBaud_ctl));
                    String string10 = (String)hashtable.get(CardBaud_baud);
                    if (string10 != null) {
                        ((Hashtable)object).put(ai_SEND_CARD_BAUD_RATE, string10);
                    }
                    ((Hashtable)object).put(tc_CONTROL, ai_SEND_CARD_BAUD);
                    if (!this.write(tc_SMARTCARD, (Hashtable)object, this.getUniqueTag())) {
                        throw new SmartCardIDException("Error sending cardBaud message to terminal");
                    }
                    this.state = 32;
                    bl = true;
                    break;
                }
                case 32: {
                    String string6;
                    String string5;
                    Object object = (String)hashtable.get(isc_SEND_CARD_BAUD_RESULT);
                    if (object == null) {
                        throw new SmartCardIDException("Missing cardBaud operation result");
                    }
                    boolean bl6 = false;
                    if (((String)object).equals("0") || ((String)object).equals("1")) {
                        string5 = null;
                        string6 = "rdrBaud_low rdrBaud_high cardBaud_low cardBaud_high cardBaud_current";
                        StringTokenizer stringTokenizer = new StringTokenizer(string6);
                        while (stringTokenizer.hasMoreElements()) {
                            String string11 = stringTokenizer.nextToken();
                            string5 = (String)hashtable.get(string11);
                            if (string5 == null) {
                                if (!bl6) continue;
                                throw new SmartCardIDException("Missing cardBaud baudrate property: " + string11);
                            }
                            try {
                                this.scwi.push(Integer.decode(string5).toString());
                                bl6 = true;
                            }
                            catch (Exception exception) {
                                throw new SmartCardIDException("Invalid cardBaud baudrate value format: " + string11 + "=" + string5);
                            }
                        }
                    }
                    this.scwi.push(bl6);
                    this.scwi.push((String)object);
                    this.state = 40;
                    break;
                }
                case 2: {
                    this.state = 1;
                    throw new SmartCardIDException("Error while communicating with terminal");
                }
                case 3: {
                    this.state = 1;
                    throw new SmartCardIDException("Timeout while waiting for terminal response");
                }
                case 41: {
                    this.term.setInsertParam(ir_TOKEN_TYPE, (String)hashtable.get(TokenType));
                    this.term.setInsertParam(ir_TOKEN_ID, (String)hashtable.get(TokenID));
                    return true;
                }
                case 42: {
                    this.state = 43;
                    bl2 = true;
                    break;
                }
                case 43: {
                    return true;
                }
                case 100: {
                    Object object = new Hashtable();
                    ((Hashtable)object).put(tc_CONTROL, ai_CARD_RESET_INF);
                    if (!this.write(tc_SMARTCARD, (Hashtable)object, this.getUniqueTag())) {
                        this.state = 2;
                        throw new SmartCardIDException("Error sending message to terminal");
                    }
                    this.state = 101;
                    bl = true;
                    break;
                }
                case 101: {
                    String string6;
                    String string5;
                    Object object = (String)hashtable.get(isc_RESET_RESULT);
                    if (object == null) {
                        throw new SmartCardIDException("Missing cardReset operation result");
                    }
                    boolean bl7 = false;
                    if (((String)object).equals("1")) {
                        string5 = (String)hashtable.get("atr");
                        if (object == null) {
                            throw new SmartCardIDException("Missing ATR from cardReset");
                        }
                        string6 = (String)hashtable.get("atr.hs");
                        if (object == null) {
                            throw new SmartCardIDException("Missing ATR history start from cardReset");
                        }
                        bl7 = true;
                        this.scwi.pushHex(string5);
                        this.setupATRprops(ti_INFO_SMARTCARD, ai_CARD_RESET_INF, hashtable);
                    }
                    this.scwi.push(bl7);
                    this.state = 40;
                    break;
                }
                default: {
                    this.state = 1;
                    throw new SmartCardIDException("Invalid state: " + this.state);
                }
            }
        } while (!bl);
        return bl2;
    }

    public boolean processMsg(Hashtable hashtable) {
        while (this.configFileIndex < this.configFiles.size()) {
            Vector vector = (Vector)this.configFiles.get(this.configFileIndex);
            int n = vector.size();
            block20: while (this.configFileTokenIndex < n) {
                String string;
                String string2;
                String string3;
                String string4 = (String)vector.get(this.configFileTokenIndex++);
                try {
                    int n2 = this.scwi.wordImpl(string4, hashtable);
                    switch (n2) {
                        case 0: {
                            continue block20;
                        }
                        case 10: {
                            this.state = 10;
                            return false;
                        }
                        case 11: {
                            this.state = 11;
                            return false;
                        }
                        case 20: {
                            this.state = 41;
                            return true;
                        }
                        case 21: {
                            this.configFileTokenIndex = n;
                            continue block20;
                        }
                        case 30: {
                            System.out.print((String)hashtable.get(Display_Message));
                            continue block20;
                        }
                        case 31: {
                            Log.notice((String)((String)hashtable.get(Display_Message)));
                            continue block20;
                        }
                        case 32: {
                            continue block20;
                        }
                        case 40: 
                        case 50: {
                            int n3 = this.labelIndex((String)hashtable.get(Jump_Label), n);
                            if (n3 == -1) {
                                n3 = n;
                            }
                            if (n2 == 40) {
                                this.configFileTokenIndex = n3;
                                continue block20;
                            }
                            this.exceptionHandlerIndex = n3;
                            continue block20;
                        }
                        case 100: {
                            this.state = 100;
                            return false;
                        }
                        case 12: {
                            this.state = 12;
                            return false;
                        }
                        case 13: {
                            this.state = 13;
                            return false;
                        }
                        case 17: {
                            this.state = 14;
                            return false;
                        }
                    }
                    Log.configError((String)("SmartCardID:processMsg: wordImpl unknown return code: " + n2));
                    this.configFileTokenIndex = n;
                }
                catch (EmptyStackException emptyStackException) {
                    StringBuffer stringBuffer = new StringBuffer("");
                    this.configFileTokenIndex = this.adjustConfigTokenIndex(n, stringBuffer);
                    string3 = "SmartCardID:processMsg: EmptyStackException";
                    string2 = emptyStackException.getMessage();
                    if (string2 != null) {
                        string3 = string3 + ": " + string2;
                    }
                    string = string3 + stringBuffer.toString();
                    Log.configError((String)string);
                    this.scwi.push(string3);
                    this.scwi.push("EmptyStackException");
                    System.out.println(string);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer("");
                    this.configFileTokenIndex = this.adjustConfigTokenIndex(n, stringBuffer);
                    string3 = "SmartCardID:processMsg: NumberFormatException";
                    string2 = numberFormatException.getMessage();
                    if (string2 != null) {
                        string3 = string3 + ": " + string2;
                    }
                    string = string3 + stringBuffer.toString();
                    Log.configError((String)string);
                    this.scwi.push(string3);
                    this.scwi.push("NumberFormatException");
                    System.out.println(string);
                }
                catch (SmartCardWordException smartCardWordException) {
                    StringBuffer stringBuffer = new StringBuffer("");
                    this.configFileTokenIndex = this.adjustConfigTokenIndex(n, stringBuffer);
                    string3 = smartCardWordException.getMessage() + stringBuffer.toString();
                    Log.configError((String)string3);
                    this.scwi.push(smartCardWordException.getMessage());
                    this.scwi.push("SmartCardWordException");
                    System.out.println(string3);
                }
            }
            this.loadLabels(++this.configFileIndex);
            this.configFileTokenIndex = this.firstConfigFileTokenIndex;
            this.scwi.clear();
            this.exceptionHandlerIndex = -1;
        }
        hashtable.put(TokenType, "unknown");
        hashtable.put(TokenID, "unknown");
        this.state = 41;
        return true;
    }

    private void stuffAPDU(Hashtable hashtable, Hashtable hashtable2) {
        String string = (String)hashtable2.get(Xchange_APDU);
        String string2 = (String)hashtable2.get(Xchange_APDU_rlen);
        int n = string.length();
        hashtable.put(ai_HEAD, string.substring(0, Math.min(8, n)));
        if (n >= 10) {
            hashtable.put(ai_TDATA, string.substring(10));
        }
        if (string2 != null) {
            hashtable.put(ai_RLEN, string2);
        }
    }

    private void setupATRprops(String string, String string2, Hashtable hashtable) throws SmartCardIDException {
        this.ATRprops.clear();
        String string3 = (String)hashtable.get("atr");
        if (string3 == null) {
            throw new SmartCardIDException("No ATR received for message: [" + string + "] " + "event: [" + string2 + "]");
        }
        this.ATRprops.setProperty(ATR_data_prop, this.scwi.getHexFromString(string3));
        int n = 0;
        String string4 = (String)hashtable.get("atr.hs");
        if (string4 != null) {
            try {
                int n2 = Integer.parseInt(string4, 16) * 2;
                String string5 = (String)hashtable.get("atr.hist_len");
                if (string5 == null && (string5 = string3.substring(3, 4)) == null) {
                    n = string3.length() - n2;
                }
                if (string5 != null) {
                    try {
                        n = Integer.parseInt(string5, 16) * 2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = string3.length() - n2;
                        Log.unexpectedError((String)("SmartCardID: invalid ATR history length: [" + string5 + "]"));
                    }
                }
                if (n2 + n <= string3.length()) {
                    this.ATRprops.setProperty(ATR_history_prop, this.scwi.getHexFromString(string3.substring(n2, n2 + n)));
                } else {
                    Log.unexpectedError((String)("SmartCardID: invalid ATR history start: " + n2 + "history length: " + n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.unexpectedError((String)("SmartCardID: invalid ATR history start: [" + string4 + "]"));
            }
        }
    }

    private void loadLabels(int n) {
        this.configTokensSource = null;
        if (this.configFiles.isEmpty()) {
            return;
        }
        if (this.configFileIndex >= this.configFiles.size()) {
            return;
        }
        Hashtable hashtable = (Hashtable)((Vector)this.configFiles.get(n)).get(this.labelsIndex);
        this.labels.clear();
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.labels.put(string, (String)hashtable.get(string));
        }
        this.configTokensSource = (String)this.labels.get("ConfigTokensSourceKey");
    }

    private int labelIndex(String string, int n) {
        int n2 = -1;
        String string2 = (String)this.labels.get(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
                if (n2 > n) {
                    Log.configError((String)("SmartCardID:processMsg: label: [" + string + "] " + "has invalid offset: " + n2));
                    n2 = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.configError((String)("SmartCardID:processMsg: label: [" + string + "] " + "is not a valid label"));
                n2 = -1;
            }
        } else {
            Log.configError((String)("SmartCardID:processMsg: unknown label: [" + string + "]"));
            n2 = -1;
        }
        return n2;
    }

    private int adjustConfigTokenIndex(int n, StringBuffer stringBuffer) {
        int n2 = n;
        if (this.exceptionHandlerIndex != -1) {
            n2 = this.exceptionHandlerIndex;
            stringBuffer.append(" (caught)");
            this.exceptionHandlerIndex = -1;
        }
        return n2;
    }

    public void tick() {
        this.mStime += this.mSticks;
    }

    public void setTickTime(int n) {
        this.mSticks = n;
    }

    private synchronized String getUniqueTag() {
        this.expectedMsgTag = this.msgTag + ":" + Integer.toHexString(this.tagCtr++);
        return this.expectedMsgTag;
    }

    private boolean write(String string, Hashtable hashtable, String string2) {
        hashtable.put("tag", string2);
        return this.term.write(string, hashtable);
    }
}

