/*
 * Decompiled with CFR 0.152.
 */
package auth.protocol;

import auth.protocol.Protocol;
import auth.sdk.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class AuthWriter {
    OutputStream out = null;

    public AuthWriter(OutputStream out) {
        this.out = out;
    }

    public String write(String command, Hashtable param) {
        try {
            ByteArrayOutputStream packet = Protocol.format(command, param);
            String message = packet.toString("8859_1");
            Log.debug((String)(this.underline() + message + this.normal()));
            packet.writeTo(this.out);
            this.out.flush();
            return message;
        }
        catch (Exception e) {
            Log.unexpectedError((String)("during send to: " + this.out + " error=" + e));
            return null;
        }
    }

    private String normal() {
        return "\u001b[0m";
    }

    private String bold() {
        return "\u001b[1m";
    }

    private String underline() {
        return "\u001b[4m";
    }

    private String inverse() {
        return "\u001b[7m";
    }
}

