/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.server;

import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.Context;
import com.sun.ut.console.I18N;
import com.sun.ut.console.dtus.DesktopUnitHelper;
import com.sun.ut.console.dtus.SearchCriteria;
import com.sun.ut.console.server.CachedHost;
import com.sun.ut.console.server.DiskSpaceInfo;
import com.sun.ut.console.server.RestartServicesTask;
import com.sun.ut.console.server.ServerHelper;
import com.sun.ut.service.Host;
import com.sun.ut.service.ServiceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ServerDetailsHandler
extends BaseHandler {
    public static final String CACHED_DATA = "CachedData";
    public static final String HOSTNAME = "DetailsHostname";
    public static final int ONE_SECOND = 1000;
    public static final int USER_SESSIONS = 0;
    public static final int USER_SESSIONS_DISC = 1;
    public static final int IDLE_SESSIONS = 2;
    public static final int IDLE_SESSIONS_DISC = 3;
    private String name;
    private Host host;
    private long elapsedTime;
    private boolean bLocalhost;
    private ObjectListDataProvider diskSpaceProvider;
    private int totalDtus;
    private int totalUserSessions;
    private int totalDisconnectedUserSessions;
    private int totalGreeterSessions;
    private int totalDisconnectedGreeterSessions;
    private CachedHost cachedHost;

    public ServerDetailsHandler() {
        this.getServerInfo();
    }

    public void getServerInfo() {
        boolean useCache = true;
        this.name = ServerHelper.getSelectedId();
        String localhost = this.getProvider().getCurrentHostName();
        this.bLocalhost = localhost.indexOf(this.name) == 0;
        HashMap cachedData = (HashMap)Context.getSessionAttribute(CACHED_DATA);
        if (cachedData != null) {
            this.cachedHost = (CachedHost)cachedData.get(this.name);
            if (this.cachedHost != null) {
                this.host = this.cachedHost.getHost();
            }
        }
        if (this.host == null) {
            useCache = false;
            this.host = this.getHost(this.name);
        }
        if (this.host != null) {
            this.initSessionInfo(useCache);
            this.initDiskSpaceInfo(useCache);
        }
    }

    public TableDataProvider getDiskSpaceInfo() {
        if (this.diskSpaceProvider == null) {
            this.diskSpaceProvider = new ObjectListDataProvider(new ArrayList());
        }
        return this.diskSpaceProvider;
    }

    public String getName() {
        return this.name;
    }

    public Host getHost() {
        return this.host;
    }

    public String getSoftwareVersion() {
        return this.getProvider().getSoftwareVersion();
    }

    public String getOperatingSystem() {
        String architecture;
        String versionOS;
        StringBuffer buffer = new StringBuffer();
        String nameOS = System.getProperty("os.name");
        if (nameOS != null) {
            buffer.append(nameOS);
        }
        if ((versionOS = System.getProperty("os.version")) != null) {
            buffer.append(" ");
            buffer.append(versionOS);
        }
        if ((architecture = System.getProperty("os.arch")) != null) {
            buffer.append(" (");
            buffer.append(architecture);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String getElapsedTime() {
        this.elapsedTime = 0L;
        if (this.cachedHost != null) {
            this.elapsedTime = (System.currentTimeMillis() - this.cachedHost.getRestartTime()) / 1000L;
        }
        return String.valueOf(this.elapsedTime);
    }

    public int getTotalDtus() {
        return this.totalDtus;
    }

    public int getTotalUserSessions() {
        return this.totalUserSessions + this.totalDisconnectedUserSessions;
    }

    public int getUserSessions() {
        return this.totalUserSessions;
    }

    public int getTotalGreeterSessions() {
        return this.totalGreeterSessions + this.totalDisconnectedGreeterSessions;
    }

    public String showDTUs() {
        SearchCriteria criteria = DesktopUnitHelper.getSearchCriteria();
        criteria.setFilter("current");
        criteria.setSearchString(this.getName());
        DesktopUnitHelper.setSelectedId(null);
        return "viewServerDesktopUnits";
    }

    public boolean isLocalHost() {
        return this.bLocalhost;
    }

    public String warmRestart() {
        this.getNotification().setRestartRequired(false);
        this.restart(false);
        return "success";
    }

    public String coldRestart() {
        this.getNotification().setColdRestartRequired(false);
        this.restart(true);
        return "success";
    }

    public boolean isRestartInProgress() {
        boolean restartInProgress = false;
        if (this.host != null) {
            ArrayList serversRestarting = (ArrayList)Context.getSessionAttribute("ServersRestarting");
            if (serversRestarting == null || !this.isServerInRestartList(serversRestarting)) {
                restartInProgress = false;
            } else if (this.isCurrentServerRestarting(serversRestarting)) {
                restartInProgress = true;
            } else {
                Host restartedHost = this.getServerFromRestartList(serversRestarting);
                String restartedHostName = "";
                if (restartedHost != null) {
                    restartedHostName = restartedHost.getName();
                }
                String statusRestartType = I18N.getResource("servers_table_warm_restart_button");
                String auditRestartType = this.getAuditService().getMessage("restart_warm");
                if (this.isColdRestart(restartedHost)) {
                    auditRestartType = this.getAuditService().getMessage("restart_cold");
                    statusRestartType = I18N.getResource("servers_table_cold_restart_button");
                }
                if (this.isRestartSuccessful(restartedHost)) {
                    Object[] auditArgs = new String[]{auditRestartType, restartedHostName};
                    this.getAuditService().publishEvent("servers_restart", auditArgs);
                    Object[] args = new String[]{statusRestartType, restartedHostName};
                    this.getStatusMessage().info("server_restart_done", I18N.getResource("restart_success_single", args));
                } else {
                    Object[] auditArgs = new String[]{auditRestartType, restartedHostName};
                    this.getAuditService().publishEvent("servers_restart_failed", auditArgs);
                    String[] args = new String[]{restartedHostName};
                    this.getStatusMessage().error("server_restart_failed_alert", "");
                }
                this.updateCachedData();
                restartInProgress = false;
                this.getServerInfo();
            }
        }
        return restartInProgress;
    }

    public String getWarmRestartOnClick() {
        return "javascript: if (confirmWarmRestart(\"" + I18N.getResource("server_restart_warm_popup2") + "\" ) == false) return false";
    }

    public String getColdRestartOnClick() {
        return "javascript: if (confirmColdRestart(\"" + I18N.getResource("server_restart_cold_popup2") + "\" ) == false) return false";
    }

    protected void restart(boolean isColdRestart) {
        if (this.host != null) {
            try {
                RestartServicesTask task = new RestartServicesTask(this.getAdminContext(), this.host, isColdRestart);
                List hosts = this.updateServersList();
                ArrayList restarting = this.updateRestartingList();
                HashMap<String, CachedHost> cachedData = (HashMap<String, CachedHost>)Context.getSessionAttribute(CACHED_DATA);
                if (cachedData == null) {
                    cachedData = new HashMap<String, CachedHost>();
                }
                Context.setSessionAttribute("AllServers", new ObjectListDataProvider(hosts));
                Context.setSessionAttribute("ServersRestarting", restarting);
                this.cachedHost = new CachedHost(this.host, this.getProvider());
                this.cachedHost.setRestartTime(System.currentTimeMillis());
                cachedData.put(this.host.getName(), this.cachedHost);
                Context.setSessionAttribute(CACHED_DATA, cachedData);
                this.host.setRestartStatus("restarting");
                if (isColdRestart) {
                    this.host.setLastRestartType("cold_restart");
                } else {
                    this.host.setLastRestartType("warm_restart");
                }
                task.start();
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error(se);
            }
        }
    }

    private Host getHost(String name) {
        Host result;
        block8: {
            result = null;
            try {
                List hosts = this.getProvider().getHosts();
                if (hosts == null) break block8;
                Iterator it = hosts.iterator();
                while (it.hasNext()) {
                    result = (Host)it.next();
                    if (name.compareTo(result.getName()) != 0) continue;
                    int role = this.getProvider().getReplicationRole(result.getName());
                    switch (role) {
                        case 2: {
                            result.setType(I18N.getResource("server_type_primary"));
                            break;
                        }
                        case 4: {
                            result.setType(I18N.getResource("server_type_secondary"));
                            break;
                        }
                        case 1: {
                            result.setType(I18N.getResource("server_type_standalone"));
                            break;
                        }
                        default: {
                            result.setType(I18N.getResource("server_type_unknown"));
                            break;
                        }
                    }
                    break;
                }
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error(se);
            }
        }
        return result;
    }

    private void initSessionInfo(boolean useCache) {
        if (useCache) {
            this.totalDtus = this.cachedHost.getTotalDtus();
            this.totalUserSessions = this.cachedHost.getTotalUserSessions();
            this.totalDisconnectedUserSessions = this.cachedHost.getTotalDisconnectedUserSessions();
            this.totalGreeterSessions = this.cachedHost.getTotalGreeterSessions();
            this.totalDisconnectedGreeterSessions = this.cachedHost.getTotalDisconnectedGreeterSessions();
        } else {
            this.totalDtus = this.getProvider().getCurrentDTUsNumber(this.name);
            try {
                int[] sessions = this.getProvider().getSessionNumbers(this.name);
                if (sessions != null) {
                    this.totalUserSessions = sessions[0];
                    this.totalDisconnectedUserSessions = sessions[1];
                    this.totalGreeterSessions = sessions[2];
                    this.totalDisconnectedGreeterSessions = sessions[3];
                }
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("sessions_alert_get_numbers", se);
            }
        }
    }

    private void initDiskSpaceInfo(boolean useCache) {
        if (useCache) {
            this.diskSpaceProvider = this.cachedHost.getDiskSpaceInfo();
        } else {
            ArrayList<DiskSpaceInfo> list = new ArrayList<DiskSpaceInfo>();
            try {
                long[] info = this.getProvider().getDiskSpace("/");
                list.add(new DiskSpaceInfo(I18N.getResource("serverDetails_root"), info[2], info[1], info[0]));
                info = this.getProvider().getDiskSpace("/tmp");
                list.add(new DiskSpaceInfo(I18N.getResource("serverDetails_tmp"), info[2], info[1], info[0]));
                info = this.getProvider().getSwapSpace();
                list.add(new DiskSpaceInfo(I18N.getResource("serverDetails_swap"), info[2], info[1], info[0]));
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error(se);
            }
            this.diskSpaceProvider = new ObjectListDataProvider(list);
        }
    }

    private ArrayList updateRestartingList() {
        ArrayList<Host> restarting = (ArrayList<Host>)Context.getSessionAttribute("ServersRestarting");
        if (restarting == null) {
            restarting = new ArrayList<Host>();
            restarting.add(this.host);
        } else {
            boolean isNewRestarter = true;
            for (int i = 0; i < restarting.size(); ++i) {
                Host nextHost = (Host)restarting.get(i);
                if (this.host.getName().compareTo(nextHost.getName()) != 0) continue;
                restarting.set(i, this.host);
                isNewRestarter = false;
            }
            if (isNewRestarter) {
                restarting.add(this.host);
            }
        }
        return restarting;
    }

    private List updateServersList() throws ServiceException {
        ObjectListDataProvider dataProvider = (ObjectListDataProvider)Context.getSessionAttribute("AllServers");
        List<Host> hosts = new ArrayList();
        hosts = dataProvider == null ? this.getProvider().getHosts() : dataProvider.getList();
        for (int i = 0; i < hosts.size(); ++i) {
            Host nextHost = (Host)hosts.get(i);
            if (this.host.getName().compareTo(nextHost.getName()) != 0) continue;
            hosts.set(i, this.host);
        }
        return hosts;
    }

    private boolean isRestartSuccessful(Host server) {
        return !"restart_failed".equals(server.getRestartStatus());
    }

    private boolean isHostRestarting(Host server) {
        return server.getRestartStatus() != null && server.getRestartStatus().equals("restarting");
    }

    private void updateCachedData() {
        ObjectListDataProvider allServers = (ObjectListDataProvider)Context.getSessionAttribute("AllServers");
        ArrayList restartingServers = (ArrayList)Context.getSessionAttribute("ServersRestarting");
        HashMap cachedData = (HashMap)Context.getSessionAttribute(CACHED_DATA);
        if (!this.isAnyServerRestarting(allServers.getList())) {
            Context.setSessionAttribute("AllServers", null);
        }
        if (restartingServers != null) {
            for (int i = 0; i < restartingServers.size(); ++i) {
                Host server = (Host)restartingServers.get(i);
                if (this.host.getName().compareTo(server.getName()) != 0) continue;
                restartingServers.remove(i);
                break;
            }
            if (restartingServers.size() == 0) {
                Context.setSessionAttribute("ServersRestarting", null);
            } else {
                Context.setSessionAttribute("ServersRestarting", restartingServers);
            }
        }
        if (cachedData.get(this.host.getName()) != null) {
            cachedData.remove(this.host.getName());
            this.host = null;
        }
        if (cachedData.isEmpty()) {
            Context.setSessionAttribute(CACHED_DATA, null);
        } else {
            Context.setSessionAttribute(CACHED_DATA, cachedData);
        }
    }

    private boolean isCurrentServerRestarting(ArrayList servers) {
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Host server = (Host)servers.get(i);
                if (this.host.getName().compareTo(server.getName()) != 0 || server.getRestartStatus() == null || !server.getRestartStatus().equals("restarting")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAnyServerRestarting(List servers) {
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Host server = (Host)servers.get(i);
                if (server.getRestartStatus() == null || !server.getRestartStatus().equals("restarting")) continue;
                return true;
            }
        }
        return false;
    }

    private Host getServerFromRestartList(ArrayList servers) {
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Host server = (Host)servers.get(i);
                if (this.host.getName().compareTo(server.getName()) != 0) continue;
                return server;
            }
        }
        return null;
    }

    private boolean isServerInRestartList(ArrayList servers) {
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Host server = (Host)servers.get(i);
                if (this.host.getName().compareTo(server.getName()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isColdRestart(Host server) {
        return !server.getLastRestartType().equals("warm_restart");
    }
}

