/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.tokens;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.Context;
import com.sun.ut.console.I18N;
import com.sun.ut.console.RawTokenWrapper;
import com.sun.ut.console.SelectHelper;
import com.sun.ut.service.LogicalToken;
import com.sun.ut.service.RawToken;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.User;
import com.sun.web.ui.component.TableRowGroup;
import com.sun.web.ui.model.Option;
import java.util.ArrayList;
import java.util.List;

public class TokenHandler
extends BaseHandler {
    public static final String SESSTYPE_DEFAULT = "default";
    public static final String SESSTYPE_KIOSK = "kiosk";
    public static final String SESSTYPE_REGULAR = "regular";
    private List rawTokens;
    private ObjectListDataProvider dataProvider;
    private RawToken selectedToken;
    private User selectedUser;
    private TableRowGroup tableRowGroup;
    private SelectHelper selectHelper = new SelectHelper("#{tokenRowGroup.tableRow}");
    private Option[] sessionTypeOptions;
    private String sessionType = "default";
    private String origSessionType = "default";
    private int totalTokenSessions;
    private boolean isUnregistered;
    private boolean checkedKioskInstalled;
    private boolean isKioskInstalled;

    public TokenHandler() {
        this.getSelectedUser();
        this.getRawTokens();
        ArrayList<Option> options = new ArrayList<Option>();
        options.add(new Option((Object)SESSTYPE_DEFAULT, I18N.getResource("tokens_session_type_default")));
        options.add(new Option((Object)SESSTYPE_KIOSK, I18N.getResource("tokens_session_type_kiosk")));
        options.add(new Option((Object)SESSTYPE_REGULAR, I18N.getResource("tokens_session_type_regular")));
        this.sessionTypeOptions = new Option[options.size()];
        this.sessionTypeOptions = options.toArray(this.sessionTypeOptions);
    }

    public ObjectListDataProvider getRawTokens() {
        if (this.rawTokens == null) {
            String selectedTokenId = (String)Context.getSessionAttribute("selectedTokenId");
            this.rawTokens = new ArrayList();
            if (this.isUnregistered) {
                try {
                    List currentTokens = this.getProvider().getCurrentTokens();
                    for (int j = 0; j < currentTokens.size(); ++j) {
                        RawToken rawToken = (RawToken)currentTokens.get(j);
                        if (!selectedTokenId.equals((rawToken = new RawTokenWrapper(rawToken)).getId())) continue;
                        this.selectedToken = rawToken;
                        this.selectedToken.setEnabled(true);
                    }
                }
                catch (ServiceException se) {
                    this.getLogger().severe(se.toString());
                    this.getStatusMessage().error("tokens_alert_get", se);
                }
            } else {
                List logicalTokenList = this.selectedUser.getLogicalTokens();
                for (int i = 0; i < logicalTokenList.size(); ++i) {
                    LogicalToken logicalToken = (LogicalToken)logicalTokenList.get(i);
                    List tokens = logicalToken.getRawTokens();
                    for (int j = 0; j < tokens.size(); ++j) {
                        RawToken rawToken = (RawToken)tokens.get(j);
                        if (selectedTokenId.equals((rawToken = new RawTokenWrapper(rawToken)).getId())) {
                            this.selectedToken = rawToken;
                            continue;
                        }
                        this.rawTokens.add(rawToken);
                    }
                }
            }
            if (this.selectedToken == null) {
                this.selectedToken = new RawTokenWrapper(new RawToken("", false));
            }
            List sessions = new ArrayList();
            try {
                sessions = this.getProvider().getSessions(selectedTokenId, null);
                this.totalTokenSessions = sessions.size();
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error(se);
            }
        }
        this.dataProvider = new ObjectListDataProvider(this.rawTokens);
        return this.dataProvider;
    }

    public User getSelectedUser() {
        if (this.selectedUser == null) {
            String selectedUserId = (String)Context.getSessionAttribute("selectedUserId");
            try {
                if (selectedUserId == null) {
                    this.isUnregistered = true;
                    this.selectedUser = new User("", "", "", null);
                    this.getStatusMessage().info("tokens_unregistered_alert", "tokens_unregistered_summary");
                } else {
                    this.selectedUser = this.getProvider().getUser(selectedUserId);
                    List logicalTokens = this.selectedUser.getLogicalTokens();
                    if (!logicalTokens.isEmpty()) {
                        LogicalToken logicalToken = (LogicalToken)logicalTokens.get(0);
                        int type = this.getProvider().getSessionType(logicalToken.getId());
                        switch (type) {
                            case 2: {
                                this.sessionType = SESSTYPE_REGULAR;
                                break;
                            }
                            case 1: {
                                this.sessionType = SESSTYPE_KIOSK;
                                break;
                            }
                            default: {
                                this.sessionType = SESSTYPE_DEFAULT;
                            }
                        }
                        this.origSessionType = this.sessionType;
                    }
                }
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("tokens_alert_owner", se);
                this.selectedUser = new User("", "", "", null);
            }
        }
        return this.selectedUser;
    }

    public RawToken getSelectedToken() {
        return this.selectedToken;
    }

    public String edit() {
        this.getStatusMessage().reset();
        return "editTokenDetails";
    }

    public String sessions() {
        this.getStatusMessage().reset();
        return "viewTokenSessions";
    }

    public String delete() {
        RowKey[] rowKeys = this.tableRowGroup.getRenderedSelectedRowKeys();
        if (rowKeys == null) {
            return "success";
        }
        ObjectListDataProvider oldp = this.getRawTokens();
        ArrayList<String> deletedTokens = new ArrayList<String>();
        String tokenId = null;
        for (int i = 0; i < rowKeys.length; ++i) {
            RowKey rowKey = rowKeys[i];
            RawToken rawToken = (RawToken)oldp.getObject(rowKey);
            try {
                this.getProvider().deleteToken(rawToken.getId());
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("tokens_alert_delete", se);
                return "";
            }
            deletedTokens.add(rawToken.getId());
            if (i != 0) continue;
            tokenId = rawToken.getId();
        }
        this.rawTokens = null;
        this.selectedUser = null;
        this.selectHelper.clear();
        String tokens = "";
        if (deletedTokens.size() != 0) {
            tokens = tokens + "[";
            for (int i = 0; i < deletedTokens.size(); ++i) {
                tokens = i == 0 ? tokens + (String)deletedTokens.get(i) : tokens + ", " + (String)deletedTokens.get(i);
            }
            tokens = tokens + "]";
        }
        Object[] args = new Object[]{tokens};
        this.getAuditService().publishEvent("Users", "token_removed", args, 0);
        this.getStatusMessage().info("alert_stored_changes", "tokens_delete");
        return "success";
    }

    public String enable() {
        RowKey[] rowKeys = this.tableRowGroup.getRenderedSelectedRowKeys();
        if (rowKeys == null) {
            return "success";
        }
        ObjectListDataProvider oldp = this.getRawTokens();
        ArrayList<String> enabledTokens = new ArrayList<String>();
        String tokenId = null;
        for (int i = 0; i < rowKeys.length; ++i) {
            RowKey rowKey = rowKeys[i];
            RawToken rawToken = (RawToken)oldp.getObject(rowKey);
            try {
                this.getProvider().modifyToken(rawToken.getId(), true);
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("tokens_alert_modify", se);
                return "";
            }
            enabledTokens.add(rawToken.getId());
            if (i != 0) continue;
            tokenId = rawToken.getId();
        }
        this.rawTokens = null;
        this.selectedUser = null;
        this.selectHelper.clear();
        String tokens = "";
        if (enabledTokens.size() != 0) {
            tokens = tokens + "[";
            for (int i = 0; i < enabledTokens.size(); ++i) {
                tokens = i == 0 ? tokens + (String)enabledTokens.get(i) : tokens + ", " + (String)enabledTokens.get(i);
            }
            tokens = tokens + "]";
        }
        Object[] args = new Object[]{tokens};
        this.getAuditService().publishEvent("Users", "token_enabled", args, 0);
        this.getStatusMessage().info("alert_stored_changes", "tokens_enable");
        return "success";
    }

    public String disable() {
        RowKey[] rowKeys = this.tableRowGroup.getRenderedSelectedRowKeys();
        if (rowKeys == null) {
            return "success";
        }
        ObjectListDataProvider oldp = this.getRawTokens();
        ArrayList<String> disabledTokens = new ArrayList<String>();
        String tokenId = null;
        for (int i = 0; i < rowKeys.length; ++i) {
            RowKey rowKey = rowKeys[i];
            RawToken rawToken = (RawToken)oldp.getObject(rowKey);
            try {
                this.getProvider().modifyToken(rawToken.getId(), false);
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("tokens_alert_modify", se);
                return "";
            }
            disabledTokens.add(rawToken.getId());
            if (i != 0) continue;
            tokenId = rawToken.getId();
        }
        this.rawTokens = null;
        this.selectedUser = null;
        this.selectHelper.clear();
        String tokens = "";
        if (disabledTokens.size() != 0) {
            tokens = tokens + "[";
            for (int i = 0; i < disabledTokens.size(); ++i) {
                tokens = i == 0 ? tokens + (String)disabledTokens.get(i) : tokens + ", " + (String)disabledTokens.get(i);
            }
            tokens = tokens + "]";
        }
        Object[] args = new Object[]{tokens};
        this.getAuditService().publishEvent("Users", "token_disabled", args, 0);
        this.getStatusMessage().info("alert_stored_changes", "tokens_disable");
        return "success";
    }

    public String modify() {
        User user = this.getSelectedUser();
        RawToken rawToken = this.getSelectedToken();
        try {
            String auditUser;
            if (this.isUnregistered) {
                String userId = this.getProvider().addUser(user.getUserName(), user.getDescription(), rawToken.getId());
                user = this.getProvider().getUser(userId);
                Context.setSessionAttribute("selectedUserId", userId);
            } else {
                this.getProvider().modifyUser(user.getId(), user.getUserName(), user.getDescription());
            }
            this.getProvider().modifyToken(rawToken.getId(), rawToken.isEnabled());
            List logicalTokens = user.getLogicalTokens();
            if (!logicalTokens.isEmpty()) {
                LogicalToken logicalToken = (LogicalToken)logicalTokens.get(0);
                String id = logicalToken.getId();
                if (this.sessionType.equals(SESSTYPE_REGULAR)) {
                    this.getProvider().setSessionType(id, 2);
                } else if (this.sessionType.equals(SESSTYPE_KIOSK)) {
                    this.getProvider().setSessionType(id, 1);
                } else {
                    this.getProvider().setSessionType(id, 0);
                }
            }
            if ((auditUser = user.getUserName()) == null) {
                auditUser = "";
            }
            String status = this.getAuditService().getMessage("token_status_disabled");
            if (rawToken.isEnabled()) {
                status = this.getAuditService().getMessage("token_status_enabled");
            }
            String alertDetails = "tokens_modify";
            if (!this.origSessionType.equals(this.sessionType)) {
                alertDetails = "tokens_modify_session_changed";
            }
            if (this.isKioskInstalled()) {
                Object[] args = new Object[]{rawToken.getId(), auditUser, status, user.getDescription(), this.sessionType};
                this.getAuditService().publishEvent("Users", "token_edit", args, 0);
            } else {
                Object[] args = new Object[]{rawToken.getId(), auditUser, status, user.getDescription()};
                this.getAuditService().publishEvent("Users", "token_edit_no_session", args, 0);
            }
            this.getStatusMessage().info("alert_stored_changes", alertDetails, true);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("tokens_alert_modify", se);
            return "";
        }
        this.selectHelper.clear();
        return "viewTokenDetails";
    }

    public TableRowGroup getTableRowGroup() {
        return this.tableRowGroup;
    }

    public void setTableRowGroup(TableRowGroup tableRowGroup) {
        this.tableRowGroup = tableRowGroup;
    }

    public SelectHelper getSelectHelper() {
        return this.selectHelper;
    }

    public Option[] getSessionTypeOptions() {
        return this.sessionTypeOptions;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(String type) {
        this.sessionType = type;
    }

    public int getTotalTokenSessions() {
        return this.totalTokenSessions;
    }

    public void setTotalTokenSessions(int num) {
        this.totalTokenSessions = num;
    }

    public boolean isUnregistered() {
        return this.isUnregistered;
    }

    public String getSessionTypeDescription() {
        if (this.sessionType.equals(SESSTYPE_REGULAR)) {
            return I18N.getResource("tokens_session_type_regular");
        }
        if (this.sessionType.equals(SESSTYPE_KIOSK)) {
            return I18N.getResource("tokens_session_type_kiosk");
        }
        return I18N.getResource("tokens_session_type_default");
    }

    public boolean isKioskInstalled() {
        if (!this.checkedKioskInstalled) {
            this.isKioskInstalled = this.getProvider().isKioskInstalled();
            this.checkedKioskInstalled = true;
        }
        return this.isKioskInstalled;
    }

    public String getBackToLabel() {
        Object[] args = new Object[]{this.getSelectedToken().getId()};
        return I18N.getResource("back_to_button2", args);
    }
}

