/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import com.sun.ut.service.AuditService;
import com.sun.ut.service.Provider;
import com.sun.ut.service.authentication.LoginModule;
import com.sun.ut.service.jni.Datastore;
import com.sun.ut.service.jni.DatastoreFactory;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdminContext
implements Serializable {
    public static final String USERNAME = "Username";
    public static final String CLIENT_ID = "Client ID";
    public static final String START_TIME = "Start Time";
    public static final String LOG_LEVEL = "LogLevel";
    public static final String SECONDARY_SERVER = "isSecondaryServer";
    public static final String KIOSK_INSTALLED = "isKioskInstalled";
    public static final String LOG_FILE_NAME = "utwebadmin";
    private Hashtable env;
    private transient Provider provider;
    private transient AuditService auditService;
    private transient LoginModule loginModule;
    private transient String hostName;
    private transient Datastore datastore;
    private transient boolean initialized = false;
    private static transient Logger logger;

    public AdminContext() {
        this.env = new Hashtable();
        this.init();
    }

    public AdminContext(Hashtable env) {
        this.env = env;
        this.init();
    }

    public Hashtable getEnvironment() {
        return this.env;
    }

    void setProvider(Provider newProvider) {
        this.provider = newProvider;
    }

    public Provider getProvider() {
        return this.provider;
    }

    void setAuditService(AuditService service) {
        this.auditService = service;
    }

    public AuditService getAuditService() {
        return this.auditService;
    }

    public String getUserName() {
        return (String)this.env.get(USERNAME);
    }

    public void setUserName(String userName) {
        this.env.put(USERNAME, userName);
    }

    void setHostName(String name) {
        this.hostName = name;
    }

    public String getHostName() {
        return this.hostName;
    }

    Datastore getDatastore() {
        return this.datastore;
    }

    void setLoginModule(LoginModule module) {
        this.loginModule = module;
    }

    public LoginModule getLoginModule() {
        return this.loginModule;
    }

    public void init() {
        if (!this.initialized) {
            this.hostName = this.determineHostName();
            this.datastore = DatastoreFactory.getDatastore();
            this.loginModule = new LoginModule();
            this.auditService = new AuditService();
            this.provider = new Provider();
            this.auditService.init(this);
            this.provider.init(this);
            this.initialized = true;
        }
    }

    public void release() {
        this.provider.release();
        this.auditService.release();
        this.datastore = null;
        this.provider = null;
        this.auditService = null;
        this.loginModule = null;
        this.env = null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean state) {
        this.initialized = state;
    }

    public Logger getLogger() {
        if (logger == null) {
            logger = Logger.getAnonymousLogger();
            logger.setUseParentHandlers(false);
            logger.setLevel(this.getLogLevel());
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            logger.addHandler(consoleHandler);
        }
        return logger;
    }

    protected Level getLogLevel() {
        Level logLevel = null;
        String logLevelValue = (String)this.env.get(LOG_LEVEL);
        if (logLevelValue != null) {
            try {
                logLevel = Level.parse(logLevelValue);
            }
            catch (IllegalArgumentException ex) {
                logLevel = Level.SEVERE;
            }
        } else {
            logLevel = Level.SEVERE;
        }
        return logLevel;
    }

    protected String determineHostName() {
        String result = "localhost";
        try {
            result = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }
}

