/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import com.sun.ut.service.MultiheadGroup;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DesktopUnit {
    public static final String DEFAULT_NAMESPACE = "IEEE802";
    public static final int CLIENT_KEY_UNCONFIRMED = 0;
    public static final int CLIENT_KEY_CONFIRMED = 1;
    public static final int CLIENT_KEY_NEW = 2;
    public static final int CLIENT_KEY_AUTOCONFIRMED = 3;
    public static final int CLIENT_KEY_CONFLICT = 4;
    public static final int CLIENT_KEY_INVALID = 5;
    private static final int ONE_SECOND = 1000;
    private String id;
    private String location = "";
    private String description = "";
    private String model;
    private String firmwareRev;
    private String group;
    private String server;
    private List clientKeys;
    private int clientKeyStatus;
    private String namespace;
    private Date lastStatusUpdate;
    private Date firstConnection;
    private boolean isTokenReader;
    private boolean isRegistered;
    private MultiheadGroup multiheadGroup;

    public DesktopUnit(String id, boolean isTokenReader, String group, String namespace, boolean isRegistered) {
        this(id, null, null, null, null, null, null, null, null, 0, isTokenReader, group, namespace, isRegistered);
    }

    public DesktopUnit(String id, String location, String description, String model, String firmwareRev, String server, String firstConnection, String lastStatusUpdate, List clientKeys, int clientKeyStatus, boolean isTokenReader, String group, String namespace, boolean isRegistered) {
        this.id = id;
        if (location != null) {
            this.location = location;
        }
        if (description != null) {
            this.description = description;
        }
        this.model = model;
        this.firmwareRev = firmwareRev;
        this.server = server;
        this.lastStatusUpdate = this.getDateForString(lastStatusUpdate);
        this.clientKeys = clientKeys;
        this.clientKeyStatus = clientKeyStatus;
        this.firstConnection = this.getDateForString(firstConnection);
        this.isTokenReader = isTokenReader;
        this.isRegistered = isRegistered;
        this.group = group;
        this.namespace = namespace != null && namespace.length() > 0 ? namespace : DEFAULT_NAMESPACE;
    }

    private Date getDateForString(String time) {
        Date result = null;
        if (time != null && time.length() > 0) {
            try {
                result = new Date(Long.parseLong(time) * 1000L);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getCanonicalId() {
        StringBuffer buffer = new StringBuffer(this.namespace);
        buffer.append(".");
        buffer.append(this.id);
        return buffer.toString();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModel() {
        return this.model;
    }

    public String getFirmwareRev() {
        return this.firmwareRev;
    }

    public Date getFirstConnection() {
        return this.firstConnection;
    }

    public Date getLastUpdate() {
        return this.lastStatusUpdate;
    }

    public boolean isClientKeyUnconfirmed() {
        return this.clientKeyStatus == 0;
    }

    public boolean isClientKeyConfirmed() {
        return this.clientKeyStatus == 1;
    }

    public boolean isClientKeyAutomatic() {
        return this.clientKeyStatus == 3;
    }

    public boolean isClientKeyConflicting() {
        return this.clientKeyStatus == 4;
    }

    public boolean isClientKeyInvalid() {
        return this.clientKeyStatus == 5;
    }

    public boolean isClientKeyNew() {
        return this.clientKeyStatus == 2;
    }

    public int getClientKeyStatus() {
        return this.clientKeyStatus;
    }

    public List getClientKeys() {
        return this.clientKeys;
    }

    public void setClientKeys(ArrayList clientKeys) {
        this.clientKeys = clientKeys;
    }

    public boolean isTokenReader() {
        return this.isTokenReader;
    }

    public boolean isConnected() {
        return this.server != null;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getCurrentTokenId() {
        return null;
    }

    public String getServer() {
        return this.server;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    private String[] convertIdsForDisplay(String[] dtuIds) {
        for (int i = 0; i < dtuIds.length; ++i) {
            if (!dtuIds[i].startsWith(DEFAULT_NAMESPACE)) continue;
            dtuIds[i] = dtuIds[i].substring(DEFAULT_NAMESPACE.length() + 1);
        }
        return dtuIds;
    }

    public void setMultiheadGroup(MultiheadGroup multiheadGroup) {
        this.multiheadGroup = multiheadGroup;
    }

    public MultiheadGroup getMultiheadGroup() {
        return this.multiheadGroup;
    }
}

