/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model.scheduler;

import com.sun.web.ui.model.scheduler.RepeatUnit;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.Serializable;
import javax.faces.context.FacesContext;

public class RepeatInterval
implements Serializable {
    public static final String ONETIME = "ONETIME";
    public static final String HOURLY = "HOURLY";
    public static final String DAILY = "DAILY";
    public static final String WEEKLY = "WEEKLY";
    public static final String MONTHLY = "MONTHLY";
    private static final boolean DEBUG = false;
    private static RepeatInterval ONETIME_RI = null;
    private static RepeatInterval HOURLY_RI = null;
    private static RepeatInterval DAILY_RI = null;
    private static RepeatInterval WEEKLY_RI = null;
    private static RepeatInterval MONTHLY_RI = null;
    private Integer calField = null;
    private String key = null;
    private String representation = null;
    private String defaultRepeatUnitString = null;

    public RepeatInterval() {
    }

    public RepeatInterval(int calFieldInt, String key, String rep, String repUnit) {
        this.calField = new Integer(calFieldInt);
        this.key = key;
        this.representation = rep;
        this.defaultRepeatUnitString = repUnit;
    }

    public static RepeatInterval getInstance(String representation) {
        if (representation.equals(ONETIME)) {
            if (ONETIME_RI == null) {
                ONETIME_RI = new RepeatInterval(-1, "Scheduler.oneTime", ONETIME, null);
            }
            return ONETIME_RI;
        }
        if (representation.equals(HOURLY)) {
            if (HOURLY_RI == null) {
                HOURLY_RI = new RepeatInterval(11, "Scheduler.hourly", HOURLY, "HOURS");
            }
            return HOURLY_RI;
        }
        if (representation.equals(DAILY)) {
            if (DAILY_RI == null) {
                DAILY_RI = new RepeatInterval(5, "Scheduler.daily", DAILY, "DAYS");
            }
            return DAILY_RI;
        }
        if (representation.equals(WEEKLY)) {
            if (WEEKLY_RI == null) {
                WEEKLY_RI = new RepeatInterval(3, "Scheduler.weekly", WEEKLY, "WEEKS");
            }
            return WEEKLY_RI;
        }
        if (representation.equals(MONTHLY)) {
            if (MONTHLY_RI == null) {
                MONTHLY_RI = new RepeatInterval(2, "Scheduler.monthly", MONTHLY, "MONTHS");
            }
            return MONTHLY_RI;
        }
        return null;
    }

    public Integer getCalendarField() {
        return this.calField;
    }

    public void setCalendarField(Integer calField) {
        this.calField = calField;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setRepresentation(String representation) {
        this.representation = representation;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public String getLabel(FacesContext context) {
        return ThemeUtilities.getTheme(context).getMessage(this.key);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RepeatInterval)) {
            return false;
        }
        RepeatInterval ri = (RepeatInterval)object;
        if (this.getCalendarField() == null ? ri.getCalendarField() != null : !this.getCalendarField().equals(ri.getCalendarField())) {
            return false;
        }
        if (this.getRepresentation() == null ? ri.getRepresentation() != null : !this.getRepresentation().equals(ri.getRepresentation())) {
            return false;
        }
        return !(this.getKey() == null ? ri.getKey() != null : !this.getKey().equals(ri.getKey()));
    }

    public RepeatUnit getDefaultRepeatUnit() {
        if (this.defaultRepeatUnitString == null) {
            return null;
        }
        return RepeatUnit.getInstance(this.defaultRepeatUnitString);
    }

    private static void log(String s) {
        System.out.println("RepeatInterval::" + s);
    }
}

