/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;

public class ConversionUtilities {
    private static final String RENDERED_NULL_VALUE = "_RENDERED_NULL_VALUE_";
    private static final boolean DEBUG = false;
    private static final String RENDERED_TABLE_NULL_VALUES = "_RENDERED_TABLE_NULL_VALUES_";

    public static Object convertValueToObject(UIComponent component, String rawValue, FacesContext context) throws ConverterException {
        if (rawValue == null || !(component instanceof ValueHolder)) {
            return rawValue;
        }
        ValueHolder valueHolder = (ValueHolder)component;
        Converter converter = valueHolder.getConverter();
        if (converter == null) {
            Class<?> clazz = null;
            ValueBinding valueBinding = component.getValueBinding("value");
            if (valueBinding == null) {
                Object value = valueHolder.getValue();
                if (value == null) {
                    return rawValue;
                }
                clazz = value.getClass();
            } else {
                clazz = valueBinding.getType(context);
            }
            if (clazz == null || clazz.equals(String.class) || clazz.equals(Object.class)) {
                return rawValue;
            }
            converter = ConversionUtilities.getConverterForClass(clazz);
            if (converter == null) {
                return rawValue;
            }
        }
        return converter.getAsObject(context, component, rawValue);
    }

    public static Object convertValueToArray(UIComponent component, String[] rawValues, FacesContext context) throws ConverterException {
        if (rawValues == null) {
            return null;
        }
        Class clazz = null;
        Converter converter = ((ValueHolder)component).getConverter();
        try {
            clazz = component.getValueBinding("value").getType(context).getComponentType();
        }
        catch (Exception ex) {
            Object value = ((ValueHolder)component).getValue();
            if (value == null) {
                clazz = converter != null ? Object.class : String.class;
            }
            clazz = value.getClass().getComponentType();
        }
        if (clazz.equals(String.class)) {
            return rawValues;
        }
        int arraySize = 0;
        arraySize = rawValues.length;
        Object valueArray = Array.newInstance(clazz, arraySize);
        if (arraySize == 0) {
            return valueArray;
        }
        if (converter == null) {
            converter = ConversionUtilities.getConverterForClass(clazz);
        }
        if (converter == null) {
            if (clazz.equals(Object.class)) {
                return rawValues;
            }
            String valueString = "";
            for (int counter = 0; counter < rawValues.length; ++counter) {
                valueString = valueString + " " + rawValues[counter];
            }
            Object[] params = new Object[]{valueString, "null Converter"};
            String message = "Could not find converter for " + valueString;
            throw new ConverterException(message);
        }
        if (clazz.isPrimitive()) {
            for (int counter = 0; counter < arraySize; ++counter) {
                ConversionUtilities.addPrimitiveToArray(component, context, converter, clazz, valueArray, counter, rawValues[counter]);
            }
        } else {
            for (int counter = 0; counter < arraySize; ++counter) {
                Array.set(valueArray, counter, converter.getAsObject(context, component, rawValues[counter]));
            }
        }
        return valueArray;
    }

    private static void addPrimitiveToArray(UIComponent component, FacesContext context, Converter converter, Class clazz, Object valueArray, int arrayIndex, String rawValue) {
        Object valueObject = converter.getAsObject(context, component, rawValue);
        if (clazz.equals(Boolean.TYPE)) {
            boolean value = (Boolean)valueObject;
            Array.setBoolean(valueArray, arrayIndex, value);
        } else if (clazz.equals(Byte.TYPE)) {
            byte value = (Byte)valueObject;
            Array.setByte(valueArray, arrayIndex, value);
        } else if (clazz.equals(Double.TYPE)) {
            double value = (Double)valueObject;
            Array.setDouble(valueArray, arrayIndex, value);
        } else if (clazz.equals(Float.TYPE)) {
            float value = ((Float)valueObject).floatValue();
            Array.setFloat(valueArray, arrayIndex, value);
        } else if (clazz.equals(Integer.TYPE)) {
            int value = (Integer)valueObject;
            Array.setInt(valueArray, arrayIndex, value);
        } else if (clazz.equals(Character.TYPE)) {
            char value = ((Character)valueObject).charValue();
            Array.setChar(valueArray, arrayIndex, value);
        } else if (clazz.equals(Short.TYPE)) {
            short value = (Short)valueObject;
            Array.setShort(valueArray, arrayIndex, value);
        } else if (clazz.equals(Long.TYPE)) {
            long value = (Long)valueObject;
            Array.setLong(valueArray, arrayIndex, value);
        }
    }

    public static Object convertValueToList(UIComponent component, String[] rawValues, FacesContext context) throws ConverterException {
        if (rawValues == null) {
            return null;
        }
        Class clazz = null;
        Converter converter = ((ValueHolder)component).getConverter();
        try {
            clazz = component.getValueBinding("value").getType(context).getComponentType();
        }
        catch (Exception ex) {
            Object value = ((ValueHolder)component).getValue();
            if (value == null) {
                clazz = converter != null ? Object.class : String.class;
            }
            clazz = value.getClass().getComponentType();
        }
        AbstractList list = null;
        try {
            list = (ArrayList)clazz.newInstance();
        }
        catch (Throwable problem) {
            if (clazz.isAssignableFrom(ArrayList.class)) {
                list = new ArrayList();
            }
            if (clazz.isAssignableFrom(LinkedList.class)) {
                list = new LinkedList();
            }
            if (clazz.isAssignableFrom(Vector.class)) {
                list = new Vector();
            }
            String message = "Unable to convert the value of component " + component.toString() + ". The type of the " + "value object must be a class that can be " + "instantiated, or it must be assignable " + "from ArrayList, LinkedList or Vector.";
            throw new ConverterException(message, problem);
        }
        int listSize = 0;
        listSize = rawValues.length;
        if (listSize == 0) {
            return list;
        }
        if (converter == null) {
            for (int arrayIndex = 0; arrayIndex < listSize; ++arrayIndex) {
                list.add(rawValues[arrayIndex]);
            }
        } else {
            for (int arrayIndex = 0; arrayIndex < listSize; ++arrayIndex) {
                list.add(converter.getAsObject(context, component, rawValues[arrayIndex]));
            }
        }
        return list;
    }

    public static String convertValueToString(UIComponent component, Object realValue) throws ConverterException {
        if (realValue == null) {
            return new String();
        }
        if (realValue instanceof String) {
            return (String)realValue;
        }
        if (!(component instanceof ValueHolder)) {
            return String.valueOf(realValue);
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null && (converter = ConversionUtilities.getConverterForClass(realValue.getClass())) == null) {
            return String.valueOf(realValue);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return converter.getAsString(context, component, realValue);
    }

    public static Converter getConverterForClass(Class converterClass) {
        if (converterClass == null) {
            return null;
        }
        try {
            ApplicationFactory aFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            Application application = aFactory.getApplication();
            return application.createConverter(converterClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    static void log(String s) {
        System.out.println("ConversionUtilities::" + s);
    }

    public static Object convertRenderedValue(FacesContext context, Object submittedValue, UIComponent component) throws ConverterException {
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null && ConversionUtilities.renderedNull(component) && submittedValue instanceof String && ((String)submittedValue).length() == 0) {
            return null;
        }
        return ConversionUtilities.convertValueToObject(component, (String)submittedValue, context);
    }

    public static void setRenderedValue(UIComponent component, Object value) {
        component.getAttributes().remove(RENDERED_NULL_VALUE);
        if (value == null) {
            component.getAttributes().put(RENDERED_NULL_VALUE, Boolean.TRUE);
        }
    }

    public static boolean renderedNull(UIComponent component) {
        return (Boolean)component.getAttributes().get(RENDERED_NULL_VALUE) != null;
    }

    public static void removeRenderedValue(UIComponent component) {
        component.getAttributes().remove(RENDERED_NULL_VALUE);
    }

    public static void saveRenderedValueState(FacesContext context, UIComponent component) {
        boolean renderedNullValue = ConversionUtilities.renderedNull(component);
        HashMap<String, Object> rv = (HashMap<String, Object>)component.getAttributes().get(RENDERED_TABLE_NULL_VALUES);
        if (rv == null) {
            if (renderedNullValue) {
                rv = new HashMap<String, Object>();
                component.getAttributes().put(RENDERED_TABLE_NULL_VALUES, rv);
                rv.put(component.getClientId(context), null);
                component.getAttributes().remove(RENDERED_NULL_VALUE);
            }
        } else if (!renderedNullValue) {
            rv.remove(component.getClientId(context));
        } else {
            rv.put(component.getClientId(context), null);
            ConversionUtilities.removeRenderedValue(component);
        }
    }

    public static void restoreRenderedValueState(FacesContext context, UIComponent component) {
        HashMap rv = (HashMap)component.getAttributes().get(RENDERED_TABLE_NULL_VALUES);
        if (rv != null && rv.containsKey(component.getClientId(context))) {
            ConversionUtilities.setRenderedValue(component, null);
        }
    }

    public static void removeSavedRenderedValueState(UIComponent component) {
        component.getAttributes().remove(RENDERED_TABLE_NULL_VALUES);
    }
}

