/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.session;

import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.I18N;
import com.sun.ut.service.Host;
import com.sun.ut.service.ServiceException;
import com.sun.web.ui.model.Option;
import com.sun.web.ui.model.OptionGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SearchCriteria
extends BaseHandler {
    public static final String ALL = "all";
    public static final String DEFAULT_SEARCH_STRING = "*";
    private Option[] filterOptions;
    private String filter;
    private String searchString;

    public SearchCriteria() {
        this.setFilter(ALL);
        this.setSearchString(DEFAULT_SEARCH_STRING);
        this.getOptions();
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString.length() == 0 ? DEFAULT_SEARCH_STRING : searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public Option[] getOptions() {
        if (this.filterOptions == null) {
            List list = new ArrayList();
            try {
                list = this.getProvider().getHosts();
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error(se);
            }
            Option[] serverOptions = new Option[list.size()];
            Iterator it = list.iterator();
            for (int i = 0; i < serverOptions.length; ++i) {
                Host host = (Host)it.next();
                serverOptions[i] = new Option((Object)host.getName(), host.getName());
            }
            OptionGroup group = new OptionGroup();
            group.setLabel(I18N.getResource("sessions_filter_label"));
            group.setOptions(serverOptions);
            this.filterOptions = new Option[2];
            this.filterOptions[0] = new Option((Object)ALL, I18N.getResource("sessions_filter_all"));
            this.filterOptions[1] = group;
        }
        return this.filterOptions;
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        if (!this.filter.equals(ALL)) {
            buffer.append(this.filter);
        } else {
            buffer.append(I18N.getResource("sessions_filter_all"));
        }
        if (!this.searchString.equals(DEFAULT_SEARCH_STRING)) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("\"");
            buffer.append(this.searchString);
            buffer.append("\"");
        }
        return buffer.toString();
    }

    public boolean isSearchActive() {
        if (!this.searchString.equals(DEFAULT_SEARCH_STRING)) {
            return true;
        }
        return !this.filter.equals(ALL);
    }

    public String cancelSearch() {
        this.setFilter(ALL);
        this.setSearchString(DEFAULT_SEARCH_STRING);
        return "success";
    }
}

