/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.jni;

import com.sun.ut.service.Security;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.jni.Datastore;
import com.sun.ut.service.jni.DatastoreFactory;
import junit.framework.TestCase;

public class SecurityTest
extends TestCase {
    private Datastore ds;

    protected final void setUp() throws ServiceException {
        this.ds = DatastoreFactory.getDatastore();
        Security security = new Security(false, false, false, false, 0, 0);
        this.ds.saveSecurity(security.getContent());
    }

    protected final void tearDown() {
        this.ds = null;
    }

    protected void assertSecurity(boolean encUp, boolean encDown, boolean authUp, boolean authDown, int encMode, int clientMode) throws ServiceException {
        String content = this.ds.getSecurity();
        Security security = new Security(content);
        SecurityTest.assertTrue((security.isEncUp() == encUp ? 1 : 0) != 0);
        SecurityTest.assertTrue((security.isEncDown() == encDown ? 1 : 0) != 0);
        SecurityTest.assertTrue((security.isAuthUp() == authUp ? 1 : 0) != 0);
        SecurityTest.assertTrue((security.isAuthDown() == authDown ? 1 : 0) != 0);
        SecurityTest.assertTrue((security.getEncryptionMode() == encMode ? 1 : 0) != 0);
        SecurityTest.assertTrue((security.getClientMode() == clientMode ? 1 : 0) != 0);
    }

    public void testGetSecurity() throws ServiceException {
        this.assertSecurity(false, false, false, false, 0, 0);
    }

    public void testSetEncUp() throws ServiceException {
        Security security = new Security(true, false, false, false, 0, 0);
        this.ds.saveSecurity(security.getContent());
        this.assertSecurity(true, false, false, false, 0, 0);
        security = new Security(false, false, false, false, 0, 0);
        this.ds.saveSecurity(security.getContent());
        this.assertSecurity(false, false, false, false, 0, 0);
    }

    public void testSetEncDown() throws ServiceException {
        Security security = new Security(false, true, false, false, 0, 0);
        this.ds.saveSecurity(security.getContent());
        this.assertSecurity(false, true, false, false, 0, 0);
        security = new Security(false, false, false, false, 0, 0);
        this.ds.saveSecurity(security.getContent());
        this.assertSecurity(false, false, false, false, 0, 0);
    }

    public void testSetAuthDown() throws ServiceException {
        Security security = new Security(false, false, false, true, 0, 0);
        this.ds.saveSecurity(security.getContent());
        this.assertSecurity(false, false, false, true, 0, 0);
        security = new Security(false, false, false, false, 0, 0);
        this.ds.saveSecurity(security.getContent());
        this.assertSecurity(false, false, false, false, 0, 0);
    }

    public void testSetAuthUp() throws ServiceException {
        Security security = new Security(false, false, true, false, 0, 0);
        this.ds.saveSecurity(security.getContent());
        this.assertSecurity(false, false, true, false, 0, 0);
        security = new Security(false, false, false, false, 0, 0);
        this.ds.saveSecurity(security.getContent());
        this.assertSecurity(false, false, false, false, 0, 0);
    }

    public void testSetMode() throws ServiceException {
        Security security = new Security(false, false, false, false, 1, 0);
        this.ds.saveSecurity(security.getContent());
        this.assertSecurity(false, false, false, false, 1, 0);
        security = new Security(false, false, false, false, 0, 0);
        this.ds.saveSecurity(security.getContent());
        this.assertSecurity(false, false, false, false, 0, 0);
    }

    public void testSetClientMode() throws ServiceException {
        Security security = new Security(false, false, false, false, 0, 1);
        this.ds.saveSecurity(security.getContent());
        this.assertSecurity(false, false, false, false, 0, 1);
        security = new Security(false, false, false, false, 0, 0);
        this.ds.saveSecurity(security.getContent());
        this.assertSecurity(false, false, false, false, 0, 0);
    }
}

