/*
 * Decompiled with CFR 0.152.
 */
package auth.module.TerminalGroup;

import auth.sdk.AccessControl;
import auth.sdk.Authentication;
import auth.sdk.AuthenticationClient;
import auth.sdk.Log;
import java.util.Hashtable;

public final class TerminalGroupClient
implements AuthenticationClient {
    private AccessControl access;
    private String myTokenType = null;
    private String myTokenId = null;
    private String localName;
    private String globalName;
    private Authentication module;
    private boolean orphaned;
    private boolean redirected;
    private String primaryId;
    private String myId;

    TerminalGroupClient(AccessControl access, Authentication module, String name, String primary) {
        this.access = access;
        this.module = module;
        this.localName = name;
        this.globalName = access.mapModuleToGlobalName(this.localName);
        this.primaryId = primary;
        this.myId = name;
        this.orphaned = false;
        this.redirected = false;
    }

    public void close() {
        Log.notice((String)"TerminalGroupClient.close");
    }

    public boolean connReq(Hashtable param) {
        if (this.orphaned) {
            return this.access.connect("waiting for primary");
        }
        if (!this.redirected) {
            return this.access.connect("joining group");
        }
        return true;
    }

    public String getGlobalName() {
        return this.globalName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getModuleName() {
        return this.module.getName();
    }

    public String getServiceInitCommand() {
        if (this.orphaned) {
            String command = this.access.getServiceStartCommand("waitforprimary");
            command = String.valueOf(command) + " -- " + this.primaryId;
            return command;
        }
        return null;
    }

    public String getSessionManagerId() {
        return String.valueOf(this.access.getDefaultSessionHost()) + ":" + this.access.getDefaultSessionPort();
    }

    public void isOrphan() {
        this.orphaned = true;
    }

    public void isRedir() {
        this.redirected = true;
    }

    public boolean message(String command, Hashtable param) {
        if (this.redirected) {
            return false;
        }
        if (command.equals("discReq")) {
            this.access.disconnect("discReq-or-terminated");
            return false;
        }
        if (command.equals("discRsp")) {
            this.access.disconnect("discRsp");
            return false;
        }
        return true;
    }

    public void setLocalName(String name) {
        this.localName = name;
        this.globalName = this.access.mapModuleToGlobalName(this.localName);
    }
}

