/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.server;

import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.server.OCFCardHandle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class OCFClientHandle
implements Serializable {
    private long _uid;
    private long _value;
    private String _appName;
    private String _display;
    private String _filterKey;
    private Hashtable _lockedCards;
    private boolean _isRegistered = false;

    public OCFClientHandle(String string, long l, long l2, String string2, String string3) {
        this._uid = l2;
        this._appName = string;
        this._value = l;
        this._lockedCards = new Hashtable();
        this._isRegistered = true;
        this._display = string2;
        this._filterKey = string3;
    }

    void addLockedCard(OCFCardHandle oCFCardHandle) {
        this.debug("addLockedCard", "");
        this._lockedCards.put(oCFCardHandle, "");
    }

    void close() {
        this.debug("close", "");
        Enumeration enumeration = this._lockedCards.keys();
        while (enumeration.hasMoreElements()) {
            OCFCardHandle oCFCardHandle = (OCFCardHandle)enumeration.nextElement();
            oCFCardHandle.unlock(this);
        }
        this._isRegistered = false;
    }

    void debug(String string, String string2) {
        try {
            OCFDebug.debugln("OCFClientHandle::" + string + " " + string2);
        }
        catch (Exception exception) {}
    }

    public boolean equals(OCFClientHandle oCFClientHandle) {
        return oCFClientHandle.getValue() == this._value;
    }

    public String getDisplay() {
        return this._display;
    }

    public String getFilterKey() {
        return this._filterKey;
    }

    public String getName() {
        return this._appName;
    }

    public long getUID() {
        return this._uid;
    }

    public long getValue() {
        return this._value;
    }

    boolean isRegistered() {
        return this._isRegistered;
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    void removeLockedCard(OCFCardHandle oCFCardHandle) {
        this.debug("removeLockedCard", "");
        this._lockedCards.remove(oCFCardHandle);
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "Client handle app name  = " + this._appName;
        string = String.valueOf(string) + "\nClient handle value = " + this._value;
        return string;
    }

    public void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

