/*
 * Decompiled with CFR 0.152.
 */
package auth.sdk;

import auth.sdk.InvalidSessionException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class SessionCred {
    private static final String SCCS_ID = "@(#)SessionCred.java\t1.2 02/10/14 SMI";
    private static final String PROPNAME = "_SUN_SUNRAY_SESSION";
    private static final String PROPLINE_INTRO = "_SUN_SUNRAY_SESSION(STRING)";
    private static final String PROPCMD = "/usr/openwin/bin/xprop -root _SUN_SUNRAY_SESSION";
    private String rawSessionInfo = null;
    private String hostname = null;
    private int port = 0;
    private String sessionID = null;

    public SessionCred() throws InvalidSessionException {
        this.parseCred(this.discoverCred());
    }

    private String discoverCred() throws InvalidSessionException {
        Process process = null;
        String string = null;
        InvalidSessionException invalidSessionException = null;
        try {
            process = Runtime.getRuntime().exec(PROPCMD);
        }
        catch (IOException iOException) {
            invalidSessionException = new InvalidSessionException(iOException.getMessage());
        }
        if (process != null) {
            BufferedReader bufferedReader;
            block14: {
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (!string2.startsWith(PROPLINE_INTRO)) continue;
                        int n = string2.indexOf(34) + 1;
                        int n2 = string2.lastIndexOf(34);
                        if (n2 > n) {
                            string = string2.substring(n, n2);
                            continue;
                        }
                        invalidSessionException = new InvalidSessionException("Improperly quoted session property");
                    }
                }
                catch (IOException iOException) {
                    if (string != null || invalidSessionException != null) break block14;
                    invalidSessionException = new InvalidSessionException(iOException.getMessage());
                }
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            while (true) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        if (string == null) {
            if (invalidSessionException == null) {
                invalidSessionException = new InvalidSessionException("Session ID property not found");
            }
            throw invalidSessionException;
        }
        return string;
    }

    public String getCred() {
        return this.rawSessionInfo;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getID() {
        return this.sessionID;
    }

    public int getPort() {
        return this.port;
    }

    private void parseCred(String string) throws InvalidSessionException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() < 3) {
            throw new InvalidSessionException("Improper session information format");
        }
        this.rawSessionInfo = string;
        this.hostname = stringTokenizer.nextToken();
        this.port = Integer.decode(stringTokenizer.nextToken());
        this.sessionID = stringTokenizer.nextToken();
    }
}

