/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.sunray;

import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.terminal.sunray.SunRayCardTerminalFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class SunRaySessionEventHandler
implements Runnable {
    private static final String SCCS_ID = "@(#)SunRaySessionEventHandler.java\t1.8 02/04/24 SMI";
    private SunRayCardTerminalFactory ctf = null;
    private Thread sessionInfoPoller = null;
    private int eventPort = 7013;
    private final int acceptTimeout = 0;
    private final int readTimeout = 10000;
    private static final String OK_response = "OK/";
    private static final String ERR_response = "ERR/";
    private static final String DONE_Response = "/DONE";
    private static final String EventConsumerHelloMsg = "SunRayCardTerminalDriver Event Consumer";
    private static final String EmptyCommandMsg = "No Command Seen";
    private static final String BadCommandMsg = "Unrecognized Command";
    private static final String BadXDisplayMsg = "Invalid X Display";
    private static final String NotSunRayDisplayMsg = "Not Sun Ray X Display";
    private static final String NoValidXMsg = "No valid Sun Ray X displays specified";
    private static final String CommandTimeout = "Command Timeout";
    private static final String CMD_CreateSession = "CREATE_SESSION";
    private static final String CMD_DestroySession = "DESTROY_SESSION";
    private static final String CMD_Help = "HELP";
    private static final String HELP_Text = "There is no help for the weary";

    public SunRaySessionEventHandler(SunRayCardTerminalFactory sunRayCardTerminalFactory) {
        this.setupHandler(sunRayCardTerminalFactory);
    }

    public SunRaySessionEventHandler(SunRayCardTerminalFactory sunRayCardTerminalFactory, int n) {
        this.eventPort = n;
        this.setupHandler(sunRayCardTerminalFactory);
    }

    private static void debug(String string, String string2) {
        try {
            OCFDebug.debugln((String)("SunRaySessionEventHandler: <" + string + "> " + string2));
        }
        catch (Exception exception) {}
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        SunRaySessionEventHandler.debug("<run>", "start");
        var1_1 = null;
        var2_2 = null;
        block26: while (true) lbl-1000:
        // 6 sources

        {
            block51: {
                try {
                    while (true) {
                        try {
                            var1_1 = new ServerSocket(this.eventPort);
                        }
                        catch (IOException var5_5) {
                            SunRaySessionEventHandler.debug("<run>/ServerSocket", "error creating server socket: [" + var5_5.getMessage() + "]");
                            var4_3 = null;
                            if (var2_2 != null) {
                                try {
                                    var2_2.close();
                                }
                                catch (IOException v0) {}
                                var2_2 = null;
                            }
                            if (var1_1 != null) {
                                try {
                                    var1_1.close();
                                }
                                catch (IOException v1) {}
                                var1_1 = null;
                            }
                            return;
                        }
                        try {
                            var1_1.setSoTimeout(0);
                            var2_2 = var1_1.accept();
                        }
                        catch (IOException var5_6) {
                            SunRaySessionEventHandler.debug("<run>/accept", "error: [" + var5_6.getMessage() + "]");
                            var4_3 = null;
                            if (var2_2 != null) {
                                try {
                                    var2_2.close();
                                }
                                catch (IOException v2) {}
                                var2_2 = null;
                            }
                            if (var1_1 == null) continue block26;
                            try {
                                var1_1.close();
                            }
                            catch (IOException v3) {}
                            var1_1 = null;
                            continue;
                        }
                        var2_2.setSoTimeout(10000);
                        var5_4 = new BufferedWriter(new OutputStreamWriter(var2_2.getOutputStream(), "8859_1"));
                        var6_7 = new BufferedReader(new InputStreamReader(var2_2.getInputStream(), "8859_1"));
                        SunRaySessionEventHandler.sendToClient(var5_4, "OK/SunRayCardTerminalDriver Event Consumer @(#)SunRaySessionEventHandler.java\t1.8 02/04/24 SMI");
                        try {
                            var7_8 = var6_7.readLine();
                        }
                        catch (InterruptedIOException v4) {
                            SunRaySessionEventHandler.sendToClient(var5_4, "ERR/Command Timeout/DONE");
                            var4_3 = null;
                            if (var2_2 != null) {
                                try {
                                    var2_2.close();
                                }
                                catch (IOException v5) {}
                                var2_2 = null;
                            }
                            if (var1_1 == null) continue block26;
                            try {
                                var1_1.close();
                            }
                            catch (IOException v6) {}
                            var1_1 = null;
                            continue;
                        }
                        if (var7_8 == null) {
                            SunRaySessionEventHandler.sendToClient(var5_4, "ERR/[(null)]");
                            break block51;
                        }
                        var7_8 = var7_8.trim();
                        SunRaySessionEventHandler.debug("<run>", "processing: [" + var7_8 + "]");
                        var8_9 = new StringTokenizer(var7_8);
                        try {
                            var9_10 = var8_9.nextToken().toUpperCase();
                        }
                        catch (NoSuchElementException v7) {
                            SunRaySessionEventHandler.debug("<run>/NoSuchElementException", "(empty command line)");
                            SunRaySessionEventHandler.sendToClient(var5_4, "ERR/No Command Seen/DONE");
                            var4_3 = null;
                            if (var2_2 != null) {
                                try {
                                    var2_2.close();
                                }
                                catch (IOException v8) {}
                                var2_2 = null;
                            }
                            if (var1_1 == null) continue block26;
                            try {
                                var1_1.close();
                            }
                            catch (IOException v9) {}
                            var1_1 = null;
                            continue;
                        }
                        break;
                    }
                    if (var9_10.equals("CREATE_SESSION") || var9_10.equals("DESTROY_SESSION")) {
                        var10_11 = false;
                        while (var8_9.hasMoreTokens()) {
                            var11_12 = var8_9.nextToken();
                            if (var11_12.startsWith("#")) break;
                            var12_13 = SunRayCardTerminalFactory.getXdisplayNumber(var11_12);
                            if (var12_13 == null) {
                                SunRaySessionEventHandler.debug("<run>/parse command(" + var9_10 + ")", "invalid display token: [" + var11_12 + "]");
                                SunRaySessionEventHandler.sendToClient(var5_4, "ERR/Invalid X Display: [" + var11_12 + "]");
                                continue;
                            }
                            var13_14 = SunRayCardTerminalFactory.getSessionID(var12_13);
                            if (var13_14 == null) {
                                SunRaySessionEventHandler.debug("<run>/parse command(" + var9_10 + ")", "Not a Sun Ray X display: [" + var11_12 + "]");
                                SunRaySessionEventHandler.sendToClient(var5_4, "ERR/Not Sun Ray X Display: [" + var11_12 + "]");
                                continue;
                            }
                            var14_15 = new Properties();
                            if (var9_10.equals("CREATE_SESSION")) {
                                var14_15.setProperty("event", "SessionCreated");
                            } else {
                                var14_15.setProperty("event", "SessionDestroyed");
                            }
                            var14_15.setProperty("Xdisplay", var12_13);
                            var14_15.setProperty("readerName", SunRayCardTerminalFactory.constructReaderName(var12_13));
                            this.ctf.sessionEvent(var14_15);
                            SunRaySessionEventHandler.sendToClient(var5_4, "OK/" + var9_10 + ": [" + var12_13 + "]");
                            var10_11 = true;
                        }
                        if (!var10_11) {
                            SunRaySessionEventHandler.sendToClient(var5_4, "ERR/No valid Sun Ray X displays specified");
                        }
                        SunRaySessionEventHandler.sendToClient(var5_4, "OK/" + var9_10 + "/DONE");
                    } else if (var9_10.equals("HELP")) {
                        SunRaySessionEventHandler.sendToClient(var5_4, "There is no help for the weary");
                        SunRaySessionEventHandler.sendToClient(var5_4, "OK/HELP/DONE");
                    } else {
                        SunRaySessionEventHandler.sendToClient(var5_4, "ERR/Unrecognized Command/DONE");
                    }
                }
                catch (IOException v10) {
                }
            }
            var4_3 = null;
            if (var2_2 == null) break block54;
            break;
        }
        catch (Throwable var3_16) {
            block57: {
                var4_3 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException v11) {}
                    var2_2 = null;
                }
                if (var1_1 == null) break block57;
                try {
                    var1_1.close();
                }
                catch (IOException v12) {}
                var1_1 = null;
            }
            throw var3_16;
        }
        {
            block54: {
                try {
                    var2_2.close();
                }
                catch (IOException v13) {}
                var2_2 = null;
            }
            if (var1_1 == null) continue;
            try {
                var1_1.close();
            }
            catch (IOException v14) {}
            var1_1 = null;
            ** while (true)
        }
    }

    private static void sendToClient(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        bufferedWriter.flush();
    }

    private void setupHandler(SunRayCardTerminalFactory sunRayCardTerminalFactory) {
        this.ctf = sunRayCardTerminalFactory;
        if (this.sessionInfoPoller == null) {
            this.sessionInfoPoller = new Thread(this);
            this.sessionInfoPoller.setDaemon(true);
            this.sessionInfoPoller.start();
        }
    }
}

