/*
 * Decompiled with CFR 0.152.
 */
package auth.protocol;

import auth.protocol.Protocol;
import auth.sdk.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class AuthWriter {
    OutputStream out = null;

    public AuthWriter(OutputStream out) {
        this.out = out;
    }

    private String bold() {
        return "\u001b[1m";
    }

    private String inverse() {
        return "\u001b[7m";
    }

    private String normal() {
        return "\u001b[0m";
    }

    private String underline() {
        return "\u001b[4m";
    }

    public boolean write(String command, Hashtable param) {
        try {
            ByteArrayOutputStream packet = Protocol.format(command, param);
            Log.debug((String)(String.valueOf(this.underline()) + packet.toString() + this.normal()));
            packet.writeTo(this.out);
            this.out.flush();
            return true;
        }
        catch (Exception e) {
            Log.unexpectedError((String)("during send to: " + this.out + " error=" + e));
            return false;
        }
    }
}

