/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import sun.awt.image.ImageConsumerQueue;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;

public abstract class ImageDecoder {
    InputStreamImageSource source;
    InputStream input;
    Thread feeder;
    protected boolean aborted;
    protected boolean finished;
    ImageConsumerQueue queue;
    ImageDecoder next;

    public ImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) {
        this.source = inputStreamImageSource;
        this.input = inputStream;
        this.feeder = Thread.currentThread();
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return ImageConsumerQueue.isConsumer(this.queue, imageConsumer);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.queue = ImageConsumerQueue.removeConsumer(this.queue, imageConsumer, false);
        if (!this.finished && this.queue == null) {
            this.abort();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ImageConsumerQueue nextConsumer(ImageConsumerQueue imageConsumerQueue) {
        InputStreamImageSource inputStreamImageSource = this.source;
        synchronized (inputStreamImageSource) {
            if (this.aborted) {
                return null;
            }
            imageConsumerQueue = imageConsumerQueue == null ? this.queue : imageConsumerQueue.next;
            while (imageConsumerQueue != null) {
                if (imageConsumerQueue.interested) {
                    return imageConsumerQueue;
                }
                imageConsumerQueue = imageConsumerQueue.next;
            }
            return null;
        }
    }

    protected int setDimensions(int n, int n2) {
        ImageConsumerQueue imageConsumerQueue = null;
        int n3 = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.setDimensions(n, n2);
            ++n3;
        }
        return n3;
    }

    protected int setProperties(Hashtable hashtable) {
        ImageConsumerQueue imageConsumerQueue = null;
        int n = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.setProperties(hashtable);
            ++n;
        }
        return n;
    }

    protected int setColorModel(ColorModel colorModel) {
        ImageConsumerQueue imageConsumerQueue = null;
        int n = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.setColorModel(colorModel);
            ++n;
        }
        return n;
    }

    protected int setHints(int n) {
        ImageConsumerQueue imageConsumerQueue = null;
        int n2 = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.setHints(n);
            ++n2;
        }
        return n2;
    }

    protected void headerComplete() {
        this.feeder.setPriority(3);
    }

    protected int setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        this.source.latchConsumers(this);
        ImageConsumerQueue imageConsumerQueue = null;
        int n7 = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.setPixels(n, n2, n3, n4, colorModel, byArray, n5, n6);
            ++n7;
        }
        return n7;
    }

    protected int setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        this.source.latchConsumers(this);
        ImageConsumerQueue imageConsumerQueue = null;
        int n7 = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
            ++n7;
        }
        return n7;
    }

    protected int imageComplete(int n, boolean bl) {
        this.source.latchConsumers(this);
        if (bl) {
            this.finished = true;
            this.source.doneDecoding(this);
        }
        ImageConsumerQueue imageConsumerQueue = null;
        int n2 = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.imageComplete(n);
            ++n2;
        }
        return n2;
    }

    public void replayConsumer(ImageConsumer imageConsumer) {
    }

    public abstract boolean catchupConsumer(InputStreamImageSource var1, ImageConsumer var2);

    public abstract void produceImage() throws IOException, ImageFormatException;

    public void abort() {
        this.aborted = true;
        this.source.doneDecoding(this);
        this.close();
        SecurityManager.enablePrivilege("UniversalThreadAccess");
        this.feeder.interrupt();
        SecurityManager.revertPrivilege();
    }

    public synchronized void close() {
        if (this.input != null) {
            try {
                this.input.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }
}

