/*
 * Decompiled with CFR 0.152.
 */
package auth.module.TerminalId;

import auth.module.TerminalId.TerminalId;
import auth.sdk.AccessControl;
import auth.sdk.AuthenticationClient;
import auth.sdk.Log;
import java.util.Hashtable;

public class TerminalIdClient
implements AuthenticationClient {
    private AccessControl access;
    private String localName;
    private String globalName;
    private TerminalId module;
    private String terminalId;

    TerminalIdClient(AccessControl access, TerminalId module, String localName, String globalName, String terminalId) {
        this.access = access;
        this.module = module;
        this.localName = localName;
        this.terminalId = terminalId;
        this.globalName = globalName;
    }

    public void close() {
        Log.notice((String)"TerminalIdClient.close");
    }

    public boolean connReq(Hashtable param) {
        String reason = null;
        Log.debug((String)("TerminalIdClient connReq: " + param));
        String allow = this.module.getTermProp(this.terminalId, "allow");
        if (allow == null) {
            reason = "implicit";
            allow = "true";
        } else {
            reason = "explicit";
        }
        if (!allow.equals("true")) {
            Log.notice((String)"TerminalIdClient.connReq: sending discInf");
            Hashtable<String, String> arg = new Hashtable<String, String>(3);
            arg.put("access", "denied");
            arg.put("cause", "explicit denial");
            this.access.send("discInf", arg);
            return false;
        }
        Log.debug((String)"TerminalIdClient.connReq: connecting");
        String type = (String)param.get("type");
        String id = (String)param.get("id");
        if (type != null && id != null) {
            String annotate = this.module.getTermProp(this.terminalId, "annotateTokens");
            if (annotate != null && annotate.equals("true")) {
                this.access.annotate("x_token", (Object)(String.valueOf(type) + "." + id));
            } else {
                this.access.annotate("x_token", null);
            }
        } else {
            Log.debug((String)"TerminalIdClient.connReq: INVALID TYPE/ID");
        }
        return this.access.connect(String.valueOf(reason) + " grant");
    }

    public String getGlobalName() {
        return this.globalName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getModuleName() {
        return this.module.getName();
    }

    public String getServiceInitCommand() {
        return this.access.getServiceStartCommand(this.module.getTermProp(this.terminalId, "session"));
    }

    public String getSessionManagerId() {
        return String.valueOf(this.access.getDefaultSessionHost()) + ":" + this.access.getDefaultSessionPort();
    }

    public boolean message(String command, Hashtable param) {
        Log.debug((String)("TerminalIdClient.message: " + command + " " + param));
        String token = null;
        String type = (String)param.get("type");
        String id = (String)param.get("id");
        if (type != null && id != null) {
            token = String.valueOf(type) + "." + id;
        }
        if (command.equals("infoReq")) {
            String event = (String)param.get("event");
            String annotate = this.module.getTermProp(this.terminalId, "annotateTokens");
            if (annotate != null && annotate.equals("true")) {
                if (event.equals("insert")) {
                    Log.debug((String)"TokenId.message: ADDING annotation");
                    this.access.annotate("x_token", (Object)token);
                } else if (event.equals("remove")) {
                    Log.debug((String)"TokenId.message: REMOVING annotation");
                    this.access.annotate("x_token", null);
                }
            } else {
                Log.debug((String)("NO ANNOTATION: annotate=" + (annotate == null ? "(null)" : annotate)));
            }
        } else {
            if (command.equals("discReq")) {
                Log.debug((String)"TerminalIdClient.message: disconnecting");
                this.access.disconnect("discReq-or-terminated");
                return false;
            }
            Log.debug((String)("TerminalId: IGNORE command: " + command));
        }
        return true;
    }

    public void setLocalName(String name) {
        this.localName = name;
        this.globalName = this.access.mapModuleToGlobalName(this.localName);
    }
}

