/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.core;

import com.scmmicro.smartos.exceptions.BadParameterException;
import com.scmmicro.smartos.exceptions.BadParameterValueException;

public class Parameters {
    public static final byte CLP_VERSION = 0;
    public static final byte CLP_PROTOCOL = 1;
    public static final byte CLP_CGT = 2;
    public static final byte CLP_CARDSTATE = 4;
    public static final byte CLP_CWT = 5;
    public static final byte CLP_CONV = 8;
    public static final byte CLP_PTS = 13;
    public static final byte CLP_TS_TIMEOUT = 14;
    public static final byte CLP_AUTOLEARN = 17;
    public static final byte CLP_PTSNECESSARY = 21;
    public static final byte CLP_DL = 9;
    public static final byte CLP_FL = 10;
    public static final byte CLP_ETULENGTH = 15;
    public static final byte CLP_BGT = 3;
    public static final byte CLP_BWT = 6;
    public static final byte CLP_EDC = 7;
    public static final byte CLP_IFSC = 11;
    public static final byte CLP_IFSD = 12;
    public static final byte CLP_NAD = 18;
    public static final byte CLP_IFSE = 19;
    public static final byte CLP_WTX = 20;
    byte CLP_Version;
    byte CLP_Protocol;
    short CLP_ETULength;
    byte CLP_CardState;
    long CLP_Cwt;
    boolean CLP_Conv;
    boolean CLP_Pts;
    int CLP_TS_Timeout;
    boolean CLP_Autolearn;
    byte CLP_Dl;
    byte CLP_Fl;
    boolean CLP_PTSNecessary;
    short CLP_Cgt;
    byte CLP_Bgt;
    long CLP_Bwt;
    boolean CLP_Edc;
    short CLP_Ifsc;
    short CLP_Ifsd;
    byte CLP_Nad;
    boolean CLP_Ifse;
    byte CLP_Wtx;
    byte Just_Atr = 0;
    private static final byte DEFAULT_VERSION = 0;
    private static final byte DEFAULT_PROTOCOL = 0;
    private static final short DEFAULT_ETULENGTH = 372;
    private static final byte DEFAULT_CARDSTATE = 0;
    private static final long DEFAULT_CWT = 3571200L;
    private static final byte DEFAULT_DL = 1;
    private static final byte DEFAULT_FL = 1;
    private static final short DEFAULT_CGT = 13;
    private static final boolean DEFAULT_CONV = false;
    private static final boolean DEFAULT_PTS = true;
    private static final int DEFAULT_TS_TIMEOUT = 40000;
    private static final boolean DEFAULT_AUTOLEARN = true;
    private static final boolean DEFAULT_PTSNECESSARY = false;
    public static final byte DEFAULT_BGT = 34;
    public static final long DEFAULT_BWT = 62853120L;
    public static final boolean DEFAULT_EDC = false;
    public static final short DEFAULT_IFSC = 254;
    public static final short DEFAULT_IFSD = 254;
    public static final byte DEFAULT_NAD = 0;
    public static final boolean DEFAULT_IFSE = false;
    public static final byte DEFAULT_WTX = 1;

    public long getParameter(byte by) throws BadParameterException {
        long l;
        switch (by) {
            case 0: {
                l = this.CLP_Version;
                break;
            }
            case 1: {
                l = this.CLP_Protocol;
                break;
            }
            case 15: {
                l = this.CLP_ETULength;
                break;
            }
            case 4: {
                l = this.CLP_CardState;
                break;
            }
            case 5: {
                l = this.CLP_Cwt;
                break;
            }
            case 8: {
                if (this.CLP_Conv) {
                    l = 1L;
                    break;
                }
                l = 0L;
                break;
            }
            case 13: {
                if (this.CLP_Pts) {
                    l = 1L;
                    break;
                }
                l = 0L;
                break;
            }
            case 14: {
                l = this.CLP_TS_Timeout;
                break;
            }
            case 17: {
                if (this.CLP_Autolearn) {
                    l = 1L;
                    break;
                }
                l = 0L;
                break;
            }
            case 9: {
                l = this.CLP_Dl;
                break;
            }
            case 10: {
                l = this.CLP_Fl;
                break;
            }
            case 2: {
                l = this.CLP_Cgt;
                break;
            }
            case 21: {
                if (this.CLP_PTSNecessary) {
                    l = 1L;
                    break;
                }
                l = 0L;
                break;
            }
            case 3: {
                l = this.CLP_Bgt;
                break;
            }
            case 6: {
                l = this.CLP_Bwt;
                break;
            }
            case 7: {
                if (this.CLP_Edc) {
                    l = 1L;
                    break;
                }
                l = 0L;
                break;
            }
            case 11: {
                l = this.CLP_Ifsc;
                break;
            }
            case 12: {
                l = this.CLP_Ifsd;
                break;
            }
            case 18: {
                l = this.CLP_Nad;
                break;
            }
            case 19: {
                if (this.CLP_Ifse) {
                    l = 1L;
                    break;
                }
                l = 0L;
                break;
            }
            case 20: {
                l = this.CLP_Wtx;
                break;
            }
            default: {
                throw new BadParameterException(" Parameter " + by + " unknown ");
            }
        }
        return l;
    }

    void init() {
        this.CLP_Version = 0;
        this.CLP_Protocol = 0;
        this.CLP_ETULength = (short)372;
        this.CLP_CardState = 0;
        this.CLP_Cwt = 3571200L;
        this.CLP_Conv = false;
        this.CLP_Pts = true;
        this.CLP_TS_Timeout = 40000;
        this.CLP_Autolearn = true;
        this.CLP_Dl = 1;
        this.CLP_Fl = 1;
        this.CLP_Cgt = (short)13;
        this.CLP_PTSNecessary = false;
        this.CLP_Bgt = (byte)34;
        this.CLP_Bwt = 62853120L;
        this.CLP_Edc = false;
        this.CLP_Ifsc = (short)254;
        this.CLP_Ifsd = (short)254;
        this.CLP_Nad = 0;
        this.CLP_Ifse = false;
        this.CLP_Wtx = 1;
    }

    public void setParameter(byte by, long l) throws BadParameterException, BadParameterValueException {
        this.Just_Atr = 1;
        switch (by) {
            case 0: {
                throw new BadParameterException("CLP_VERSION is a read only parameter");
            }
            case 1: {
                if (l > 127L) {
                    throw new BadParameterValueException("CL_VERSION must be less than 127");
                }
                this.CLP_Protocol = (byte)l;
                break;
            }
            case 15: {
                if (l > 32767L) {
                    throw new BadParameterValueException("CL_ETULENGTH must be less than 32767");
                }
                this.CLP_ETULength = (short)l;
                break;
            }
            case 4: {
                throw new BadParameterException("CLP_CARDSTATE is a read only parameter");
            }
            case 5: {
                this.CLP_Cwt = l;
                break;
            }
            case 8: {
                if (l == 0L) {
                    this.CLP_Conv = false;
                    break;
                }
                if (l == 1L) {
                    this.CLP_Conv = true;
                    break;
                }
                throw new BadParameterValueException("CL_CONV must be 0 or 1");
            }
            case 13: {
                if (l == 0L) {
                    this.CLP_Pts = false;
                    break;
                }
                if (l == 1L) {
                    this.CLP_Pts = true;
                    break;
                }
                throw new BadParameterValueException("CL_PTS must be 0 or 1");
            }
            case 14: {
                if (l > 32767L) {
                    throw new BadParameterValueException("CL_TS_TIMEOUT must be less than 32767");
                }
                this.CLP_TS_Timeout = (short)l;
                break;
            }
            case 17: {
                if (l == 0L) {
                    this.CLP_Autolearn = false;
                    break;
                }
                if (l == 1L) {
                    this.CLP_Autolearn = true;
                    break;
                }
                throw new BadParameterValueException("CL_AUTOLEARN must be 0 or 1");
            }
            case 9: {
                if (l > 127L) {
                    throw new BadParameterValueException("CL_DL must be less than 127");
                }
                this.CLP_Dl = (byte)l;
                break;
            }
            case 10: {
                if (l > 127L) {
                    throw new BadParameterValueException("CL_FL must be less than 127");
                }
                this.CLP_Fl = (byte)l;
                break;
            }
            case 2: {
                if (l > 32767L) {
                    throw new BadParameterValueException("CL_CGT must be less than 32767");
                }
                this.CLP_Cgt = (short)l;
                break;
            }
            case 21: {
                throw new BadParameterException("CLP_PTSNECESSARY is a read only parameter");
            }
            case 3: {
                if (l > 127L) {
                    throw new BadParameterValueException("CLP_BGT must be less than 127");
                }
                this.CLP_Bgt = (byte)l;
                break;
            }
            case 6: {
                this.CLP_Bwt = l;
                break;
            }
            case 7: {
                if (l == 0L) {
                    this.CLP_Edc = false;
                    break;
                }
                if (l == 1L) {
                    this.CLP_Edc = true;
                    break;
                }
                throw new BadParameterValueException("CLP_EDC must be 0 or 1");
            }
            case 11: {
                if (l > 32767L) {
                    throw new BadParameterValueException("CLP_IFSC must be less than 32767");
                }
                this.CLP_Ifsc = (short)l;
                break;
            }
            case 12: {
                if (l > 32767L) {
                    throw new BadParameterValueException("CLP_IFSD must be less than 32767");
                }
                this.CLP_Ifsd = (short)l;
                break;
            }
            case 18: {
                if (l > 127L) {
                    throw new BadParameterValueException("CLP_NAD must be less than 127");
                }
                this.CLP_Nad = (byte)l;
                break;
            }
            case 19: {
                if (l == 0L) {
                    this.CLP_Ifse = false;
                    break;
                }
                if (l == 1L) {
                    this.CLP_Ifse = true;
                    break;
                }
                throw new BadParameterValueException("CLP_IFSE must be 0 or 1");
            }
            case 20: {
                if (l > 127L) {
                    throw new BadParameterValueException("CLP_WTX must be less than 127");
                }
                this.CLP_Wtx = (byte)l;
                break;
            }
            default: {
                throw new BadParameterException(" Parameter " + by + " unknown ");
            }
        }
    }
}

