/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.physical;

import com.scmmicro.smartos.exceptions.BadParameterException;
import com.scmmicro.smartos.exceptions.BadParameterValueException;
import com.scmmicro.smartos.exceptions.CardException;
import com.scmmicro.smartos.exceptions.CommunicationException;
import com.scmmicro.smartos.exceptions.TimeOutException;
import com.scmmicro.smartos.physical.Drive;
import com.scmmicro.smartos.physical.DriveListener;
import com.scmmicro.smartos.physical.SerialLinkListener;
import com.scmmicro.smartos.physical.SerialPortAccess;
import com.scmmicro.smartos.util.Buffer;
import com.scmmicro.smartos.util.Fifo;
import com.scmmicro.smartos.util.Timer;
import com.scmmicro.smartos.util.TimerListener;
import java.math.BigInteger;

public class SerialDrive
extends Drive
implements TimerListener,
SerialLinkListener {
    private boolean verbose = true;
    private Fifo m_rSmardCardBuffer;
    boolean m_bSmardCardBufferUpdated;
    private Fifo m_rSmartOSBuffer;
    boolean m_bSmardOSBufferUpdated;
    private byte[] buf;
    private int[] tbSpeed;
    private byte[] rubbish;
    private byte[] TPDU_Received;
    private byte[] Cmd;
    private int CmdLength;
    private byte CardState;
    SerialPortAccess m_rSerialLink;
    private String m_rCommString;
    Exception m_rSerialException;
    private Timer m_rReceptionTimer;
    private boolean m_bReceptionTimout;
    private int versionFw;
    private boolean Chaining;
    private boolean CmdToSend;
    private int m_rbufScSize_Request;
    static final byte MAX_SPEED = 6;
    static final byte MAX_TPDU = 32;
    static final byte CARD_MOVEMENT = 100;
    static final byte CARD_INSERTION = -96;
    static final byte CARD_EXTRACTION = -95;
    static final byte READER_PRESENT = -16;
    static final byte READER_REMOVED = -15;
    static final byte NAD_COMPUTER_TO_SMARTOS1 = 18;
    static final byte PCB = 0;
    static final byte NAD_SMARTOS1_TO_COMPUTER = 33;
    static final byte NAD_COMPUTER_TO_SMARTCARD1 = 2;
    static final byte NAD_SMARTCARD_TO_COMPUTER = 32;
    static final byte READ_REGISTER_CLA = 0;
    static final byte READ_REGISTER_INS = -80;
    static final byte READ_FW_VERSION_INS = -79;
    static final byte WRITE_REGISTER_CLA = 0;
    static final byte WRITE_REGISTER_INS = -48;
    static final byte WRITE_BAUDRATE_INS = -46;
    static final byte NO_ERROR2 = 0;
    static final byte NO_ERROR1 = -112;
    private static final byte WORD32 = 4;
    private static final byte WORD16 = 2;
    private static final byte BOOLEAN = 1;
    private static final byte BYTE = 1;
    private static final byte SET_PARAMETER = 0;
    private static final byte GET_PARAMETER = 1;
    private static final byte SEND_DATA = 2;
    private static final byte RECEIVE_DATA = 3;

    public SerialDrive() {
        byte[] byArray = new byte[10];
        byArray[0] = 18;
        byArray[2] = 6;
        byArray[4] = -48;
        byArray[6] = 20;
        byArray[7] = 1;
        byArray[8] = 2;
        byArray[9] = -45;
        this.buf = byArray;
        this.tbSpeed = new int[]{9600, 19200, 28800, 38400, 57600, 115200, 12800};
        this.CardState = 0;
        this.m_rSmartOSBuffer = new Fifo(280);
        this.m_rSmardCardBuffer = new Fifo(280);
        this.m_bSmardOSBufferUpdated = false;
        this.m_bSmardCardBufferUpdated = false;
        this.Cmd = new byte[32];
        this.TPDU_Received = new byte[2048];
        this.rubbish = new byte[1024];
        this.CmdLength = 0;
        this.m_rSerialException = null;
        this.m_rReceptionTimer = null;
        this.m_rSerialLink = null;
        this.Chaining = false;
        this.CmdToSend = false;
    }

    private static String BytesToString(byte[] byArray) {
        String string = "";
        byte[] byArray2 = new byte[2];
        byArray2[0] = 0;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byArray2[1] = byArray[n2];
            BigInteger bigInteger = new BigInteger(byArray2);
            if (byArray[n2] < 16 && byArray[n2] >= 0) {
                string = String.valueOf(string) + "0";
            }
            string = String.valueOf(string) + bigInteger.toString(16);
            ++n2;
        }
        return string;
    }

    private synchronized void InitUART(long l) throws CommunicationException, CardException, BadParameterException, TimeOutException {
        long l2 = 32L;
        this.WriteRegister((byte)15, (byte)1, l2, 0L);
        l2 = 17L;
        this.WriteRegister((byte)17, (byte)1, l2, 0L);
        l2 = l == 0L ? 71L : 79L;
        this.WriteRegister((byte)15, (byte)1, l2, 0L);
    }

    private synchronized void PowerManagement_(long l) throws CommunicationException, CardException, BadParameterException, TimeOutException {
        switch ((int)l) {
            case 1: {
                long l2 = 2L;
                this.WriteRegister((byte)20, (byte)1, l2, 0L);
                l2 = 0L;
                this.WriteRegister((byte)21, (byte)1, l2, 0L);
                break;
            }
            case 2: {
                long l3 = 209L;
                this.WriteRegister((byte)21, (byte)1, l3, 0L);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                this.m_bReceptionTimout = false;
                this.m_rSerialLink.getBufSize();
                this.m_bReceptionTimout = true;
                if (!this.m_bReceptionTimout) break;
                this.m_bReceptionTimout = false;
                l3 = 241L;
                this.WriteRegister((byte)21, (byte)1, l3, 0L);
                this.m_bReceptionTimout = false;
                this.m_rReceptionTimer.start(this.m_nTsTimeout);
                while (!this.m_bReceptionTimout && this.m_rSerialLink.getBufSize() == 0) {
                }
                if (this.m_bReceptionTimout) break;
                this.m_rReceptionTimer.stop();
                break;
            }
        }
        if (this.m_bReceptionTimout && this.m_rSerialLink.getBufSize() == 0) {
            throw new CardException();
        }
        this.m_bReceptionTimout = false;
    }

    public synchronized long ReadRegister(byte by, byte by2, long l) throws CommunicationException, CardException, TimeOutException {
        if (by == 23) {
            this.Cmd[0] = 18;
            this.Cmd[1] = 0;
            this.Cmd[2] = 6;
            this.Cmd[3] = 0;
            this.Cmd[4] = -79;
            this.Cmd[5] = 0;
            this.Cmd[6] = 0;
            this.Cmd[7] = 0;
            this.Cmd[8] = 2;
            this.Cmd[9] = this.buildErrorCode_(this.Cmd, 9);
            this.CmdLength = this.Cmd[2] + 4;
        } else {
            this.Cmd[0] = 18;
            this.Cmd[1] = 0;
            this.Cmd[2] = 6;
            this.Cmd[3] = 0;
            this.Cmd[4] = -80;
            this.Cmd[5] = 0;
            this.Cmd[6] = by;
            this.Cmd[7] = 0;
            this.Cmd[8] = by2;
            this.Cmd[9] = this.buildErrorCode_(this.Cmd, 9);
            this.CmdLength = this.Cmd[2] + 4;
        }
        if (this.verbose) {
            byte[] byArray = new byte[this.CmdLength];
            int n = 0;
            while (n < this.CmdLength) {
                byArray[n] = this.Cmd[n];
                ++n;
            }
            this.debug("Read register: Len=" + this.CmdLength + "; Cmd= " + SerialDrive.BytesToString(byArray));
        }
        this.CmdToSend = true;
        int n = 0;
        if (this.serialAck(this.m_nRegAccesTimeout)) {
            do {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {}
                this.CmdToSend = true;
                this.debug("retry for ReadReg");
                if (++n != 10) continue;
                throw new CommunicationException();
            } while (this.serialAck(this.m_nRegAccesTimeout));
        }
        byte[] byArray = new byte[by2];
        this.m_rSmartOSBuffer.getBytes(byArray, by2);
        long l2 = 0L;
        long l3 = 255L;
        int n2 = 0;
        int n3 = by2 - 1;
        while (n3 >= 0) {
            l2 |= l3 & (long)(byArray[n3] << n2);
            --n3;
            l3 <<= 8;
            n2 = (byte)(n2 + 8);
        }
        if (l != 0L) {
            while ((l & 1L) == 0L) {
                l2 >>= 1;
                l >>= 1;
            }
            l2 &= l;
        }
        this.m_rSmartOSBuffer.setLength(0);
        return l2;
    }

    private synchronized byte ReceiveData_(long l) throws TimeOutException, CommunicationException, CardException {
        byte by = -1;
        int n = 0;
        int n2 = 2;
        this.TPDU_Received[2] = 0;
        this.m_bReceptionTimout = false;
        this.m_rReceptionTimer.start(l);
        do {
            if (this.CmdToSend) {
                if (!this.Chaining && this.m_rSerialLink.getBufSize() != 0) {
                    int n3;
                    while ((n3 = this.m_rSerialLink.getBufSize()) != 0) {
                        this.debug("reading rubbish : k = " + n3);
                        this.m_rSerialLink.read(this.rubbish, 0, n3);
                    }
                }
                this.m_rSerialLink.write(this.Cmd, this.CmdLength);
                this.CmdToSend = false;
            }
            if (this.m_rSerialLink.getBufSize() < n2) continue;
            this.m_rSerialLink.read(this.TPDU_Received, n, n2);
            if (n == 0) {
                if ((this.TPDU_Received[0] & 0xFE) == 32 && this.TPDU_Received[1] == 0) {
                    n = 2;
                    n2 = 1;
                    continue;
                }
                this.m_bReceptionTimout = false;
                this.m_rReceptionTimer.stop();
                return 2;
            }
            if (n == 2) {
                if (this.TPDU_Received[2] != 0 && this.TPDU_Received[2] < 33) {
                    n2 = this.TPDU_Received[2] + 1;
                    n = 3;
                    continue;
                }
                this.m_bReceptionTimout = false;
                this.m_rReceptionTimer.stop();
                return 2;
            }
            if (n != 3) continue;
            n2 = 0;
        } while (n2 > 0 && !this.m_bReceptionTimout);
        if (this.m_bReceptionTimout) {
            this.m_bReceptionTimout = false;
            throw new TimeOutException();
        }
        this.m_bReceptionTimout = false;
        this.m_rReceptionTimer.stop();
        if (this.TPDU_Received[0] == 32) {
            n2 = this.TPDU_Received[2];
            n = 0;
            while (n < n2) {
                this.TPDU_Received[n] = this.TPDU_Received[n + 3];
                n = (byte)(n + 1);
            }
            this.m_rSmardCardBuffer.addBytes(this.TPDU_Received, n2);
            if (this.m_rSmardCardBuffer.getLength() >= this.m_rbufScSize_Request && this.m_rbufScSize_Request != 0) {
                this.m_rbufScSize_Request = 0;
            }
            return 0;
        }
        if (this.TPDU_Received[0] == 33) {
            this.m_rSmartOSBuffer.addBytes(this.TPDU_Received, this.TPDU_Received[2] + 4);
            by = 1;
        }
        return by;
    }

    private synchronized long ShortCC_() throws CommunicationException, CardException, BadParameterException, TimeOutException {
        long l = 2L;
        this.WriteRegister((byte)20, (byte)1, l, 0L);
        l = this.ReadRegister((byte)18, (byte)1, 0L);
        l = 64L;
        this.WriteRegister((byte)21, (byte)1, l, 0L);
        l = 6L;
        this.WriteRegister((byte)20, (byte)1, l, 0L);
        long l2 = this.ReadRegister((byte)18, (byte)1, 2L);
        l = 193L;
        this.WriteRegister((byte)21, (byte)1, l, 0L);
        return l2;
    }

    public void TimerEnd() {
        this.debug("Time - out - event Triggered ");
        this.m_bReceptionTimout = true;
    }

    public synchronized void WriteRegister(byte by, byte by2, long l, long l2) throws CommunicationException, CardException, TimeOutException {
        if (l2 != 0L) {
            long l3 = this.ReadRegister(by, by2, 0L);
            l = l3 & (l2 ^ 0xFFFFFFFFFFFFFFFFL) | l;
        }
        this.Cmd[0] = 18;
        this.Cmd[1] = 0;
        this.Cmd[2] = (byte)(by2 + 5);
        this.Cmd[3] = 0;
        this.Cmd[4] = by == 25 ? -46 : -48;
        this.Cmd[5] = 0;
        this.Cmd[6] = by;
        this.Cmd[7] = by2;
        long l4 = 255L;
        int n = 0;
        int n2 = 7 + by2;
        while (n2 > 7) {
            this.Cmd[n2] = (byte)(l >> n & l4);
            --n2;
            n += 8;
        }
        this.Cmd[this.Cmd[2] + 3] = this.buildErrorCode_(this.Cmd, 3 + this.Cmd[2]);
        this.CmdLength = this.Cmd[2] + 4;
        if (this.verbose) {
            byte[] byArray = new byte[this.CmdLength];
            int n3 = 0;
            while (n3 < this.CmdLength) {
                byArray[n3] = this.Cmd[n3];
                ++n3;
            }
            this.debug("Write register: Len=" + this.CmdLength + "; Cmd= " + SerialDrive.BytesToString(byArray));
        }
        this.CmdToSend = true;
        int n4 = 0;
        if (this.serialAck(this.m_nRegAccesTimeout)) {
            do {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {}
                this.CmdToSend = true;
                this.debug("retry for WriteReg");
                if (++n4 != 10) continue;
                throw new CommunicationException();
            } while (this.serialAck(this.m_nRegAccesTimeout));
        }
        this.m_rSmartOSBuffer.setLength(0);
    }

    private synchronized byte buildErrorCode_(byte[] byArray, int n) {
        byte by = 0;
        int n2 = 0;
        while (n2 < n) {
            by = (byte)(by ^ byArray[n2]);
            ++n2;
        }
        return by;
    }

    public void cardMovement(byte by) {
        if (by == -16) {
            try {
                this.m_rSerialLink.close();
                this.m_rSerialLink = null;
                Drive.m_bOpenned = false;
                this.open();
            }
            catch (CommunicationException communicationException) {
            }
            catch (CardException cardException) {
            }
            catch (TimeOutException timeOutException) {}
            if (this.CardState == 1) {
                this.m_rDriveListener.cardMovement((byte)-96);
            }
            return;
        }
        if (by == -15) {
            if (this.CardState == 1) {
                this.m_rDriveListener.cardMovement((byte)-95);
            }
            return;
        }
        if (by == -96) {
            this.CardState = 1;
            this.debug("card inserted");
        } else {
            this.CardState = 0;
            this.debug("card removed");
        }
        this.m_rDriveListener.cardMovement(by);
    }

    public void close() throws CommunicationException, CardException, TimeOutException {
        this.WriteRegister((byte)17, (byte)1, 0L, 0L);
        this.WriteRegister((byte)21, (byte)1, 0L, 0L);
        this.WriteRegister((byte)22, (byte)1, 0L, 0L);
        try {
            Thread.sleep(70L);
        }
        catch (InterruptedException interruptedException) {}
        this.m_rSerialLink.close();
        this.m_rSerialLink = null;
        Drive.m_bOpenned = false;
        this.debug("Reader CLOSE OK");
    }

    void debug(String string) {
        if (this.verbose) {
            System.out.println("SerialDrive : " + string);
        }
    }

    DriveListener getListener() {
        return this.m_rDriveListener;
    }

    public int getNumReceived() throws CommunicationException, CardException {
        if (!Drive.m_bOpenned) {
            throw new CommunicationException("no Connection is openned");
        }
        return this.m_rSmardCardBuffer.getLength();
    }

    public synchronized long getParameter(byte by) throws CommunicationException, CardException, BadParameterException, TimeOutException {
        byte by2;
        byte by3;
        long l = super.getParameter(by);
        if (l > 0L) {
            return l;
        }
        if (!Drive.m_bOpenned) {
            throw new CommunicationException("no Connection is openned");
        }
        long l2 = 0L;
        switch (by) {
            case 2: {
                by3 = 2;
                by2 = 2;
                break;
            }
            case 3: {
                by3 = 2;
                by2 = 8;
                break;
            }
            case 4: {
                by3 = 4;
                by2 = 4;
                break;
            }
            case 5: {
                by3 = 4;
                by2 = 10;
                break;
            }
            case 6: {
                by3 = 4;
                by2 = 0;
                break;
            }
            case 7: {
                l2 = 16L;
                by3 = 1;
                by2 = 15;
                break;
            }
            case 8: {
                l2 = 64L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 9: {
                l2 = 8L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 10: {
                l2 = 32L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 11: {
                l2 = 128L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 12: {
                l2 = 2L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 13: {
                l2 = 4L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 14: {
                return this.CardState;
            }
            case 17: {
                l2 = 4095L;
                by3 = 2;
                by2 = 0;
                break;
            }
            case 19: {
                l2 = 1L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 20: {
                l2 = 2L;
                by3 = 1;
                by2 = 22;
                break;
            }
            case 21: {
                l2 = 8L;
                by3 = 1;
                by2 = 15;
                break;
            }
            case 23: {
                l2 = 3L;
                by3 = 1;
                by2 = 15;
                break;
            }
            case 24: {
                l2 = 4L;
                by3 = 1;
                by2 = 15;
                break;
            }
            case 25: {
                l2 = 12288L;
                by3 = 1;
                by2 = 0;
                break;
            }
            case 27: {
                l2 = 1L;
                by3 = 1;
                by2 = 14;
                break;
            }
            case 28: {
                l2 = 2L;
                by3 = 1;
                by2 = 14;
                break;
            }
            case 29: {
                return this.ShortCC_();
            }
            case 31: {
                return this.comSpeed;
            }
            default: {
                throw new BadParameterException();
            }
        }
        l = this.ReadRegister(by2, by3, l2);
        return l;
    }

    private synchronized boolean getSmardOSBufferUpdated() {
        return this.m_bSmardOSBufferUpdated;
    }

    synchronized Fifo getSmartCardBuffer() {
        return this.m_rSmardCardBuffer;
    }

    synchronized Fifo getSmartOSBuffer() {
        return this.m_rSmartOSBuffer;
    }

    public synchronized void open() throws CommunicationException, CardException, TimeOutException {
        if (Drive.m_bOpenned) {
            return;
        }
        this.m_rSerialLink = null;
        this.debug("Looking for Reader at port: " + this.DriverAddress);
        this.m_rSerialLink = new SerialPortAccess(this.DriverAddress);
        this.m_rSerialLink.setListener(this);
        this.m_rSerialLink.init();
        Drive.m_bOpenned = true;
        try {
            this.debug("9600");
            this.m_rSerialLink.switchBaudrate(9600);
            this.m_rSerialLink.m_rPort.sendBreak(50);
            this.comSpeed = 0;
            this.open_STC();
            return;
        }
        catch (Exception exception) {
            try {
                this.debug("115200");
                this.m_rSerialLink.switchBaudrate(115200);
                this.comSpeed = 5;
                this.open_STC();
                return;
            }
            catch (Exception exception2) {
                try {
                    int n;
                    this.debug("38400");
                    while ((n = this.m_rSerialLink.getBufSize()) != 0) {
                        this.m_rSerialLink.read(this.rubbish, 0, n);
                    }
                    this.m_rSerialLink.switchBaudrate(38400);
                    this.comSpeed = 3;
                    this.open_STC();
                    return;
                }
                catch (Exception exception3) {
                    return;
                }
            }
        }
    }

    private synchronized void open_STC() throws CommunicationException, CardException, TimeOutException {
        int n = 5;
        try {
            this.WriteRegister((byte)17, (byte)1, 0L, 0L);
            this.versionFw = (int)this.ReadRegister((byte)23, (byte)1, 0L);
            this.debug(" Fw Version is " + this.versionFw);
            switch (this.versionFw) {
                case 18: 
                case 34: {
                    this.WriteRegister((byte)22, (byte)1, 1L, 0L);
                    Thread.sleep(70L);
                    this.WriteRegister((byte)22, (byte)1, 3L, 0L);
                    this.WriteRegister((byte)0, (byte)2, 33140L, 0L);
                    this.WriteRegister((byte)20, (byte)1, 2L, 0L);
                    this.ReadRegister((byte)18, (byte)1, 0L);
                    break;
                }
                default: {
                    this.debug("Firmware > 1.22");
                    do {
                        try {
                            this.WriteRegister((byte)17, (byte)1, 0L, 0L);
                            this.WriteRegister((byte)25, (byte)1, n, 0L);
                            this.m_rSerialLink.switchBaudrate(this.tbSpeed[n]);
                            this.WriteRegister((byte)22, (byte)1, 1L, 0L);
                            Thread.sleep(70L);
                            this.WriteRegister((byte)22, (byte)1, 3L, 0L);
                            n = 255;
                        }
                        catch (Exception exception) {
                            this.debug("Speed " + this.tbSpeed[n] + " not supported");
                            this.debug("Break to set speed to 9600");
                            this.m_rSerialLink.switchBaudrate(9600);
                            this.m_rSerialLink.m_rPort.sendBreak(50);
                            --n;
                        }
                    } while (n != 0 && n != 255);
                    if (n != 0) break;
                    throw new CommunicationException();
                }
            }
            this.debug("Speed " + this.tbSpeed[this.comSpeed] + " supported");
            this.WriteRegister((byte)17, (byte)1, 17L, 0L);
            this.CardState = (byte)(this.ReadRegister((byte)20, (byte)1, 0L) & 1L);
        }
        catch (CommunicationException communicationException) {
            this.debug("Opening session error");
            throw new CommunicationException();
        }
        catch (CardException cardException) {
            throw new CommunicationException("No available port found");
        }
        catch (TimeOutException timeOutException) {
            this.debug("Not an RSR3 reader");
            throw new CommunicationException("No available port found");
        }
        catch (InterruptedException interruptedException) {
            throw new CommunicationException("No available port found");
        }
        this.debug("STC INIT OK");
    }

    public synchronized void receiveBlock(Buffer buffer) throws CommunicationException, CardException, TimeOutException {
        this.m_rbufScSize_Request = buffer.getCapacity();
        buffer.setLength(this.m_rbufScSize_Request);
        this.CmdToSend = false;
        this.serialAck(this.m_nReceptionTimeout);
        if (this.m_rSmardCardBuffer.getLength() < buffer.getCapacity()) {
            throw new TimeOutException("Reception TimeOut for receiveblock");
        }
        this.m_rSmardCardBuffer.getBytes(buffer);
        this.debug("ReceiveBlock =  " + SerialDrive.BytesToString(buffer.getData()));
        this.m_rSmartOSBuffer.setLength(0);
    }

    public synchronized void sendBlock(Buffer buffer) throws CommunicationException, CardException, TimeOutException {
        int n = 0;
        this.m_rSmartOSBuffer.setLength(0);
        this.m_rSmardCardBuffer.setLength(0);
        byte[] byArray = buffer.getData();
        int n2 = buffer.getLength();
        this.debug("SendBlock =  " + SerialDrive.BytesToString(byArray));
        if (buffer.getLength() + 4 <= 32) {
            this.Cmd[0] = 2;
            this.Cmd[1] = 0;
            this.Cmd[2] = (byte)buffer.getLength();
            this.CmdLength = 3;
            int n3 = 0;
            while (n3 < n2) {
                this.Cmd[n3 + 3] = byArray[n3];
                ++n3;
            }
            this.Cmd[this.Cmd[2] + 3] = this.buildErrorCode_(this.Cmd, 3 + this.Cmd[2]);
            this.CmdLength = this.Cmd[2] + 4;
            this.CmdToSend = true;
            this.debug("sendblock without chaining--->No of bytes  = " + this.CmdLength);
            this.serialAck(this.m_nTransmitionTimeout);
        } else {
            this.debug("SerialDrive: SendBlock: with chaining");
            n = n2;
            this.Cmd[0] = 2;
            this.Cmd[1] = 0;
            this.Cmd[2] = 28;
            this.CmdLength = 3;
            int n4 = 0;
            while (n4 < 28) {
                this.Cmd[n4 + 3] = byArray[n4];
                ++n4;
            }
            this.Cmd[this.Cmd[2] + 3] = this.buildErrorCode_(this.Cmd, 3 + this.Cmd[2]);
            this.CmdLength = this.Cmd[2] + 4;
            this.CmdToSend = true;
            this.serialAck(this.m_nTransmitionTimeout);
            this.Chaining = true;
            n -= this.Cmd[2];
            do {
                this.m_rSmartOSBuffer.setLength(0);
                this.Cmd[2] = n <= 28 ? (int)n : 28;
                this.CmdLength = 3;
                n4 = 0;
                while (n4 < this.Cmd[2]) {
                    this.Cmd[n4 + 3] = byArray[n2 - n + n4];
                    ++n4;
                }
                this.Cmd[this.Cmd[2] + 3] = this.buildErrorCode_(this.Cmd, 3 + this.Cmd[2]);
                this.CmdLength = this.Cmd[2] + 4;
                this.CmdToSend = true;
                this.serialAck(this.m_nTransmitionTimeout);
            } while ((n -= this.Cmd[2]) != 0);
        }
        this.Chaining = false;
        this.m_rSmartOSBuffer.setLength(0);
    }

    public synchronized boolean serialAck(long l) throws CommunicationException, TimeOutException, CardException {
        byte by = 0;
        if (this.m_rSmardCardBuffer.getLength() >= this.m_rbufScSize_Request && this.m_rbufScSize_Request != 0) {
            return false;
        }
        while ((by = this.ReceiveData_(l)) == 0 && this.m_rbufScSize_Request != 0) {
        }
        if (by == 0) {
            return false;
        }
        if (by == 1) {
            byte by2;
            this.m_rSmartOSBuffer.getByte();
            this.m_rSmartOSBuffer.getByte();
            return this.m_rSmartOSBuffer.getByte() <= 2 && (by2 = this.m_rSmartOSBuffer.getByte()) != -112 && by2 != 1;
        }
        if (by == 2) {
            return true;
        }
        throw new CommunicationException();
    }

    public void setListener(DriveListener driveListener) throws CommunicationException, CardException, TimeOutException {
        this.m_rDriveListener = driveListener;
        if (this.m_rReceptionTimer == null) {
            this.m_rReceptionTimer = new Timer(this);
        }
        this.open();
    }

    public synchronized void setParameter(byte by, long l) throws CommunicationException, CardException, BadParameterException, BadParameterValueException, TimeOutException {
        byte by2;
        byte by3;
        super.setParameter(by, l);
        if (!Drive.m_bOpenned) {
            throw new CommunicationException("no Connection is openned");
        }
        long l2 = 0L;
        switch (by) {
            case 2: {
                by3 = 2;
                by2 = 2;
                break;
            }
            case 3: {
                by3 = 2;
                by2 = 8;
                break;
            }
            case 4: {
                by3 = 4;
                by2 = 4;
                break;
            }
            case 5: {
                by3 = 4;
                by2 = 10;
                break;
            }
            case 7: {
                l2 = 16L;
                by3 = 1;
                by2 = 15;
                break;
            }
            case 8: {
                l2 = 64L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 9: {
                l2 = 8L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 10: {
                l2 = 32L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 11: {
                l2 = 128L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 12: {
                l2 = 2L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 13: {
                l2 = 4L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 17: {
                l2 = 4095L;
                by3 = 2;
                by2 = 0;
                break;
            }
            case 19: {
                l2 = 1L;
                by3 = 1;
                by2 = 21;
                break;
            }
            case 20: {
                l2 = 2L;
                by3 = 1;
                by2 = 22;
                break;
            }
            case 21: {
                l2 = 8L;
                by3 = 1;
                by2 = 15;
                break;
            }
            case 23: {
                l2 = 3L;
                by3 = 1;
                by2 = 15;
                break;
            }
            case 24: {
                l2 = 4L;
                by3 = 1;
                by2 = 15;
                break;
            }
            case 25: {
                l2 = 12288L;
                by3 = 1;
                by2 = 0;
                break;
            }
            case 27: {
                l2 = 1L;
                by3 = 1;
                by2 = 14;
                break;
            }
            case 28: {
                l2 = 2L;
                by3 = 1;
                by2 = 14;
                break;
            }
            case 18: {
                l2 = 2L;
                by3 = 1;
                by2 = 22;
                break;
            }
            case 22: {
                this.PowerManagement_(l);
                return;
            }
            case 26: {
                this.InitUART(l);
                return;
            }
            case 30: {
                return;
            }
            case 15: {
                return;
            }
            default: {
                throw new BadParameterException();
            }
        }
        this.WriteRegister(by2, by3, l, l2);
    }

    synchronized void setSmardOSBufferUpdated(boolean bl) {
        this.m_bSmardOSBufferUpdated = bl;
    }
}

