/*
 * Copyright (c) 1999, by Sun Microsystems, Inc.
 * All rights reserved.
 *
 * NAME : resdoor.h
 *
 * DESCRIPTION : 
 *
 * The resource door interface.
 *  
 */

#pragma ident	"@(#)resdoor.h 3.1	99/01/29 SMI"

#ifndef __RESDOOR_H__
#define __RESDOOR_H__

#define RESOURCE_DOOR_1_0			10001
#define RESOURCE_DOOR_REQUEST		15001
#define RESOURCE_DOOR_RESPONSE		15002

typedef struct door_io_t {
	uint32_t	version;    /* version number */
	uint32_t	op;         /* type of operation */

	uint32_t	fd_set;     /* Is the data being sent as pipe fd */

	/*
	 * For a request, header_len and header refer to the
	 * 'environment' block.
	 * In a response buffer, they refer to the HTTP headers.
	 */
	uint32_t	header_len; /* Length */
	uint32_t	header;     /* Offset */

	/*
	 * In both request as well as response, data_len and
	 * data attributes refer to the HTTP content.
	 */
	uint32_t	data_len;   /* Length */
	uint32_t	data;       /* Offset */

	/*
	 * Followed by actual data.
	 */
} door_io_t;

#endif /* __RESDOOR_H__ */

/*
 * EOF
 */
