#!/bin/sh
#
# Copyright (c) 1999, by Sun Microsystems, Inc.
# All rights reserved.
# 
# swscheck.sh  - private support script to use in crontab or other
# periodic checking mechanism to start all enabled web server daemons.
# This is registered with the HC process management tools.
# 
# Behavior: start all enabled daemons that aren't running.
# If there is an error on startup, Disable that daemon,
# and generate noisy mail to root.   Meanwhile, if there are errors,
# htserver will also syslog them.
#
#
# Usage: swscheck.sh  
# 		(no arguments or options)
#
#
# Not internationalized yet  (do invisible daemons get localized?)


#-------------------------------------------------------------------------
# Setup:
# Find INSTALL_ROOT (which leads to htserver and to httpd-instances.conf)
# Assumes we've been run either under a path, or as an absolute path.
#
# This script is in 
#  	[WHEREVER]/opt/SUNWut/http/lib/swscheck.sh
# while htserver is in
#	[WHEREVER]/opt/SUNWut/http/bin/htserver
#
CALLED_AS=$0
if [ x"`dirname $CALLED_AS`" != x"." ]; then
	INSTALL_ROOT=`dirname $CALLED_AS`
	INSTALL_ROOT=`dirname $INSTALL_ROOT`	# peel off lib
	INSTALL_ROOT=`dirname $INSTALL_ROOT`	# peel off http
	INSTALL_ROOT=`dirname $INSTALL_ROOT`	# peel off usr
	HTSERVER=$INSTALL_ROOT/opt/SUNWut/http/bin/htserver
else
	HTSERVER=htserver
	INSTALL_ROOT=/
fi;
if [ ! -f $INSTALL_ROOT/etc/opt/SUNWut/http/httpd-instances.conf ]; then
	echo "swscheck: Cannot find master server registration file."
	exit -1
fi;


#-------------------------------------------------------------------------
# Temp files to keep 'htserver' messages until we've decided if
# they should form part of this script's output (which goes to cron mail.)

TMPFILE=/tmp/swscheck.$$
/bin/rm -f $TMPFILE
RESFILE=/tmp/swscheck.res.$$
/bin/rm -f $RESFILE
touch $RESFILE

#-------------------------------------------------------------------------
# Get the list of servers - 
# leave out the commented lines from httpd-intstances,
# and for the others, turn each line into the form NAME/STATE
#
SERVER_LIST=`cat $INSTALL_ROOT/etc/opt/SUNWut/http/httpd-instances.conf | awk '{ print $1"/"$3 }' | grep -v '#' `


# For each server with STATE 'enabled', try to start it.
#
for SERVER in $SERVER_LIST ; do

	SERVERNAME=`dirname $SERVER`
	SERVERSTATE=`basename $SERVER`

	if [ x"$SERVERSTATE" = x"enable" ]; then

		$HTSERVER start $SERVERNAME >  $TMPFILE 2>&1 

		# Check the result of the start operation:
		# '0' is OK
		# '3' is the special result for 'nothing to do'
		# Other results mean startup failed.

		if [ $? -ne 0 -a $? -ne 3 ]; then

			cat $TMPFILE >>$RESFILE 2>&1
			echo >> $RESFILE
			echo
			echo "Web server instance $SERVERNAME failed to start." >> $RESFILE
			echo "It is being disabled." >> $RESFILE

			htserver disable $SERVERNAME > /dev/null 2>&1
		fi;
	fi
done;

# Finally, emit the result file - which is probably empty.
# If it's not, it has errors, which cron passes along in email.

cat $RESFILE
/bin/rm -f $RESFILE
/bin/rm -f $TMPFILE

