#!/bin/sh
# 
# Copyright (c) 1999, by Sun Microsystems, Inc.
# All rights reserved.
#


INSTALL_ROOT=${BASEDIR:-`pkgparam SUNWutws BASEDIR`}

VERBOSE=0
if [ $# -ge 1 ]; then
	VERBOSE=1
fi;

# Get the list of servers - 
# leave out the commented lines from httpd-intstances,
# and get the 2nd field (the server config line) for the rest.

SERVER_LIST=`cat $INSTALL_ROOT/etc/opt/SUNWut/http/httpd-instances.conf | grep -v '#' | awk '{ print $2  }' `

#

if [ $VERBOSE -ne 0 ]; then
	echo "`gettext 'Updating server configuration files...'`"
fi;

for SERVER in $SERVER_LIST ; do

	/bin/rm -f /tmp/sws.update.$$

	if [ -r $SERVER ] && [ `grep -c 'usr/jsdk/lib/classes.zip' $SERVER` -gt 0 ]; then

	    if [ $VERBOSE -ne 0 ]; then 
		echo $SERVER
	    fi;

	    sed -e 's+usr/jsdk/lib/classes.zip+usr/jsdk/lib/jsdk.jar+' $SERVER > /tmp/sws.update.$$

	    if [ $? -eq 0 ]; then 
		mv $SERVER $SERVER.SWS20
		mv /tmp/sws.update.$$ $SERVER
	    else
		/bin/rm -f /tmp/sws.update.$$
		echo "`gettext 'Could not update the JSDK jar file name\nfrom classes.zip to jsdk.jar \nin the server config file:\n'`"  $SERVER 

	    fi;

	fi
done;

