/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.advanced;

import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.I18N;
import com.sun.ut.service.Devices;
import com.sun.ut.service.Security;
import com.sun.ut.service.ServiceException;
import com.sun.web.ui.model.Option;
import java.util.ArrayList;
import java.util.List;

public class SecurityHandler
extends BaseHandler {
    private ArrayList encryptionModeOptions;
    private ArrayList clientModeOptions;
    private Security security;
    private Devices devices;

    public SecurityHandler() {
        this.getSecurity();
        this.getDevices();
    }

    public Security getSecurity() {
        if (this.security == null) {
            try {
                this.security = this.getProvider().getSecurity();
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("security_alert_get", se);
            }
        }
        return this.security;
    }

    public Devices getDevices() {
        if (this.devices == null) {
            try {
                this.devices = this.getProvider().getDevices();
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("devices_alert_get", se);
                this.devices = new Devices();
            }
        }
        return this.devices;
    }

    public List getEncryptionModeOptions() {
        if (this.encryptionModeOptions == null) {
            this.encryptionModeOptions = new ArrayList();
            Option soft = new Option((Object)new Integer(0), I18N.getResource("security_mode_soft"));
            soft.setTooltip(I18N.getResource("security_mode_soft_encryption_tooltip"));
            Option hard = new Option((Object)new Integer(1), I18N.getResource("security_mode_hard"));
            hard.setTooltip(I18N.getResource("security_mode_hard_encryption_tooltip"));
            this.encryptionModeOptions.add(soft);
            this.encryptionModeOptions.add(hard);
        }
        return this.encryptionModeOptions;
    }

    public List getClientModeOptions() {
        if (this.clientModeOptions == null) {
            this.clientModeOptions = new ArrayList();
            Option soft = new Option((Object)new Integer(0), I18N.getResource("security_mode_soft"));
            soft.setTooltip(I18N.getResource("security_mode_soft_client_tooltip"));
            Option hard = new Option((Object)new Integer(1), I18N.getResource("security_mode_hard"));
            hard.setTooltip(I18N.getResource("security_mode_hard_client_tooltip"));
            this.clientModeOptions.add(soft);
            this.clientModeOptions.add(hard);
        }
        return this.clientModeOptions;
    }

    public String modify() {
        try {
            boolean deviceChanges = this.hasDevicesChanges();
            if (deviceChanges) {
                this.getProvider().saveDevices(this.devices);
            }
            this.getProvider().saveSecurity(this.security);
            if (deviceChanges) {
                this.getNotification().setColdRestartRequired(true);
                this.getStatusMessage().coldRestartRequired();
            } else {
                this.getNotification().setRestartRequired(true);
                this.getStatusMessage().restartRequired();
            }
            this.getAuditService().publishEvent("Security", "security_updated", this.getAuditValues(this.security, this.devices), 0);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("security_alert_save", se);
        }
        return "success";
    }

    private boolean hasDevicesChanges() throws ServiceException {
        Devices old = this.getProvider().getDevices();
        return old.isInternalSerialEnabled() != this.devices.isInternalSerialEnabled() || old.isInternalSmartCardReaderEnabled() != this.devices.isInternalSmartCardReaderEnabled() || old.isUsbEnabled() != this.devices.isUsbEnabled();
    }

    private String[] getAuditValues(Security sec, Devices devs) {
        boolean upEnc = sec.isEncUp();
        boolean downEnc = sec.isEncDown();
        boolean isAuthDown = sec.isAuthDown();
        boolean isAuthUp = sec.isAuthUp();
        int encryptionMode = sec.getEncryptionMode();
        int clientMode = sec.getClientMode();
        boolean serialPort = devs.isInternalSerialEnabled();
        boolean reader = devs.isInternalSmartCardReaderEnabled();
        boolean usb = devs.isUsbEnabled();
        String upEncValue = "disabled";
        String downEncValue = "disabled";
        String isAuthDownValue = "disabled";
        String isAuthUpValue = "disabled";
        String encryptionModeValue = "soft";
        String clientModeValue = "soft";
        String serialPortValue = "disabled";
        String readerValue = "disabled";
        String usbValue = "disabled";
        if (upEnc) {
            upEncValue = "enabled";
        }
        if (downEnc) {
            downEncValue = "enabled";
        }
        if (isAuthDown) {
            isAuthDownValue = "enabled";
        }
        if (isAuthUp) {
            isAuthUpValue = "enabled";
        }
        if (encryptionMode == 1) {
            encryptionModeValue = "hard";
        }
        if (clientMode == 1) {
            clientModeValue = "hard";
        }
        if (serialPort) {
            serialPortValue = "enabled";
        }
        if (reader) {
            readerValue = "enabled";
        }
        if (usb) {
            usbValue = "enabled";
        }
        String[] args = new String[]{upEncValue, downEncValue, isAuthDownValue, encryptionModeValue, isAuthUpValue, clientModeValue, serialPortValue, readerValue, usbValue};
        return args;
    }
}

