/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.login;

import com.sun.ut.console.I18N;

public class LoginChallenge {
    private String challenge;
    private String type;
    private int number;
    private String input;

    public LoginChallenge(int number, String challenge, String type) {
        this.number = number;
        this.challenge = challenge;
        this.type = type;
    }

    public String getChallenge() {
        return this.localizeMessage(this.challenge);
    }

    public String getInput() {
        return this.input;
    }

    public String getObfuscatedInput() {
        if (this.isPromptEchoOff()) {
            StringBuffer buffer = new StringBuffer();
            if (this.input != null) {
                for (int i = 0; i < this.input.length(); ++i) {
                    buffer.append("*");
                }
            }
            return buffer.toString();
        }
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public int getNumber() {
        return this.number;
    }

    public String getType() {
        return this.type;
    }

    public boolean isPromptEchoOff() {
        return this.type.compareTo("\u00001") == 0;
    }

    public boolean isPromptEchoOn() {
        return this.type.compareTo("\u00002") == 0;
    }

    public boolean isTextInfo() {
        return this.type.compareTo("\u00004") == 0;
    }

    private String localizeMessage(String message) {
        if (message.compareTo("Please enter user name: ") == 0) {
            return I18N.getResource("login_user_name");
        }
        if (message.compareTo("login: ") == 0) {
            return I18N.getResource("login_user_name");
        }
        if (message.compareTo("Password: ") == 0) {
            return I18N.getResource("login_password");
        }
        return message;
    }
}

